/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceContainer;
import jet.universe.UniverseEditor;
import jet.util.HashVector;
import toolkit.db.TableInfo;

public class JetUTableView
extends JetUResourceContainer {
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_VIEW = 2;
    public static final int TYPE_ALIAS = 4;
    public static final int TYPE_SYNONYM = 8;
    public static final int TYPE_MASK_ALL = 15;
    public JetEnumeration tableType = new JetEnumeration(this, "TableType", 94);
    public JetString qualifier = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString tableName = new JetString(this, "TableName");
    public TableInfo table = null;
    private JetString InitAfterCreate = new JetString(this, "ObjParamLinks");
    private Hashtable InitAfterLoad = null;
    private static JRLogger IsMappingNameOK;
    private static final HashMap QOIV;
    private static final HashVector add;
    static Class class$jet$universe$JetUTableView;
    static final boolean $assertionsDisabled;

    public HashMap getIndecialMap() {
        return QOIV;
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return add;
        }
        return null;
    }

    public JetUTableView() {
    }

    public JetUTableView(String string, String string2, int n, String string3, String string4, String string5) {
        super(string, string2);
        this.tableType.set(new Integer(n));
        this.qualifier.set(string3);
        this.owner.set(string4);
        this.tableName.set(string5);
    }

    public JetUTableView(String string, String string2, TableInfo tableInfo) {
        super(string, string2);
        this.tableType.set(new Integer(tableInfo.getTableType()));
        this.qualifier.set(tableInfo.getQualifierName());
        this.owner.set(tableInfo.getOwnerName());
        this.tableName.set(tableInfo.getTableName());
        this.table = tableInfo;
    }

    public JetUTableView createNew() {
        return new JetUTableView(this.getResourceName(), this.getDesc(), this.getTableType(), this.getQualifier(), this.getOwner(), this.getTableName());
    }

    public void InitAfterLoad() {
        boolean bl;
        super.InitAfterLoad();
        JetUConnection jetUConnection = this.getDatabase().getConnection();
        if (jetUConnection instanceof JetUJDBCConnection && (bl = ((JetUJDBCConnection)jetUConnection).getJdbcDriver().equals("com.jinfonet.jdbc.obj.ObjectDriver"))) {
            this.qualifier.set("jinfonet");
            this.owner.set("object");
        }
    }

    public void InitAfterCreate(Character c) {
        super.InitAfterCreate();
        if (this.table == null) {
            return;
        }
        Vector vector = this.table.getColumns();
        int n = vector.size();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            DbColDesc dbColDesc = (DbColDesc)vector.elementAt(n2);
            string = this.getMappingName(dbColDesc.getColName(), c);
            JetUField jetUField = new JetUField(string, "", dbColDesc);
            this.addField(jetUField);
            ++n2;
        }
        this.table = null;
    }

    public String getMappingName(String string, Character c) {
        StringBuffer stringBuffer = new StringBuffer();
        JetUDatabase jetUDatabase = this.getDatabase();
        String string2 = null;
        String string3 = string;
        boolean bl = false;
        if (c == null) {
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
            c = JetUConnection.I;
        }
        int n = 1;
        if (!bl) {
            string3 = this.getResourceName() + c + string;
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        }
        string2 = string3;
        while (!bl) {
            string3 = string2 + n++;
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        }
        return string3;
    }

    public int getTableType() {
        return this.tableType.intValue();
    }

    public void setQualifiedNamePattern(int n) {
        this.tableType.set(new Integer(n));
    }

    public boolean isTable() {
        return (this.getTableType() & 1) == 1;
    }

    public boolean isView() {
        return (this.getTableType() & 2) == 2;
    }

    public boolean isAlias() {
        return (this.getTableType() & 4) == 4;
    }

    public boolean isSynonym() {
        return (this.getTableType() & 8) == 8;
    }

    public String getQualifier() {
        return this.qualifier.get();
    }

    public void setQualifier(String string) {
        this.qualifier.set(string);
    }

    public String getOwner() {
        return this.owner.get();
    }

    public void setOwner(String string) {
        this.owner.set(string);
    }

    public String getTableName() {
        return this.tableName.get();
    }

    public void setTableName(String string) {
        this.tableName.set(string);
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!$assertionsDisabled && !(jetObject instanceof JetUField)) {
            throw new AssertionError((Object)("Invalid child of JetUTableView!" + jetObject.getClass().getName() + " Can not be child of " + this.getClass().getName()));
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public void addField(JetUField jetUField) {
        this.add(jetUField);
        jetUField.InitAfterCreate();
    }

    public JetUField removeField(JetUField jetUField) {
        this.remove(jetUField);
        return jetUField;
    }

    public Vector getFields() {
        return this.getChildren();
    }

    public JetUField getFieldByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUField jetUField = (JetUField)vector.elementAt(n2);
            if (jetUField.getResourceName().equalsIgnoreCase(string)) {
                return jetUField;
            }
            ++n2;
        }
        return null;
    }

    public JetUField getFieldByFieldName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUField jetUField = (JetUField)vector.elementAt(n2);
            if (jetUField.getFldName().equalsIgnoreCase(string)) {
                return jetUField;
            }
            ++n2;
        }
        return null;
    }

    public JetUConnection getConnection() {
        return (JetUConnection)this.getParent();
    }

    private Hashtable $assertionsDisabled(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(vector.size());
        JetUDatabase jetUDatabase = this.getDatabase();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            int n2 = string2.indexOf("=");
            if (n2 > -1) {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                hashtable.put(string3, string4);
            }
            ++n;
        }
        return hashtable;
    }

    private String InitAfterCreate(Hashtable hashtable) {
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + "=" + hashtable.get(string2) + ";";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void bindParameter(Hashtable hashtable) {
        this.InitAfterLoad = hashtable;
        this.InitAfterCreate.set(this.InitAfterCreate(this.InitAfterLoad));
    }

    public String getBindUPName(String string) {
        if (this.InitAfterLoad == null) {
            this.InitAfterLoad = this.$assertionsDisabled(this.InitAfterCreate.get());
        }
        return (String)this.InitAfterLoad.get(string);
    }

    public JetUParameter getBindParameter(String string) {
        String string2 = this.getBindUPName(string);
        if (string2 != null) {
            return this.getDatabase().getParameterByResourceName(string2);
        }
        return null;
    }

    public boolean isEmptyLinks() {
        return this.InitAfterCreate.get().length() == 0;
    }

    public Hashtable getParamLink() {
        if (this.InitAfterLoad == null) {
            this.InitAfterLoad = this.$assertionsDisabled(this.InitAfterCreate.get());
        }
        return this.InitAfterLoad;
    }

    public void setParamLinks(String string) {
        this.InitAfterCreate.set(string);
        this.InitAfterLoad = null;
    }

    public String getParamLinks() {
        return this.InitAfterCreate.get();
    }

    public String getInstancePrefix() {
        return "TableView";
    }

    public void setResourceName(String string) {
        JetUDatabase jetUDatabase = this.getDatabase();
        UniverseEditor universeEditor = jetUDatabase.getUniverse().editor;
        if (universeEditor != null) {
            universeEditor.updateTableNames(this.getResourceName(), string, jetUDatabase.getResourceName());
        }
        super.setResourceName(string);
    }

    public boolean isSimilar(JetUResourceContainer jetUResourceContainer) {
        return super.isSimilar(jetUResourceContainer) && this.tableType.equal(((JetUTableView)jetUResourceContainer).tableType) && this.tableName.equal(((JetUTableView)jetUResourceContainer).tableName);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUTableView == null ? (class$jet$universe$JetUTableView = JetUTableView.class$("jet.universe.JetUTableView")) : class$jet$universe$JetUTableView).desiredAssertionStatus();
        IsMappingNameOK = JRLogger.getLogger((class$jet$universe$JetUTableView == null ? (class$jet$universe$JetUTableView = JetUTableView.class$("jet.universe.JetUTableView")) : class$jet$universe$JetUTableView).getName());
        QOIV = new HashMap(7);
        QOIV.put("TableType", new Integer(0));
        QOIV.put("Description", new Integer(1));
        QOIV.put("ObjParamLinks", new Integer(2));
        QOIV.put("TableName", new Integer(3));
        QOIV.put("Name", new Integer(4));
        QOIV.put("Owner", new Integer(5));
        QOIV.put("Qualifier", new Integer(6));
        add = new HashVector(1);
        String string = null;
        Vector<String> vector = null;
        string = "anonymous";
        vector = new Vector<String>(7);
        vector.add("TableType");
        vector.add("Description");
        vector.add("ObjParamLinks");
        vector.add("TableName");
        vector.add("Name");
        vector.add("Owner");
        vector.add("Qualifier");
        add.put(string, vector);
    }
}

