/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbDateTime;
import jet.connect.DbValue;
import jet.datasource.hds.ArrayImpl;
import jet.util.DbValueFormat;

public class DateTimeFormat
extends SimpleDateFormat
implements DbValueFormat {
    public DateTimeFormat() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string) {
        super(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string, TimeZone timeZone) {
        super(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string, DateFormatSymbols dateFormatSymbols) {
        super(string, dateFormatSymbols);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string, DateFormatSymbols dateFormatSymbols, TimeZone timeZone) {
        super(string, dateFormatSymbols);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setCalendar(gregorianCalendar);
    }

    public synchronized String format(DbValue dbValue) {
        Date date = ((DbDateTime)dbValue).toUtilDate();
        return this.format(date);
    }

    private String QOIV(DbValue dbValue, String string) {
        String string2 = null;
        int n = dbValue.getSqlType();
        switch (n) {
            case 91: {
                Date[] dateArray = (Date[])((DbArray)dbValue).getValue();
                int n2 = 0;
                while (n2 < dateArray.length) {
                    string2 = n2 == 0 ? this.format(dateArray[n2]) : string2 + string + this.format(dateArray[n2]);
                    ++n2;
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])((DbArray)dbValue).getValue();
                int n3 = 0;
                while (n3 < timeArray.length) {
                    string2 = n3 == 0 ? this.format(timeArray[n3]) : string2 + string + this.format(timeArray[n3]);
                    ++n3;
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])((DbArray)dbValue).getValue();
                int n4 = 0;
                while (n4 < timestampArray.length) {
                    string2 = n4 == 0 ? this.format(timestampArray[n4]) : string2 + string + this.format(timestampArray[n4]);
                    ++n4;
                }
                break;
            }
        }
        return string2;
    }

    public synchronized String format(DbValue dbValue, String string) {
        Object object = ((DbArray)dbValue).getValue();
        if (object instanceof Date[] || object instanceof Time[] || object instanceof Timestamp[]) {
            return this.QOIV(dbValue, string);
        }
        String string2 = null;
        int n = dbValue.getSqlType();
        switch (n) {
            case 91: 
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int n2 = 0;
                while (n2 < lArray.length) {
                    string2 = n2 == 0 ? this.format(new Date(lArray[n2])) : string2 + string + this.format(new Date(lArray[n2]));
                    ++n2;
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                int n3 = 0;
                while (n3 < lArray.length) {
                    string2 = n3 == 0 ? this.format(new Date(lArray[n3] + (long)(nArray[n3] / 1000000))) : string2 + string + this.format(new Date(lArray[n3] + (long)(nArray[n3] / 1000000)));
                    ++n3;
                }
                break;
            }
        }
        return string2;
    }

    public String getPattern() {
        return this.toPattern();
    }

    public String getLocalizedPattern() {
        return this.toLocalizedPattern();
    }

    public void applyPattern(String string) {
        super.applyPattern(string);
    }

    public void applyLocalizedPattern(String string) {
        super.applyLocalizedPattern(string);
    }

    public void parse(DbValue dbValue, String string) {
        ((DbDateTime)dbValue).set(this.parse(string, new ParsePosition(0)).getTime());
    }

    public void parse(DbValue dbValue, String string, String string2) throws ParseException, SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        ArrayImpl arrayImpl = new ArrayImpl(dbValue.getSqlType(), this);
        arrayImpl.setValue(vector);
        ((DbArray)dbValue).set(arrayImpl);
    }
}

