/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DBarP;
import chart.chart2d.Graph2DBarSt;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartShading;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class Graph2DBar
extends Chart2DObject {
    protected float startX;
    protected float startY;
    protected float barWidth;
    protected float barHeight;
    protected float top;
    protected float bottom;
    protected float[] absSumOfCol;
    protected float[][] vertex;
    protected float[][] tVertex;
    protected Shape[] seriesShapes;
    protected Shape[][] itemShapes;
    protected Shape[][] topItemShapes;
    protected Shape[][] rightItemShapes;
    protected float unitX;
    protected float unitY;
    protected float[][] value;
    protected int col;
    protected int row;
    protected float depth;
    private float[][] v;
    private boolean[][] HighLightPattern;
    private boolean abs;
    private float append = 0.0f;
    private float closePath = 0.0f;
    protected float startOffsetW = 0.0f;
    protected float startOffsetH = 0.0f;
    protected float offsetW = 0.0f;
    protected float offsetH = 0.0f;
    protected int offsetN = 1;
    private String[][][] contains;
    private double[] cos;
    private boolean draw;
    protected float percentBarWidth;

    Graph2DBar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, int n) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.offsetN = n;
    }

    public void init() {
        int n;
        super.init();
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        this.value = new float[this.row][this.col];
        this.contains = this.layer.isShowCategoryAndSeries() ? new String[this.row][this.col][3] : new String[this.row][this.col][1];
        int n2 = this.dataset.getChartDataSetInfo().getChartType();
        int n3 = ChartTypeInfo.getPrimType(n2);
        this.abs = n3 == 1;
        double d = Math.PI / 180 * (double)this.objectProperties.getDepthDirection();
        this.depth = this.objectProperties.getDepth() / (float)this.layer.getChartCount();
        this.startOffsetW = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.cos(d));
        this.startOffsetH = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.sin(d));
        this.startOffsetW = this.startOffsetW < 0.0f ? 0.0f : this.startOffsetW;
        this.startOffsetH = this.startOffsetH < 0.0f ? 0.0f : this.startOffsetH;
        this.depth *= (float)this.offsetN;
        this.closePath = (float)((double)this.depth * Math.cos(d));
        this.append = (float)((double)this.depth * Math.sin(d));
        this.closePath = this.closePath < 0.0f ? 0.0f : this.closePath;
        this.append = this.append < 0.0f ? 0.0f : this.append;
        this.offsetW = this.closePath / (float)this.offsetN;
        this.offsetH = this.append / (float)this.offsetN;
        int n4 = 0;
        while (n4 < this.row) {
            n = 0;
            while (n < this.col) {
                Number number = this instanceof Graph2DBarSt ? (Number)((Chart1DDataSet)this.dataset).getOriginValue(n4, n) : (Number)((Chart1DDataSet)this.dataset).getValue(n4, n);
                if (number == null) {
                    this.value[n4][n] = 0.0f;
                } else {
                    this.value[n4][n] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.contains[n4][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n4, n);
                    } else {
                        this.contains[n4][n][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(n4, n));
                    }
                }
                ++n;
            }
            ++n4;
        }
        if (this.valueLabelPosition != 0) {
            this.ininSum();
        }
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][this.col];
        if (this.layer.isDepth()) {
            this.topItemShapes = new Shape[this.row][this.col];
            this.rightItemShapes = new Shape[this.row][this.col];
            n = 0;
            while (n < this.row) {
                int n5 = 0;
                while (n5 < this.col) {
                    this.topItemShapes[n][n5] = new GeneralPath();
                    this.rightItemShapes[n][n5] = new GeneralPath();
                    ++n5;
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.row) {
            this.seriesShapes[n] = new GeneralPath();
            ++n;
        }
        int n6 = 0;
        while (n6 < this.row) {
            int n7 = 0;
            while (n7 < this.col) {
                this.itemShapes[n6][n7] = new GeneralPath();
                ++n7;
            }
            ++n6;
        }
        this.vertex = new float[this.row * this.col * 4][2];
        this.tVertex = new float[this.row * this.col * 4][2];
        this.v = new float[this.col * this.row][2];
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        this.HighLightPattern = ((Chart1DDataSet)this.dataset).isNullValue();
    }

    public void locate() {
        int n;
        int n2;
        if (this.layer.isDepth()) {
            n2 = 0;
            while (n2 < this.row) {
                n = 0;
                while (n < this.col) {
                    ((GeneralPath)this.topItemShapes[n2][n]).reset();
                    ((GeneralPath)this.rightItemShapes[n2][n]).reset();
                    ++n;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.row) {
            ((GeneralPath)this.seriesShapes[n2]).reset();
            n = 0;
            while (n < this.col) {
                ((GeneralPath)this.itemShapes[n2][n]).reset();
                ++n;
            }
            ++n2;
        }
        this.layer.I(this.vertex, this.tVertex);
        if (this.layer.isDepth()) {
            n = 0;
            while (n < this.col) {
                int n3 = 0;
                while (n3 < this.row) {
                    if (!this.HighLightPattern[n3][n]) {
                        ((GeneralPath)this.topItemShapes[n3][n]).moveTo(this.tVertex[n3 * 4 * this.col + 4 * n + 3][0] - this.startOffsetW - this.offsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 3][1] + this.startOffsetH + this.offsetH);
                        ((GeneralPath)this.topItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 2][0] - this.startOffsetW - this.offsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 2][1] + this.startOffsetH + this.offsetH);
                        ((GeneralPath)this.topItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 2][0] - this.startOffsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 2][1] + this.startOffsetH);
                        ((GeneralPath)this.topItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 3][0] - this.startOffsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 3][1] + this.startOffsetH);
                        ((GeneralPath)this.topItemShapes[n3][n]).closePath();
                        ((GeneralPath)this.itemShapes[n3][n]).moveTo(this.tVertex[n3 * 4 * this.col + 4 * n][0] - this.closePath, this.tVertex[n3 * 4 * this.col + 4 * n][1] + this.append);
                        ((GeneralPath)this.itemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 1][0] - this.closePath, this.tVertex[n3 * 4 * this.col + 4 * n + 1][1] + this.append);
                        ((GeneralPath)this.itemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 2][0] - this.closePath, this.tVertex[n3 * 4 * this.col + 4 * n + 2][1] + this.append);
                        ((GeneralPath)this.itemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 3][0] - this.closePath, this.tVertex[n3 * 4 * this.col + 4 * n + 3][1] + this.append);
                        ((GeneralPath)this.itemShapes[n3][n]).closePath();
                        ((GeneralPath)this.seriesShapes[n3]).append(this.itemShapes[n3][n], false);
                        if (!this.layer.isCombo()) {
                            ((GeneralPath)this.rightItemShapes[n3][n]).moveTo(this.tVertex[n3 * 4 * this.col + 4 * n + 1][0] - this.startOffsetW - this.offsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 1][1] + this.startOffsetH + this.offsetH);
                            ((GeneralPath)this.rightItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 1][0] - this.startOffsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 1][1] + this.startOffsetH);
                            ((GeneralPath)this.rightItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 2][0] - this.startOffsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 2][1] + this.startOffsetH);
                            ((GeneralPath)this.rightItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 2][0] - this.startOffsetW - this.offsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 2][1] + this.startOffsetH + this.offsetH);
                        } else {
                            ((GeneralPath)this.rightItemShapes[n3][n]).moveTo(this.tVertex[n3 * 4 * this.col + 4 * n][0] - this.startOffsetW - this.offsetW, this.tVertex[n3 * 4 * this.col + 4 * n][1] + this.startOffsetH + this.offsetH);
                            ((GeneralPath)this.rightItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n][0] - this.startOffsetW, this.tVertex[n3 * 4 * this.col + 4 * n][1] + this.startOffsetH);
                            ((GeneralPath)this.rightItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 3][0] - this.startOffsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 3][1] + this.startOffsetH);
                            ((GeneralPath)this.rightItemShapes[n3][n]).lineTo(this.tVertex[n3 * 4 * this.col + 4 * n + 3][0] - this.startOffsetW - this.offsetW, this.tVertex[n3 * 4 * this.col + 4 * n + 3][1] + this.startOffsetH + this.offsetH);
                        }
                        ((GeneralPath)this.rightItemShapes[n3][n]).closePath();
                    }
                    ++n3;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.row) {
                int n4 = 0;
                while (n4 < this.col) {
                    ((GeneralPath)this.itemShapes[n][n4]).moveTo(this.tVertex[n * 4 * this.col + 4 * n4][0], this.tVertex[n * 4 * this.col + 4 * n4][1]);
                    ((GeneralPath)this.itemShapes[n][n4]).lineTo(this.tVertex[n * 4 * this.col + 4 * n4 + 1][0], this.tVertex[n * 4 * this.col + 4 * n4 + 1][1]);
                    ((GeneralPath)this.itemShapes[n][n4]).lineTo(this.tVertex[n * 4 * this.col + 4 * n4 + 2][0], this.tVertex[n * 4 * this.col + 4 * n4 + 2][1]);
                    ((GeneralPath)this.itemShapes[n][n4]).lineTo(this.tVertex[n * 4 * this.col + 4 * n4 + 3][0], this.tVertex[n * 4 * this.col + 4 * n4 + 3][1]);
                    ((GeneralPath)this.itemShapes[n][n4]).closePath();
                    ((GeneralPath)this.seriesShapes[n]).append(this.itemShapes[n][n4], false);
                    ++n4;
                }
                ++n;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        if (this.layer.isDepth()) {
            this.drawDepthBar(graphics2D);
        } else {
            int n2 = 0;
            while (n2 < this.row) {
                n = 0;
                while (n < this.col) {
                    if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
                        if (this.objectProperties.isVaryColorbyValues()) {
                            if (this.seriesPattern[n] != null) {
                                this.seriesPattern[n].fill(graphics2D, this.itemShapes[n2][n]);
                            }
                        } else if (this.seriesPattern[0] != null) {
                            this.seriesPattern[0].fill(graphics2D, this.itemShapes[n2][n]);
                        }
                    } else if (this.seriesPattern[n2] != null) {
                        this.seriesPattern[n2].fill(graphics2D, this.itemShapes[n2][n]);
                    }
                    if (this.objectProperties.isContour()) {
                        this.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[n2][n]);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if (this.valueLabelPosition != 0) {
            float[][] fArray = new float[this.row][this.col];
            n = 0;
            while (n < this.row) {
                int n3 = 0;
                while (n3 < this.col) {
                    if (this.abs) {
                        this.v[this.col * n + n3][0] = this.tVertex[n * 4 * this.col + 4 * n3 + 2][0];
                        this.v[this.col * n + n3][1] = (this.tVertex[n * 4 * this.col + 4 * n3 + 2][1] + this.tVertex[n * 4 * this.col + 4 * n3 + 3][1]) / 2.0f;
                        fArray[n][n3] = this.tVertex[n * 4 * this.col + 4 * n3 + 2][0] - this.tVertex[n * 4 * this.col + 4 * n3 + 1][0];
                    } else {
                        this.v[this.col * n + n3][0] = (this.tVertex[n * 4 * this.col + 4 * n3 + 2][0] + this.tVertex[n * 4 * this.col + 4 * n3 + 3][0]) / 2.0f;
                        this.v[this.col * n + n3][1] = this.tVertex[n * 4 * this.col + 4 * n3 + 2][1];
                        fArray[n][n3] = this.tVertex[n * 4 * this.col + 4 * n3 + 1][1] - this.tVertex[n * 4 * this.col + 4 * n3 + 2][1];
                    }
                    if (this.layer.isDepth()) {
                        float[] fArray2 = this.v[this.col * n + n3];
                        fArray2[0] = fArray2[0] - this.closePath;
                        float[] fArray3 = this.v[this.col * n + n3];
                        fArray3[1] = fArray3[1] + this.append;
                    }
                    ++n3;
                }
                ++n;
            }
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.v, this.barWidth, fArray, 0, this.row, this.valueLabelPosition, this.cos, this.draw);
            graph2DStaticHint.paint();
        }
    }

    public void drawDepthBar(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        while (n < this.col) {
            int n2 = 0;
            while (n2 < this.row) {
                if (!this.HighLightPattern[n2][n]) {
                    ChartFillPattern chartFillPattern;
                    if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
                        if (this.objectProperties.isVaryColorbyValues()) {
                            if (this.seriesPattern[n] != null) {
                                chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n], 20);
                                chartFillPattern.fill(graphics2D, this.topItemShapes[n2][n]);
                                this.seriesPattern[n].fill(graphics2D, this.itemShapes[n2][n]);
                                chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n], -20);
                                chartFillPattern.fill(graphics2D, this.rightItemShapes[n2][n]);
                            }
                        } else if (this.seriesPattern[0] != null) {
                            chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[0], 20);
                            chartFillPattern.fill(graphics2D, this.topItemShapes[n2][n]);
                            this.seriesPattern[0].fill(graphics2D, this.itemShapes[n2][n]);
                            chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[0], -20);
                            chartFillPattern.fill(graphics2D, this.rightItemShapes[n2][n]);
                        }
                    } else if (this.seriesPattern[n2] != null) {
                        chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n2], 20);
                        chartFillPattern.fill(graphics2D, this.topItemShapes[n2][n]);
                        this.seriesPattern[n2].fill(graphics2D, this.itemShapes[n2][n]);
                        chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n2], -20);
                        chartFillPattern.fill(graphics2D, this.rightItemShapes[n2][n]);
                    }
                    if (this.objectProperties.isContour()) {
                        this.objectProperties.getContourPen().draw(graphics2D, this.topItemShapes[n2][n]);
                        this.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[n2][n]);
                        this.objectProperties.getContourPen().draw(graphics2D, this.rightItemShapes[n2][n]);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        if (this.layer.isDepth()) {
            int n3 = this.row - 1;
            while (n3 >= 0) {
                int n4 = this.col - 1;
                while (n4 >= 0) {
                    if (this.itemShapes[n3][n4].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n3;
                        this.drilldown[1] = n4;
                        return this.contains[n3][n4];
                    }
                    if (this.topItemShapes[n3][n4].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n3;
                        this.drilldown[1] = n4;
                        return this.contains[n3][n4];
                    }
                    if (this.rightItemShapes[n3][n4].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n3;
                        this.drilldown[1] = n4;
                        return this.contains[n3][n4];
                    }
                    --n4;
                }
                --n3;
            }
        } else {
            int n5 = 0;
            while (n5 < this.row) {
                int n6 = 0;
                while (n6 < this.col) {
                    if (this.itemShapes[n5][n6].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n5;
                        this.drilldown[1] = n6;
                        return this.contains[n5][n6];
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        return null;
    }

    Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.seriesShapes.length) {
            if (this.seriesShapes[n3].contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public boolean isBench() {
        return this.abs;
    }

    public void setBarWidth(float f) {
        this.percentBarWidth = f;
    }

    public void ininSum() {
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            if (this.row == 1 || this.col == 1) {
                this.cos = new double[1];
                int n = 0;
                while (n < this.row) {
                    int n2 = 0;
                    while (n2 < this.col) {
                        if (this instanceof Graph2DBarP) {
                            if (this.col == 1) {
                                this.cos[0] = Math.abs(this.value[this.row - 1][n]);
                                return;
                            }
                            this.cos[0] = this.cos[0] + (double)Math.abs(this.value[n][n2]);
                        } else {
                            this.cos[0] = this.cos[0] + (double)Math.abs(this.value[n][n2]);
                        }
                        ++n2;
                    }
                    if (this.cos[0] == 0.0) {
                        this.cos[0] = 1.0;
                    }
                    ++n;
                }
                return;
            }
            this.cos = new double[this.col];
            int n = 0;
            while (n < this.col) {
                int n3 = 0;
                while (n3 < this.row) {
                    if (this instanceof Graph2DBarP) {
                        this.cos[n] = Math.abs(this.value[this.row - 1][n]);
                        break;
                    }
                    int n4 = n;
                    this.cos[n4] = this.cos[n4] + (double)Math.abs(this.value[n3][n]);
                    ++n3;
                }
                if (this.cos[n] == 0.0) {
                    this.cos[n] = 1.0;
                }
                ++n;
            }
            return;
        }
        this.cos = new double[this.col];
        int n = 0;
        while (n < this.col) {
            int n5 = 0;
            while (n5 < this.row) {
                if (this instanceof Graph2DBarP) {
                    this.cos[n] = Math.abs(this.value[this.row - 1][n]);
                    break;
                }
                int n6 = n;
                this.cos[n6] = this.cos[n6] + (double)Math.abs(this.value[n5][n]);
                ++n5;
            }
            if (this.cos[n] == 0.0) {
                this.cos[n] = 1.0;
            }
            ++n;
        }
    }
}

