/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.GuiUtil;
import guitools.SpinChangedListener;
import guitools.UIResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jet.JCliResource;
import jet.cs.ui.SDatePanel;
import jet.cs.ui.SIntSpin;

public class SCalendarPanel
extends JPanel
implements ComponentListener,
ItemListener,
SpinChangedListener {
    private static boolean QOIV = GuiUtil.isWindows();
    private static Font addElement = new Font("DateFont", 0, QOIV ? 11 : 10);
    private static Color addItem = UIResource.getColor((Object)"Highlited Text Color");
    private static Color addItemListener = UIResource.getColor((Object)"Background of Hightlited Text");
    private static Color addSpinChangedListener = SystemColor.inactiveCaptionText;
    private static Color arrange = SystemColor.inactiveCaption;
    protected static final int DEFAULT_WIDTH = 160;
    protected static final int DEFAULT_HEIGTH = 160;
    protected static final String[] PMT_MONTHS = new String[]{JCliResource.getDlgText((String)"Public", (String)"m1"), JCliResource.getDlgText((String)"Public", (String)"m2"), JCliResource.getDlgText((String)"Public", (String)"m3"), JCliResource.getDlgText((String)"Public", (String)"m4"), JCliResource.getDlgText((String)"Public", (String)"m5"), JCliResource.getDlgText((String)"Public", (String)"m6"), JCliResource.getDlgText((String)"Public", (String)"m7"), JCliResource.getDlgText((String)"Public", (String)"m8"), JCliResource.getDlgText((String)"Public", (String)"m9"), JCliResource.getDlgText((String)"Public", (String)"m10"), JCliResource.getDlgText((String)"Public", (String)"m11"), JCliResource.getDlgText((String)"Public", (String)"m12")};
    protected int year = 1998;
    protected int month = 1;
    protected JComboBox chMonth = new JComboBox();
    protected SIntSpin spinYear = new SIntSpin(1980, 2099, true);
    protected SDatePanel datePanel = new SDatePanel();
    private Vector changed = new Vector();

    public SCalendarPanel() {
        this(new GregorianCalendar());
    }

    public SCalendarPanel(GregorianCalendar gregorianCalendar) {
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2);
        this.datePanel.setGC(gregorianCalendar);
        this.initControls();
    }

    public void setGC(GregorianCalendar gregorianCalendar) {
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2);
        this.datePanel.setGC(gregorianCalendar);
        this.chMonth.setSelectedIndex(this.month);
        this.spinYear.setValue(this.year);
        this.repaint();
    }

    public GregorianCalendar getGC() {
        return this.datePanel.getGC();
    }

    protected void initControls() {
        this.setLayout(null);
        this.setSize(160, 160);
        int n = 0;
        while (n < PMT_MONTHS.length) {
            this.chMonth.addItem(PMT_MONTHS[n]);
            ++n;
        }
        this.chMonth.setSelectedIndex(this.month);
        this.spinYear.setValue(this.year);
        this.add(this.chMonth);
        this.add(this.spinYear);
        this.add(this.datePanel);
        this.arrange();
        this.chMonth.addItemListener(this);
        this.spinYear.addSpinChangedListener(this);
        this.datePanel.addSpinChangedListener(this);
    }

    protected void arrange() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = 24;
        int n4 = 8;
        int n5 = 10;
        int n6 = (dimension.width - n5) / 2 + 10;
        int n7 = (dimension.width - n5) / 2 - 10;
        this.chMonth.setBounds(n, n2, n6, n3);
        this.spinYear.setBounds(dimension.width - n7, n2, n7, n3);
        this.datePanel.setBounds(n, n3 + n4, dimension.width, dimension.height - n3 - n4);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        Object object = itemEvent.getSource();
        if (object == this.chMonth && (n = this.chMonth.getSelectedIndex()) != this.month) {
            this.month = n;
            this.datePanel.setMonth(n);
        }
    }

    public void changed(Object object) {
        if (object == this.spinYear) {
            this.year = this.spinYear.getValue();
            this.datePanel.setYear(this.year);
        } else if (object == this.datePanel) {
            this.notifyChanged();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.arrange();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDate() {
        return this.datePanel.getDate();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.chMonth.setEnabled(bl);
        this.spinYear.setEnabled(bl);
        this.datePanel.setEnabled(bl);
    }

    public void addSpinChangedListener(SpinChangedListener spinChangedListener) {
        if (!this.changed.contains(spinChangedListener)) {
            this.changed.addElement(spinChangedListener);
        }
    }

    public void removeSpinChangedListener(SpinChangedListener spinChangedListener) {
        this.changed.removeElement(spinChangedListener);
    }

    protected void notifyChanged() {
        int n = this.changed.size();
        int n2 = 0;
        while (n2 < n) {
            ((SpinChangedListener)this.changed.elementAt(n2)).changed(this);
            ++n2;
        }
    }

    public Date getDateTime() {
        return this.getGC().getTime();
    }

    public void setDateTime(Date date) {
        GregorianCalendar gregorianCalendar = this.getGC();
        gregorianCalendar.setTime(date);
        this.setGC(gregorianCalendar);
    }
}

