/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.util;

import com.jinfonet.jdbc.util.IntCircle;
import com.jinfonet.jdbc.util.IntHashNode;
import jet.util.IntVector;

public class IntHashtable {
    private transient IntHashNode[] QOIV;
    private transient int addElement;
    private int append;
    private float clone;

    public IntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.clone = f;
        this.QOIV = new IntHashNode[n];
        this.append = (int)((float)n * f);
    }

    public IntHashtable(int n) {
        this(n, 0.618f);
    }

    public IntHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.addElement;
    }

    public boolean isEmpty() {
        return this.addElement == 0;
    }

    public synchronized int getKey(int n) {
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            IntHashNode intHashNode = this.QOIV[n2];
            while (intHashNode != null) {
                if (intHashNode.Z == n) {
                    return intHashNode.I;
                }
                intHashNode = intHashNode.C;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized IntCircle getKeys(int n) {
        IntCircle intCircle = new IntCircle(2);
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            IntHashNode intHashNode = this.QOIV[n2];
            while (intHashNode != null) {
                if (intHashNode.Z == n) {
                    intCircle.addElement(intHashNode.I);
                    break;
                }
                intHashNode = intHashNode.C;
            }
            ++n2;
        }
        if (intCircle.size() > 0) {
            return intCircle;
        }
        return null;
    }

    public synchronized boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            IntHashNode intHashNode = this.QOIV[n2];
            while (intHashNode != null) {
                if (intHashNode.Z == n) {
                    return true;
                }
                intHashNode = intHashNode.C;
            }
            ++n2;
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntHashNode intHashNode = this.QOIV[n2];
        while (intHashNode != null) {
            if (intHashNode.I == n) {
                return true;
            }
            intHashNode = intHashNode.C;
        }
        return false;
    }

    public synchronized int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntHashNode intHashNode = this.QOIV[n2];
        while (intHashNode != null) {
            if (intHashNode.I == n) {
                return intHashNode.Z;
            }
            intHashNode = intHashNode.C;
        }
        return -1;
    }

    protected void rehash() {
        int n = this.QOIV.length;
        IntHashNode[] intHashNodeArray = this.QOIV;
        int n2 = n * 2 + 1;
        IntHashNode[] intHashNodeArray2 = new IntHashNode[n2];
        this.append = (int)((float)n2 * this.clone);
        this.QOIV = intHashNodeArray2;
        int n3 = 0;
        while (n3 < n) {
            IntHashNode intHashNode = intHashNodeArray[n3];
            while (intHashNode != null) {
                IntHashNode intHashNode2 = intHashNode;
                intHashNode = intHashNode.C;
                int n4 = (intHashNode2.I & Integer.MAX_VALUE) % n2;
                intHashNode2.C = intHashNodeArray2[n4];
                intHashNodeArray2[n4] = intHashNode2;
            }
            ++n3;
        }
    }

    public synchronized int put(int n, int n2) {
        int n3 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntHashNode intHashNode = this.QOIV[n3];
        while (intHashNode != null) {
            if (intHashNode.I == n) {
                int n4 = intHashNode.Z;
                intHashNode.Z = n2;
                return n4;
            }
            intHashNode = intHashNode.C;
        }
        if (this.addElement >= this.append) {
            this.rehash();
            return this.put(n, n2);
        }
        IntHashNode intHashNode2 = new IntHashNode();
        intHashNode2.I = n;
        intHashNode2.Z = n2;
        intHashNode2.C = this.QOIV[n3];
        this.QOIV[n3] = intHashNode2;
        ++this.addElement;
        return -1;
    }

    public synchronized int remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntHashNode intHashNode = this.QOIV[n2];
        IntHashNode intHashNode2 = null;
        while (intHashNode != null) {
            if (intHashNode.I == n) {
                if (intHashNode2 != null) {
                    intHashNode2.C = intHashNode.C;
                } else {
                    this.QOIV[n2] = intHashNode.C;
                }
                --this.addElement;
                return intHashNode.Z;
            }
            intHashNode2 = intHashNode;
            intHashNode = intHashNode.C;
        }
        return -1;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = null;
            ++n;
        }
        this.addElement = 0;
    }

    public synchronized Object clone() {
        IntHashtable intHashtable = new IntHashtable(this.QOIV.length, this.clone);
        int n = 0;
        while (n < this.QOIV.length) {
            intHashtable.QOIV[n] = this.QOIV[n] != null ? (IntHashNode)this.QOIV[n].clone() : null;
            ++n;
        }
        return intHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            int n = 0;
            while (n < this.QOIV.length) {
                IntHashNode intHashNode = this.QOIV[n];
                if (intHashNode != null) {
                    do {
                        intVector.addElement(intHashNode.I);
                    } while ((intHashNode = intHashNode.C) != null);
                }
                ++n;
            }
        }
        return intVector;
    }

    public synchronized IntVector elements() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            int n = 0;
            while (n < this.QOIV.length) {
                IntHashNode intHashNode = this.QOIV[n];
                if (intHashNode != null) {
                    do {
                        intVector.addElement(intHashNode.Z);
                    } while ((intHashNode = intHashNode.C) != null);
                }
                ++n;
            }
        }
        return intVector;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.addElement != 0) {
            stringBuffer.append("[");
            int n = 0;
            while (n < this.QOIV.length) {
                IntHashNode intHashNode = this.QOIV[n];
                if (intHashNode != null) {
                    do {
                        stringBuffer.append("[").append(intHashNode.I).append(",").append(intHashNode.Z).append("],");
                    } while ((intHashNode = intHashNode.C) != null);
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

