/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.type1;

import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSMap;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.DSShape;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.export.excel.ExcelCache;
import jet.export.excel.ExcelToolkit;
import jet.export.excel.type1.ExcelFomular;
import jet.export.excel.type1.ExcelLayoutManager;
import jet.export.excel.type1.Spliter;
import jet.export.util.CCUtil;
import jet.export.util.DSShapeLocater;
import jet.export.util.ExportUtil;
import jet.export.util.ImageEngine;
import jet.export.util.IntArrayList;
import jet.export.util.IntHashtable;
import jet.export.util.LongKeyHashtable;

public class ExcelColTemplateMaker {
    private Stack I;
    private Spliter QOIV;
    private LongKeyHashtable SearchContainer;
    private LongKeyHashtable add;
    private int[] addPair;
    private IntArrayList calculate;
    private ArrayList contains;
    private int convertPixelToUnit = Integer.MAX_VALUE;
    private IntHashtable createKey;
    private int dx;
    private float elementAt;
    ExcelFomular get;
    private ImageEngine getAlternation = new ImageEngine();
    private ExcelCache getBounds;

    private ExcelColTemplateMaker() {
        this.I = new Stack();
        this.I.push(new Offset(0, 0));
        this.QOIV = new Spliter();
        this.calculate = new IntArrayList();
        this.contains = new ArrayList();
        this.createKey = new IntHashtable();
        this.dx = 0;
    }

    public ExcelColTemplateMaker(ExcelFomular excelFomular, float f, ExcelCache excelCache) {
        this();
        this.get = excelFomular;
        this.elementAt = f;
        this.getBounds = excelCache;
    }

    public LongKeyHashtable getTemplate() {
        return this.SearchContainer;
    }

    public LongKeyHashtable getImageTemplate() {
        return this.add;
    }

    public int[] getColumnWidths() {
        return this.addPair;
    }

    public void makeTemplate(DSPage dSPage) throws IOException {
        Rectangle rectangle = dSPage.getPageArea();
        int n = 0;
        while (n < dSPage.size()) {
            JRObjectResult jRObjectResult = ExportUtil.getRealObject(dSPage.getObject(n));
            if (this.getBounds.isExport(jRObjectResult)) {
                int n2;
                int n3;
                Long l;
                Rectangle rectangle2;
                if (jRObjectResult instanceof DSContainer) {
                    this.SearchContainer((DSContainer)jRObjectResult, rectangle);
                } else if (jRObjectResult instanceof DSShape && (rectangle2 = DSShapeLocater.getShapeBound((DSShape)jRObjectResult, rectangle)) != null && !this.contains.contains(l = new Long(ExcelToolkit.createKey(n3 = (int)rectangle2.getX(), (n2 = (int)rectangle2.getWidth() + n3) - n3)))) {
                    this.contains.add(l);
                }
            }
            ++n;
        }
        this.I.push(new Offset((Offset)this.I.pop(), 0, 0));
    }

    public void calculate() {
        ExcelLayoutManager excelLayoutManager = ExcelLayoutManager.getInstance(1);
        excelLayoutManager.setParameter(this.calculate, this.contains, this.QOIV, this.createKey, this.dx, this.createKey(this.elementAt));
        excelLayoutManager.calculate();
        this.SearchContainer = excelLayoutManager.getTemplate();
        this.addPair = excelLayoutManager.getAlternation();
        this.add = excelLayoutManager.getImageTemplate();
    }

    public void SearchContainer(DSContainer dSContainer, Rectangle rectangle) throws IOException {
        this.I.push(new Offset((Offset)this.I.peek(), dSContainer.getX(), 0));
        if (dSContainer instanceof DSMultiValueContainer) {
            this.contains(((DSMultiValueContainer)dSContainer).getRender());
            this.I.pop();
            return;
        }
        Vector vector = dSContainer.getChildren();
        int n = 0;
        while (n < vector.size()) {
            JRObjectResult jRObjectResult = ExportUtil.getRealObject((JRObjectResult)vector.elementAt(n));
            int n2 = jRObjectResult.getObjectType();
            if (this.getBounds.isExport(jRObjectResult)) {
                if ((n2 & 0x40) == 64) {
                    if (n2 == 71) {
                        this.addPair((DSChartPlatform)jRObjectResult);
                    }
                } else if ((n2 & 0x80) == 128 || jRObjectResult instanceof DSMap) {
                    this.addPair((JRVisiableResult)jRObjectResult);
                } else if (jRObjectResult instanceof DSParagraphText) {
                    this.QOIV((JRVisiableResult)jRObjectResult);
                } else if ((n2 & 0x100) == 256) {
                    DSField dSField = (DSField)jRObjectResult;
                    if ((n2 & 0x101) == 257) {
                        this.SearchContainer((DSField)jRObjectResult);
                    } else if (dSField.getStartLine() != -1) {
                        this.SearchContainer((DSField)jRObjectResult);
                    }
                } else if (n2 == 4096) {
                    this.add((JRVisiableResult)jRObjectResult);
                } else if (jRObjectResult instanceof DSShape) {
                    this.calculate((DSShape)jRObjectResult, rectangle);
                } else if (jRObjectResult instanceof DSContainer) {
                    if (this.getBounds.isSplit((DSContainer)jRObjectResult)) {
                        this.I((DSContainer)jRObjectResult);
                    } else {
                        this.SearchContainer((DSContainer)jRObjectResult, rectangle);
                    }
                }
            }
            ++n;
        }
        this.I.pop();
    }

    private void I(DSContainer dSContainer) {
        Offset offset = (Offset)this.I.peek();
        int n = CCUtil.getIntPropertyByName(dSContainer, "X") + offset.dx;
        int[] nArray = ExcelToolkit.getContainerWH(dSContainer);
        int n2 = nArray[0];
        this.QOIV.addPair(ExcelToolkit.createKey(n, n2));
        this.convertPixelToUnit(n, n2);
    }

    private void QOIV(JRVisiableResult jRVisiableResult) {
        Offset offset = (Offset)this.I.peek();
        int n = jRVisiableResult.getX() + offset.dx;
        int n2 = jRVisiableResult.getWidth();
        this.QOIV.addPair(ExcelToolkit.createKey(n, n2));
        this.convertPixelToUnit(n, n2);
    }

    private void SearchContainer(DSField dSField) {
        Offset offset = (Offset)this.I.peek();
        int n = dSField.getX() + offset.dx;
        int n2 = dSField.getWidth();
        this.QOIV.addPair(ExcelToolkit.createKey(n, n2));
        this.convertPixelToUnit(n, n2);
        if (this.getBounds.isTextField(dSField)) {
            return;
        }
        Render render = dSField.getRender();
        Rectangle rectangle = render.getBounds();
        if (rectangle != null) {
            n2 = rectangle.width;
            n2 = Unit.convertPixelToUnit(n2);
            int n3 = rectangle.x;
            long l = ExcelToolkit.createKey(n += (n3 = Unit.convertPixelToUnit(n3)), n2);
            if (!this.contains.contains(new Long(l))) {
                this.contains.add(new Long(l));
            }
        }
    }

    private void add(JRVisiableResult jRVisiableResult) {
        Offset offset = (Offset)this.I.peek();
        int n = jRVisiableResult.getX() + offset.dx;
        int n2 = jRVisiableResult.getWidth();
        this.QOIV.addPair(ExcelToolkit.createKey(n, n2));
        this.convertPixelToUnit(n, n2);
    }

    private void addPair(JRVisiableResult jRVisiableResult) {
        long l;
        int n;
        Offset offset = (Offset)this.I.peek();
        int n2 = jRVisiableResult.getX() + offset.dx;
        if (jRVisiableResult instanceof DSPicture) {
            DSPicture dSPicture = (DSPicture)jRVisiableResult;
            n = this.getAlternation.getImage(true, false, dSPicture).getWidth();
            if (n == 0) {
                return;
            }
        } else {
            n = jRVisiableResult.getWidth();
        }
        if (!this.contains.contains(new Long(l = ExcelToolkit.createKey(n2, n)))) {
            this.contains.add(new Long(l));
        }
    }

    private void calculate(DSShape dSShape, Rectangle rectangle) {
        int n;
        int n2;
        Long l;
        Offset offset = (Offset)this.I.peek();
        Rectangle rectangle2 = DSShapeLocater.getShapeBound(dSShape, rectangle);
        if (rectangle2 != null && !this.contains.contains(l = new Long(ExcelToolkit.createKey(n2 = (int)rectangle2.getX() + offset.dx, (n = (int)rectangle2.getWidth() + n2) - n2)))) {
            this.contains.add(l);
        }
    }

    private void contains(Render render) {
        Offset offset = (Offset)this.I.peek();
        int n = render.getX() + offset.dx;
        int n2 = render.getWidth();
        long l = ExcelToolkit.createKey(n, n2);
        this.QOIV.addPair(l);
        this.convertPixelToUnit(n, n2);
    }

    private void convertPixelToUnit(int n, int n2) {
        int n3;
        int n4;
        if (this.convertPixelToUnit > n2 && n2 != 0) {
            this.convertPixelToUnit = n2;
        }
        if (!this.calculate.contains(n4 = n)) {
            this.calculate.add(n4);
            n3 = 1;
        } else {
            n3 = this.createKey.get(n4) + 1;
        }
        this.createKey.put(n4, n3);
        if (this.dx < n3) {
            this.dx = n3;
        }
        if (!this.calculate.contains(n4 = n + n2)) {
            this.calculate.add(n4);
            n3 = 1;
        } else {
            n3 = this.createKey.get(n4) + 1;
        }
        this.createKey.put(n4, n3);
        if (this.dx < n3) {
            this.dx = n3;
        }
    }

    private int createKey(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return (int)((float)this.convertPixelToUnit * f);
    }
}

