/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.api;

import java.awt.Color;
import jet.export.rtf.api.PatternInfo;

public final class LineInfo {
    public static final byte ST_NONE_LINE = 0;
    public static final byte ST_SOLD_LINE = 1;
    public static final byte ST_DOUBLE_LINE = 2;
    public static final byte ST_LIGHT_DARK_LINE = 3;
    public static final byte ST_DARK_LIGHT_LINE = 4;
    public static final byte ST_LIGHT_DARK_LIGHT_LINE = 5;
    public static final byte DS_SOLD = 6;
    public static final byte DS_ROUND_DOT = 7;
    public static final byte DS_SQUARE_DOT = 8;
    public static final byte DS_DASH = 9;
    public static final byte DS_DASH_DOT = 10;
    public static final byte DS_LONG_DASH = 11;
    public static final byte DS_LONG_DASH_DOT = 12;
    public static final byte DS_LONG_DASH_DOT_DOT = 13;
    public static final byte ARST_NONE = 14;
    public static final byte ARST_ARROW = 15;
    public static final byte ARST_OPEN_ARROW = 16;
    public static final byte ARST_STEALTH_ARROW = 17;
    public static final byte ARST_DIAMOND_ARROW = 18;
    public static final byte ARST_OVAL_ARROW = 19;
    private Color QOIV = Color.black;
    private byte ST_NONE = 1;
    private byte black = 0;
    private byte equal = (byte)14;
    private byte getRGB = (byte)14;
    private int getStyle = 15;
    private PatternInfo isNoLine;
    private boolean reset;

    public LineInfo() {
        this.reset();
    }

    public void setColor(Color color) {
        this.QOIV = color;
    }

    public void setLineWidth(int n) {
        this.getStyle = n;
    }

    public boolean isNoLine() {
        return this.QOIV == null || this.ST_NONE == 0;
    }

    public void setLineStyle(byte by) {
        if (by >= 0 && by <= 5) {
            this.ST_NONE = by;
        }
    }

    public void setDashed(byte by) {
        if (by >= 6 && by <= 13) {
            this.black = by;
        }
    }

    public void setBeginArrow(byte by) {
        if (by < 15 || by > 19) {
            by = (byte)14;
        }
        this.equal = by;
    }

    public void setEndArrow(byte by) {
        if (by < 15 || by > 19) {
            by = (byte)14;
        }
        this.getRGB = by;
    }

    public void setPattern(PatternInfo patternInfo) {
        if (patternInfo == null || patternInfo.getStyle() == PatternInfo.ST_NONE) {
            return;
        }
        this.isNoLine = patternInfo;
    }

    public PatternInfo getPattern() {
        return this.isNoLine;
    }

    public Color getLineColor() {
        return this.QOIV;
    }

    public byte getLineStyle() {
        return this.ST_NONE;
    }

    public byte getLineDash() {
        return this.black;
    }

    public long getLineWidth() {
        long l = this.getStyle * 635;
        return l;
    }

    public byte getBeginArrowStyle() {
        return this.equal;
    }

    public byte getEndArrowStyle() {
        return this.getRGB;
    }

    public boolean equal(LineInfo lineInfo) {
        if (lineInfo == null) {
            return false;
        }
        if (lineInfo.isNoLine() && this.isNoLine()) {
            return true;
        }
        if (lineInfo.ST_NONE != this.ST_NONE) {
            return false;
        }
        if (lineInfo.getStyle != this.getStyle) {
            return false;
        }
        if (!this.QOIV(lineInfo.QOIV, this.QOIV)) {
            return false;
        }
        if (lineInfo.equal != this.equal) {
            return false;
        }
        if (lineInfo.black != this.black) {
            return false;
        }
        if (lineInfo.getRGB != this.getRGB) {
            return false;
        }
        return this.ST_NONE(lineInfo.isNoLine, this.isNoLine);
    }

    private boolean QOIV(Color color, Color color2) {
        if (color == null && color2 == null) {
            return true;
        }
        if (color != null && color2 != null) {
            return color.getRGB() == color2.getRGB();
        }
        return false;
    }

    private boolean ST_NONE(PatternInfo patternInfo, PatternInfo patternInfo2) {
        if (patternInfo == null && patternInfo2 == null) {
            return true;
        }
        if (patternInfo != null && patternInfo2 != null) {
            return patternInfo.equal(patternInfo2);
        }
        return false;
    }

    public void reset() {
        this.reset = true;
    }

    public boolean canBeReuse() {
        return this.reset;
    }
}

