/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.toolkit.Offset;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.TextParameter;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.ExpException;
import jet.export.excel.tool.PD;
import jet.export.excel.tool.PDTable;
import jet.export.text.SDFTextBase;
import jet.export.text.SimpleSDFText;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.udo.TextGeneratable;
import jet.udos.JHyperLinkRslt;

public class SDFText
extends SDFTextBase {
    private boolean C = true;
    private Hashtable I;
    private Stack QOIV;
    protected Vector pageData;
    private SDFTextBase add;
    private long addElement = 0L;
    private PDTable addLineSeparator = new PDTable(256);
    private long adjustString = 0L;

    public SDFText(Communicator communicator, TextParameter textParameter) {
        if (textParameter.isUseDelimiter()) {
            this.setDelimiter(textParameter.getDelimiter());
        }
        if (communicator.isPreDefinedCol()) {
            this.add = new SimpleSDFText(communicator, textParameter);
        } else {
            JRLog.trace(4, "Exporting to CSV......");
            this._commu = communicator;
            this.getParameters(textParameter);
            this.add = this;
        }
    }

    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this.checkFilePathExist(string);
        String string2 = string.endsWith(".txt") || string.endsWith(".csv") ? string : (this.isCSV ? string + ".csv" : string + ".txt");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.treatIOException(fileNotFoundException, string2, true);
        }
        this.exportToStream(fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, string2, true);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return arrayList;
    }

    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            this.add.publish(bufferedOutputStream);
            this.add.free();
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
    }

    protected void publish(BufferedOutputStream bufferedOutputStream) throws IOException, JRStopEngineException {
        long l;
        long l2;
        long l3 = System.currentTimeMillis();
        boolean bl = JRLog.isTrace(4);
        if (bl) {
            JRLog.indent("Export to sdf text");
            JRLog.trace(4, 4402101, new Timestamp(l3));
        }
        super.publish(bufferedOutputStream);
        this.pageData = new Vector();
        this.QOIV = new Stack();
        this.I = new Hashtable();
        CommEnumeration commEnumeration = new CommEnumeration(this._commu);
        long l4 = 0L;
        while (commEnumeration.hasMoreElements()) {
            ExportUtil.checkStop(this._commu);
            l2 = System.currentTimeMillis();
            DSPage dSPage = (DSPage)commEnumeration.nextElement();
            l = System.currentTimeMillis();
            l4 += l - l2;
            this.writePage(dSPage, true);
        }
        int n = this.addElement();
        commEnumeration = new CommEnumeration(this._commu);
        while (commEnumeration.hasMoreElements()) {
            ExportUtil.checkStop(this._commu);
            l2 = System.currentTimeMillis();
            DSPage dSPage = (DSPage)commEnumeration.nextElement();
            l = System.currentTimeMillis();
            l4 += l - l2;
            this.writePage(dSPage, false);
            String string = this.addLineSeparator(n);
            this.textwriter.print(string);
            this.pageData.removeAllElements();
        }
        this.textwriter.flush();
        if (bl) {
            long l5 = System.currentTimeMillis();
            JRLog.trace(4, 4402102, new Timestamp(l5));
            JRLog.trace(4, 4402103, new Long(l5 - l3 - l4));
            JRLog.trace(4, "Export getData times(" + this.adjustString + ")");
            JRLog.trace(4, "Get render and to String times(" + this.addElement + ")");
            JRLog.deIndent("Export to sdf text");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the sdf text");
        }
    }

    protected void writeBody(DSBody dSBody, int n, boolean bl) {
        this.C(dSBody, n, bl);
    }

    protected void writeSection(DSSection dSSection, int n, boolean bl) {
        this.C(dSSection, n, bl);
    }

    private void C(DSContainer dSContainer, int n, boolean bl) {
        int n2 = dSContainer.getStartYPos();
        List list = this.zOrder(dSContainer.getChildren());
        int n3 = list.size();
        this.QOIV.push(this.QOIV.isEmpty() ? new Offset(dSContainer.getX(), this.getY(dSContainer, n)) : new Offset((Offset)this.QOIV.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        int n4 = n3;
        while (--n4 >= 0) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n4);
            jRObjectResult = this.getFactOject(jRObjectResult);
            this.checkFilePathExist(jRObjectResult, n2, bl);
        }
        this.QOIV.pop();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void I(DSField dSField, int n, boolean bl) {
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        block10: {
            int[][] nArray;
            block11: {
                if (!this.isTextField(dSField)) {
                    return;
                }
                Offset offset = (Offset)this.QOIV.peek();
                n5 = dSField.getX() + offset.dx;
                n4 = dSField.getWidth();
                if (bl) {
                    this.add(n5, 0, n4, 0, null, bl);
                    return;
                }
                string = dSField.toString();
                n3 = this.getY(dSField, n) + offset.dy;
                n2 = this.close(dSField, "Height");
                if (n2 == 0) {
                    n2 = dSField.getHeight();
                }
                if ((nArray = dSField.getLineBreakPos()) == null) break block10;
                string = Painter.adjustString(string);
                int n6 = dSField.getObjectType();
                if (n6 != 257) break block11;
                int n7 = dSField.getStartLine();
                if (n7 >= 0 && n7 < nArray.length) {
                    int n8 = dSField.getEndLine();
                    if (n8 >= 0) {
                        n8 = Math.min(nArray.length - 1, n8) < 0 ? 0 : Math.min(nArray.length - 1, n8);
                        string = string.substring(nArray[n7][0], nArray[n8][0] + nArray[n8][1]);
                    }
                    break block10;
                } else {
                    return;
                }
            }
            if (string.length() > 50) {
                int n9 = dSField.getStartLine();
                int n10 = dSField.getEndLine();
                if (n10 < 0) {
                    JRLog.error(2, 2405109, new Object[]{new Integer(string.length()), new Integer(n10)});
                    return;
                }
                n10 = Math.min(nArray.length - 1, n10) < 0 ? 0 : Math.min(nArray.length - 1, n10);
                string = string.substring(nArray[n9][0], nArray[n10][0] + nArray[n10][1]);
            } else if (dSField.getStartLine() > 0) {
                return;
            }
        }
        this.add(n5, n3, n4, n2, string, bl);
    }

    private String QOIV(Render render, Object object) {
        if (render instanceof RenderText) {
            if (object != null && object instanceof DSField) {
                return ((DSField)object).toString();
            }
        } else {
            if (render instanceof RenderList) {
                int n;
                RenderList renderList = (RenderList)render;
                Vector vector = renderList.getSelectedText();
                Vector vector2 = renderList.getTexts();
                AbstractList abstractList = null;
                if (vector == null || vector.size() == 0) {
                    abstractList = vector2;
                } else {
                    abstractList = new ArrayList(vector.size());
                    boolean bl = false;
                    n = 0;
                    while (n < vector.size()) {
                        if (vector2.contains(vector.get(n))) {
                            bl = true;
                            abstractList.add(vector.get(n));
                        }
                        ++n;
                    }
                    if (!bl) {
                        abstractList = vector2;
                    }
                }
                String string = null;
                if (abstractList != null && abstractList.size() != 0) {
                    string = (String)abstractList.get(0);
                    n = 1;
                    while (n < abstractList.size()) {
                        string = string + "\n" + abstractList.get(n);
                        ++n;
                    }
                }
                return string;
            }
            if (render instanceof RenderDropDownList) {
                String string = null;
                RenderDropDownList renderDropDownList = (RenderDropDownList)render;
                String string2 = renderDropDownList.getSelectedTexts();
                Vector vector = renderDropDownList.getTexts();
                if (string2 != null && vector != null && vector.size() != 0) {
                    string = vector.contains(string2) ? string2 : (String)vector.get(0);
                }
                return string;
            }
            if (render instanceof RenderBarCode) {
                return object instanceof DSField ? ((DSField)object).toString() : null;
            }
        }
        return null;
    }

    private void _commu(JRVisiableResult jRVisiableResult, int n, boolean bl) {
        boolean bl2 = jRVisiableResult instanceof TextGeneratable;
        String string = null;
        if (bl2) {
            string = ((TextGeneratable)((Object)jRVisiableResult)).toText();
        } else if (jRVisiableResult instanceof JHyperLinkRslt) {
            string = (String)jRVisiableResult.getPropertyByName("displayValue").getObject();
        }
        if (string != null) {
            Offset offset = (Offset)this.QOIV.peek();
            int n2 = jRVisiableResult.getX() + offset.dx;
            int n3 = this.getY(jRVisiableResult, n) + offset.dy;
            int n4 = jRVisiableResult.getWidth();
            int n5 = jRVisiableResult.getHeight();
            this.add(n2, n3, n4, n5, string, bl);
        }
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n4 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n3 = (n2 = n4) > 0 ? n2 : 0;
        }
        return n3;
    }

    private void add(int n, int n2, int n3, int n4, String string, boolean bl) {
        if (bl) {
            this.addLineSeparator.put(n, n3);
        } else if (this.pageData.isEmpty()) {
            Vector<TxtBlock> vector = new Vector<TxtBlock>();
            vector.addElement(new TxtBlock(this, n, n2, n3, n4, string));
            this.pageData.addElement(vector);
        } else {
            TxtBlock txtBlock;
            Vector<TxtBlock> vector;
            Vector vector2;
            boolean bl2 = true;
            int n5 = this.pageData.size() - 1;
            while (n5 >= 0) {
                vector2 = (Vector)this.pageData.elementAt(n5);
                TxtBlock txtBlock2 = (TxtBlock)vector2.elementAt(0);
                if (n2 == txtBlock2.y) {
                    vector2.addElement(new TxtBlock(this, n, n2, n3, n4, string));
                    bl2 = false;
                    break;
                }
                if (n2 >= txtBlock2.y - n4 / 2 && n2 < txtBlock2.y + n4 / 2 && txtBlock2.y + txtBlock2.Z > n2) {
                    vector2.addElement(new TxtBlock(this, n, n2, n3, n4, string));
                    bl2 = false;
                    break;
                }
                vector = new Vector<TxtBlock>();
                vector.addElement(new TxtBlock(this, n, n2, n3, n4, string));
                if (n5 == 0 && n2 <= txtBlock2.y - n4 / 2) {
                    this.pageData.insertElementAt(vector, 0);
                    bl2 = false;
                    break;
                }
                if (n5 == this.pageData.size() - 1 && (n2 > txtBlock2.y + n4 / 2 || n2 >= txtBlock2.y + txtBlock2.Z)) {
                    this.pageData.addElement(vector);
                    bl2 = false;
                    break;
                }
                if (n5 > 0) {
                    Vector vector3 = (Vector)this.pageData.elementAt(n5 - 1);
                    txtBlock = (TxtBlock)vector3.elementAt(0);
                    if (n2 > txtBlock.y + n4 / 2 && n2 <= txtBlock2.y - n4 / 2) {
                        this.pageData.insertElementAt(vector, n5);
                        bl2 = false;
                        break;
                    }
                }
                --n5;
            }
            if (bl2) {
                int n6 = 0;
                while (n6 < this.pageData.size()) {
                    vector2 = (Vector)this.pageData.elementAt(n6);
                    txtBlock = (TxtBlock)vector2.elementAt(0);
                    if (txtBlock.y > n2) {
                        vector = new Vector();
                        vector.addElement(new TxtBlock(this, n, n2, n3, n4, string));
                        this.pageData.insertElementAt(vector, n6);
                        break;
                    }
                    ++n6;
                }
            }
        }
    }

    private int addElement() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.addLineSeparator.size();
        if (n4 == 0) {
            return 0;
        }
        PD[] pDArray = new PD[n4];
        int n5 = 0;
        while (n5 < n4) {
            PD pD = this.addLineSeparator.get(n5);
            n = 0;
            while (n < n3) {
                if (pD.getPoint() < pDArray[n].getPoint() || pD.getPoint() == pDArray[n].getPoint() && pD.getDimension() < pDArray[n].getDimension()) break;
                ++n;
            }
            System.arraycopy(pDArray, n, pDArray, n + 1, n3 - n);
            pDArray[n] = pD;
            ++n3;
            ++n5;
        }
        n = pDArray[0].getPoint() + pDArray[0].getDimension() / 2;
        int n6 = pDArray[0].getDimension();
        this.I.put(pDArray[0], new Integer(n2));
        int n7 = 0;
        while (n7 < n3) {
            if (pDArray[n7].getPoint() < n) {
                this.I.put(pDArray[n7], new Integer(n2));
                if (pDArray[n7].getDimension() < n6) {
                    n = pDArray[n7].getPoint() + pDArray[n7].getDimension() / 2;
                    n6 = pDArray[n7].getDimension();
                }
            } else {
                this.I.put(pDArray[n7], new Integer(++n2));
                n = pDArray[n7].getPoint() + pDArray[n7].getDimension() / 2;
                n6 = pDArray[n7].getDimension();
            }
            ++n7;
        }
        return n2;
    }

    private String addLineSeparator(int n) {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        if (!this.pageData.isEmpty()) {
            int n2 = 0;
            while (n2 < this.pageData.size()) {
                Vector vector = (Vector)this.pageData.elementAt(n2);
                if (!vector.isEmpty()) {
                    int n3;
                    String string;
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        int n5;
                        TxtBlock txtBlock = (TxtBlock)vector.elementAt(n4);
                        int n6 = txtBlock.x;
                        string = txtBlock.C.trim();
                        if (bl && string.length() != 0) {
                            bl = false;
                        }
                        if (stringArray[n5 = ((Integer)this.I.get(this.addLineSeparator.getPD(n6, txtBlock.I))).intValue()] != null) {
                            n3 = stringArray.length;
                            String[] stringArray3 = new String[n3 + 1];
                            int n7 = -1;
                            int n8 = 0;
                            while (n8 < n3) {
                                stringArray3[++n7] = stringArray[n8];
                                if (n8 == n5) {
                                    stringArray3[++n7] = string;
                                }
                                ++n8;
                            }
                            stringArray = stringArray3;
                            stringArray2 = new String[stringArray.length + 1];
                        } else {
                            stringArray[n5] = string;
                        }
                        ++n4;
                    }
                    if (!this.isCompress || !bl) {
                        n3 = 0;
                        int n9 = 0;
                        while (n9 < stringArray.length) {
                            if (n3 != 0 && this.useDelimiter) {
                                stringBuffer.append(this.delimiter);
                            }
                            if (this.useQuoteMark) {
                                stringBuffer.append(this.quoteMark);
                            }
                            if ((string = stringArray[n9]) != null && string.length() != 0) {
                                if (this.useQuoteMark || this.isCSV) {
                                    string = this.prepareText(string);
                                }
                                stringBuffer.append(string);
                                stringArray2[n9] = stringArray[n9];
                            } else {
                                string = stringArray2[n9];
                                if (this.isRepeat && string != null && string.length() != 0) {
                                    if (this.useQuoteMark || this.isCSV) {
                                        string = this.prepareText(string);
                                    }
                                    stringBuffer.append(string);
                                }
                            }
                            if (this.useQuoteMark) {
                                stringBuffer.append(this.quoteMark);
                            }
                            n3 = 1;
                            stringArray[n9] = null;
                            ++n9;
                        }
                        this.addLineSeparator(stringBuffer);
                    }
                    bl = true;
                }
                ++n2;
            }
        }
        long l2 = System.currentTimeMillis();
        this.adjustString += l2 - l;
        return stringBuffer.toString();
    }

    private void adjustString(DSParagraphText dSParagraphText, int n, boolean bl) {
        String string = dSParagraphText.getText();
        if (string != null) {
            Offset offset = (Offset)this.QOIV.peek();
            int n2 = dSParagraphText.getX() + offset.dx;
            int n3 = this.getY(dSParagraphText, n) + offset.dy;
            int n4 = dSParagraphText.getWidth();
            int n5 = dSParagraphText.getHeight();
            this.add(n2, n3, n4, n5, string, bl);
        }
    }

    private void append(DSParagraph dSParagraph, int n, boolean bl) {
        if (this.C) {
            Vector vector = dSParagraph.getChildren();
            int n2 = vector.size();
            if (n2 > 0) {
                Object object;
                JRObjectResult jRObjectResult = null;
                String string = "";
                int n3 = 0;
                while (n3 < n2) {
                    jRObjectResult = this.getFactOject((JRObjectResult)vector.get(n3));
                    int n4 = jRObjectResult.getObjectType();
                    if (this.canExportToCSV(jRObjectResult)) {
                        String string2;
                        if (n4 == 524291) {
                            object = (DSParagraphText)jRObjectResult;
                            string2 = ((DSParagraphText)object).getText();
                            if (string2 != null) {
                                string = string + string2;
                            }
                        } else if ((n4 & 0x100) == 256 && this.isTextField((DSField)(object = (DSField)jRObjectResult)) && (string2 = ((DSField)object).toString()) != null) {
                            string = string + string2;
                        }
                    }
                    ++n3;
                }
                if (string.length() != 0) {
                    object = (Offset)this.QOIV.peek();
                    int n5 = dSParagraph.getX() + ((Offset)object).dx;
                    int n6 = this.getY(dSParagraph, n) + ((Offset)object).dy;
                    int n7 = dSParagraph.getWidth();
                    int n8 = dSParagraph.getHeight();
                    this.add(n5, n6, n7, n8, string, bl);
                }
            }
        } else {
            this.C(dSParagraph, n, bl);
        }
    }

    private void arraycopy(DSTableObject dSTableObject, int n, boolean bl) {
        int n2 = dSTableObject.getStartYPos();
        Vector vector = dSTableObject.getChildren();
        int n3 = vector.size();
        this.QOIV.push(this.QOIV.isEmpty() ? new Offset(dSTableObject.getX(), this.getY(dSTableObject, n)) : new Offset((Offset)this.QOIV.peek(), dSTableObject.getX(), this.getY(dSTableObject, n)));
        int n4 = 0;
        while (n4 < n3) {
            DSTableRow dSTableRow;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n4);
            if (jRObjectResult instanceof DSTableRow && this.canExportToCSV(dSTableRow = (DSTableRow)jRObjectResult)) {
                this.canExportToCSV(dSTableRow, n2, bl);
            }
            ++n4;
        }
        this.QOIV.pop();
    }

    private void canExportToCSV(DSTableRow dSTableRow, int n, boolean bl) {
        this.QOIV.push(new Offset((Offset)this.QOIV.peek(), dSTableRow.getX(), this.getY(dSTableRow, n)));
        int n2 = dSTableRow.getStartYPos();
        Vector vector = dSTableRow.getChildren();
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            JRObjectResult jRObjectResult = this.getFactOject((JRObjectResult)vector.get(n4));
            if (this.canExportToCSV(jRObjectResult)) {
                this.checkFilePathExist(jRObjectResult, n2, bl);
            }
            ++n4;
        }
        this.QOIV.pop();
    }

    private void checkFilePathExist(JRObjectResult jRObjectResult, int n, boolean bl) {
        int n2 = jRObjectResult.getObjectType();
        if (this.canExportToCSV(jRObjectResult)) {
            if ((n2 & 0x20) == 32) {
                switch (n2) {
                    case 262178: {
                        this.append((DSParagraph)jRObjectResult, n, bl);
                        break;
                    }
                    case 262179: {
                        this.arraycopy((DSTableObject)jRObjectResult, n, bl);
                        break;
                    }
                    case 262183: {
                        this.checkOutputStream((DSMultiValueContainer)jRObjectResult, n, bl);
                        break;
                    }
                    case 34: {
                        this.clear((DSCrossTab)jRObjectResult, n, bl);
                        break;
                    }
                    case 45: {
                        this.checkStop((DSContainer)jRObjectResult, n, bl);
                        break;
                    }
                    default: {
                        this.C((DSContainer)jRObjectResult, n, bl);
                        break;
                    }
                }
            } else if ((n2 & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() != -1) {
                this.I((DSField)jRObjectResult, n, bl);
            } else if (n2 == 4096) {
                this._commu((JRVisiableResult)jRObjectResult, n, bl);
            } else if (jRObjectResult instanceof DSSection) {
                this.writeSection((DSSection)jRObjectResult, n, bl);
            } else if (jRObjectResult instanceof DSParagraphText) {
                this.adjustString((DSParagraphText)jRObjectResult, n, bl);
            } else if (jRObjectResult instanceof DSContainer) {
                this.C((DSContainer)jRObjectResult, n, bl);
            } else if (JRLog.isAd()) {
                JRLog.print("Now, when export to text(CSV) can not treat this object : " + jRObjectResult + " type is : " + jRObjectResult.getObjectType());
            }
        }
    }

    private void checkOutputStream(DSMultiValueContainer dSMultiValueContainer, int n, boolean bl) {
        String string = this.QOIV(dSMultiValueContainer.getRender(), null);
        if (string != null) {
            Offset offset = (Offset)this.QOIV.peek();
            int n2 = dSMultiValueContainer.getX() + offset.dx;
            int n3 = this.getY(dSMultiValueContainer, n) + offset.dy;
            int n4 = dSMultiValueContainer.getWidth();
            int n5 = dSMultiValueContainer.getHeight();
            this.add(n2, n3, n4, n5, string, bl);
        }
    }

    private void checkStop(DSContainer dSContainer, int n, boolean bl) {
        int n2 = dSContainer.getStartYPos();
        List list = this.zOrder(dSContainer.getChildren());
        int n3 = list.size();
        this.QOIV.push(this.QOIV.isEmpty() ? new Offset(dSContainer.getX(), this.getY(dSContainer, n)) : new Offset((Offset)this.QOIV.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        int n4 = 0;
        while (n4 < n3) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n4);
            jRObjectResult = this.getFactOject(jRObjectResult);
            this.checkFilePathExist(jRObjectResult, n2, bl);
            ++n4;
        }
        this.QOIV.pop();
    }

    private void clear(DSCrossTab dSCrossTab, int n, boolean bl) {
        int n2 = dSCrossTab.getStartYPos();
        List list = this.zOrder(dSCrossTab.getChildren());
        int n3 = list.size();
        this.QOIV.push(this.QOIV.isEmpty() ? new Offset(dSCrossTab.getX(), this.getY(dSCrossTab, n)) : new Offset((Offset)this.QOIV.peek(), dSCrossTab.getX(), this.getY(dSCrossTab, n)));
        int n4 = 0;
        while (n4 < n3) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n4);
            jRObjectResult = this.getFactOject(jRObjectResult);
            this.checkFilePathExist(jRObjectResult, n2, bl);
            ++n4;
        }
        this.QOIV.pop();
    }

    private int close(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected void free() {
        super.free();
        if (this.I != null) {
            this.I.clear();
            this.I = null;
        }
        if (this.pageData != null) {
            this.pageData.clear();
            this.pageData = null;
        }
    }

    private class TxtBlock {
        int x;
        int y;
        int I;
        int Z;
        String C;
        private final SDFText this$0;

        TxtBlock(SDFText sDFText, int n, int n2, int n3, int n4, String string) {
            this.this$0 = sDFText;
            this.x = n;
            this.y = n2;
            this.I = n3;
            this.Z = n4;
            this.C = string;
        }

        public String toString() {
            return this.C + ", y=" + this.y + ",heigth=" + this.Z;
        }
    }
}

