/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUDBField;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.util.HashVector;
import toolkit.db.ProcColumnInfo;

public class JetUProcField
extends JetUResourceField
implements JetUDBField,
JetUQueriableField {
    public JetNumber columnIndex;
    public JetString colName;
    public JetNumber sqlType;
    public JetNumber precision;
    public JetNumber length;
    public JetNumber scale;
    public JetNumber radix;
    public JetNumber nullable;
    public JetNumber currency;
    public JetBoolean array;
    private static final HashMap COMBO_EDITOR = new HashMap(43);
    private static final HashVector I;

    public JetUProcField() {
    }

    public JetUProcField(String string, String string2, ProcColumnInfo procColumnInfo) {
        super(string, string2);
        this.columnIndex.set(procColumnInfo.iIndex);
        this.colName.set(procColumnInfo.strName);
        this.sqlType.set(procColumnInfo.iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(procColumnInfo.iPrecision);
        this.scale.set(procColumnInfo.iScale);
        this.nullable.set(procColumnInfo.iNullable);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array.set(procColumnInfo.bArray);
        this.setHAlignmentDefault(procColumnInfo.iSQLType);
        this.setVAlignmentDefault(procColumnInfo.iSQLType);
        this.setFormatDefault(procColumnInfo.iSQLType);
    }

    void I() {
        super.I();
        this.colName = new JetString(this, "ColumnName");
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.scale = new JetNumber(this, "Scale");
        this.nullable = new JetNumber(this, "Nullable");
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.columnIndex = new JetNumber(this, "ColumnIndex");
        this.radix = new JetNumber(this, "Radix");
        this.length = new JetNumber(this, "Length");
        this.currency = new JetNumber(this, "Currency");
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array = new JetBoolean(this, "Array");
    }

    public JetUQueriable getQueriable() {
        return this.getProcedure();
    }

    public JetUProcedure getProcedure() {
        return (JetUProcedure)this.getParent();
    }

    public String getQueriableName() {
        JetUProcedure jetUProcedure = this.getProcedure();
        if (jetUProcedure != null) {
            return jetUProcedure.getResourceName();
        }
        return null;
    }

    public String getFldName() {
        return this.colName.get();
    }

    public void setFldName(String string) {
        this.colName.set(string);
    }

    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int n) {
        this.sqlType.set(n);
        this.setHAlignmentDefault(n);
        this.setVAlignmentDefault(n);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int n) {
        this.precision.set(n);
    }

    public int getLength() {
        return this.length.get();
    }

    public void setLength(int n) {
        this.length.set(n);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int n) {
        this.scale.set(n);
    }

    public boolean getArray() {
        return this.array.get();
    }

    public void setArray(boolean bl) {
        this.array.set(bl);
    }

    public int getRadix() {
        return this.radix.get();
    }

    public void setRadix(int n) {
        this.radix.set(n);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int n) {
        this.nullable.set(n);
    }

    public int getColIndex() {
        return this.columnIndex.get();
    }

    public void setColIndex(int n) {
        this.columnIndex.set(n);
    }

    public DbColDesc getColDesc() {
        DbColDesc dbColDesc = new DbColDesc(this.getFldName(), this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable());
        if (this.currency.get() > 0) {
            dbColDesc.setCurrency(true);
        }
        dbColDesc.setArray(this.getArray());
        this.addCaseSensitiveInfo(dbColDesc);
        this.addEncodingPattern(dbColDesc);
        return dbColDesc;
    }

    public String getTableName() {
        return null;
    }

    public JetUTableView getTable() {
        return null;
    }

    public String getDefinition() {
        return null;
    }

    public String toString() {
        String string = "ProcField[" + this.getResourceName() + "|" + this.getQueriableName() + "|" + this.getFldName() + " ]";
        return string;
    }

    public String getInstancePrefix() {
        return "ProcedureField";
    }

    public boolean isSimilar(JetUResourceEntity jetUResourceEntity) {
        return super.isSimilar(jetUResourceEntity) && this.columnIndex.equal(((JetUProcField)jetUResourceEntity).columnIndex) && this.colName.equal(((JetUProcField)jetUResourceEntity).colName) && this.sqlType.equal(((JetUProcField)jetUResourceEntity).sqlType);
    }

    public HashMap getIndecialMap() {
        return COMBO_EDITOR;
    }

    public HashVector getPropGrpsDesc() {
        return I;
    }

    static {
        COMBO_EDITOR.put("SQLType", new Integer(0));
        COMBO_EDITOR.put("padding-right", new Integer(1));
        COMBO_EDITOR.put("RightLine", new Integer(2));
        COMBO_EDITOR.put("HorizontalAlignment", new Integer(3));
        COMBO_EDITOR.put("PatternStyle", new Integer(4));
        COMBO_EDITOR.put("Format", new Integer(5));
        COMBO_EDITOR.put("Precision", new Integer(6));
        COMBO_EDITOR.put("Length", new Integer(7));
        COMBO_EDITOR.put("Bold", new Integer(8));
        COMBO_EDITOR.put("AutoFit", new Integer(9));
        COMBO_EDITOR.put("Width", new Integer(10));
        COMBO_EDITOR.put("GUIField", new Integer(11));
        COMBO_EDITOR.put("Height", new Integer(12));
        COMBO_EDITOR.put("Radix", new Integer(13));
        COMBO_EDITOR.put("padding-bottom", new Integer(14));
        COMBO_EDITOR.put("Array", new Integer(15));
        COMBO_EDITOR.put("Name", new Integer(16));
        COMBO_EDITOR.put("ShadowColor", new Integer(17));
        COMBO_EDITOR.put("ColumnIndex", new Integer(18));
        COMBO_EDITOR.put("BottomLine", new Integer(19));
        COMBO_EDITOR.put("padding-top", new Integer(20));
        COMBO_EDITOR.put("Description", new Integer(21));
        COMBO_EDITOR.put("BorderWidth", new Integer(22));
        COMBO_EDITOR.put("Background", new Integer(23));
        COMBO_EDITOR.put("Scale", new Integer(24));
        COMBO_EDITOR.put("DisplayWidth", new Integer(25));
        COMBO_EDITOR.put("VerticalAlignment", new Integer(26));
        COMBO_EDITOR.put("PatternColor", new Integer(27));
        COMBO_EDITOR.put("TopLine", new Integer(28));
        COMBO_EDITOR.put("FontSize", new Integer(29));
        COMBO_EDITOR.put("Underline", new Integer(30));
        COMBO_EDITOR.put("LeftLine", new Integer(31));
        COMBO_EDITOR.put("Nullable", new Integer(32));
        COMBO_EDITOR.put("ColumnName", new Integer(33));
        COMBO_EDITOR.put("FontFace", new Integer(34));
        COMBO_EDITOR.put("Alignment", new Integer(35));
        COMBO_EDITOR.put("padding-left", new Integer(36));
        COMBO_EDITOR.put("WordWrap", new Integer(37));
        COMBO_EDITOR.put("Italic", new Integer(38));
        COMBO_EDITOR.put("StrikeOut", new Integer(39));
        COMBO_EDITOR.put("BorderColor", new Integer(40));
        COMBO_EDITOR.put("Currency", new Integer(41));
        COMBO_EDITOR.put("Foreground", new Integer(42));
        COMBO_EDITOR.put("Shadow", new Integer(43));
        I = new HashVector(7);
        String string = null;
        Vector<String> vector = null;
        string = "General";
        vector = new Vector<String>(13);
        vector.add("Name");
        vector.add("Description");
        vector.add("GUIField");
        vector.add("DisplayWidth");
        vector.add("ColumnName");
        vector.add("ColumnIndex");
        vector.add("SQLType");
        vector.add("Precision");
        vector.add("Scale");
        vector.add("Nullable");
        vector.add("Currency");
        vector.add("Array");
        vector.add("Radix");
        vector.add("Length");
        I.put(string, vector);
        string = "TextFormat";
        vector = new Vector(11);
        vector.add("FontFace");
        vector.add("FontSize");
        vector.add("Bold");
        vector.add("Italic");
        vector.add("StrikeOut");
        vector.add("Underline");
        vector.add("Format");
        vector.add("AutoFit");
        vector.add("WordWrap");
        vector.add("VerticalAlignment");
        vector.add("HorizontalAlignment");
        I.put(string, vector);
        string = "Padding";
        vector = new Vector(4);
        vector.add("padding-top");
        vector.add("padding-bottom");
        vector.add("padding-left");
        vector.add("padding-right");
        I.put(string, vector);
        string = "Geometry";
        vector = new Vector(2);
        vector.add("Width");
        vector.add("Height");
        I.put(string, vector);
        string = "Color";
        vector = new Vector(2);
        vector.add("Background");
        vector.add("Foreground");
        I.put(string, vector);
        string = "Border";
        vector = new Vector(8);
        vector.add("BorderWidth");
        vector.add("TopLine");
        vector.add("BottomLine");
        vector.add("LeftLine");
        vector.add("RightLine");
        vector.add("Shadow");
        vector.add("BorderColor");
        vector.add("ShadowColor");
        I.put(string, vector);
        string = "Pattern";
        vector = new Vector(2);
        vector.add("PatternColor");
        vector.add("PatternStyle");
        I.put(string, vector);
    }
}

