/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jet.JResource;
import jet.log.JRLogger;
import toolkit.db.DateTimeFormat;
import toolkit.db.ParaInterface;

public class ProcParaInfo
implements ParaInterface {
    public static final String JDBC_FALSE = "0";
    public static final String JDBC_TRUE = "1";
    public static final String INT_VALUE = "0";
    public static final String FLOAT_VALUE = "0.0";
    public static final String CHAR_VALUE = "";
    public static final String BINARY_VALUE = "";
    public int iIndex;
    public String strName;
    public int iType;
    public int iSQLType;
    public String strSQLTypeName;
    public int iPrecision;
    public int iLength;
    public short iScale;
    public short iRadix;
    public short iNullable;
    public boolean bPromptNextTime;
    public String value = null;
    public boolean bIsNull = false;
    public String sResourceName = null;
    private static JRLogger QOIV = JRLogger.getLogger((class$toolkit$db$ProcParaInfo == null ? (class$toolkit$db$ProcParaInfo = ProcParaInfo.class$("toolkit.db.ProcParaInfo")) : class$toolkit$db$ProcParaInfo).getName());
    static Class class$toolkit$db$ProcParaInfo;

    public ProcParaInfo(int n, String string, int n2, int n3, String string2, int n4, int n5, short s, short s2, short s3, boolean bl, String string3) {
        this.iIndex = n;
        this.strName = string;
        this.iType = n2;
        this.iSQLType = n3;
        this.strSQLTypeName = string2;
        this.iPrecision = n4;
        this.iLength = n5;
        this.iScale = s;
        this.iRadix = s2 > 0 ? s2 : (short)10;
        this.iNullable = s3;
        this.bPromptNextTime = bl;
        this.value = string3;
    }

    public ProcParaInfo(int n, String string, int n2, int n3, String string2, int n4, int n5, short s, short s2, short s3, boolean bl, String string3, boolean bl2) {
        this(n, string, n2, n3, string2, n4, n5, s, s2, s3, bl, string3);
        this.bIsNull = bl2;
    }

    public ProcParaInfo(int n, String string, int n2, int n3, String string2, int n4, int n5, short s, short s2, short s3, boolean bl, DateTimeFormat dateTimeFormat) {
        this(n, string, n2, n3, string2, n4, n5, s, s2, s3, bl, "");
        if (this.isINParameter()) {
            this.getDefaultValue(dateTimeFormat);
        }
    }

    public String getName() {
        return this.strName;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public int getType() {
        return this.iType;
    }

    public int getSQLType() {
        return this.iSQLType;
    }

    public String getSQLTypeName() {
        return this.strSQLTypeName;
    }

    public int getLength() {
        return this.iLength;
    }

    public short getScale() {
        return this.iScale;
    }

    public int getRadix() {
        return this.iRadix;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getIfPrompt() {
        return this.bPromptNextTime;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setIfPrompt(boolean bl) {
        this.bPromptNextTime = bl;
    }

    public boolean isBinaryParameter() {
        return this.iSQLType == -2 || this.iSQLType == -3 || this.iSQLType == -4;
    }

    public boolean isINParameter() {
        return this.iType == 1 || this.iType == 2;
    }

    public boolean isOUTParameter() {
        return this.iType == 4 || this.iType == 2;
    }

    public boolean isValueValid(DateTimeFormat dateTimeFormat) {
        return ProcParaInfo.isValid(this, this.value, dateTimeFormat);
    }

    protected void getDefaultValue(DateTimeFormat dateTimeFormat) {
        switch (this.iSQLType) {
            case -7: {
                this.value = JDBC_TRUE;
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                this.value = "0";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.value = FLOAT_VALUE;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.value = "";
                break;
            }
            case 91: {
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getDateFormat());
                this.value = simpleDateFormat.format(date);
                break;
            }
            case 92: {
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getTimeFormat());
                this.value = simpleDateFormat.format(date);
                break;
            }
            case 93: {
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getTimestampFormat());
                this.value = simpleDateFormat.format(date);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.value = "";
                break;
            }
        }
    }

    public static boolean isValid(ParaInterface paraInterface, String string, DateTimeFormat dateTimeFormat) {
        boolean bl = true;
        if (string.length() == 0) {
            return true;
        }
        try {
            switch (paraInterface.getSQLType()) {
                case -7: {
                    bl = string.equals("0") || string.equals(JDBC_TRUE);
                    break;
                }
                case -6: {
                    Byte.parseByte(string, paraInterface.getRadix());
                    break;
                }
                case 5: {
                    Short.parseShort(string, paraInterface.getRadix());
                    break;
                }
                case 4: {
                    Integer.parseInt(string, paraInterface.getRadix());
                    break;
                }
                case -5: {
                    Long.parseLong(string, paraInterface.getRadix());
                    break;
                }
                case 7: {
                    new Float(string);
                    break;
                }
                case 6: 
                case 8: {
                    new Double(string);
                    break;
                }
                case 2: 
                case 3: {
                    new BigDecimal(string);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    break;
                }
                case 91: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getDateFormat());
                    Date date = simpleDateFormat.parse(string);
                    bl = date != null;
                    break;
                }
                case 92: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getTimeFormat());
                    Date date = simpleDateFormat.parse(string);
                    bl = date != null;
                    break;
                }
                case 93: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getTimestampFormat());
                    Date date = simpleDateFormat.parse(string);
                    bl = date != null;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (QOIV.isErrorEnabled()) {
                QOIV.error("", numberFormatException);
            }
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (QOIV.isErrorEnabled()) {
                QOIV.error("", illegalArgumentException);
            }
            bl = false;
        }
        catch (ParseException parseException) {
            if (QOIV.isErrorEnabled()) {
                QOIV.error("", parseException);
            }
            bl = false;
        }
        return bl;
    }

    public static String getSampleValue(ParaInterface paraInterface, DateTimeFormat dateTimeFormat) {
        String string = null;
        String string2 = JResource.getMessage("CAT_98");
        String string3 = JResource.getMessage("CAT_99");
        String string4 = JResource.getMessage("CAT_100");
        String string5 = JResource.getMessage("CAT_101");
        switch (paraInterface.getSQLType()) {
            case -7: {
                string = "0 " + string2 + " " + JDBC_TRUE;
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                string = string3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = string4;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = string5;
                break;
            }
            case 91: {
                string = dateTimeFormat.getDateFormat();
                break;
            }
            case 92: {
                string = dateTimeFormat.getTimeFormat();
                break;
            }
            case 93: {
                string = dateTimeFormat.getTimestampFormat();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                break;
            }
        }
        return string;
    }

    public String getResourceName() {
        return this.sResourceName;
    }

    public void setResourceName(String string) {
        this.sResourceName = string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

