/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.GridLine;
import chart.axis.ChartNumericAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DPaper;
import chart.data.ChartDataSet;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Chart2DRadarLayer
extends Chart2DLayer {
    private int QOIV;
    private Chart2DPaper append;
    private int cos;
    private float[][] draw;
    private float[][] drawRadarCircleGrid;
    private float[][] get;
    private float[][] getCategorySize;
    private float[][] getChartDataSets;
    private Line2D.Float[] getGraphArea;
    private boolean getGraphProperties;

    Chart2DRadarLayer(Chart2DPaper chart2DPaper) {
        super(chart2DPaper);
        this.append = chart2DPaper;
    }

    public void init() {
        super.init();
        List list = this.append.model.getChartDataSets();
        ChartDataSet chartDataSet = (ChartDataSet)list.get(0);
        this.QOIV = chartDataSet.getCategorySize();
        this.getCategorySize = new float[this.QOIV][2];
        this.getChartDataSets = new float[this.QOIV][2];
        this.getGraphArea = new Line2D.Float[this.QOIV];
        this.gridYAreaPath = new GeneralPath();
        int n = 0;
        while (n < this.QOIV) {
            this.getGraphArea[n] = new Line2D.Float();
            ++n;
        }
    }

    public void paintAxis(Graphics2D graphics2D) {
        if (this.axisY != null && this.axisY.isShow()) {
            float[][] fArray2 = new float[this.QOIV + 1][2];
            fArray2[0][0] = this.tYPos[0][0];
            fArray2[0][1] = this.tYPos[0][1];
            this.axisY.setLabelPoint(this.tYTickPos);
            int n = 0;
            while (n < this.QOIV) {
                fArray2[n + 1][0] = this.tYPos[n + 1][0];
                fArray2[n + 1][1] = this.tYPos[n + 1][1];
                this.getGraphArea[n].setLine(fArray2[0][0], fArray2[0][1], fArray2[n + 1][0], fArray2[n + 1][1]);
                ++n;
            }
            ((ChartNumericRadarAxis)this.axisY).setAxisPoint(fArray2);
            ((ChartNumericRadarAxis)this.axisY).paint(graphics2D);
            ((ChartNumericRadarAxis)this.axisY).setRadarAxisAreaPath(this.getGraphArea);
        }
    }

    public void locate() {
        super.locate();
        int n = 25;
        int n2 = this.append.getProperties().getGraphProperties().getRadarArrowStyle();
        if (n2 == 0) {
            n = 5;
        }
        double d = Math.PI * 2 / (double)this.QOIV;
        int n3 = this.append.getGraphArea().height;
        int n4 = this.append.getGraphArea().width;
        this.axisYPos = new float[this.QOIV + 1][2];
        this.tYPos = new float[this.QOIV + 1][2];
        this.axisYPos[0][0] = n4 / 2;
        this.axisYPos[0][1] = n3 / 2;
        int n5 = n3 > n4 ? n4 : n3;
        n5 = this.getRadarAxisLength(n5);
        float f = this.axisY.getUnit(n5);
        double d2 = 1.5707963267948966;
        int n6 = 0;
        while (n6 < this.QOIV) {
            this.axisYPos[n6 + 1][0] = (float)(n4 / 2) + (float)n5 * (float)Math.cos(d * (double)n6 + d2);
            this.axisYPos[n6 + 1][1] = (float)(n3 / 2) + (float)n5 * (float)Math.sin(d * (double)n6 + d2);
            this.getCategorySize[n6][0] = (float)(n4 / 2) + (float)(n5 + n) * (float)Math.cos(d * (double)n6 + d2);
            this.getCategorySize[n6][1] = (float)(n3 / 2) + (float)(n5 + n) * (float)Math.sin(d * (double)n6 + d2);
            ++n6;
        }
        this.setAxisY(f, this.axisYPos[0][0]);
        ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisY;
        this.cos = chartNumericAxis.getNumOfTick();
        this.tYTickPos = new float[this.yTickPos.length][2];
        this.drawRadarCircleGrid = new float[this.QOIV * this.cos][2];
        this.get = new float[this.QOIV * this.cos][2];
        this.draw = new float[this.QOIV * this.cos][2];
        this.gridYPath = new Line2D[this.QOIV * this.cos];
        int n7 = 0;
        while (n7 < this.QOIV * this.cos) {
            this.gridYPath[n7] = new Line2D.Float();
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.cos) {
            int n9 = 0;
            while (n9 < this.QOIV) {
                this.drawRadarCircleGrid[n8 * this.QOIV + n9][0] = (float)(n4 / 2) + (float)(n8 + 1) / (float)this.cos * (float)n5 * (float)Math.cos(d * (double)n9 + d2);
                this.drawRadarCircleGrid[n8 * this.QOIV + n9][1] = (float)(n3 / 2) + (float)(n8 + 1) / (float)this.cos * (float)n5 * (float)Math.sin(d * (double)n9 + d2);
                ++n9;
            }
            ++n8;
        }
        this.m2.transform(this.axisYPos, this.tYPos);
        this.m2.transform(this.yTickPos, this.tYTickPos);
        this.m2.transform(this.drawRadarCircleGrid, this.get);
        this.m2.transform(this.getCategorySize, this.getChartDataSets);
        ((ChartNumericRadarAxis)this.axisY).setRadarColumnNamePosition(this.getChartDataSets);
    }

    public void paintGrid(Graphics2D graphics2D) {
        block7: {
            if (this.axisY == null || !this.axisY.getProperties().isShowGrid()) break block7;
            GridLine gridLine = new GridLine();
            gridLine.setPenStyle(this.axisY.getProperties().getGridPen());
            this.gridYAreaPath.reset();
            this.getGraphProperties = true;
            if (this.getGraphProperties) {
                int n = 0;
                while (n < this.QOIV * this.cos) {
                    if ((n + 1) % this.QOIV == 0) {
                        this.draw[0][0] = this.get[n][0];
                        this.draw[0][1] = this.get[n][1];
                        this.draw[1][0] = this.get[n - this.QOIV + 1][0];
                        this.draw[1][1] = this.get[n - this.QOIV + 1][1];
                    } else {
                        this.draw[0][0] = this.get[n][0];
                        this.draw[0][1] = this.get[n][1];
                        this.draw[1][0] = this.get[n + 1][0];
                        this.draw[1][1] = this.get[n + 1][1];
                    }
                    this.gridYPath[n].setLine(this.draw[0][0], this.draw[0][1], this.draw[1][0], this.draw[1][1]);
                    gridLine.setLocation(this.draw);
                    gridLine.draw(graphics2D);
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.gridYPath.length) {
                    this.gridYAreaPath.append(this.gridYPath[n2], false);
                    ++n2;
                }
            } else {
                double d = this.tYPos[0][1] - this.get[0][1];
                double d2 = this.tYPos[0][0];
                double d3 = this.tYPos[0][1];
                int n = 0;
                while (n < this.cos) {
                    d = (this.tYPos[0][1] - this.get[0][1]) * (float)(n + 1);
                    Arc2D.Double double_ = new Arc2D.Double(d2 - d, d3 - d, d * 2.0, d * 2.0, 0.0, 360.0, 1);
                    gridLine.drawRadarCircleGrid(graphics2D, double_);
                    ++n;
                }
            }
        }
    }

    protected void setAxisY(float f, float f2) {
        int n;
        ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisY;
        String[] stringArray = chartNumericAxis.getLabels();
        this.yTickPos = new float[stringArray.length][2];
        float f3 = (float)chartNumericAxis.getTickPace() * f;
        this.cos = n = chartNumericAxis.getNumOfTick();
        float f4 = this.append.getGraphArea().height / 2;
        int n2 = 0;
        while (n2 <= n) {
            this.yTickPos[n2][0] = f2;
            this.yTickPos[n2][1] = f4;
            f4 += f3;
            ++n2;
        }
        chartNumericAxis.setAxisPosition(4);
    }

    public int getRadarAxisLength(int n) {
        int n2 = 15;
        int n3 = 5;
        int n4 = 0;
        boolean bl = this.append.getProperties().getGraphProperties().isRadarIsShowColumnName();
        if (!bl) {
            n4 = n - n2 * 2 < 2 ? 2 : (n - n2 * 2) / 2;
            return n4;
        }
        ChartNumericRadarAxis chartNumericRadarAxis = (ChartNumericRadarAxis)this.axisY;
        Dimension dimension = chartNumericRadarAxis.getMaxDimensionOfCategoryLabels();
        n4 = n / 2 - (n2 + n3);
        if (dimension.width == 0 && dimension.height == 0) {
            return n4;
        }
        n4 = dimension.width > dimension.height ? (n4 -= dimension.width) : (n4 -= dimension.height);
        n4 = n4 < 1 ? 1 : n4;
        return n4;
    }

    public void setRadarIsNormalGrid(boolean bl) {
        this.getGraphProperties = bl;
    }

    public boolean getRadarIsNormalGrid() {
        return this.getGraphProperties;
    }
}

