/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.LocalConvertTuple;
import com.jinfonet.dataservice.relational.MaxrRowID;
import java.util.TimeZone;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataCacheInfo;

public class LocalConvertRelationData
implements IRelationData {
    private IRelationData QOIV;
    private TimeZone close;
    private long createRelation;
    private final int createRowID;
    private JRelationMetaData createTuple;
    private Object getDataCacheInfo = new Object();
    private boolean getIOTime = false;

    public LocalConvertRelationData(TimeZone timeZone, JRelationMetaData jRelationMetaData, long l, int n) {
        this.createTuple = jRelationMetaData;
        this.close = timeZone;
        this.createRelation = l;
        this.createRowID = n;
    }

    public String getName() throws DSException {
        this.check();
        return this.QOIV.getName();
    }

    public ARelation createRelation() throws DSException {
        this.check();
        return this.QOIV.createRelation();
    }

    public JRelationMetaData getMetaData() throws DSException {
        return this.createTuple;
    }

    public ITuple createTuple() throws DSException {
        this.check();
        return new LocalConvertTuple(this.QOIV.createTuple(), this.close, this.createRowID);
    }

    public void removeTuple(ITuple iTuple) throws DSException {
        this.check();
        this.QOIV.removeTuple(((LocalConvertTuple)iTuple).tuple);
    }

    public IRowID createRowID() throws DSException {
        this.check();
        return new MaxrRowID(this.QOIV.createRowID(), (int)this.createRelation);
    }

    public void close() throws DSException {
        this.check();
        this.QOIV.close();
    }

    public boolean isClosed() throws DSException {
        this.check();
        return this.QOIV.isClosed();
    }

    public int getType() throws DSException {
        this.check();
        return this.QOIV.getType();
    }

    public boolean isEmpty() throws DSException {
        this.check();
        return this.QOIV.isEmpty();
    }

    public long getIOTime() {
        this.check();
        return this.QOIV.getIOTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealData(IRelationData iRelationData) {
        Object object = this.getDataCacheInfo;
        synchronized (object) {
            this.QOIV = iRelationData;
            this.getIOTime = true;
            this.getDataCacheInfo.notifyAll();
        }
    }

    private void check() {
        Object object = this.getDataCacheInfo;
        synchronized (object) {
            while (true) {
                if (this.getIOTime) {
                    return;
                }
                try {
                    this.getDataCacheInfo.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public DataCacheInfo getDataCacheInfo() {
        return this.QOIV.getDataCacheInfo();
    }
}

