/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.jinfonet.util.JRLog;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.ReportEnv;
import jet.connect.AdMetaData;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumn;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbLongVariable;
import jet.connect.DbNumber;
import jet.connect.DbPage;
import jet.connect.DbRecordModel;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.exception.EndOfRecordsException;
import jet.exception.NoRecordsFoundException;
import jet.ie.io.FileBlockOutputStream;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.util.IntKeyHashtable;
import jet.util.RAFile;
import jet.util.RandomOutputable;
import jet.util.TempFile;
import jet.util.intChain;

public class DbBuffer
implements Runnable,
ResultSet {
    public static final int BYTE = 1;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 2;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 8;
    public static final int TIME = 8;
    public static final int TIMESTAMP = 12;
    public static final int BUFFER_SIZE = 4096;
    public static final int PAGE_COUNT = 500;
    int C;
    protected int recordPerPage;
    int B;
    protected int currentEnd;
    protected boolean finished;
    private Hashtable WARNING;
    protected DbRecordModel recordModel;
    private IntKeyHashtable addElement;
    private intChain append;
    protected DbPage lastPage;
    protected TempFile tempFile;
    protected File file;
    protected RAFile bufFile;
    protected boolean isFetchingWaited;
    protected int currentReadingRow;
    private int bigDecimalLength;
    private Vector byteValue;
    private Vector cacheThePage;
    protected Hashtable descToBlobFiles;
    protected boolean cacheToFile;
    protected boolean bNeedWaitFetch;
    protected long offsetBegine;
    private boolean class$;
    private boolean clear;
    private Object clearMem;
    private int clone;
    protected int halfCacheRecords;
    private Vector close;
    boolean D;
    int F;
    boolean createRecord;
    private Record createTempFile;
    private AdMetaData debug;
    private boolean decimalNeedBytes;
    private static JRLogger delete;
    private String desiredAssertionStatus;
    Thread doubleValue;
    static Class class$jet$connect$DbBuffer;
    static final boolean $assertionsDisabled;

    public DbBuffer() {
        this.WARNING = new Hashtable(10);
        this.addElement = new IntKeyHashtable();
        this.append = new intChain();
        this.byteValue = new Vector(3);
        this.cacheThePage = new Vector(3);
        this.cacheToFile = true;
        this.bNeedWaitFetch = true;
        this.clearMem = new Object();
        this.clone = -1;
        this.close = new Vector(10);
        this.createRecord = false;
        this.decimalNeedBytes = false;
        this.doubleValue = null;
        this.desiredAssertionStatus = JRLoggingUtil.getNDC();
    }

    public DbBuffer(DbRecordModel dbRecordModel) {
        this(dbRecordModel, new Hashtable(3));
        this.initFile();
    }

    public DbBuffer(DbRecordModel dbRecordModel, boolean bl) {
        block4: {
            this(dbRecordModel, new Hashtable(3));
            this.cacheToFile = bl;
            if (bl) {
                this.initFile();
            } else {
                try {
                    this.lastPage = new DbPage(this, 0);
                }
                catch (IOException iOException) {
                    if (!delete.isErrorEnabled()) break block4;
                    delete.error("", iOException);
                }
            }
        }
    }

    public DbBuffer(boolean bl, DbRecordModel dbRecordModel, int n, int n2, int n3) {
        this(bl, dbRecordModel, new Hashtable(3), n, n2, n3);
        this.cacheToFile = true;
        this.initFile();
    }

    public DbBuffer(DbRecordModel dbRecordModel, Hashtable hashtable) {
        this(false, dbRecordModel, hashtable, 0, 0, 0);
    }

    protected DbBuffer(boolean bl, DbRecordModel dbRecordModel, Hashtable hashtable) {
        this(bl, dbRecordModel, hashtable, 0, 0, 0);
    }

    protected DbBuffer(boolean bl, DbRecordModel dbRecordModel, Hashtable hashtable, int n, int n2, int n3) {
        this.WARNING = new Hashtable(10);
        this.addElement = new IntKeyHashtable();
        this.append = new intChain();
        this.byteValue = new Vector(3);
        this.cacheThePage = new Vector(3);
        this.cacheToFile = true;
        this.bNeedWaitFetch = true;
        this.clearMem = new Object();
        this.clone = -1;
        this.close = new Vector(10);
        this.createRecord = false;
        this.decimalNeedBytes = false;
        this.doubleValue = null;
        this.desiredAssertionStatus = JRLoggingUtil.getNDC();
        this.F = n;
        this.recordModel = dbRecordModel;
        this.descToBlobFiles = hashtable;
        this.D = bl;
        if (n2 > 0) {
            this.recordPerPage = n2;
        }
        if (n3 > 0) {
            this.B = n3;
        }
        dbRecordModel.setDbBuffer(this);
        this.makeRecordPerPage();
        this.halfCacheRecords = n2 * n3 / 2;
        this.createTempFile = dbRecordModel.createRecord();
        this.debug = new AdMetaData(dbRecordModel);
    }

    public boolean isFastPass() {
        return this.createRecord;
    }

    public void setFastPass(boolean bl) {
        this.createRecord = bl;
    }

    public void setSingleThread(boolean bl) {
        this.D = bl;
    }

    public boolean getSingleThread() {
        return this.D;
    }

    public void setPageCount(int n) {
        this.B = n >= 3 ? n : 3;
    }

    public void setRecPerPage(int n) {
        if (n > 0) {
            this.recordPerPage = n;
        }
    }

    public synchronized boolean restart() {
        if (!this.D) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.currentReadingRow = 0;
            this.notifyAll();
            return true;
        }
        if (this.finished) {
            this.currentReadingRow = 0;
            return true;
        }
        return false;
    }

    public void initFile() {
        try {
            this.lastPage = new DbPage(this, 0);
        }
        catch (Exception exception) {
            this.cacheToFile = false;
        }
    }

    protected void createTempFile() {
        try {
            this.tempFile = new TempFile(ReportEnv.temporaryPath, "buffer");
            this.file = this.tempFile.createTempFile();
            this.bufFile = new RAFile(this.file, "rw");
        }
        catch (IOException iOException) {
            this.cacheToFile = false;
        }
    }

    public final int getPageNumberByRowNumber(int n) {
        return n / this.recordPerPage;
    }

    public final int getRealRowNumberByRowNumber(int n) {
        return n % this.recordPerPage;
    }

    public final DbColDesc[] getColDescs() {
        return this.recordModel.getColDescs();
    }

    public int indexOfCell(String string) {
        return this.recordModel.indexOfCell(string);
    }

    public int countColumns() {
        return this.recordModel.getColDescs().length;
    }

    public synchronized int countRecords() {
        if (!this.D) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
            this.notifyAll();
        }
        return this.currentEnd;
    }

    public int getRecords() {
        return this.currentEnd;
    }

    public void setOptimizeFetch(boolean bl) {
        this.class$ = bl;
    }

    public void startOptimizeFetch() {
    }

    public synchronized void finish() {
        this.finished = true;
        if (!this.D) {
            this.notifyAll();
        }
    }

    public boolean finished() {
        return this.finished;
    }

    public synchronized void nextRecord(Record record) throws SQLException {
        this.nextRecord(record, true);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void nextRecord(Record var1_1, boolean var2_2) throws SQLException {
        if (this.currentReadingRow < this.currentEnd || !this.finished) ** GOTO lbl19
        if (this.currentEnd != 0) {
            throw new EndOfRecordsException();
        }
        throw new NoRecordsFoundException();
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
            }
            catch (Exception var3_3) {
                JDebug.WARNING(var3_3);
            }
            if (!this.finished) continue;
            if (this.currentReadingRow >= this.currentEnd && this.currentEnd != 0) {
                if (!this.D) {
                    this.notifyAll();
                }
                throw new EndOfRecordsException();
            }
            if (this.currentEnd != 0) continue;
            if (!this.D) {
                this.notifyAll();
            }
            throw new NoRecordsFoundException();
lbl19:
            // 3 sources

            ** while (this.currentReadingRow >= this.currentEnd && !this.D)
        }
lbl20:
        // 1 sources

        var1_1.setRecordIndex(this.currentReadingRow++);
        this.refreshRecord(var1_1, var2_2);
        if (!this.D) {
            this.notifyAll();
        }
    }

    public synchronized void addRecord(Record record) {
        int n = this.getRealRowNumberByRowNumber(this.currentEnd);
        if (this.currentEnd != 0 && n == 0) {
            if (this.bNeedWaitFetch && this.append.size() == this.B) {
                int n2;
                int n3;
                int n4 = this.append.lastElement();
                if (this.currentReadingRow > 0) {
                    n3 = this.getPageNumberByRowNumber(this.currentReadingRow - 1);
                    n2 = this.getRealRowNumberByRowNumber(this.currentReadingRow - 1);
                } else {
                    n3 = this.getPageNumberByRowNumber(this.currentReadingRow);
                    n2 = this.getRealRowNumberByRowNumber(this.currentReadingRow);
                }
                while ((n3 = this.getPageNumberByRowNumber(this.currentReadingRow > 0 ? this.currentReadingRow - 1 : this.currentReadingRow)) == n4 && (n2 = this.getRealRowNumberByRowNumber(this.currentReadingRow > 0 ? this.currentReadingRow - 1 : this.currentReadingRow)) < this.recordPerPage && this.addElement.size() == this.B && !this.D) {
                    try {
                        this.isFetchingWaited = true;
                        this.wait();
                    }
                    catch (Exception exception) {
                        JDebug.WARNING(exception);
                    }
                }
                this.isFetchingWaited = false;
            }
            DbPage dbPage = this.lastPage;
            this.cacheThePage(dbPage);
            this.lastPage = this.makeNewPage(dbPage.getPageNumber());
        }
        record.setRecordIndex(this.currentEnd++);
        this.lastPage.I(n, record);
        if (!this.D) {
            this.notifyAll();
        }
    }

    public synchronized void updateRecord(Record record) {
        try {
            int n = record.getRecordIndex();
            int n2 = this.getRealRowNumberByRowNumber(n);
            DbPage dbPage = this.getPageOfTheRow(n);
            dbPage.I(n2, record);
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    public synchronized void updateRecord(Record record, int n) {
        try {
            int n2 = record.getRecordIndex();
            int n3 = this.getRealRowNumberByRowNumber(n2);
            DbPage dbPage = this.getPageOfTheRow(n2);
            dbPage.I(n3, record, n);
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRecord(Record record, boolean bl) {
        try {
            int n = 0;
            DbBuffer dbBuffer = this;
            synchronized (dbBuffer) {
                n = record.getRecordIndex();
                if (!$assertionsDisabled && n >= this.currentEnd && this.finished) {
                    throw new AssertionError((Object)"Out of buffer.");
                }
                int n2 = this.getRealRowNumberByRowNumber(n);
                DbPage dbPage = this.getPageOfTheRow(n);
                dbPage.refreshRecord(n2, record, bl);
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRecord(Record record, int n) {
        try {
            int n2 = 0;
            DbBuffer dbBuffer = this;
            synchronized (dbBuffer) {
                n2 = record.getRecordIndex();
                if (!$assertionsDisabled && n2 >= this.currentEnd && this.finished) {
                    throw new AssertionError((Object)"Out of buffer.");
                }
                int n3 = this.getRealRowNumberByRowNumber(n2);
                DbPage dbPage = this.getPageOfTheRow(n2);
                dbPage.Z(n3, record, n);
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    public DbColDesc getColDesc(int n) {
        return this.recordModel.getColDesc(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbPage makeNewPage(int n) {
        DbPage dbPage = null;
        Vector vector = this.close;
        synchronized (vector) {
            if (this.close.size() != 0) {
                dbPage = (DbPage)this.close.lastElement();
                dbPage.setPageNumber(n + 1);
                this.close.removeElement(dbPage);
            }
        }
        try {
            if (dbPage == null) {
                dbPage = new DbPage(this, n + 1);
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
        return dbPage;
    }

    DbColumn[] I(DbPage dbPage) throws IOException {
        DbColDesc[] dbColDescArray = this.recordModel.getColDescs();
        DbColumn[] dbColumnArray = new DbColumn[dbColDescArray.length];
        int n = 0;
        while (n < dbColDescArray.length) {
            block12: {
                block11: {
                    if (!dbColDescArray[n].isGroupable() && !dbColDescArray[n].isConstant()) break block11;
                    dbColumnArray[n] = (DbColumn)this.WARNING.get(dbColDescArray[n]);
                    if (dbColumnArray[n] != null) break block12;
                }
                dbColumnArray[n] = DbColumn.makeDbColumn(dbColDescArray[n], this.recordPerPage);
                if (dbColDescArray[n].isGroupable() || dbColDescArray[n].isConstant()) {
                    this.WARNING.put(dbColDescArray[n], dbColumnArray[n]);
                } else if (dbColumnArray[n] instanceof DbLongVariable) {
                    if (this.cacheToFile) {
                        Object object = this.descToBlobFiles.get(dbColDescArray[n]);
                        if (object == null) {
                            object = ((DbLongVariable)((Object)dbColumnArray[n])).createTempFile();
                            this.cacheThePage.addElement(object);
                            this.byteValue.addElement(((DbLongVariable)((Object)dbColumnArray[n])).getFile());
                            this.descToBlobFiles.put(dbColDescArray[n], object);
                        } else {
                            ((DbLongVariable)((Object)dbColumnArray[n])).setBufFile((RAFile)object);
                        }
                    } else {
                        ((DbLongVariable)((Object)dbColumnArray[n])).setCacheToFile(false);
                    }
                }
            }
            ++n;
        }
        return dbColumnArray;
    }

    protected void makeRecordPerPage() {
        DbColDesc[] dbColDescArray = this.recordModel.getColDescs();
        int n = 0;
        while (n < dbColDescArray.length) {
            if (dbColDescArray[n].isGroupable() || dbColDescArray[n].isConstant() || dbColDescArray[n].isGroupLevel()) {
                switch (dbColDescArray[n].getSqlType()) {
                    case 2: 
                    case 3: {
                        dbColDescArray[n].bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDescArray[n]);
                    }
                }
            } else if (dbColDescArray[n].isArray()) {
                switch (dbColDescArray[n].getSqlType()) {
                    case 2: 
                    case 3: {
                        dbColDescArray[n].bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDescArray[n]);
                    }
                }
                this.C += 8;
                ++this.bigDecimalLength;
            } else {
                ++this.C;
                switch (dbColDescArray[n].getSqlType()) {
                    case -6: {
                        ++this.C;
                        break;
                    }
                    case 5: {
                        this.C += 2;
                        break;
                    }
                    case 4: {
                        this.C += 4;
                        break;
                    }
                    case -5: {
                        this.C += 8;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.C += 8;
                        break;
                    }
                    case 2: 
                    case 3: {
                        dbColDescArray[n].bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDescArray[n]);
                        this.C += dbColDescArray[n].bigDecimalLength;
                        break;
                    }
                    case 8: {
                        this.C += 8;
                        break;
                    }
                    case -7: {
                        this.C += 4;
                        break;
                    }
                    case 91: {
                        this.C += 8;
                        break;
                    }
                    case 92: {
                        this.C += 8;
                        break;
                    }
                    case 93: {
                        this.C += 12;
                        break;
                    }
                    case -2: 
                    case 1: 
                    case 12: {
                        this.C += 4 + dbColDescArray[n].getPrecision() * 1;
                        break;
                    }
                    case -4: 
                    case -1: 
                    case 2004: 
                    case 2005: {
                        this.C += 8;
                        ++this.bigDecimalLength;
                        break;
                    }
                    default: {
                        if (!JRLog.isAd()) break;
                        JRLog.print(new Exception("unknow sql type : " + dbColDescArray[n].getSqlType() + " of the column " + dbColDescArray[n].getColName()));
                    }
                }
            }
            ++n;
        }
        if (this.C == 0) {
            this.C = 1;
        }
        if (this.recordPerPage <= 0) {
            this.recordPerPage = 4096 / this.C;
            if (this.recordPerPage < 10) {
                this.recordPerPage = 10;
            }
        }
        if (this.B <= 0) {
            this.B = 2048000 / (this.C * this.recordPerPage);
            if (this.B == 0) {
                this.B = 3;
            }
        }
        if (delete.isDebugEnabled()) {
            delete.debug("Trace info \n" + this.toString() + "record size is " + this.C);
            delete.debug("Trace info \n" + this.toString() + "records in per page " + this.recordPerPage);
            delete.debug("Trace info \n" + this.toString() + "maximum pages " + this.B);
        }
    }

    public static int decimalNeedBytes(DbColDesc dbColDesc) {
        int n = dbColDesc.getPrecision() + dbColDesc.getScale();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("9");
            ++n2;
        }
        BigInteger bigInteger = new BigInteger(stringBuffer.toString());
        byte[] byArray = bigInteger.toByteArray();
        return byArray.length;
    }

    protected void finalize() {
        this.clearMem();
    }

    public void clearMem() {
        this.WARNING = null;
        this.clear = false;
        this.recordModel = null;
        if (this.append == null) {
            return;
        }
        int[] nArray = this.append.elements();
        int n = 0;
        while (n < nArray.length) {
            DbPage dbPage = (DbPage)this.addElement.get(nArray[n]);
            dbPage.Z();
            ++n;
        }
        if (this.lastPage != null) {
            this.lastPage.Z();
            this.lastPage = null;
        }
        this.addElement.clear();
        this.addElement = null;
        this.close = null;
        this.append = null;
        this.lastPage = null;
        if (this.file != null) {
            try {
                this.bufFile.close();
            }
            catch (IOException iOException) {
                JDebug.WARNING(iOException);
            }
            this.file.delete();
        }
        int n2 = this.byteValue.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                ((RAFile)this.cacheThePage.elementAt(n3)).close();
                ((File)this.byteValue.elementAt(n3)).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void cacheThePage(DbPage var1_1) {
        try {
            block20: {
                block19: {
                    if (this.createRecord) ** GOTO lbl32
                    if (!this.cacheToFile) break block19;
                    if (this.addElement.size() == this.B) {
                        var2_2 = this.append.removeLastElement();
                        var3_7 = (DbPage)this.addElement.remove(var2_2);
                        if (var3_7 != null) {
                            if (this.bufFile == null) {
                                this.createTempFile();
                            }
                            if (this.cacheToFile) {
                                var3_7.refreshToFile(this.bufFile);
                                var3_7.I();
                                var4_9 = this.close;
                                synchronized (var4_9) {
                                    this.close.addElement(var3_7);
                                }
                            }
                        } else {
                            JDebug.WARNING("DbBuffer.cacheThePage()::discardPage is null!(thePage=" + var1_1 + " LRU.removeLastElement()=" + var2_2 + " largestPageSize=" + this.B);
                        }
                    }
                    break block20;
                }
                if (!this.$assertionsDisabled() || this.addElement.size() != this.B || (var3_8 = (DbPage)this.addElement.remove(var2_3 = this.append.removeLastElement())) == null) break block20;
                var3_8.Z();
                break block20;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var2_4) {
                        JDebug.WARNING(var2_4);
                    }
lbl32:
                    // 3 sources

                    ** while (this.addElement.size() == this.B)
                }
            }
            if (this.addElement.get(var2_5 = var1_1.getPageNumber()) == null) {
                this.append.insertElementAt(var2_5, 0);
            }
            this.addElement.put(var2_5, var1_1);
            if (this.createRecord) {
                this.notifyAll();
            }
        }
        catch (IOException var2_6) {
            JDebug.WARNING(var2_6);
        }
    }

    public synchronized void removeDbPage(int n) {
        int[] nArray = this.append.elements();
        boolean bl = false;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            int n3 = nArray[n2];
            if (this.recordPerPage * (n3 + 1) <= n) {
                this.append.removeElement(n3);
                DbPage dbPage = (DbPage)this.addElement.remove(n3);
                dbPage.Z();
                bl = true;
            }
            --n2;
        }
        if (bl) {
            this.notifyAll();
        }
    }

    private boolean $assertionsDisabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbPage QOIV(int n) throws IOException {
        DbPage dbPage = null;
        Vector vector = this.close;
        synchronized (vector) {
            if (this.close.size() != 0) {
                dbPage = (DbPage)this.close.lastElement();
                this.close.removeElement(dbPage);
            }
        }
        if (dbPage == null) {
            dbPage = new DbPage(this, n);
        } else {
            dbPage.setPageNumber(n);
        }
        if (this.bufFile == null) {
            this.createTempFile();
        }
        this.bufFile.seek(this.offsetBegine + (long)this.C * (long)this.recordPerPage * (long)n);
        dbPage.readFromFile(this.bufFile);
        return dbPage;
    }

    private void WARNING(DbPage dbPage) {
        if (this.append.firstElement() != dbPage.getPageNumber()) {
            int n = dbPage.getPageNumber();
            this.append.removeElement(n);
            this.append.insertElementAt(n, 0);
        }
    }

    protected DbPage getPageOfTheRow(int n) throws IOException {
        int n2 = this.getPageNumberByRowNumber(n);
        DbPage dbPage = null;
        if (this.lastPage != null && n2 == this.lastPage.getPageNumber()) {
            dbPage = this.lastPage;
        } else {
            dbPage = (DbPage)this.addElement.get(n2);
            if (dbPage == null) {
                dbPage = this.QOIV(n2);
                this.cacheThePage(dbPage);
            } else if (this.finished) {
                this.WARNING(dbPage);
            }
        }
        return dbPage;
    }

    public DbRecordModel getRecordModel() {
        return this.recordModel;
    }

    public void setRecordModel(DbRecordModel dbRecordModel) {
        this.recordModel = dbRecordModel;
        this.debug = new AdMetaData(dbRecordModel);
    }

    public void setMetaData(AdMetaData adMetaData) {
        this.debug = adMetaData;
    }

    public void setNeedWaitFetch(boolean bl) {
        this.bNeedWaitFetch = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllToFile() throws IOException {
        if (!this.cacheToFile) {
            return;
        }
        if (this.bufFile == null) {
            this.createTempFile();
        }
        if (!this.cacheToFile) {
            return;
        }
        RAFile rAFile = this.bufFile;
        synchronized (rAFile) {
            int[] nArray = this.append.elements();
            int n = 0;
            while (n < nArray.length) {
                DbPage dbPage = (DbPage)this.addElement.get(nArray[n]);
                dbPage.refreshToFile(this.bufFile);
                ++n;
            }
            if (this.lastPage != null) {
                this.lastPage.refreshToFile(this.bufFile);
            }
        }
    }

    public void saveTo(RandomOutputable randomOutputable) throws IOException {
        if (this.bufFile != null) {
            this.refreshAllToFile();
            this.bufFile.saveTo(new FileBlockOutputStream(randomOutputable));
        } else {
            long l = randomOutputable.getPosition();
            int[] nArray = this.append.elements();
            int n = 0;
            while (n < nArray.length) {
                DbPage dbPage = (DbPage)this.addElement.get(nArray[n]);
                dbPage.write(randomOutputable, l);
                ++n;
            }
            if (this.lastPage != null) {
                this.lastPage.write(randomOutputable, l);
            }
        }
    }

    public int countPage() {
        return this.currentEnd / this.recordPerPage + (this.currentEnd % this.recordPerPage != 0 ? 1 : 0);
    }

    public DbPage fetchPage(DbPage dbPage, int n) throws IOException {
        if (this.cacheToFile) {
            if (dbPage == null) {
                dbPage = new DbPage(this, n);
            } else {
                dbPage.setPageNumber(n);
            }
            dbPage.readFromFile(this.bufFile);
            return dbPage;
        }
        if (this.lastPage != null && n == this.lastPage.getPageNumber()) {
            return this.lastPage;
        }
        return (DbPage)this.addElement.get(n);
    }

    public int getBlobCount() {
        return this.bigDecimalLength;
    }

    public final int getRecordPerPage() {
        return this.recordPerPage;
    }

    public final int getRecordSize() {
        return this.C;
    }

    public final Vector getBlobFiles() {
        return this.cacheThePage;
    }

    protected long[] getBlobEntrys(int n) throws IOException {
        long[] lArray = null;
        DbPage dbPage = this.getPageOfTheRow(n);
        int n2 = this.getRealRowNumberByRowNumber(n);
        if (this.bigDecimalLength != 0) {
            lArray = new long[this.bigDecimalLength];
            int n3 = 0;
            int n4 = 1;
            while (n4 < dbPage.Z.length) {
                if (dbPage.Z[n4] instanceof DbLongVariable) {
                    lArray[n3++] = ((DbLongColumnBuffer)dbPage.Z[n4]).B[n2];
                }
                ++n4;
            }
        }
        return lArray;
    }

    public int getCurrentEnd() {
        return this.currentEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n;
        boolean bl = false;
        if (this.desiredAssertionStatus != null && !this.desiredAssertionStatus.equals(JRLoggingUtil.getNDC())) {
            JRLoggingUtil.setNDC(this.desiredAssertionStatus);
            bl = true;
        }
        if ((n = this.getPageNumberByRowNumber(this.currentEnd - 1)) <= this.B) {
            return;
        }
        block12: while (this.clear) {
            Object object;
            if (this.clone == -1 && !this.D) {
                object = this.clearMem;
                synchronized (object) {
                    try {
                        this.clearMem.wait(2000L);
                        this.clearMem.notify();
                    }
                    catch (InterruptedException interruptedException) {
                        delete.error("", interruptedException);
                    }
                    continue;
                }
            }
            int n2 = this.getPageNumberByRowNumber(this.clone);
            if (n2 == n - 1) break;
            try {
                int n3 = n2;
                while (n3 < this.B + n2) {
                    if (n3 == n - 1) continue block12;
                    object = this.addElement;
                    synchronized (object) {
                        DbPage dbPage = (DbPage)this.addElement.get(n3);
                        if (dbPage == null) {
                            dbPage = this.QOIV(n3);
                            this.cacheThePage(dbPage);
                            if (!this.D) {
                                try {
                                    this.addElement.notify();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setID(int n) {
        this.F = n;
    }

    public String toString() {
        return super.toString() + '@' + this.F;
    }

    public int getReadCursor() {
        return this.currentReadingRow;
    }

    public void setReadCursor(int n) {
        this.currentReadingRow = n;
    }

    public Object clone() {
        DbRecordModel dbRecordModel = (DbRecordModel)this.recordModel.clone();
        DbBuffer dbBuffer = new DbBuffer(this.D, dbRecordModel, (Hashtable)this.descToBlobFiles.clone(), this.F, this.recordPerPage, this.B);
        dbBuffer.cacheToFile = this.cacheToFile;
        dbBuffer.currentReadingRow = 0;
        dbBuffer.initFile();
        this.currentReadingRow = 0;
        try {
            Record record = null;
            while (this.currentReadingRow < this.currentEnd) {
                record = this.recordModel.createRecord();
                this.nextRecord(record, false);
                dbBuffer.addRecord(record);
            }
            dbBuffer.finished = true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return dbBuffer;
    }

    public boolean absolute(int n) throws SQLException {
        if (n > 0) {
            if (n < this.currentEnd) {
                this.currentReadingRow = n - 1;
                this.nextRecord(this.createTempFile, false);
                return true;
            }
            this.currentReadingRow = this.currentEnd;
            return false;
        }
        if (n < 0) {
            if (-n > this.currentEnd - 1) {
                this.currentReadingRow = 0;
                this.nextRecord(this.createTempFile, false);
                return true;
            }
            this.currentReadingRow = this.currentEnd - n;
            this.nextRecord(this.createTempFile, false);
            return true;
        }
        return false;
    }

    public boolean first() throws SQLException {
        if (this.currentEnd > 0 && this.finished) {
            this.createTempFile = this.recordModel.createRecord();
            this.currentReadingRow = 0;
            this.nextRecord(this.createTempFile, false);
            return true;
        }
        return false;
    }

    public boolean last() throws SQLException {
        this.currentReadingRow = this.currentEnd - 1;
        this.createTempFile = this.recordModel.createRecord();
        this.nextRecord(this.createTempFile, false);
        return true;
    }

    public boolean next() throws SQLException {
        this.createTempFile = this.recordModel.createRecord();
        if (this.currentReadingRow < this.currentEnd) {
            this.nextRecord(this.createTempFile, false);
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        --this.currentReadingRow;
        if (this.currentReadingRow >= 0) {
            this.createTempFile = this.recordModel.createRecord();
            this.nextRecord(this.createTempFile, false);
            return true;
        }
        return false;
    }

    public boolean relative(int n) throws SQLException {
        int n2 = this.currentReadingRow + n;
        if (n2 < 0) {
            this.currentReadingRow = 0;
            this.createTempFile = this.recordModel.createRecord();
            this.nextRecord(this.createTempFile, false);
            return false;
        }
        if (n2 >= this.currentEnd) {
            this.currentReadingRow = this.currentEnd;
            return false;
        }
        this.currentReadingRow = n2;
        this.createTempFile = this.recordModel.createRecord();
        this.nextRecord(this.createTempFile, false);
        return true;
    }

    public void afterLast() throws SQLException {
        this.currentReadingRow = this.currentEnd;
    }

    public boolean isFirst() throws SQLException {
        return this.currentReadingRow == 0;
    }

    public boolean isLast() throws SQLException {
        return this.currentReadingRow == this.currentEnd - 1 && this.finished;
    }

    public int findColumn(String string) throws SQLException {
        return this.indexOfCell(string);
    }

    public Array getArray(int n) throws SQLException {
        return null;
    }

    public Array getArray(String string) throws SQLException {
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException();
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbDecimal) {
            return ((DbDecimal)dbValue).get();
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbDecimal) {
            return ((DbDecimal)dbValue).get();
        }
        return null;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        throw new SQLException();
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        throw new SQLException();
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException();
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException();
    }

    public boolean getBoolean(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbBit) {
            return ((DbBit)dbValue).get();
        }
        return false;
    }

    public boolean getBoolean(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbDecimal) {
            return ((DbBit)dbValue).get();
        }
        return false;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException();
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException();
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException();
    }

    public int getConcurrency() throws SQLException {
        return 0;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public Date getDate(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbDateTime) {
            return (Date)((DbDateTime)dbValue).toSqlDate();
        }
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    public Date getDate(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbDateTime) {
            return (Date)((DbDateTime)dbValue).toSqlDate();
        }
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    public float getFloat(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).floatValue();
        }
        return 0.0f;
    }

    public float getFloat(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).floatValue();
        }
        return 0.0f;
    }

    public int getInt(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).intValue();
        }
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getNanos();
        }
        return 0;
    }

    public int getInt(String string) {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).intValue();
        }
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getNanos();
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).longValue();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).get();
        }
        return 0L;
    }

    public long getLong(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).longValue();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).get();
        }
        return 0L;
    }

    public double getDouble(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).doubleValue();
        }
        return 0.0;
    }

    public double getDouble(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).doubleValue();
        }
        return 0.0;
    }

    public short getShort(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).shortValue();
        }
        return 0;
    }

    public short getShort(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).shortValue();
        }
        return 0;
    }

    public byte getByte(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).byteValue();
        }
        return 0;
    }

    public byte getByte(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).byteValue();
        }
        return 0;
    }

    public byte[] getBytes(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).getRaw();
        }
        return null;
    }

    public byte[] getBytes(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).getRaw();
        }
        return null;
    }

    public int getFetchDirection() throws SQLException {
        return 1003;
    }

    public int getFetchSize() throws SQLException {
        throw new SQLException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.debug;
    }

    public Object getObject(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbBinary) {
            return ((DbBinary)dbValue).get();
        }
        if (dbValue instanceof DbBit) {
            return new Boolean(((DbBit)dbValue).get());
        }
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).get();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).toSqlDate();
        }
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).toString();
        }
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException();
    }

    public Object getObject(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbBinary) {
            return ((DbBinary)dbValue).get();
        }
        if (dbValue instanceof DbBit) {
            return new Boolean(((DbBit)dbValue).get());
        }
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).get();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).toSqlDate();
        }
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).toString();
        }
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException();
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException();
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException();
    }

    public int getRow() throws SQLException {
        return this.currentReadingRow + 1;
    }

    public Statement getStatement() throws SQLException {
        throw new SQLException();
    }

    public String getString(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        return this.createTempFile.getCell(n).toString();
    }

    public String getString(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        return dbValue.toString();
    }

    public Time getTime(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbTime) {
            return ((DbTime)dbValue).getTime();
        }
        return null;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    public Time getTime(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbTime) {
            return ((DbTime)dbValue).getTime();
        }
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(n);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getTimestamp();
        }
        return null;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        DbValue dbValue = this.createTempFile.getCell(string);
        this.decimalNeedBytes = dbValue.isNull();
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getTimestamp();
        }
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    public int getType() throws SQLException {
        return 0;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException();
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException();
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException();
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException();
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentReadingRow >= this.currentEnd;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.currentEnd > 0) {
            return this.currentReadingRow == 0;
        }
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean wasNull() throws SQLException {
        return this.decimalNeedBytes;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
    }

    public void updateByte(int n, byte by) throws SQLException {
    }

    public void updateByte(String string, byte by) throws SQLException {
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
    }

    public void updateDate(int n, Date date) throws SQLException {
    }

    public void updateDate(String string, Date date) throws SQLException {
    }

    public void updateDouble(int n, double d) throws SQLException {
    }

    public void updateDouble(String string, double d) throws SQLException {
    }

    public void updateFloat(int n, float f) throws SQLException {
    }

    public void updateFloat(String string, float f) throws SQLException {
    }

    public void updateInt(int n, int n2) throws SQLException {
    }

    public void updateInt(String string, int n) throws SQLException {
    }

    public void updateLong(int n, long l) throws SQLException {
    }

    public void updateLong(String string, long l) throws SQLException {
    }

    public void updateNull(int n) throws SQLException {
    }

    public void updateNull(String string) throws SQLException {
    }

    public void updateObject(int n, Object object) throws SQLException {
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
    }

    public void updateObject(String string, Object object) throws SQLException {
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
    }

    public void updateRow() throws SQLException {
    }

    public void updateShort(int n, short s) throws SQLException {
    }

    public void updateShort(String string, short s) throws SQLException {
    }

    public void updateString(int n, String string) throws SQLException {
    }

    public void updateString(String string, String string2) throws SQLException {
    }

    public void updateTime(int n, Time time2) throws SQLException {
    }

    public void updateTime(String string, Time time2) throws SQLException {
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
    }

    public void refreshRow() throws SQLException {
    }

    public void insertRow() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        this.clearMem();
        this.createTempFile = null;
        this.debug = null;
    }

    public void deleteRow() throws SQLException {
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void beforeFirst() throws SQLException {
        this.currentReadingRow = 0;
        if (this.currentEnd > 0 && this.finished) {
            this.finished = false;
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
    }

    public void updateRef(String string, Ref ref) throws SQLException {
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
    }

    public void updateClob(int n, Clob clob) throws SQLException {
    }

    public void updateClob(String string, Clob clob) throws SQLException {
    }

    public void updateArray(int n, Array array) throws SQLException {
    }

    public void updateArray(String string, Array array) throws SQLException {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$connect$DbBuffer == null ? (class$jet$connect$DbBuffer = DbBuffer.class$("jet.connect.DbBuffer")) : class$jet$connect$DbBuffer).desiredAssertionStatus();
        delete = JRLogger.getLogger((class$jet$connect$DbBuffer == null ? (class$jet$connect$DbBuffer = DbBuffer.class$("jet.connect.DbBuffer")) : class$jet$connect$DbBuffer).getName());
    }
}

