/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbStringColumnBuffer
extends DbColumnBuffer {
    String[] QOIV;
    private final int clearMem;
    boolean equals = false;

    public String[] getBuffer() {
        return this.QOIV;
    }

    public DbStringColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new String[n];
        if (dbColDesc.getEncodingName().equals("UTF8")) {
            this.equals = true;
        }
        this.clearMem = dbColDesc.getPrecision();
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = ((DbChar)dbValue).get();
        if (this.QOIV[n] != null && this.QOIV[n].length() > this.clearMem) {
            this.QOIV[n] = this.QOIV[n].substring(0, this.clearMem);
        }
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbChar)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = this.C.getPrecision();
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            if (this.isNull(n2)) {
                dataOutput.writeInt(0);
                int n3 = 0;
                while (n3 < this.clearMem) {
                    dataOutput.write(0);
                    ++n3;
                }
            } else {
                byte[] byArray;
                if (this.QOIV[n2] == null) {
                    this.QOIV[n2] = "";
                }
                try {
                    byArray = this.equals ? this.QOIV[n2].getBytes("UTF8") : this.QOIV[n2].getBytes();
                }
                catch (Exception exception) {
                    byArray = new byte[]{};
                }
                if (byArray.length < n) {
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    int n4 = 0;
                    int n5 = n - byArray.length;
                    while (n4 < n5) {
                        dataOutput.write(0);
                        ++n4;
                    }
                } else {
                    dataOutput.writeInt(n);
                    dataOutput.write(byArray, 0, n);
                }
            }
            ++n2;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = this.C.getPrecision();
        int n2 = 0;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < this.QOIV.length) {
            n2 = dataInput.readInt();
            dataInput.readFully(byArray);
            this.QOIV[n3] = !this.isNull(n3) && n2 != 0 ? (this.equals ? new String(byArray, 0, n2, "UTF8") : new String(byArray, 0, n2)) : "";
            ++n3;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

