/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.query.AQueryOption;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.util.DSLog;
import jet.dataengine8.query.AQuery;
import jet.dataengine8.query.QueryManager;
import jet.formula.JetRptFormula;
import jet.server.api.SecurityContext;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import toolkit.db.PsqlJoin;

public abstract class ARawDataQuery
extends AQuery
implements JRawDataQuery {
    private static String NULL_ParameterList = "ARawDataQuery";
    protected static final MappingNameBindInfo[] ZERO_MAPPING_NAME_ARRAY = new MappingNameBindInfo[0];
    protected static final JetRptFormula[] ZERO_FORMULA_ARRAY = new JetRptFormula[0];
    protected static final String[] ZERO_STRING_ARRAY = new String[0];
    protected static final PsqlJoin[] ZERO_JOIN_ARRAY = new PsqlJoin[0];
    protected String[] mappingNames = ZERO_STRING_ARRAY;
    protected ParameterValueList parameterValueList;
    protected SpecialFields specialFields;
    protected SecurityContext securityContext;
    protected IExpression filters;
    protected ISortExpression sorter;
    protected boolean isBatchRun = false;
    protected RawDataQueryOption option;
    protected String strFilters;
    protected boolean share;
    private Hashtable QOIV;

    protected ARawDataQuery(QueryManager queryManager, int n) throws DSException {
        super("RawDataQuery", queryManager, n);
    }

    public void setCannotBeChange() {
        super.setCannotBeChange();
        if (this.parameterValueList == null) {
            this.parameterValueList = ParameterValueList.NULL_ParameterList;
        } else {
            this.parameterValueList.setCannotBeChange();
        }
        if (this.option == null) {
            this.option = RawDataQueryOption.defaultOption;
        } else {
            this.option.setCannotBeChange();
        }
    }

    public int getRawDataId() throws DSException {
        super.checkClose();
        return super.getQueryId();
    }

    public String[] getMappingNames() throws DSException {
        super.checkClose();
        return (String[])this.mappingNames.clone();
    }

    public void setMappingNames(String[] stringArray) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (stringArray != null) {
            this.mappingNames = (String[])stringArray.clone();
        }
    }

    public ParameterValueList getParameterValues() throws DSException {
        super.checkClose();
        return this.parameterValueList;
    }

    public void setParameterValues(ParameterValueList parameterValueList) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.parameterValueList = parameterValueList;
    }

    public SpecialFields getSpecialFields() throws DSException {
        super.checkClose();
        return this.specialFields;
    }

    public void setSpecialFields(SpecialFields specialFields) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.specialFields = specialFields;
    }

    public SecurityContext getSecurityContext() throws DSException {
        super.checkClose();
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.securityContext = securityContext;
    }

    public IExpression getFilters() throws DSException {
        super.checkClose();
        return this.filters;
    }

    public void setFilters(IExpression iExpression) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.filters = iExpression;
    }

    public String getStringFormatCondition() throws DSException {
        super.checkClose();
        return this.strFilters;
    }

    public void setStringFormatCondition(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.strFilters = string;
    }

    public boolean isBatchRun() throws DSException {
        super.checkClose();
        return this.isBatchRun;
    }

    public void setBatchRun(boolean bl) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.isBatchRun = bl;
    }

    public RawDataQueryOption getOption() throws DSException {
        super.checkClose();
        return this.option;
    }

    public void setOption(RawDataQueryOption rawDataQueryOption) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.option = rawDataQueryOption;
        super.setCacheZip();
    }

    protected void copyRawDataQuery(ARawDataQuery aRawDataQuery) throws DSException {
        if (this.parameterValueList != null) {
            aRawDataQuery.parameterValueList = this.parameterValueList.copy();
        }
        aRawDataQuery.securityContext = this.securityContext;
        aRawDataQuery.filters = this.filters;
        aRawDataQuery.isBatchRun = this.isBatchRun;
        if (this.option != null) {
            aRawDataQuery.option = this.option.copy();
        }
        if (this.specialFields != null) {
            aRawDataQuery.specialFields = this.specialFields.copy();
        }
        if (this.QOIV != null) {
            aRawDataQuery.QOIV = (Hashtable)this.QOIV.clone();
        }
    }

    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.mappingNames == null || this.mappingNames.length < 1) {
            throw new DSException(1058);
        }
        if (this.specialFields == null) {
            throw new DSException(1108);
        }
        this.specialFields.check();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        int n2 = this.mappingNames.length;
        while (n < n2) {
            String string = this.mappingNames[n];
            if (string == null) {
                throw new DSException(1122);
            }
            if (hashSet.contains(string)) {
                throw new DSException(1107, new Object[]{string});
            }
            hashSet.add(string);
            ++n;
        }
    }

    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("ARawDataQuery: ");
        this.log.indent(NULL_ParameterList);
        super.dump();
        this.log.debug("Mapping names: size = " + this.mappingNames.length);
        this.log.indent(NULL_ParameterList);
        int n = 0;
        int n2 = this.mappingNames.length;
        while (n < n2) {
            String string = this.mappingNames[n];
            this.log.debug(string);
            ++n;
        }
        this.log.deIndent(NULL_ParameterList);
        this.log.debug("End Mapping names.");
        if (this.parameterValueList == null || this.parameterValueList == ParameterValueList.NULL_ParameterList) {
            this.log.debug("parameterValueList is null");
        } else {
            this.parameterValueList.dump();
        }
        if (this.specialFields == null) {
            this.log.debug("specialFields is null");
        } else {
            this.specialFields.dump();
        }
        this.log.debug("SecurityContext: " + this.securityContext);
        this.log.debug("record level filter: " + this.filters);
        this.log.debug("isBatchRun: " + this.isBatchRun);
        if (this.option == null) {
            this.log.debug("option is null, use default options");
            RawDataQueryOption.defaultOption.dump();
        } else {
            this.option.dump();
        }
        this.log.deIndent(NULL_ParameterList);
        this.log.debug("End ARawDataQuery.");
    }

    public AQueryOption getQueryOption() throws DSException {
        super.checkClose();
        return this.getOption();
    }

    protected final void checkMappingName(JetUUniverse jetUUniverse, String string) throws DSException {
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        int n = 0;
        int n2 = this.mappingNames.length;
        while (n < n2) {
            String string2 = this.mappingNames[n];
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string2);
            if (jetUResourceEntity == null && this.QOIV != null) {
                jetUResourceEntity = (JetUFormula)this.QOIV.get(string2.toUpperCase());
            }
            if (jetUResourceEntity == null) {
                throw new DSException(1151, new Object[]{string2, string});
            }
            this.mappingNames[n] = jetUResourceEntity.getResourceName();
            ++n;
        }
    }

    protected final void checkDataSourceName(JetUUniverse jetUUniverse, String string) throws DSException {
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            throw new DSException(1135, new Object[]{string});
        }
    }

    protected final void checkQueryName(JetUUniverse jetUUniverse, String string, String string2) throws DSException {
    }

    public void close() throws DSException {
        if (this.isClose) {
            return;
        }
        List list = (List)this.manager.I().get(this.id);
        if (list != null && !list.isEmpty()) {
            throw new DSException(1135, new Object[]{this.id.toString(), list.toString()});
        }
        super.close();
    }

    protected void clearMemory() {
        super.clearMemory();
        this.mappingNames = null;
        this.parameterValueList = null;
        this.specialFields = null;
        this.securityContext = null;
        this.filters = null;
        this.option = null;
        this.strFilters = null;
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public ISortExpression getSorter() {
        return this.sorter;
    }

    public void setSorter(ISortExpression iSortExpression) {
        this.sorter = iSortExpression;
    }

    public void setReportFormulas(Hashtable hashtable) {
        this.QOIV = hashtable;
    }

    public Hashtable getReportFormulas() {
        if (this.QOIV != null) {
            return this.QOIV;
        }
        return new Hashtable();
    }
}

