/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import com.jinfonet.awt.JFont;
import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Vector;
import jet.datastream.Communicator;
import jet.datastream.DSField;
import jet.datastream.DSParagraph;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.util.Propertiable;
import jet.util.TextBreaker;

public class RenderText
extends Render {
    private int[][] I;
    private int QOIV = -1;
    private int UTFLength = -1;
    private int[][] Z;
    private Vector add;
    private int[] addElement;
    private boolean adjustJustifyString = true;
    private Render.Box adjustString = null;
    private int calculatePadding = -1;

    public RenderText(DSField dSField) {
        this.dsField = dSField;
        JRObjectResult jRObjectResult = (JRObjectResult)((Object)dSField.getParent());
        if (jRObjectResult != null) {
            Communicator communicator = dSField.getCommunicator();
            this.adjustJustifyString = communicator.isHighPrecision();
            this.fromEncoding = communicator.getFromEncoding();
            this.toEncoding = communicator.getToEncoding();
            dSField.setRuntimeComvert(true);
            dSField.setFromEncoding(this.fromEncoding);
            dSField.setToEncoding(this.toEncoding);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void locate() {
        if (this.text == null || this.text.length() == 0) {
            this.add = null;
            return;
        }
        boolean bl = this.dsField.noChangedWidth();
        boolean bl2 = this.dsField.noChangedHeight();
        if (this.adjustString == null || !bl || !bl2) {
            this.adjustString = new Render.Box(this);
            super.calculatePadding(this.adjustString);
        }
        this.x = this.adjustString.x;
        this.y = this.adjustString.y;
        this.width = this.adjustString.I;
        this.height = this.adjustString.Z;
        if (this.I != null) {
            if (this.QOIV < 0) return;
            this.text = Painter.adjustString(this.text);
            int n = this.text.length();
            this.add = new Vector(this.I.length);
            int n2 = this.QOIV;
            int n3 = this.I.length;
            while (n2 <= Math.min(n3 - 1, this.UTFLength)) {
                int n4 = this.I[n2][0] + this.I[n2][1];
                if (n4 > n) {
                    n4 = n;
                }
                if (this.I[n2][0] < n && this.I[n2][0] >= 0) {
                    this.add.addElement(this.text.substring(this.I[n2][0], n4));
                }
                ++n2;
            }
        } else {
            this.add = new Vector(1);
            this.add.add(this.text);
        }
        this.I(this.adjustString, this.layout);
        if (this.isRotation && !this.isWordwrap) {
            this.rotation();
        }
        if (bl && bl2) return;
        this.adjustString = null;
    }

    private void I(Render.Box box, int n) {
        int n2;
        boolean bl = false;
        if (n == 4 || n == 1 || n == 7) {
            bl = true;
        }
        int n3 = box.x;
        int n4 = box.y;
        int n5 = 0;
        int n6 = this.add.size();
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n6];
        this.addElement = new int[n6];
        if (!this.dsField.noChangedHeight() && this.isWordwrap) {
            this.calculatePadding = box.Z / n6;
            n2 = 0;
            while (n2 < n6) {
                this.addElement[n2] = this.calculatePadding;
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n6) {
            if (!bl) {
                rectangle2DArray[n2] = RenderGraphicsToolkit.getBounds((String)this.add.get(n2), this.font, this.adjustJustifyString);
                this.addElement[n2] = Unit.convertPixelToUnit((int)rectangle2DArray[n2].getHeight(), this.resolution);
            } else if (this.calculatePadding == -1) {
                rectangle2DArray[n2] = RenderGraphicsToolkit.getBounds((String)this.add.get(n2), this.font, this.adjustJustifyString);
                this.addElement[n2] = Unit.convertPixelToUnit((int)rectangle2DArray[n2].getHeight(), this.resolution);
                this.calculatePadding = this.addElement[n2];
            } else {
                this.addElement[n2] = this.calculatePadding;
            }
            if (n2 == 0) {
                FontMetrics fontMetrics = this.font instanceof JFont ? ((JFont)((Object)this.font)).getFontMetrics() : TextBreaker.getDefaultToolkit().getFontMetrics(this.font);
                this.addElement[0] = Unit.convertPixelToUnit(fontMetrics.getHeight(), this.resolution);
            }
            n5 += this.addElement[n2];
            ++n2;
        }
        this.Z = new int[n6][2];
        int n7 = box.Z - n5;
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                n4 = box.y + n7 / 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n4 = box.y + n7;
            }
        }
        int n8 = n3;
        int n9 = n4;
        int n10 = 0;
        while (n10 < n6) {
            String string = (String)this.add.elementAt(n10);
            int n11 = this.addElement[n10];
            int n12 = 0;
            if (!bl) {
                n12 = (int)Unit.convertPixelToUnit(rectangle2DArray[n10].getWidth(), this.resolution);
            }
            int n13 = box.I - n12;
            switch (n) {
                case 2: 
                case 5: 
                case 8: {
                    n8 = n3 + n13 / 2;
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    n8 = n3 + n13;
                    break;
                }
                default: {
                    n8 = n3;
                }
            }
            if (n6 > 1 && this.layout > 9) {
                boolean bl2 = true;
                char[] cArray = string.toCharArray();
                int n14 = 0;
                int n15 = cArray.length;
                while (bl2 && n14 < n15) {
                    bl2 &= cArray[n14] == ' ' || cArray[n14] == '\n';
                    ++n14;
                }
                if (n10 == n6 - 1) {
                    bl2 = true;
                }
                if (!bl2) {
                    int n16;
                    while ((n16 = string.length()) > 0 && string.charAt(n16 - 1) == ' ') {
                        string = string.substring(0, string.length() - 1);
                    }
                    n12 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds(string, this.font, this.adjustJustifyString).getWidth(), this.resolution);
                    int n17 = string.indexOf(32);
                    if (n17 > 0 && n17 < n16 - 1) {
                        int n18 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds(" ", this.font, this.adjustJustifyString).getWidth(), this.resolution);
                        while ((n12 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds(string, this.font, this.adjustJustifyString).getBounds().getWidth(), this.resolution)) < this.width - n18) {
                            if (n18 == 0) break;
                            int n19 = (this.width - n12) / n18;
                            string = Painter.adjustJustifyString(string, n19);
                        }
                    }
                }
                this.add.set(n10, string);
            }
            this.Z[n10][0] = n8;
            this.Z[n10][1] = n9;
            n9 += n11;
            ++n10;
        }
    }

    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        Serializable serializable;
        int n5;
        int n6 = this.dsField.getResolution();
        Vector vector = this.getVLines();
        if (vector == null) {
            return;
        }
        graphics.setColor(RenderUtil.getColorPropertyByName(this.dsField, "Foreground"));
        if (this.font == null) {
            String string = RenderUtil.getStringPropertyByName(this.dsField, "FontFace");
            n5 = 0;
            if (RenderUtil.getBooleanPropertyByName(this.dsField, "Bold")) {
                n5 |= 1;
            }
            if (RenderUtil.getBooleanPropertyByName(this.dsField, "Italic")) {
                n5 |= 2;
            }
            float f = Unit.convertUnitToPixel(RenderUtil.getIntPropertyByName(this.dsField, "FontSize"), 72);
            f = f * (float)this.resolution / 72.0f;
            serializable = RenderGraphicsToolkit.getFont(string, n5, f);
            this.font = serializable;
            graphics.setFont((Font)serializable);
        } else {
            graphics.setFont(this.font);
        }
        boolean bl = RenderUtil.getBooleanPropertyByName(this.dsField, "Underline");
        n5 = RenderUtil.getBooleanPropertyByName(this.dsField, "StrikeOut");
        graphics.setFont(this.font);
        int[][] nArray = this.getEveryLinePos();
        serializable = graphics.getFontMetrics();
        int n7 = ((FontMetrics)serializable).getAscent();
        int n8 = 0;
        int n9 = vector.size();
        while (n8 < n9) {
            int n10 = Unit.convertUnitToPixel(nArray[n8][0], n6);
            int n11 = Unit.convertUnitToPixel(nArray[n8][1], n6) + n7;
            Painter.drawText(graphics, (String)vector.get(n8), n10, n11, this.adjustJustifyString);
            int n12 = Math.max((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 1);
            int n13 = (int)RenderGraphicsToolkit.getBounds((String)this.add.get(n8), this.font, this.adjustJustifyString).getWidth();
            if (bl) {
                graphics.fillRect(n10, n11 + 2, n13, n12);
            }
            if (n5 != 0) {
                graphics.fillRect(n10, n11 - ((FontMetrics)serializable).getAscent() / 2 + 1, n13, n12);
            }
            ++n8;
        }
    }

    public int getEndLine() {
        return this.UTFLength;
    }

    public void setEndLine(int n) {
        this.UTFLength = n;
    }

    public int[][] getEveryLinePos() {
        return this.Z;
    }

    public void setEveryLinePos(int[][] nArray) {
        this.Z = nArray;
    }

    public int[][] getLineBreakPos() {
        return this.I;
    }

    public void setLineBreakPos(int[][] nArray) {
        this.I = nArray;
    }

    public int getStartLine() {
        return this.QOIV;
    }

    public void setStartLine(int n) {
        this.QOIV = n;
    }

    public Vector getVLines() {
        return this.add;
    }

    public void setVLines(Vector vector) {
        this.add = vector;
    }

    public int[] getEveryLineHeight() {
        return this.addElement;
    }

    public void setEveryLineHeight(int[] nArray) {
        this.addElement = nArray;
    }

    public boolean canBeCatch() {
        if (this.dsField.getParent() instanceof DSParagraph) {
            return false;
        }
        DSTemplatible dSTemplatible = this.dsField.getTemplate();
        Propertiable propertiable = null;
        propertiable = dSTemplatible.getPropertyByName("Shadow");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("FontFace");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("Bold");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("Italic");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("WordWrap");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("AutoFit");
        return propertiable == null || !propertiable.isChangeByOther();
    }

    public void updateRender(DSField dSField) {
        this.dsField = dSField;
        dSField.setRuntimeComvert(true);
        dSField.setFromEncoding(this.fromEncoding);
        dSField.setToEncoding(this.toEncoding);
        this.setText(dSField.toString());
        this.setStartLine(dSField.getStartLine());
        this.setEndLine(dSField.getEndLine());
        this.setLineBreakPos(dSField.getLineBreakPos());
        this.locate();
    }

    public int memoryLength() {
        int n = super.memoryLength();
        try {
            Vector vector;
            int n2;
            ++n;
            if (this.addElement != null) {
                n += 4 * this.addElement.length;
            }
            if (this.Z != null) {
                n2 = 0;
                while (n2 < this.Z.length) {
                    n += 4 * this.Z[n2].length;
                    ++n2;
                }
            }
            if (this.I != null) {
                n2 = 0;
                while (n2 < this.I.length) {
                    n += 4 * this.I[n2].length;
                    ++n2;
                }
            }
            int n3 = (vector = this.getVLines()) == null ? 0 : vector.size();
            n += 4;
            if (n3 != 0) {
                int n4 = 0;
                while (n4 < n3) {
                    n += JRObjectResult.UTFLength((String)vector.get(n4)) + 2;
                    ++n4;
                }
                n += n3 * 2 * 4;
                n += n3 * 4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public boolean isPrecision() {
        return this.adjustJustifyString;
    }

    public boolean isCutOff() {
        this.isCutOff = false;
        if (this.adjustString == null) {
            this.adjustString = new Render.Box(this);
            super.calculatePadding(this.adjustString);
        }
        int n = 0;
        int n2 = this.add.size();
        while (n < n2) {
            if (this.adjustString.I < (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds((String)this.add.get(n), this.font, this.adjustJustifyString).getWidth(), this.resolution)) {
                this.isCutOff = true;
                return this.isCutOff;
            }
            ++n;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = this.addElement.length;
        while (n4 < n5) {
            n3 += this.addElement[n4];
            ++n4;
        }
        if (!this.isCutOff && this.adjustString.Z < n3) {
            this.isCutOff = true;
        }
        return this.isCutOff;
    }

    public Rectangle getBox() {
        if (this.adjustString == null) {
            return null;
        }
        return new Rectangle(this.adjustString.x, this.adjustString.y, this.adjustString.I, this.adjustString.Z);
    }

    public void clipString() {
        int n;
        if (this.isAutoFit || this.isWordwrap) {
            return;
        }
        int n2 = n = this.add == null ? 0 : this.add.size();
        if (n == 1) {
            String string = (String)this.add.get(0);
            String string2 = TextBreaker.clipString(string, this.font, this.QOIV(), Unit.convertUnitToPixel(this.getBox().width), this.adjustJustifyString);
            if (string2.length() < string.length()) {
                this.add.set(0, string2);
                int n3 = this.Z.length;
                int n4 = 0;
                while (n4 < n3) {
                    this.Z[n4][0] = 0;
                    ++n4;
                }
            }
        } else {
            return;
        }
    }

    private int QOIV() {
        switch (this.layout) {
            case 1: 
            case 4: 
            case 7: {
                return 0;
            }
            case 2: 
            case 5: 
            case 8: {
                return 1;
            }
            case 3: 
            case 6: 
            case 9: {
                return 2;
            }
        }
        return 0;
    }
}

