/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import com.jinfonet.image.encoder.ImageFrameGrabber;
import com.jinfonet.image.encoder.gif.GIFEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import jet.export.util.ImageGrabber;
import jet.util.JpegEncoder;

public class ImageEncoder {
    public static final int ENCODE_ERR = -1;
    public static final int ENCODE_GIF = 1;
    public static final int ENCODE_JPEG = 2;
    public static final int ENCODE_LOSTFRAMES = 4;
    public static final float DEFAULTQUALITY = 0.75f;

    public byte[] encoderImage(Image image, float f) throws IOException {
        byte[] byArray = null;
        ImageGrabber imageGrabber = new ImageGrabber(image);
        if (0.0f <= f && f <= 1.0f) {
            byArray = this.Compress(imageGrabber, f);
        } else {
            imageGrabber.processImage();
            boolean bl = imageGrabber.hasAlpha();
            byArray = bl ? this.close(imageGrabber) : this.Compress(imageGrabber, -1.0f);
        }
        return byArray;
    }

    public byte[] renderImageToGif(Image image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Vector vector = new Vector();
        new ImageFrameGrabber().startGrab(image, vector);
        GIFEncoder.encode(dataOutputStream, vector);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] Compress(ImageGrabber imageGrabber, float f) throws IOException {
        imageGrabber.processImage();
        BufferedImage bufferedImage = imageGrabber.convertToBufferedImage(false);
        byte[] byArray = this.QOIV(bufferedImage, f);
        return byArray;
    }

    public byte[] renderImageToJpeg(Image image) throws IOException {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        return this.Compress(imageGrabber, -1.0f);
    }

    public byte[] renderImageToJpeg(Image image, float f) throws IOException {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        return this.Compress(imageGrabber, f);
    }

    private byte[] QOIV(BufferedImage bufferedImage, float f) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("JPG");
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            imageWriter.setOutput(imageOutputStream);
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
            jPEGImageWriteParam.setCompressionMode(2);
            if (f >= 0.0f && f <= 1.0f) {
                jPEGImageWriteParam.setCompressionQuality(f);
            }
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
            imageWriter.dispose();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            if (byArray == null || byArray.length == 0) {
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                if (f >= 0.0f || f <= 1.0f) {
                    jPEGEncodeParam.setQuality(f, false);
                }
                jPEGImageEncoder.encode(bufferedImage);
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                return byArray;
            }
        }
        catch (Exception exception) {
            JpegEncoder jpegEncoder = new JpegEncoder(bufferedImage, (int)(f * 100.0f), byteArrayOutputStream);
            jpegEncoder.Compress();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private byte[] close(ImageGrabber imageGrabber) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageGrabber.processImage();
        BufferedImage bufferedImage = imageGrabber.convertToBufferedImage(imageGrabber.hasAlpha());
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public byte[] renderImageToPNG(Image image) throws IOException {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        return this.close(imageGrabber);
    }
}

