/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine8.util.JBoolean;
import jet.dataengine8.util.dataswap.ArrayTool;

public class VersionRecord
extends Record {
    private int QOIV = 0;
    private int abs = 0;
    private final int append;
    private final int array2Bytes;
    private byte[] arraycopy = null;
    private boolean bytes2Array = false;
    private JRelationMetaData dataLength = null;
    private int doubleToRawLongBits = 0;
    private int[] findColumn = null;
    private int[] floatToIntBits = null;
    private int getAttribute = 0;

    public VersionRecord(JRelationMetaData jRelationMetaData) throws DSException {
        this.append = jRelationMetaData.getColumnCount();
        this.QOIV = this.array2Bytes = this.append << 2;
        this.findColumn = new int[this.append + 1];
        this.floatToIntBits = new int[this.append + 1];
        int n = 1;
        while (n <= this.append) {
            this.findColumn[n] = jRelationMetaData.getColumnType(n);
            JAttribute jAttribute = jRelationMetaData.getAttribute(n);
            this.floatToIntBits[n] = this.QOIV(jAttribute.isReadOnly(), this.findColumn[n]);
            this.getAttribute += Types.swapDataLength(this.findColumn[n]) + 4;
            ++n;
        }
        this.arraycopy = new byte[this.getAttribute];
    }

    private int QOIV(boolean bl, int n) {
        if (bl) {
            return 0;
        }
        int n2 = Types.dataLength(n);
        return n2;
    }

    public byte[] getRecordData() {
        return this.arraycopy;
    }

    public int getRecordSize() {
        return this.QOIV;
    }

    public void resetRecordSize(int n) {
        this.arraycopy = new byte[n];
    }

    public void setDataLength(int n) {
        this.doubleToRawLongBits = n;
        this.reset();
    }

    public void setRecord(byte[] byArray) {
        if (this.arraycopy.length < byArray.length) {
            byte[] byArray2 = new byte[byArray.length];
            this.arraycopy = byArray2;
        }
        System.arraycopy(byArray, 0, this.arraycopy, 0, byArray.length);
    }

    public void putByte(byte by) {
        this.floatToIntBits(1);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(-6);
        this.arraycopy[this.QOIV++] = by;
    }

    public byte getByte(String string) throws DSException {
        return this.getByte(this.dataLength.findColumn(string));
    }

    public byte getByte(int n) {
        return this.abs(-6, n);
    }

    private byte abs(int n, int n2) {
        this.getDate(n, n2);
        int n3 = this.getClass(n2);
        this.bytes2Array = this.getColumnCount(n2);
        if (this.bytes2Array) {
            return 0;
        }
        return this.arraycopy[n3 + 1];
    }

    public void putBoolean(boolean bl) {
        this.floatToIntBits(1);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(-7);
        this.arraycopy[this.QOIV++] = bl ? (byte)1 : 0;
    }

    public boolean getBoolean(String string) throws DSException {
        return this.getByte(this.dataLength.findColumn(string)) == 1;
    }

    public boolean getBoolean(int n) {
        return this.abs(-7, n) == 1;
    }

    public void putShort(short s) {
        this.floatToIntBits(2);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(5);
        this.arraycopy[this.QOIV++] = (byte)s;
        this.arraycopy[this.QOIV++] = (byte)(s >> 8);
    }

    public short getShort(String string) throws DSException {
        return this.getShort(this.dataLength.findColumn(string));
    }

    public short getShort(int n) {
        this.getDate(5, n);
        int n2 = this.getClass(n);
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return 0;
        }
        return (short)(this.arraycopy[n2 + 2] << 8 | this.arraycopy[n2 + 1] & 0xFF);
    }

    public void putInt(int n) {
        this.floatToIntBits(4);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(4);
        this.arraycopy[this.QOIV++] = (byte)n;
        this.arraycopy[this.QOIV++] = (byte)(n >> 8);
        this.arraycopy[this.QOIV++] = (byte)(n >> 16);
        this.arraycopy[this.QOIV++] = (byte)(n >> 24);
    }

    public int getInt(String string) throws DSException {
        return this.getInt(this.dataLength.findColumn(string));
    }

    public int getInt(int n) {
        this.getDate(4, n);
        int n2 = this.getClass(n);
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return 0;
        }
        return this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF;
    }

    public void putFloat(float f) {
        this.floatToIntBits(4);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(6);
        int n = Float.floatToIntBits(f);
        this.arraycopy[this.QOIV++] = (byte)n;
        this.arraycopy[this.QOIV++] = (byte)(n >> 8);
        this.arraycopy[this.QOIV++] = (byte)(n >> 16);
        this.arraycopy[this.QOIV++] = (byte)(n >> 24);
    }

    public float getFloat(String string) throws DSException {
        return this.getFloat(this.dataLength.findColumn(string));
    }

    public float getFloat(int n) {
        this.getDate(6, n);
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return 0.0f;
        }
        int n2 = this.getClass(n);
        return Float.intBitsToFloat(this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF);
    }

    public void putLong(long l) {
        this.floatToIntBits(8);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(-5);
        this.arraycopy[this.QOIV++] = (byte)l;
        this.arraycopy[this.QOIV++] = (byte)(l >> 8);
        this.arraycopy[this.QOIV++] = (byte)(l >> 16);
        this.arraycopy[this.QOIV++] = (byte)(l >> 24);
        this.arraycopy[this.QOIV++] = (byte)(l >> 32);
        this.arraycopy[this.QOIV++] = (byte)(l >> 40);
        this.arraycopy[this.QOIV++] = (byte)(l >> 48);
        this.arraycopy[this.QOIV++] = (byte)(l >> 56);
    }

    private final void append(long l, int n) {
        this.floatToIntBits(8);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(n);
        this.arraycopy[this.QOIV++] = (byte)l;
        this.arraycopy[this.QOIV++] = (byte)(l >> 8);
        this.arraycopy[this.QOIV++] = (byte)(l >> 16);
        this.arraycopy[this.QOIV++] = (byte)(l >> 24);
        this.arraycopy[this.QOIV++] = (byte)(l >> 32);
        this.arraycopy[this.QOIV++] = (byte)(l >> 40);
        this.arraycopy[this.QOIV++] = (byte)(l >> 48);
        this.arraycopy[this.QOIV++] = (byte)(l >> 56);
    }

    public long getLong(String string) throws DSException {
        return this.getLong(this.dataLength.findColumn(string));
    }

    public long getLong(int n) {
        return this.array2Bytes(-5, n);
    }

    private long array2Bytes(int n, int n2) {
        this.getDate(n, n2);
        this.bytes2Array = this.getColumnCount(n2);
        if (this.bytes2Array) {
            return 0L;
        }
        int n3 = this.getClass(n2);
        return (long)this.arraycopy[n3 + 8] << 56 | ((long)this.arraycopy[n3 + 7] & 0xFFL) << 48 | ((long)this.arraycopy[n3 + 6] & 0xFFL) << 40 | ((long)this.arraycopy[n3 + 5] & 0xFFL) << 32 | ((long)this.arraycopy[n3 + 4] & 0xFFL) << 24 | ((long)this.arraycopy[n3 + 3] & 0xFFL) << 16 | ((long)this.arraycopy[n3 + 2] & 0xFFL) << 8 | (long)this.arraycopy[n3 + 1] & 0xFFL;
    }

    public void putDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        this.append(l, 8);
    }

    public double getDouble(String string) throws DSException {
        return this.getDouble(this.dataLength.findColumn(string));
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.array2Bytes(8, n));
    }

    public void putBigDecimal(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        this.floatToIntBits(n + 4);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(3);
        int n2 = bigDecimal.scale();
        this.arraycopy[this.QOIV++] = (byte)n2;
        this.arraycopy[this.QOIV++] = (byte)(n2 >> 8);
        this.arraycopy[this.QOIV++] = (byte)(n2 >> 16);
        this.arraycopy[this.QOIV++] = (byte)(n2 >> 24);
        int n3 = 0;
        while (n3 < n) {
            this.arraycopy[this.QOIV++] = byArray[n3];
            ++n3;
        }
    }

    public BigDecimal getBigDecimal(String string) throws DSException {
        return this.getBigDecimal(this.dataLength.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) {
        this.getDate(3, n);
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return null;
        }
        int n2 = this.getClass(n);
        int n3 = this.getDataTypeName(n2, n);
        int n4 = this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF;
        byte[] byArray = new byte[n3 - 4];
        int n5 = 0;
        int n6 = n2 + 5;
        while (n5 < byArray.length) {
            byArray[n5] = this.arraycopy[n6];
            ++n5;
            ++n6;
        }
        return new BigDecimal(new BigInteger(byArray), n4);
    }

    public void putDate(Date date) {
        this.append(date.getTime(), 91);
    }

    public void putDate(long l) {
        this.append(l, 91);
    }

    public Date getDate(String string) throws DSException {
        return this.getDate(this.dataLength.findColumn(string));
    }

    public Date getDate(int n) {
        return new JinfonetDate(this.array2Bytes(91, n));
    }

    public void putTimeStamp(Timestamp timestamp) {
        this.append(timestamp.getTime(), 93);
    }

    public void putTimeStamp(long l) {
        this.append(l, 93);
    }

    public Timestamp getTimeStamp(String string) throws DSException {
        return this.getTimeStamp(this.dataLength.findColumn(string));
    }

    public Timestamp getTimeStamp(int n) {
        return new JinfonetTimeStamp(this.array2Bytes(93, n));
    }

    public void putTime(Time time2) {
        this.append(time2.getTime(), 92);
    }

    public void putTime(long l) {
        this.append(l, 92);
    }

    public Time getTime(String string) throws DSException {
        return this.getTime(this.dataLength.findColumn(string));
    }

    public Time getTime(int n) {
        return new JinfonetTime(this.array2Bytes(92, n));
    }

    public void putString(String string) {
        byte[] byArray = null;
        if (string != null) {
            try {
                byArray = string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        this.dataLength(byArray, 12);
    }

    public String getString(String string) throws DSException {
        return this.getString(this.dataLength.findColumn(string));
    }

    public String getString(int n) {
        byte[] byArray = this.doubleToRawLongBits(12, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return byArray == null ? null : new String(byArray);
        }
    }

    public void putBlob(Blob blob) throws DSException {
        if (blob == null) {
            this.putNull(-2);
            return;
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        this.putBytes(byArray);
    }

    public Blob getBlob(String string) throws DSException {
        return this.getBlob(this.dataLength.findColumn(string));
    }

    public Blob getBlob(int n) throws DSException {
        this.getDate(2004, n);
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return null;
        }
        byte[] byArray = this.arraycopy(n);
        return new JinfonetBlobBaseBytes(byArray);
    }

    private byte[] arraycopy(int n) {
        int n2 = this.getClass(n);
        int n3 = this.getDataTypeName(n2, n);
        if (n3 < 0) {
            this.getDataTypeName(n2, n);
        }
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return null;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.arraycopy, n2 + 1, byArray, 0, n3);
        return byArray;
    }

    public void putClob(Clob clob) throws DSException {
        if (clob == null) {
            this.putNull(12);
            return;
        }
        this.putString(clob.getSubString(1L, (int)clob.length()));
    }

    public Clob getClob(String string) throws DSException {
        return this.getClob(this.dataLength.findColumn(string));
    }

    public Clob getClob(int n) throws DSException {
        this.getDate(2005, n);
        this.bytes2Array = this.getColumnCount(n);
        if (this.bytes2Array) {
            return null;
        }
        String string = this.bytes2Array(n);
        return new JinfonetClobBaseString(string);
    }

    private String bytes2Array(int n) {
        byte[] byArray = this.doubleToRawLongBits(2005, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return byArray == null ? null : new String(byArray);
        }
    }

    public void putBytes(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.floatToIntBits(byArray.length);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(-2);
        int n = 0;
        while (n < byArray.length) {
            this.arraycopy[this.QOIV++] = byArray[n];
            ++n;
        }
    }

    private void dataLength(byte[] byArray, int n) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.floatToIntBits(byArray.length);
        this.getAttribute(this.abs++, this.QOIV);
        this.getColumnType(n);
        int n2 = 0;
        while (n2 < byArray.length) {
            this.arraycopy[this.QOIV++] = byArray[n2];
            ++n2;
        }
    }

    public byte[] getBytes(String string) throws DSException {
        return this.getBytes(this.dataLength.findColumn(string));
    }

    public byte[] getBytes(int n) {
        return this.doubleToRawLongBits(-2, n);
    }

    private byte[] doubleToRawLongBits(int n, int n2) {
        this.getDate(n, n2);
        this.bytes2Array = this.getColumnCount(n2);
        if (this.bytes2Array) {
            return null;
        }
        int n3 = this.getClass(n2);
        int n4 = this.getDataTypeName(n3, n2);
        byte[] byArray = new byte[n4];
        System.arraycopy(this.arraycopy, n3 + 1, byArray, 0, n4);
        return byArray;
    }

    public JRelationMetaData getMetaData() {
        return this.dataLength;
    }

    public int putRecord() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.abs = 0;
        this.QOIV = this.array2Bytes;
        this.bytes2Array = false;
    }

    public void init(int n) {
        throw new UnsupportedOperationException();
    }

    public void putNull(int n) {
        this.floatToIntBits(0);
        this.getAttribute(this.abs++, -this.QOIV);
        this.getColumnType(n);
        this.QOIV += this.floatToIntBits[this.abs];
    }

    public boolean wasNull() {
        return this.bytes2Array;
    }

    private int findColumn(int n) {
        if (n <= 500) {
            return (int)(2.0f * (float)n);
        }
        if (n <= 1000) {
            return (int)(1.5f * (float)n);
        }
        return (int)(1.2f * (float)n);
    }

    private void floatToIntBits(int n) {
        if (this.arraycopy.length <= this.QOIV + n) {
            byte[] byArray = new byte[this.findColumn(this.QOIV + n)];
            System.arraycopy(this.arraycopy, 0, byArray, 0, this.arraycopy.length);
            this.arraycopy = byArray;
        }
    }

    private void getAttribute(int n, int n2) {
        int n3 = n << 2;
        this.arraycopy[n3] = (byte)n2;
        this.arraycopy[n3 + 1] = (byte)(n2 >> 8);
        this.arraycopy[n3 + 2] = (byte)(n2 >> 16);
        this.arraycopy[n3 + 3] = (byte)(n2 >> 24);
    }

    private int getClass(int n) {
        if (n < 1 || n > this.append) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.append);
        }
        int n2 = n - 1 << 2;
        int n3 = this.arraycopy[n2 + 3] << 24 | (this.arraycopy[n2 + 2] & 0xFF) << 16 | (this.arraycopy[n2 + 1] & 0xFF) << 8 | this.arraycopy[n2] & 0xFF;
        return Math.abs(n3);
    }

    private boolean getColumnCount(int n) {
        if (n < 1 || n > this.append) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.append);
        }
        int n2 = n - 1 << 2;
        return this.arraycopy[n2 + 3] < 0;
    }

    private void getColumnType(int n) {
        this.arraycopy[this.QOIV++] = (byte)n;
    }

    private int getDataTypeName(int n, int n2) {
        if (n2 == this.append) {
            return this.doubleToRawLongBits - n - 1;
        }
        return Math.abs(this.getClass(n2 + 1)) - n - 1;
    }

    public int dataType(String string) throws DSException {
        return this.dataLength.getColumnType(this.dataLength.findColumn(string));
    }

    public int dataType(int n) throws DSException {
        return this.dataLength.getColumnType(n);
    }

    public Object getObject(int n) throws DSException {
        int n2 = this.dataLength.getColumnType(n);
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case -7: {
                return new JBoolean(this.getBoolean(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 93: {
                return this.getTimeStamp(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 0x7FFFFFFF: {
                return this.getRelationData(n);
            }
        }
        throw new DSException(5859, new String[]{this.dataLength.getClass().getName() + " Unkonw dataType in getObject(). ColumnIndex: " + n + "; data type: " + n2});
    }

    public Object getObject(String string) throws DSException {
        return this.getObject(this.dataLength.findColumn(string));
    }

    public boolean isNull(int n) {
        int n2 = this.getClass(n);
        return this.getDataTypeName(n2, n) == 0;
    }

    private void getDate(int n, int n2) {
        if (n2 < 1 || n2 > this.append) {
            throw new IllegalStateException("columnIndex " + n2 + " Out of range , current range is :" + this.append);
        }
        if (n != this.findColumn[n2]) {
            throw new IllegalStateException("violation data type. indicate " + Types.getDataTypeName(n) + ", but " + Types.getDataTypeName(this.findColumn[n2]));
        }
    }

    public void close() throws DSException {
        this.arraycopy = null;
        this.findColumn = null;
    }

    public void putArray(Array array) throws DSException {
        byte[] byArray = ArrayTool.array2Bytes(array);
        this.dataLength(byArray, 2003);
    }

    public Array getArray(int n) throws DSException {
        byte[] byArray = this.doubleToRawLongBits(2003, n);
        return byArray == null ? null : ArrayTool.bytes2Array(byArray);
    }

    public void pubRelationData(IRelationData iRelationData) throws DSException {
        throw new UnsupportedOperationException();
    }
}

