/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.image.encoder.ImageEncoder;
import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbBuffer;
import jet.connect.DbChar;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.controls.JetCustomerProperty;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetImgVector;
import jet.controls.JetMappingTable;
import jet.ie.PJFAux;
import jet.ie.io.PJFDataOutput;
import jet.util.Propertiable;

public class WriterTool {
    private static final Component QOIV = new Component(){};

    public static final void writePropDecl(Short s, Propertiable propertiable, DataOutput dataOutput) throws IOException {
        int n = propertiable.getPropType();
        if (n == 0) {
            dataOutput.writeShort(n);
            return;
        }
        Object object = propertiable.getObject();
        if (n == 3 && object != null) {
            if (object instanceof String) {
                n = 6;
            } else if (object instanceof Integer) {
                n = 5;
            } else if (object instanceof Boolean) {
                n = 1;
            } else if (object instanceof Color) {
                n = 2;
            } else if (object instanceof Image) {
                n = 7;
            } else {
                dataOutput.writeShort(0);
                return;
            }
        }
        dataOutput.writeShort(n);
        dataOutput.writeShort(s.shortValue());
        boolean bl = propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
        dataOutput.writeBoolean(bl);
        if (bl) {
            object = propertiable.saveFullChangeBy();
            if (object == null) {
                dataOutput.writeBoolean(true);
            } else {
                dataOutput.writeBoolean(false);
                dataOutput.writeUTF((String)object);
            }
            if (propertiable.getNormalObject() == null) {
                dataOutput.writeInt(0);
            } else {
                byte[] byArray = WriterTool.close(propertiable.getNormalObject());
                dataOutput.writeInt(byArray.length);
                dataOutput.write(byArray);
            }
            return;
        }
        if (object == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            switch (n) {
                case 12: {
                    Vector vector = (Vector)object;
                    Vector vector2 = ((JetImgVector)propertiable).getImageTypeVec();
                    int n2 = vector.size();
                    dataOutput.writeInt(n2);
                    int n3 = 0;
                    while (n3 < n2) {
                        Image image = (Image)vector.get(n3);
                        if (image == null) {
                            dataOutput.writeInt(0);
                        } else {
                            int n4 = (Integer)vector2.get(n3);
                            byte[] byArray = WriterTool.booleanValue(image, n4);
                            dataOutput.writeInt(byArray.length);
                            dataOutput.write(byArray);
                        }
                        ++n3;
                    }
                    break;
                }
                case 1: {
                    dataOutput.writeBoolean((Boolean)object);
                    break;
                }
                case 2: {
                    dataOutput.writeInt(((Color)object).getRGB());
                    break;
                }
                case 3: {
                    dataOutput.writeInt(((JetEnumeration)propertiable).intValue());
                    break;
                }
                case 4: 
                case 5: {
                    dataOutput.writeInt(((Number)object).intValue());
                    break;
                }
                case 6: {
                    dataOutput.writeUTF((String)object);
                    break;
                }
                case 11: {
                    dataOutput.writeDouble(((Number)object).doubleValue());
                    break;
                }
                case 7: {
                    Image image = (Image)object;
                    int n5 = ((JetImgProperty)propertiable).getImageType();
                    byte[] byArray = WriterTool.booleanValue(image, n5);
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
                case 8: 
                case 13: {
                    byte[] byArray = ((JetCustomerProperty)propertiable).toByteArray();
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
                case 9: {
                    Vector vector = (Vector)object;
                    int n6 = vector.size();
                    dataOutput.writeInt(n6);
                    int n7 = 0;
                    while (n7 < n6) {
                        dataOutput.writeUTF((String)vector.elementAt(n7));
                        ++n7;
                    }
                    break;
                }
                case 14: {
                    byte[] byArray = ((JetMappingTable)propertiable).toByteArray();
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
            }
        }
    }

    public static final void writeDbValue(DbValue dbValue, PJFDataOutput pJFDataOutput) throws IOException {
        boolean bl = dbValue.isNull();
        pJFDataOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            int n = dbValue.getColDesc().getPrecision();
            byte[] byArray = new byte[n >= 0x7FFFFFFD ? 2 : PJFAux.getColLength(dbValue.getColDesc())];
            pJFDataOutput.write(byArray);
            return;
        }
        if (dbValue.getColDesc().isArray()) {
            WriterTool.writeArray(dbValue, pJFDataOutput);
            return;
        }
        int n = dbValue.getSqlType();
        switch (n) {
            case 5: {
                pJFDataOutput.writeShort(((DbSmallInt)dbValue).get());
                break;
            }
            case -6: {
                pJFDataOutput.writeByte(((DbTinyInt)dbValue).get());
                break;
            }
            case 4: {
                pJFDataOutput.writeInt(((DbInteger)dbValue).get());
                break;
            }
            case 91: 
            case 92: {
                pJFDataOutput.writeLong(((DbDateTime)dbValue).get());
                break;
            }
            case -5: {
                pJFDataOutput.writeLong(((DbBigInt)dbValue).get());
                break;
            }
            case 6: 
            case 7: {
                pJFDataOutput.writeFloat(((DbReal)dbValue).get());
                break;
            }
            case 2: 
            case 3: {
                pJFDataOutput.writeBigDecimal(((DbDecimal)dbValue).get(), dbValue.getScale(), DbBuffer.decimalNeedBytes(dbValue.getColDesc()));
                break;
            }
            case 8: {
                pJFDataOutput.writeDouble(((DbDouble)dbValue).get());
                break;
            }
            case -7: {
                pJFDataOutput.writeBoolean(((DbBit)dbValue).get());
                break;
            }
            case 93: {
                pJFDataOutput.writeLong(((DbTimestamp)dbValue).get());
                pJFDataOutput.writeInt(((DbTimestamp)dbValue).getNanos());
                break;
            }
            case 1: 
            case 12: {
                pJFDataOutput.writeVariantBinary(((DbChar)dbValue).getRaw());
                break;
            }
            case -1: {
                pJFDataOutput.writeVariantBinary(((DbChar)dbValue).getRaw());
                break;
            }
            case -3: {
                pJFDataOutput.writeFixedBinary(((DbBinary)dbValue).get(), dbValue.getPrecision());
                break;
            }
            case -4: {
                pJFDataOutput.writeVariantBinary(((DbBinary)dbValue).get());
            }
        }
    }

    public static final void writeArray(DbValue dbValue, PJFDataOutput pJFDataOutput) throws IOException {
        int n = dbValue.getSqlType();
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(blArray.length);
                int n2 = 0;
                while (n2 < blArray.length) {
                    pJFDataOutput.writeBoolean(blArray[n2]);
                    ++n2;
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(byArray.length);
                int n3 = 0;
                while (n3 < byArray.length) {
                    pJFDataOutput.writeByte(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(sArray.length);
                int n4 = 0;
                while (n4 < sArray.length) {
                    pJFDataOutput.writeShort(sArray[n4]);
                    ++n4;
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(nArray.length);
                int n5 = 0;
                while (n5 < nArray.length) {
                    pJFDataOutput.writeInt(nArray[n5]);
                    ++n5;
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(lArray.length);
                int n6 = 0;
                while (n6 < lArray.length) {
                    pJFDataOutput.writeLong(lArray[n6]);
                    ++n6;
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                pJFDataOutput.writeInt(lArray.length);
                int n7 = 0;
                while (n7 < lArray.length) {
                    pJFDataOutput.writeLong(lArray[n7]);
                    pJFDataOutput.writeInt(nArray[n7]);
                    ++n7;
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(fArray2.length);
                int n8 = 0;
                while (n8 < fArray2.length) {
                    pJFDataOutput.writeFloat(fArray2[n8]);
                    ++n8;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(dArray.length);
                int n9 = 0;
                while (n9 < dArray.length) {
                    pJFDataOutput.writeDouble(dArray[n9]);
                    ++n9;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(bigDecimalArray.length);
                int n10 = 0;
                while (n10 < bigDecimalArray.length) {
                    pJFDataOutput.writeUTF(bigDecimalArray[n10].toString());
                    ++n10;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(stringArray.length);
                int n11 = 0;
                while (n11 < stringArray.length) {
                    pJFDataOutput.writeUTF(stringArray[n11]);
                    ++n11;
                }
                break;
            }
        }
    }

    private static final byte[] QOIV(Image image) throws IOException {
        ImageEncoder imageEncoder = new ImageEncoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = imageEncoder.encode(image, dataOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private static final byte[] booleanValue(Image image, int n) throws IOException {
        if (image != null) {
            jet.export.util.ImageEncoder imageEncoder = new jet.export.util.ImageEncoder();
            switch (n) {
                case 4: {
                    return imageEncoder.renderImageToGif(image);
                }
                case 3: {
                    return imageEncoder.renderImageToPNG(image);
                }
                case 0: 
                case 1: {
                    return imageEncoder.renderImageToJpeg(image);
                }
            }
            return WriterTool.QOIV(image);
        }
        return new byte[0];
    }

    private static final byte[] close(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            boolean bl = object == null;
            objectOutputStream.writeBoolean(bl);
            if (!bl) {
                objectOutputStream.writeObject(object);
            }
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            JRLog.trace(6, 6200000, (Throwable)iOException);
            return new byte[0];
        }
    }
}

