/*
 * Decompiled with CFR 0.152.
 */
package jet.jetc;

import com.jinfonet.util.JRLog;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;
import jet.JResource;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.convertrpt.CrystalConverter;
import jet.export.xml.LoadXSDException;
import jet.export.xml.ObjectToXML;
import jet.export.xml.XMLToObject;
import jet.export.xml.XSDToObject;
import jet.jetc.InvalidJetCVersionException;
import jet.jetc.JetCParser;
import jet.jetc.JetCReader;
import jet.jetc.JetCWriter;
import jet.jetc.ParseException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.jetc.b2t;
import jet.universe.JetUUniverse;
import jet.util.EnginePerformance;

public class LoaderNoCache {
    protected boolean isCacheable = false;
    String LoadFromText = "";
    File QOIV;
    static EnginePerformance I;
    String afterNewTree = "";
    int append;
    boolean canWrite = true;
    public static final int INPUTSTREAM_CAT = 1;
    public static final int INPUTSTREAM_CATXML = 2;
    public static final int INPUTSTREAM_CATXSD = 3;
    public static final int INPUTSTREAM_CLS = 6;
    public static final int INPUTSTREAM_RPT = 7;
    public static final int INPUTSTREAM_CLSXML = 9;

    public LoaderNoCache() {
    }

    public LoaderNoCache(String string) {
        this.LoadFromText = string;
        this.QOIV = new File(this.LoadFromText);
    }

    public LoaderNoCache(String string, String string2) {
        this.afterNewTree = string;
        this.LoadFromText = string2;
        if (this.afterNewTree != null && this.afterNewTree.length() != 0 && !this.afterNewTree.equals(File.separator)) {
            this.LoadFromText = this.afterNewTree + (this.afterNewTree.endsWith(File.separator) ? "" : File.separator) + this.LoadFromText;
        }
        this.QOIV = new File(this.LoadFromText);
    }

    public boolean getEditable() {
        return this.canWrite;
    }

    public void setEditable(boolean bl) {
        this.canWrite = bl;
    }

    public String getFileName() {
        return this.LoadFromText;
    }

    public int getVersion() {
        return this.append;
    }

    public static boolean isReportName(String string) {
        return (string = string.toLowerCase()).endsWith(".cls".toLowerCase()) || string.endsWith(".rpt".toLowerCase());
    }

    public JetObject loadObject() throws ReadFailureException {
        return this.loadObject(false);
    }

    public JetObject loadNoInit() throws ReadFailureException {
        return this.loadObject(false);
    }

    public JetObject loadNoInit(Locale locale) throws ReadFailureException {
        return this.loadObject(false, locale);
    }

    public JetObject loadNoInit(Locale locale, String string) throws ReadFailureException {
        return this.loadObject(false, locale, string);
    }

    public JetObject load() throws ReadFailureException {
        return this.loadObject(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetObject loadObject(boolean bl) throws ReadFailureException {
        JetObject jetObject3;
        if (this.LoadFromText.equals("")) {
            return null;
        }
        if (this.LoadFromText.toLowerCase().endsWith(".rpt")) {
            JetObject jetObject2 = this.LoadFromText(this.LoadFromText);
            if (!bl) return jetObject2;
            JetObject.afterNewTree(jetObject2);
            return jetObject2;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                JetObject jetObject;
                fileInputStream = new FileInputStream(this.LoadFromText);
                jetObject3 = jetObject = this.loadObject((InputStream)fileInputStream, bl);
                Object var6_7 = null;
                if (fileInputStream == null) return jetObject3;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ReadFailureException(200049, new String[]{JResource.getMessage("JET_1", (Object)this.LoadFromText)}, fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ReadFailureException(200050, new String[]{JResource.getMessage("JET_8", (Object)this.LoadFromText)}, iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new ReadFailureException(200050, new String[]{JResource.getMessage("JET_8", (Object)this.LoadFromText)}, iOException);
        }
        fileInputStream.close();
        return jetObject3;
    }

    public JetObject loadObject(boolean bl, Locale locale) throws ReadFailureException {
        return this.loadObject(bl, locale, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetObject loadObject(boolean bl, Locale locale, String string) throws ReadFailureException {
        JetObject jetObject3;
        if (this.LoadFromText.equals("")) {
            return null;
        }
        if (this.LoadFromText.toLowerCase().endsWith(".rpt")) {
            JetObject jetObject2 = this.LoadFromText(this.LoadFromText);
            if (!bl) return jetObject2;
            JetObject.afterNewTree(jetObject2);
            return jetObject2;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                JetObject jetObject;
                fileInputStream = new FileInputStream(this.LoadFromText);
                jetObject3 = jetObject = this.loadObject(fileInputStream, bl, locale, string);
                Object var8_9 = null;
                if (fileInputStream == null) return jetObject3;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ReadFailureException(200049, new String[]{JResource.getMessage("JET_1", (Object)this.LoadFromText)}, fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ReadFailureException(200050, new String[]{JResource.getMessage("JET_8", (Object)this.LoadFromText)}, iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new ReadFailureException(200050, new String[]{JResource.getMessage("JET_8", (Object)this.LoadFromText)}, iOException);
        }
        fileInputStream.close();
        return jetObject3;
    }

    public JetObject loadObject(InputStream inputStream, boolean bl) throws ReadFailureException {
        if (this.isCacheable && I != null) {
            return I.loadObject(this.QOIV, inputStream, bl);
        }
        JetObject jetObject = null;
        JetCReader jetCReader = null;
        if (this.LoadFromText != null && (this.LoadFromText.toLowerCase().endsWith(".csd") || this.LoadFromText.toLowerCase().endsWith(".cls.xml") || this.LoadFromText.toLowerCase().endsWith(".cat.xml"))) {
            try {
                if (this.LoadFromText.toLowerCase().endsWith(".csd")) {
                    jetObject = XSDToObject.toObject(this.LoadFromText);
                }
                jetObject = XMLToObject.toObject(this.LoadFromText);
            }
            catch (LoadXSDException loadXSDException) {
                throw new ReadFailureException(200022, new String[]{loadXSDException.getMessage()}, loadXSDException);
            }
        } else {
            jetCReader = new JetCReader(this.QOIV.toString());
            jetObject = jetCReader.read(new DataInputStream(inputStream));
            this.append = jetCReader.getVersion();
        }
        if (jetObject != null && jetObject instanceof JetRootable) {
            ((JetRootable)((Object)jetObject)).refer();
            if (jetCReader != null && jetCReader.getVersion() < 65553) {
                jetObject.createNamingSystemB();
            } else {
                jetObject.createNamingSystem(true);
            }
            if (bl) {
                if (jetObject instanceof JetUUniverse) {
                    ((JetUUniverse)jetObject).setFullFileName(this.QOIV);
                }
                JetObject.afterNewTree(jetObject);
            }
        }
        return jetObject;
    }

    public JetObject loadObject(InputStream inputStream, boolean bl, Locale locale) throws ReadFailureException {
        return this.loadObject(inputStream, bl, locale, "");
    }

    public JetObject loadObject(InputStream inputStream, boolean bl, Locale locale, String string) throws ReadFailureException {
        if (this.isCacheable && I != null) {
            return I.loadObject(this.QOIV, inputStream, bl, locale, string);
        }
        JetObject jetObject = null;
        JetCReader jetCReader = null;
        if (this.LoadFromText != null && (this.LoadFromText.toLowerCase().endsWith(".cls.xml") || this.LoadFromText.toLowerCase().endsWith(".cat.xml"))) {
            try {
                jetObject = XMLToObject.toObject(this.LoadFromText);
            }
            catch (LoadXSDException loadXSDException) {
                throw new ReadFailureException(200022, new String[]{loadXSDException.getMessage()}, loadXSDException);
            }
        } else {
            jetCReader = new JetCReader(this.QOIV.toString());
            jetObject = jetCReader.read(new DataInputStream(inputStream));
            this.append = jetCReader.getVersion();
        }
        if (jetObject != null && jetObject instanceof JetRootable) {
            ((JetRootable)((Object)jetObject)).refer();
            if (jetCReader != null && jetCReader.getVersion() < 65553) {
                jetObject.createNamingSystemB();
            } else {
                jetObject.createNamingSystem(true);
            }
            if (bl) {
                if (jetObject instanceof JetUUniverse) {
                    ((JetUUniverse)jetObject).setFullFileName(this.QOIV);
                }
                JetObject.afterNewTree(jetObject);
            }
        }
        return jetObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetObject LoadFromText(String string) throws ReadFailureException {
        JetObject jetObject;
        FilterInputStream filterInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                this.append = 65540;
                bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = bufferedReader.readLine().trim();
                bufferedReader.close();
                bufferedReader = null;
                if (!string2.startsWith("class")) {
                    try {
                        this.append = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        StringBuffer stringBuffer = new StringBuffer();
                        boolean bl = CrystalConverter.isCrystalRpt(string, stringBuffer);
                        if (bl) {
                            throw new ReadFailureException(200053, new String[]{JResource.getMessage("RPT_CRY", new Object[]{string})}, numberFormatException);
                        }
                        if (stringBuffer.length() > 0) {
                            throw new ReadFailureException(200051, new String[]{stringBuffer + ""}, numberFormatException);
                        }
                        throw new ReadFailureException(200052, new String[]{JResource.getMessage("RPT_23", new Object[]{string})}, numberFormatException);
                    }
                }
                filterInputStream = new DataInputStream(new FileInputStream(string));
                if (this.append > 65553) {
                    InvalidJetCVersionException invalidJetCVersionException = new InvalidJetCVersionException(200040, new String[]{String.valueOf(this.append >> 16), String.valueOf(this.append & 0xFFFF)}, null);
                    if (JRLog.isError(1)) {
                        JRLog.error(1, string, (Throwable)invalidJetCVersionException);
                    }
                    throw new ReadFailureException(200034, new String[]{string, invalidJetCVersionException.getClass().getName(), invalidJetCVersionException.getMessage()}, invalidJetCVersionException);
                }
                if (this.append > 65540) {
                    ((DataInputStream)filterInputStream).readLine();
                }
                JetObject jetObject2 = new JetCParser(filterInputStream).parse(this.append);
                filterInputStream.close();
                filterInputStream = null;
                jetObject = jetObject2;
                Object var11_16 = null;
            }
            catch (ParseException parseException) {
                throw new ReadFailureException(200054, new String[]{string, parseException.getMessage()}, parseException);
            }
            catch (IOException iOException) {
                throw new ReadFailureException(200055, new String[]{string, iOException.getMessage()}, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReadFailureException(200056, new String[]{string + JResource.getMessage("JET_10") + " " + classNotFoundException.getMessage()}, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new ReadFailureException(200057, new String[]{string + JResource.getMessage("JET_11") + " " + instantiationException.getMessage()}, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReadFailureException(200058, new String[]{string + JResource.getMessage("JET_12") + " " + illegalAccessException.getMessage()}, illegalAccessException);
            }
            catch (NullPointerException nullPointerException) {
                throw new ReadFailureException(200085, new String[]{string}, nullPointerException);
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (filterInputStream == null) throw throwable;
                filterInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ReadFailureException(200055, new String[]{string, iOException.getMessage()}, iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new ReadFailureException(200055, new String[]{string, iOException.getMessage()}, iOException);
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (filterInputStream == null) return jetObject;
        filterInputStream.close();
        return jetObject;
    }

    public JetObject loadReport(InputStream inputStream, boolean bl, Locale locale) throws ReadFailureException {
        if (this.isCacheable && I != null) {
            return I.loadObject(this.QOIV, inputStream, bl, locale);
        }
        return this.loadObject(inputStream, bl);
    }

    public JetObject loadObject(InputStream inputStream, int n) throws ReadFailureException {
        return this.loadObject(inputStream, true, n);
    }

    public JetObject loadObject(InputStream inputStream, boolean bl, int n) throws ReadFailureException {
        this.QOIV = null;
        JetObject jetObject = null;
        JetCReader jetCReader = null;
        switch (n) {
            case 1: 
            case 6: {
                jetCReader = new JetCReader();
                if (this.canWrite) {
                    jetCReader.setEditable();
                }
                jetObject = jetCReader.read(new DataInputStream(inputStream));
                break;
            }
            case 2: 
            case 9: {
                try {
                    jetObject = XMLToObject.toObject(inputStream, n);
                    break;
                }
                catch (LoadXSDException loadXSDException) {
                    throw new ReadFailureException(200087, new String[]{loadXSDException.getMessage()}, loadXSDException);
                }
            }
            case 3: {
                try {
                    jetObject = XSDToObject.toObject(inputStream);
                    break;
                }
                catch (LoadXSDException loadXSDException) {
                    throw new ReadFailureException(200088, new String[]{loadXSDException.getMessage()}, loadXSDException);
                }
            }
            case 7: {
                jetObject = this.LoadFromText(inputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal input stream type : " + n);
            }
        }
        jetObject = this.QOIV(jetObject, bl, jetCReader != null && jetCReader.getVersion() < 65553);
        return jetObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JetObject LoadFromText(InputStream inputStream) throws ReadFailureException {
        try {
            JetObject jetObject;
            this.append = 65540;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                JetObject jetObject2;
                bufferedReader.mark(1);
                String string = bufferedReader.readLine().trim();
                if (!string.startsWith("class")) {
                    try {
                        this.append = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (!this.afterNewTree(string, stringBuffer)) {
                            if (stringBuffer.length() > 0) {
                                throw new ReadFailureException(200095, new String[]{stringBuffer + ""}, numberFormatException);
                            }
                            throw new ReadFailureException(200096, (Throwable)numberFormatException);
                        }
                        throw new ReadFailureException(200097, (Throwable)numberFormatException);
                    }
                }
                if (this.append > 65553) {
                    InvalidJetCVersionException invalidJetCVersionException = new InvalidJetCVersionException(200040, new String[]{String.valueOf(this.append >> 16), String.valueOf(this.append & 0xFFFF)}, null);
                    if (JRLog.isError(1)) {
                        JRLog.error(1, "", (Throwable)invalidJetCVersionException);
                    }
                    throw new ReadFailureException(200034, new String[]{"", invalidJetCVersionException.getClass().getName(), invalidJetCVersionException.getMessage()}, invalidJetCVersionException);
                }
                if (this.append <= 65540) {
                    bufferedReader.reset();
                }
                bufferedReader.mark(0);
                jetObject = jetObject2 = new JetCParser(bufferedReader).parse(this.append);
                Object var8_14 = null;
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return jetObject;
        }
        catch (ParseException parseException) {
            throw new ReadFailureException(200089, new String[]{parseException.getMessage()}, parseException);
        }
        catch (IOException iOException) {
            throw new ReadFailureException(200090, new String[]{iOException.getMessage()}, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReadFailureException(200091, new String[]{classNotFoundException.getMessage()}, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new ReadFailureException(200092, new String[]{instantiationException.getMessage()}, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReadFailureException(200093, new String[]{illegalAccessException.getMessage()}, illegalAccessException);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReadFailureException(200094, (Throwable)nullPointerException);
        }
    }

    private JetObject QOIV(JetObject jetObject, boolean bl, boolean bl2) {
        if (jetObject != null && jetObject instanceof JetRootable) {
            ((JetRootable)((Object)jetObject)).refer();
            if (bl2) {
                jetObject.createNamingSystemB();
            } else {
                jetObject.createNamingSystem(true);
            }
            if (bl) {
                if (this.QOIV != null && jetObject instanceof JetUUniverse) {
                    ((JetUUniverse)jetObject).setFullFileName(this.QOIV);
                }
                JetObject.afterNewTree(jetObject);
            }
        }
        return jetObject;
    }

    private boolean afterNewTree(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        try {
            byte[] byArray = string.getBytes("8859_1");
            byte[] byArray2 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31, 0};
            bl = true;
            int n = 0;
            while (bl && n < byArray2.length) {
                if (byArray2[n] != byArray[n]) {
                    bl = false;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage());
        }
        if (!bl && stringBuffer.length() == 0) {
            stringBuffer.append(JResource.getMessage("CONVERTCRY_14"));
        }
        return bl;
    }

    public static void saveToText(JetObject jetObject, String string, String string2) throws WriteFailureException {
        b2t.save(jetObject, "", string2);
    }

    public static void saveToText(JetObject jetObject, String string, OutputStream outputStream) throws WriteFailureException {
        b2t.save(jetObject, outputStream, string);
    }

    public static void save(JetObject jetObject, OutputStream outputStream, String string, byte[] byArray) throws WriteFailureException {
        new JetCWriter().write(jetObject, outputStream, string, byArray);
    }

    public static void save(JetObject jetObject, OutputStream outputStream, String string) throws WriteFailureException {
        new JetCWriter().write(jetObject, outputStream, string);
    }

    public static void save(JetObject jetObject, String string, String string2, byte[] byArray) throws WriteFailureException {
        new JetCWriter().write(jetObject, string2, string, byArray);
    }

    public static String save(JetObject jetObject, String string, String string2) throws WriteFailureException {
        File file = new File(string2);
        if (file.exists()) {
            if (file.canWrite()) {
                file.delete();
            } else {
                throw new WriteFailureException(200023, new String[]{string2}, null);
            }
        }
        if (string2.toLowerCase().endsWith(".rpt")) {
            LoaderNoCache.saveToText(jetObject, string, string2);
        } else if (string2.toLowerCase().endsWith(".cls.xml") || string2.toLowerCase().endsWith(".cat.xml")) {
            try {
                new ObjectToXML(jetObject, string2, null);
            }
            catch (LoadXSDException loadXSDException) {
                throw new WriteFailureException(200024, new String[]{loadXSDException.getMessage()}, loadXSDException);
            }
        } else {
            new JetCWriter().write(jetObject, string2, string);
        }
        return string2;
    }

    public static void clearMem() {
        if (I != null) {
            I.clearMem();
        }
    }

    public String getFilePath() {
        String string = new File(this.LoadFromText).getParent();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }
}

