/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.UMapTable;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.util.HashVector;
import toolkit.db.ProcColumnInfo;
import toolkit.db.ProcInfo;
import toolkit.db.ProcParaInfo;

public class JetUProcedure
extends JetUResourceContainer
implements JetUQueriable {
    public JetString qualifier = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString procedureName = new JetString(this, "ProcedureName");
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 99);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    ProcInfo InitAfterCreate = null;
    private static JRLogger IsMappingNameOK;
    private static final HashMap QOIV;
    private static final HashVector add;
    static Class class$jet$universe$JetUProcedure;
    static final boolean $assertionsDisabled;

    public JetUProcedure() {
        this.initialize();
    }

    public JetUProcedure(String string, String string2) {
        super(string, string2);
        this.initialize();
    }

    public JetUProcedure(String string, String string2, ProcInfo procInfo) {
        super(string, string2);
        this.initialize();
        this.qualifier.set(procInfo.getCatalog());
        this.owner.set(procInfo.getSchema());
        this.procedureName.set(procInfo.getName());
        this.InitAfterCreate = procInfo;
    }

    protected void initialize() {
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
    }

    public void InitProcedure() {
        String string;
        super.InitAfterCreate();
        Vector vector = this.InitAfterCreate.getParameters();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ProcParaInfo procParaInfo = (ProcParaInfo)vector.elementAt(n2);
            string = procParaInfo.getResourceName();
            if (string == null || string.length() <= 0) {
                string = this.getMappingName(procParaInfo.strName);
            }
            JetUProcParameter jetUProcParameter = new JetUProcParameter(string, "", procParaInfo);
            this.addParameter(jetUProcParameter);
            ++n2;
        }
        Vector vector2 = this.InitAfterCreate.getColumns();
        int n3 = vector2.size();
        int n4 = 0;
        while (n4 < n3) {
            ProcColumnInfo procColumnInfo = (ProcColumnInfo)vector2.elementAt(n4);
            string = this.getMappingName(procColumnInfo.strName);
            JetUProcField jetUProcField = new JetUProcField(string, "", procColumnInfo);
            this.addField(jetUProcField);
            ++n4;
        }
        this.InitAfterCreate = null;
    }

    public JetUProcedure cloneEntity() {
        Object object;
        Object object2;
        JetUProcedure jetUProcedure = new JetUProcedure(this.getResourceName(), this.getDesc());
        jetUProcedure.setQualifier(this.getQualifier());
        jetUProcedure.setOwner(this.getOwner());
        jetUProcedure.setProcedureName(this.getProcedureName());
        Vector vector = this.getParameters();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUProcParameter jetUProcParameter = (JetUProcParameter)vector.elementAt(n2);
            object2 = new JetUProcParameter();
            JetObject.copyProperties((JetObject)object2, jetUProcParameter);
            jetUProcedure.addParameter((JetUProcParameter)object2);
            ++n2;
        }
        object2 = this.getFields();
        int n3 = ((Vector)object2).size();
        int n4 = 0;
        while (n4 < n3) {
            JetUProcField jetUProcField = (JetUProcField)((Vector)object2).elementAt(n4);
            object = new JetUProcField();
            JetObject.copyProperties((JetObject)object, jetUProcField);
            jetUProcedure.addField((JetUProcField)object);
            ++n4;
        }
        JetObject.copyProperties(jetUProcedure, this);
        jetUProcedure.removeBL();
        object = this.getBL();
        jetUProcedure.add((JetObject)((Object)(object == null ? null : object.copy())));
        return jetUProcedure;
    }

    protected String getMappingName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        JetUDatabase jetUDatabase = this.getDatabase();
        String string2 = null;
        String string3 = string;
        boolean bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        int n = 1;
        if (!bl) {
            string3 = this.getResourceName() + "_" + string;
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        }
        string2 = string3;
        while (!bl) {
            string3 = string2 + n++;
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        }
        return string3;
    }

    protected void addParameter(JetUProcParameter jetUProcParameter) {
        this.add(jetUProcParameter);
    }

    protected void addField(JetUProcField jetUProcField) {
        this.add(jetUProcField);
        jetUProcField.InitAfterCreate();
    }

    public String getQualifier() {
        return this.qualifier.get();
    }

    public void setQualifier(String string) {
        this.qualifier.set(string);
    }

    public String getOwner() {
        return this.owner.get();
    }

    public void setOwner(String string) {
        this.owner.set(string);
    }

    public String getProcedureName() {
        return this.procedureName.get();
    }

    public void setProcedureName(String string) {
        this.procedureName.set(string);
    }

    public void setTransactionIsolation(int n) {
        this.transactionIsolation.set(new Integer(n));
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int n) {
        this.readOnly.set(new Integer(n));
    }

    public void setMaxRows(int n) {
        this.maxRows.set(n);
    }

    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int n) {
        this.maxDuration.set(n);
    }

    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    public int getReadOnly() {
        return this.readOnly.intValue();
    }

    public JetUConnection getConnection() {
        return (JetUConnection)this.getParent();
    }

    public Vector getParameters() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUProcParameter) {
                vector.addElement(jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public boolean hasINParameter() {
        Vector vector = this.getParameters();
        int n = vector.size();
        JetUProcParameter jetUProcParameter = null;
        int n2 = 0;
        while (n2 < n) {
            jetUProcParameter = (JetUProcParameter)vector.elementAt(n2);
            if (jetUProcParameter.isINParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public JetUProcParameter getParameterByResourceName(String string) {
        Vector vector = new Vector();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUProcParameter && ((JetUProcParameter)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUProcParameter)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public Vector getFields() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUProcField) {
                vector.addElement(jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUResourceEntity getFieldByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUProcField && ((JetUProcField)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUProcField)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public String getSQLString() {
        return null;
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(jetUUniverse, string, "");
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string, String string2) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string2, this.getResourceName(), string);
        if (jetUResourceEntity == null) {
            throw new CannotFindEntity(string);
        }
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity, string2);
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity, "");
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bl = false;
        if (!$assertionsDisabled && jetUResourceEntity == null) {
            throw new AssertionError((Object)"entity can not be null");
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            bl = true;
        } else if (jetUResourceEntity instanceof JetUFormula) {
            bl = this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse, string);
        } else if (jetUResourceEntity instanceof JetUQueriableField) {
            if (jetUResourceEntity instanceof JetUProcField) {
                bl = ((JetUProcField)jetUResourceEntity).getProcedure() == this;
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknow Field Type" + jetUResourceEntity.getClass().getName()));
        }
        return bl;
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(jetUFormula, jetUUniverse, "");
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector vector = jetUFormula.getRefDbFld();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)vector.elementAt(n2);
                try {
                    if (!this.isFieldValidToQuery(jetUUniverse, string2, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string2);
                }
                ++n2;
            }
        }
        Vector vector2 = jetUFormula.getRefFormuFld();
        int n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            String string3 = (String)vector2.elementAt(n3);
            try {
                if (!this.isFieldValidToQuery(jetUUniverse, string3, string)) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string3);
            }
            ++n3;
        }
        Vector vector3 = jetUFormula.getGroupByVector();
        n = vector3.size();
        int n4 = 0;
        while (n4 < n) {
            String string4 = (String)vector3.elementAt(n4);
            if (!(jetUFormula instanceof JetUSummary) || !JetUDatabase.I(string4)) {
                try {
                    if (!string4.equalsIgnoreCase("Report") && !this.isFieldValidToQuery(jetUUniverse, string4, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string4);
                }
            }
            ++n4;
        }
        return true;
    }

    public Vector getAutoGroupFields() {
        return null;
    }

    void I(UMapTable uMapTable) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUResourceContainer) {
                ((JetUResourceContainer)jetObject).I(uMapTable);
            }
            if (jetObject instanceof JetUResourceEntity && !(jetObject instanceof JetUProcParameter)) {
                uMapTable.removeElement((JetUResourceEntity)jetObject);
            }
            ++n2;
        }
    }

    public boolean resetProcedure(ProcInfo procInfo) {
        String string;
        String string2;
        JetUProcField jetUProcField;
        JetUProcParameter jetUProcParameter;
        this.objectModified();
        this.initialize();
        this.qualifier.set(procInfo.getCatalog());
        this.owner.set(procInfo.getSchema());
        this.procedureName.set(procInfo.getName());
        this.InitAfterCreate = procInfo;
        Vector vector = this.getParameters();
        int n = vector.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n);
        int n2 = 0;
        while (n2 < n) {
            jetUProcParameter = (JetUProcParameter)vector.elementAt(n2);
            hashtable.put(jetUProcParameter.getName(), jetUProcParameter.getResourceName());
            ++n2;
        }
        Vector vector2 = this.getFields();
        int n3 = vector2.size();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(n3);
        int n4 = 0;
        while (n4 < n3) {
            jetUProcField = (JetUProcField)vector2.elementAt(n4);
            hashtable2.put(jetUProcField.getFldName(), jetUProcField.getResourceName());
            ++n4;
        }
        Vector vector3 = procInfo.getParameters();
        int n5 = 0;
        while (n5 < n) {
            jetUProcParameter = (JetUProcParameter)vector.elementAt(n5);
            this.remove(jetUProcParameter);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            jetUProcField = (JetUProcField)vector2.elementAt(n6);
            this.remove(jetUProcField);
            ++n6;
        }
        if (vector3 != null) {
            int n7 = 0;
            while (n7 < vector3.size()) {
                ProcParaInfo procParaInfo = (ProcParaInfo)vector3.elementAt(n7);
                string2 = procParaInfo.getName();
                string = (String)hashtable.get(string2);
                if (string == null && ((string = procParaInfo.getResourceName()) == null || string.length() <= 0)) {
                    string = this.getMappingName(procParaInfo.strName);
                }
                jetUProcParameter = new JetUProcParameter(string, "", procParaInfo);
                this.addParameter(jetUProcParameter);
                ++n7;
            }
        }
        Vector vector4 = procInfo.getColumns();
        int n8 = 0;
        while (n8 < vector4.size()) {
            ProcColumnInfo procColumnInfo = (ProcColumnInfo)vector4.elementAt(n8);
            string2 = procColumnInfo.getName();
            string = (String)hashtable2.get(string2);
            if (string == null) {
                string = this.getMappingName(procColumnInfo.strName);
            }
            jetUProcField = new JetUProcField(string, "", procColumnInfo);
            this.addField(jetUProcField);
            ++n8;
        }
        procInfo = null;
        JetUUniverse.objectChanged(this.getUniverse(), this, 1002);
        return true;
    }

    public String toString() {
        return this.getProcedureName() + this.getChildren();
    }

    public String getInstancePrefix() {
        return "Procedure";
    }

    public boolean isSimilar(JetUResourceContainer jetUResourceContainer) {
        JBusinessLogic jBusinessLogic;
        if (!super.isSimilar(jetUResourceContainer)) {
            return false;
        }
        JBusinessLogic jBusinessLogic2 = this.getBL();
        if (jBusinessLogic2 == (jBusinessLogic = ((JetUProcedure)jetUResourceContainer).getBL())) {
            return true;
        }
        if (jBusinessLogic2 == null) {
            return jBusinessLogic == null;
        }
        return jBusinessLogic2.isSimilar(jBusinessLogic);
    }

    public JBusinessLogic newBL(String string) throws BLIlegalNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic businessLogic = new BusinessLogic();
        try {
            businessLogic.setName(string);
        }
        catch (BLDupleNameException bLDupleNameException) {
            bLDupleNameException.printStackTrace();
        }
        this.add(businessLogic);
        return businessLogic;
    }

    public void removeBL() {
        JBusinessLogic jBusinessLogic = this.getBL();
        if (jBusinessLogic != null) {
            this.remove((JetObject)((Object)jBusinessLogic));
        }
    }

    public JBusinessLogic getBL() {
        Vector vector = this.getChildren();
        JBusinessLogic jBusinessLogic = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            JetObject jetObject = (JetObject)iterator.next();
            if (!(jetObject instanceof JBusinessLogic)) continue;
            jBusinessLogic = (JBusinessLogic)((Object)jetObject);
        }
        return jBusinessLogic;
    }

    public HashMap getIndecialMap() {
        return QOIV;
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return add;
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUProcedure == null ? (class$jet$universe$JetUProcedure = JetUProcedure.class$("jet.universe.JetUProcedure")) : class$jet$universe$JetUProcedure).desiredAssertionStatus();
        IsMappingNameOK = JRLogger.getLogger((class$jet$universe$JetUProcedure == null ? (class$jet$universe$JetUProcedure = JetUProcedure.class$("jet.universe.JetUProcedure")) : class$jet$universe$JetUProcedure).getName());
        QOIV = new HashMap(9);
        QOIV.put("Qualifier", new Integer(0));
        QOIV.put("TransactionIsolation", new Integer(1));
        QOIV.put("maxRows", new Integer(2));
        QOIV.put("Name", new Integer(3));
        QOIV.put("Description", new Integer(4));
        QOIV.put("ProcedureName", new Integer(5));
        QOIV.put("ReadOnly", new Integer(6));
        QOIV.put("maxDuration", new Integer(7));
        QOIV.put("Owner", new Integer(8));
        add = new HashVector(1);
        String string = null;
        Vector<String> vector = null;
        string = "anonymous";
        vector = new Vector<String>(9);
        vector.add("Qualifier");
        vector.add("TransactionIsolation");
        vector.add("maxRows");
        vector.add("Name");
        vector.add("Description");
        vector.add("ProcedureName");
        vector.add("ReadOnly");
        vector.add("maxDuration");
        vector.add("Owner");
        add.put(string, vector);
    }
}

