/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class HeadlessHelper {
    private HeadlessHelper() {
    }

    public static void init() {
    }

    public static FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = null;
        fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return fontMetrics;
    }

    public static Image createImage(int n, int n2) {
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Dimension getScreenSize() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (Throwable throwable) {
            return new Dimension(1280, 1024);
        }
    }

    public static int getScreenResolution() {
        try {
            int n = 0;
            try {
                n = Integer.parseInt(System.getProperty("resolution"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n < 72) {
                n = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            return n;
        }
        catch (Throwable throwable) {
            return 96;
        }
    }

    static {
        try {
            Toolkit.getDefaultToolkit();
            new Frame();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

