/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class Graph2DLineNode {
    public static final int RECTANGLE = 0;
    public static final int DIAMOND = 1;
    public static final int TRIANGLEUP = 2;
    public static final int TRIANGLEDOWN = 3;
    public static final int TRIANGLELEFT = 4;
    public static final int TRIANGLERIGHT = 5;
    public static final int CIRCLE = 6;
    public static final int CROSS1 = 7;
    public static final int CROSS2 = 8;
    public static final int NONE = 9;
    public static final int STAR1 = 10;
    public static final int STAR2 = 11;
    public static final int ARROW = 12;
    public static final int ARROW1 = 13;
    public static final int DEFAULT_SIZE = 3;
    public static final int DEFAULT_STYLE = 1;
    public static final int MAX_SIZE = 14;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final String[] styleNames = new String[]{"Rectangle", "Diamond", "Triangle Up", "Triangle Down", "Triangle Left", "Triangle Right", "Circle", "Cross1", "Cross2", "None", "Star1", "Star2"};
    protected int x;
    protected int y;
    protected int style = 9;
    protected int size;
    protected int maxSize = -1;
    protected ChartPenStyle pen;
    protected ChartFillPattern pattern;
    private GeneralPath QOIV = new GeneralPath();
    private int append = 3;
    private int black = 5;
    private int draw = 5;
    private int drawNode = 2;
    private int err = 2;
    private int fillOval;
    private int fillPolygon;
    private int fillRect;
    private int getColor;
    private int lineTo;
    private int moveTo;
    private int println;
    private int reset;
    private int setPenColor;
    private int setPenWidth;
    private int toString;
    private int I;
    private int Z;
    private int C;
    private int B;
    private int D;

    public Graph2DLineNode() {
        this.pen = new ChartPenStyle("Solid Line");
        this.pen.setPenWidth(this.append);
        this.pattern = new ChartColorPattern(DEFAULT_COLOR);
    }

    public Graph2DLineNode(int n, int n2) {
        this();
        this.x = n;
        this.y = n2;
    }

    public Graph2DLineNode(int n, int n2, int n3) {
        this(n, n2);
        this.style = n3;
    }

    public Graph2DLineNode(int n) {
        this();
        this.style = n;
    }

    public Graph2DLineNode(int n, int n2, int n3, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern) {
        this(n, n2, n3);
        this.pen = chartPenStyle;
        this.pattern = chartFillPattern;
    }

    public Graph2DLineNode(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3);
        this.black = n4;
        this.draw = n5;
    }

    public Graph2DLineNode(int n, int n2, int n3, int n4, int n5, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern) {
        this(n, n2, n3, n4, n5);
        this.pen = chartPenStyle;
        this.pattern = chartFillPattern;
    }

    public void drawNode(Graphics graphics) {
        this.drawNode(graphics, this.x, this.y, this.style);
    }

    public void drawNode(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.black = n4;
        this.draw = n5;
        this.drawNode(graphics, n, n2, n3);
    }

    public void drawNode(Graphics graphics, int n, int n2, int n3) {
        ChartPenStyle chartPenStyle = new ChartPenStyle("Solid Line");
        ChartColorPattern chartColorPattern = new ChartColorPattern();
        chartPenStyle.setPenColor(chartColorPattern);
        this.drawNode = this.black / 2;
        this.err = this.draw / 2;
        switch (n3) {
            case 0: {
                this.append(graphics, n, n2);
                break;
            }
            case 1: {
                this.fillOval(graphics, n, n2);
                break;
            }
            case 2: {
                this.QOIV(graphics, n, n2);
                break;
            }
            case 3: {
                this.fillPolygon(graphics, n, n2);
                break;
            }
            case 4: {
                this.fillRect(graphics, n, n2);
                break;
            }
            case 5: {
                this.getColor(graphics, n, n2);
                break;
            }
            case 6: {
                this.DEFAULT_COLOR(graphics, n, n2);
                break;
            }
            case 7: {
                this.black(graphics, n, n2);
                break;
            }
            case 8: {
                this.err(graphics, n, n2);
                break;
            }
            case 10: {
                this.draw(graphics, n, n2);
                break;
            }
            case 11: {
                this.drawNode(graphics, n, n2);
                break;
            }
            case 12: {
                this.lineTo(graphics, n, n2);
                break;
            }
            case 13: {
                this.maxSize(graphics, n, n2);
                break;
            }
            case 9: {
                return;
            }
            default: {
                System.err.println("Invalid line node style " + n3);
                return;
            }
        }
    }

    private void DEFAULT_COLOR(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        graphics.fillOval(this.fillOval, this.setPenColor, this.black, this.draw);
    }

    private void QOIV(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 + this.err;
        this.fillPolygon = n;
        this.setPenWidth = n2 - this.err;
        this.fillRect = n + this.drawNode;
        this.toString = n2 + this.err;
        int[] nArray = new int[]{this.fillOval, this.fillPolygon, this.fillRect};
        int[] nArray2 = new int[]{this.setPenColor, this.setPenWidth, this.toString};
        int n3 = 3;
        graphics.fillPolygon(nArray, nArray2, n3);
    }

    private void append(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        graphics.fillRect(this.fillOval, this.setPenColor, this.black, this.draw);
    }

    private void black(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2;
        this.fillPolygon = n + this.drawNode;
        this.setPenWidth = n2;
        this.fillRect = n;
        this.toString = n2 - this.err;
        this.getColor = n;
        this.I = n2 + this.err;
        this.moveTo(graphics, this.fillOval, this.setPenColor, this.fillPolygon, this.setPenWidth);
        this.moveTo(graphics, this.fillRect, this.toString, this.getColor, this.I);
    }

    private void draw(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        this.fillPolygon = n + this.drawNode;
        this.setPenWidth = n2 + this.err;
        this.fillRect = n - this.drawNode;
        this.toString = n2 + this.err;
        this.getColor = n + this.drawNode;
        this.I = n2 - this.err;
        this.lineTo = n;
        this.Z = n2 - this.err;
        this.moveTo = n;
        this.C = n2 + this.err;
        this.moveTo(graphics, this.fillOval, this.setPenColor, this.fillPolygon, this.setPenWidth);
        this.moveTo(graphics, this.fillRect, this.toString, this.getColor, this.I);
        this.moveTo(graphics, this.lineTo, this.Z, this.moveTo, this.C);
    }

    private void drawNode(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        this.fillPolygon = n + this.drawNode;
        this.setPenWidth = n2 + this.err;
        this.fillRect = n - this.drawNode;
        this.toString = n2 + this.err;
        this.getColor = n + this.drawNode;
        this.I = n2 - this.err;
        this.lineTo = n;
        this.Z = n2 - this.err;
        this.moveTo = n;
        this.C = n2 + this.err;
        this.println = n - this.drawNode;
        this.B = n2;
        this.reset = n + this.drawNode;
        this.D = n2;
        this.moveTo(graphics, this.fillOval, this.setPenColor, this.fillPolygon, this.setPenWidth);
        this.moveTo(graphics, this.fillRect, this.toString, this.getColor, this.I);
        this.moveTo(graphics, this.lineTo, this.Z, this.moveTo, this.C);
        this.moveTo(graphics, this.println, this.B, this.reset, this.D);
    }

    private void err(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        this.fillPolygon = n + this.err;
        this.setPenWidth = n2 + this.err;
        this.fillRect = n - this.drawNode;
        this.toString = n2 + this.err;
        this.getColor = n + this.drawNode;
        this.I = n2 - this.err;
        this.moveTo(graphics, this.fillOval, this.setPenColor, this.fillPolygon, this.setPenWidth);
        this.moveTo(graphics, this.fillRect, this.toString, this.getColor, this.I);
    }

    private void fillOval(Graphics graphics, int n, int n2) {
        this.fillOval = n;
        this.setPenColor = n2 - this.err;
        this.fillPolygon = n - this.drawNode;
        this.setPenWidth = n2;
        this.fillRect = n;
        this.toString = n2 + this.err;
        this.getColor = n + this.drawNode;
        this.I = n2;
        int[] nArray = new int[]{this.fillOval, this.fillPolygon, this.fillRect, this.getColor};
        int[] nArray2 = new int[]{this.setPenColor, this.setPenWidth, this.toString, this.I};
        int n3 = 4;
        graphics.fillPolygon(nArray, nArray2, n3);
    }

    private void fillPolygon(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        this.fillPolygon = n;
        this.setPenWidth = n2 + this.err;
        this.fillRect = n + this.drawNode;
        this.toString = n2 - this.err;
        int[] nArray = new int[]{this.fillOval, this.fillPolygon, this.fillRect};
        int[] nArray2 = new int[]{this.setPenColor, this.setPenWidth, this.toString};
        int n3 = 3;
        graphics.fillPolygon(nArray, nArray2, n3);
    }

    private void fillRect(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2;
        this.fillPolygon = n + this.drawNode;
        this.setPenWidth = n2 - this.err;
        this.fillRect = n + this.drawNode;
        this.toString = n2 + this.err;
        int[] nArray = new int[]{this.fillOval, this.fillPolygon, this.fillRect};
        int[] nArray2 = new int[]{this.setPenColor, this.setPenWidth, this.toString};
        int n3 = 3;
        graphics.fillPolygon(nArray, nArray2, n3);
    }

    private void getColor(Graphics graphics, int n, int n2) {
        this.fillOval = n - this.drawNode;
        this.setPenColor = n2 - this.err;
        this.fillPolygon = n - this.drawNode;
        this.setPenWidth = n2 + this.err;
        this.fillRect = n + this.drawNode;
        this.toString = n2;
        int[] nArray = new int[]{this.fillOval, this.fillPolygon, this.fillRect};
        int[] nArray2 = new int[]{this.setPenColor, this.setPenWidth, this.toString};
        int n3 = 3;
        graphics.fillPolygon(nArray, nArray2, n3);
    }

    private void lineTo(Graphics graphics, int n, int n2) {
        int n3 = 4;
        this.fillPolygon = n - 2 * n3;
        this.fillRect = n;
        this.getColor = n + 2 * n3;
        this.lineTo = n;
        this.setPenWidth = n2 + 2 * n3;
        this.toString = n2 - 2 * n3;
        this.I = n2 + 2 * n3;
        this.Z = n2 + 1;
        int[] nArray = new int[]{this.fillPolygon, this.fillRect, this.getColor, this.lineTo};
        int[] nArray2 = new int[]{this.setPenWidth, this.toString, this.I, this.Z};
        int n4 = 4;
        graphics.fillPolygon(nArray, nArray2, n4);
    }

    private void maxSize(Graphics graphics, int n, int n2) {
        int n3 = 5;
        this.fillPolygon = n - n3;
        this.fillRect = n + n3;
        this.getColor = n;
        this.setPenWidth = n2 + 2 * n3;
        this.toString = n2 + 2 * n3;
        this.I = n2 - 2 * n3;
        int[] nArray = new int[]{this.fillPolygon, this.fillRect, this.getColor};
        int[] nArray2 = new int[]{this.setPenWidth, this.toString, this.I};
        int n4 = 3;
        graphics.fillPolygon(nArray, nArray2, n4);
    }

    public void setPenStyle(ChartPenStyle chartPenStyle) {
        this.pen = chartPenStyle;
    }

    public void setFillPattern(ChartFillPattern chartFillPattern) {
        this.pattern = chartFillPattern;
    }

    public void setSize(int n) {
        if (n >= 0 && n <= 14) {
            this.size = n;
        } else {
            n = 3;
        }
    }

    private void moveTo(Graphics graphics, int n, int n2, int n3, int n4) {
        this.pen.setPenColor(new ChartColorPattern(graphics.getColor()));
        this.QOIV.reset();
        this.QOIV.moveTo(n, n2);
        this.QOIV.lineTo(n3, n4);
        this.pen.draw((Graphics2D)graphics, this.QOIV);
    }
}

