/*
 * Decompiled with CFR 0.152.
 */
package jet.controls;

import com.jinfonet.util.JRLog;
import guitools.image.GIF;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.controls.JetResourceable;
import jet.controls.JetString;
import jet.convert.ImgInfo;
import jet.export.util.ImageEncoder;
import jet.util.BitmapReader;
import jet.util.ImageLoader;
import jet.util.TempFile;
import org.apache.commons.codec.binary.Base64;

public class JetImgProperty
extends JetString
implements JetResourceable,
ImgInfo {
    static final String C = ".." + File.separator;
    static final String QOIV = File.separator;
    private Image append = null;
    int available = -1;
    String close;
    private static Canvas createGraphics = new Canvas();
    private String createImage = "";
    private String createImageOutputStream = "";
    private int createTempFile = -100;

    public JetImgProperty() {
    }

    public JetImgProperty(JetObject jetObject, String string) {
        super(jetObject, string);
        this.value = "";
    }

    public int getResourceID() {
        return this.available;
    }

    public void setResourceID(int n) {
        this.available = n;
    }

    public String getLocalPath() {
        return this.close;
    }

    public void setLocalPath(String string) {
        this.set(string);
    }

    public String getURL() {
        return this.close;
    }

    public void setURL(String string) {
        this.close = string;
    }

    public void set(String string) {
        super.set(string);
        this.close = null;
    }

    public void setPath(String string) {
        this.createImage = string;
        this.createImageOutputStream = null;
    }

    public String getPath() {
        if (this.createImage == null || this.createImage.length() == 0) {
            // empty if block
        }
        return this.createImage;
    }

    public void setEmbedImage(Image image) {
        this.append = image;
    }

    public void setEmbedImageType(int n) {
        this.createTempFile = n;
    }

    public boolean isImageEmbed() {
        return this.append != null;
    }

    public Object getResource(String string) {
        if (this.append != null) {
            return this.append;
        }
        String string2 = this.get();
        if (string2 == null || string2.trim().length() == 0) {
            this.createTempFile = -100;
            return null;
        }
        if (ImageLoader.isFileFormat(string2)) {
            this.close = ImageLoader.getFilePath(string, string2);
            this.createImage = string;
        } else {
            this.close = string2;
        }
        ImageLoader imageLoader = new ImageLoader(string, string2);
        Object[] objectArray = imageLoader.loadImageDesc();
        this.createTempFile = (Integer)objectArray[1];
        return (Image)objectArray[0];
    }

    public int getImageType() {
        if (this.createTempFile == -100) {
            this.getObject();
        }
        return this.createTempFile;
    }

    public Object getResource() {
        return this.getObject();
    }

    public Object getObject() {
        if (this.append != null) {
            return this.append;
        }
        if (this.value instanceof Image) {
            return super.getObject();
        }
        if (this.isChangeByOther()) {
            return super.getObject();
        }
        if (this.close == null) {
            this.close = this.get();
        }
        if (this.close == null) {
            return null;
        }
        this.createImage = this.getPath();
        if (this.createImageOutputStream == null) {
            return this.getResource(this.createImage);
        }
        return this.getResource(this.createImageOutputStream);
    }

    public byte[] getGifBytes() throws IOException {
        Object object;
        boolean bl;
        if (this.close == null) {
            return null;
        }
        File file = new File(this.close);
        boolean bl2 = bl = !file.exists();
        if (bl) {
            object = this.C(this.close);
            Image image = (Image)this.getObject();
            TempFile tempFile = new TempFile(ReportEnv.temporaryPath, (String)object);
            file = tempFile.createTempFile();
            GIF gIF = new GIF(false);
            gIF.setDimensions(image.getWidth(createGraphics), image.getHeight(createGraphics));
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            gIF.encode(image, dataOutputStream);
        }
        object = new FileInputStream(file);
        byte[] byArray = new byte[((FileInputStream)object).available()];
        ((FileInputStream)object).read(byArray);
        ((FileInputStream)object).close();
        if (bl) {
            file.delete();
        }
        return byArray;
    }

    private String C(String string) {
        string = string.replace(File.separatorChar, '_');
        string = string.replace(':', '_');
        return string;
    }

    public void setImage(String string, Image image) {
        this.set(string);
        this.close = string;
        int n = image.getWidth(createGraphics);
        int n2 = image.getHeight(createGraphics);
        Image image2 = createGraphics.createImage(n, n2);
        Graphics graphics = image2.getGraphics();
        graphics.setClip(0, 0, n, n2);
        graphics.drawImage(image, 0, 0, createGraphics);
        graphics.dispose();
        image.flush();
        image = image2;
    }

    private static boolean QOIV(String string) {
        return ImageLoader.isFileFormat(string);
    }

    public ImageIcon getImageIcon(String string) throws MalformedURLException, IOException {
        ImageIcon imageIcon = null;
        if (!JetImgProperty.QOIV(this.get())) {
            BitmapReader bitmapReader;
            URL uRL = new URL(this.get());
            imageIcon = new ImageIcon(uRL);
            if ((imageIcon.getIconWidth() == -1 || imageIcon.getIconHeight() == -1) && (bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(uRL.openStream()))) != null) {
                imageIcon.setImage(Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc()));
            }
        } else {
            BitmapReader bitmapReader;
            String string2 = this.getFilePath(string);
            imageIcon = new ImageIcon(string2);
            if ((imageIcon.getIconWidth() == -1 || imageIcon.getIconHeight() == -1) && (bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(new FileInputStream(string2)))) != null) {
                imageIcon.setImage(Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc()));
            }
        }
        return imageIcon;
    }

    public String getFilePath(String string) {
        return JetImgProperty.getFilePath(string, this.get());
    }

    public static String getFilePath(String string, String string2) {
        return ImageLoader.getFilePath(string, string2);
    }

    public static String createRelativePath(String string, String string2) {
        String string3;
        if (!JetImgProperty.QOIV(string2)) {
            return string2;
        }
        if (!JetImgProperty.getRootPath(string).equals(JetImgProperty.getRootPath(string2))) {
            return "";
        }
        File file = new File(string);
        String string4 = file.getParent();
        if (string2.indexOf(string) == 0) {
            string3 = string2.substring(string.length() + 1, string2.length());
        } else if (string2.indexOf(string4) == 0) {
            string3 = "../";
            string3 = string3 + string2.substring(string4.length() + 1, string2.length());
        } else {
            string3 = "/";
            string3 = string3 + string2.substring(string2.indexOf(":") + 2, string2.length());
        }
        if (!File.separator.equals("/")) {
            String string5 = "";
            while (string3.length() > 0) {
                int n = string3.indexOf(File.separatorChar);
                if (n != -1) {
                    string5 = string5 + string3.substring(0, n);
                    string5 = string5 + "/";
                    string3 = string3.substring(n + 1);
                    continue;
                }
                string5 = string5 + string3;
                string3 = "";
            }
            return string5;
        }
        return string3;
    }

    public static String getRootPath(String string) {
        return ImageLoader.getRootPath(string);
    }

    public static byte[] imageToByte(Image image, int n) {
        try {
            if (image != null) {
                ImageEncoder imageEncoder = new ImageEncoder();
                switch (n) {
                    case 4: {
                        return imageEncoder.renderImageToGif(image);
                    }
                    case 3: {
                        return imageEncoder.renderImageToPNG(image);
                    }
                    case 0: 
                    case 1: {
                        return imageEncoder.renderImageToJpeg(image);
                    }
                }
                return JetImgProperty.imageToByte(image);
            }
            return new byte[0];
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static byte[] imageToByte(Image image) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/jpeg");
        ImageWriter imageWriter = iterator.hasNext() ? iterator.next() : null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = null;
        byte[] byArray = new byte[]{};
        try {
            imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            JRLog.error(2, 2200004, (Throwable)iOException);
        }
        if (imageOutputStream != null) {
            imageWriter.setOutput(imageOutputStream);
            BufferedImage bufferedImage = null;
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n <= 0 || n2 <= 0) {
                return byArray;
            }
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                bufferedImage = new BufferedImage(n, n2, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
            }
            try {
                imageWriter.write(new IIOImage(bufferedImage, null, null));
            }
            catch (IOException iOException) {
                JRLog.error(2, 2200004, (Throwable)iOException);
            }
            imageWriter.dispose();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public String getInspValue() {
        return super.get();
    }

    public String toString() {
        if (this.append != null) {
            byte[] byArray = JetImgProperty.imageToByte(this.append, this.createTempFile);
            return super.get() + "EMBED\u0007" + new String(Base64.encodeBase64((byte[])byArray));
        }
        return super.toString();
    }

    void I(String string) {
        if (string != null && string.indexOf("EMBED\u0007") > 0) {
            int n = string.indexOf("EMBED\u0007");
            super.I(string.substring(0, n));
            string = string.substring(n + "EMBED\u0007".length());
            byte[] byArray = Base64.decodeBase64((byte[])string.getBytes());
            this.append = ImageLoader.loadImage(byArray);
        } else {
            super.I(string);
        }
    }
}

