/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.conntools;

import com.jinfonet.dataservice.api.schema.relational.datasource.JDSConnection;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbConnection;
import com.jinfonet.dataservice.relational.datasource.file.JFileConnection;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbConnection;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import jet.dataengine.api.DSException;
import jet.dataengine8.core.queryengine.conntools.DBConnectionManager;
import jet.dataengine8.core.queryengine.conntools.FileConnectionCreator;
import org.apache.xerces.xni.parser.XMLInputSource;

public class ConnectionManager {
    private static Hashtable QOIV = new Hashtable();

    public static FileInputStream getFileInputStream(JDSConnection jDSConnection) throws DSException {
        FileConnectionCreator fileConnectionCreator = new FileConnectionCreator((JFileConnection)jDSConnection);
        return fileConnectionCreator.createFileInputStream();
    }

    public static XMLInputSource getXMLInputSource(JDSConnection jDSConnection) throws DSException {
        return null;
    }

    public static Connection getRDBConnection(JDSConnection jDSConnection) throws DSException {
        Object object;
        Connection connection = null;
        if (jDSConnection instanceof RdbConnection && (connection = ((RdbConnection)(object = (RdbConnection)jDSConnection)).getConnection()) != null) {
            return connection;
        }
        object = new DBConnectionManager((JRdbConnection)jDSConnection);
        connection = ((DBConnectionManager)object).createConnection();
        return connection;
    }

    public static Connection getConnectionFromPool(JDSConnection jDSConnection) throws DSException {
        Connection connection = (Connection)QOIV.get(jDSConnection);
        if (connection != null) {
            return connection;
        }
        connection = ConnectionManager.getRDBConnection(jDSConnection);
        QOIV.put(jDSConnection, connection);
        return connection;
    }

    public static void releaseConnection(Connection connection) throws DSException {
        Set set = QOIV.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JRdbConnection jRdbConnection = (JRdbConnection)iterator.next();
            if (!QOIV.get(jRdbConnection).equals(connection)) continue;
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                throw new DSException(2059, (Throwable)sQLException);
            }
            QOIV.remove(jRdbConnection);
        }
    }
}

