/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import jet.connect.DbBuffer;
import jet.connect.DbColumn;
import jet.connect.DbLongVariable;
import jet.connect.DbPage;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.datastream.Communicator;
import jet.util.RAFile;

public class DSDbBuffer
extends DbBuffer {
    private Communicator QOIV;
    protected Vector localPages = new Vector();
    int Z = -1;
    boolean addElement = true;
    private byte[] cacheThePage = new byte[1024];
    private boolean[] contains;

    public DSDbBuffer(Communicator communicator, JRecordModel jRecordModel, int n, int n2, int n3, int n4, boolean bl) throws IOException {
        this.cacheToFile = bl;
        this.initFile();
        this.bNeedWaitFetch = false;
        this.Z = n;
        this.QOIV = communicator;
        this.currentEnd = n4;
        if (bl) {
            if (this.bufFile == null) {
                this.createTempFile();
            }
            this.bufFile.seek(n3 * n2 * (n4 / n2 + 1));
        }
        if (this.getBlobCount() != 0) {
            this.contains = new boolean[n4];
        }
        this.finish();
    }

    public DSDbBuffer(Communicator communicator, JRecordModel jRecordModel, int n, int n2, int n3, int n4) throws IOException {
        this(communicator, jRecordModel, n, n2, n3, n4, true);
    }

    private void QOIV(InputStream inputStream, RandomAccessFile randomAccessFile) throws IOException {
        int n;
        while ((n = inputStream.read(this.cacheThePage)) != -1) {
            randomAccessFile.write(this.cacheThePage, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshRecord(JRecord jRecord, boolean bl) {
        block18: {
            int n = this.getPageNumberByRowNumber(jRecord.getRecordIndex());
            int n2 = jRecord.getRecordIndex();
            if (this.addElement(n)) {
                block17: {
                    try {
                        if (this.cacheToFile) {
                            this.Z(n2, null);
                        } else {
                            DbPage dbPage = this.getPageOfTheRow(n2);
                            this.Z(n2, dbPage);
                        }
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break block17;
                        JRLog.error(2, iOException);
                    }
                }
                super.refreshRecord((Record)jRecord, bl);
            } else {
                try {
                    InputStream inputStream = this.QOIV.getRecordBlock(jRecord.getRecordIndex(), this.Z);
                    if (this.bufFile == null) {
                        this.createTempFile();
                    }
                    if (this.cacheToFile) {
                        RAFile rAFile = this.bufFile;
                        synchronized (rAFile) {
                            long l = this.getRecordSize() * this.recordPerPage * n;
                            this.bufFile.seek(l);
                            this.QOIV(inputStream, this.bufFile);
                            if (this.addElement) {
                                this.lastPage.readFromFile(this.bufFile);
                                this.addElement = false;
                            }
                            this.Z(jRecord.getRecordIndex(), null);
                        }
                    } else {
                        DbPage dbPage;
                        if (this.addElement && this.lastPage != null) {
                            this.lastPage.read(new DataInputStream(inputStream));
                            this.addElement = false;
                            dbPage = this.lastPage;
                        } else {
                            dbPage = new DbPage(this, n);
                            dbPage.read(new DataInputStream(inputStream));
                            this.cacheThePage(dbPage);
                        }
                        this.Z(jRecord.getRecordIndex(), dbPage);
                    }
                    super.refreshRecord((Record)jRecord, bl);
                    this.localPages.addElement(new Integer(n));
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block18;
                    JRLog.error(2, exception);
                }
            }
        }
    }

    private void Z(int n, DbPage dbPage) throws IOException {
        Vector vector = this.getBlobFiles();
        if (this.getBlobCount() != 0 && !this.contains[n]) {
            this.contains[n] = true;
            long[] lArray = this.getBlobEntrys(n);
            DbColumn[] dbColumnArray = null;
            if (dbPage != null) {
                dbColumnArray = dbPage.getBlobColumns();
            }
            if (lArray != null) {
                int n2 = 0;
                while (n2 < lArray.length) {
                    InputStream inputStream = this.QOIV.getBlob(this.Z, n2, lArray[n2]);
                    if (this.cacheToFile) {
                        RandomAccessFile randomAccessFile = (RandomAccessFile)vector.elementAt(n2);
                        try {
                            randomAccessFile.seek(lArray[n2]);
                            this.QOIV(inputStream, randomAccessFile);
                        }
                        catch (IOException iOException) {
                            if (JRLog.isError(2)) {
                                JRLog.error(2, iOException);
                            }
                        }
                    } else {
                        DataInputStream dataInputStream = new DataInputStream(inputStream);
                        int n3 = dataInputStream.readInt();
                        byte[] byArray = new byte[n3];
                        dataInputStream.readFully(byArray);
                        ((DbLongVariable)((Object)dbColumnArray[n2])).setByteRow(byArray, n);
                    }
                    ++n2;
                }
            }
        }
    }

    private final boolean addElement(int n) {
        return this.localPages.contains(new Integer(n));
    }
}

