/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.imp;

import java.awt.Color;
import jet.export.rtf.api.Constant;
import jet.export.rtf.api.LineInfo;
import jet.export.rtf.api.PatternInfo;

public class WriteTool
implements Constant {
    protected String getColor(Color color) {
        if (color == null) {
            return "16777215";
        }
        return Integer.toString((color.getBlue() << 16) + (color.getGreen() << 8) + color.getRed());
    }

    protected void setBorderStyle(StringBuffer stringBuffer, LineInfo lineInfo) {
        if (lineInfo == null || lineInfo.isNoLine()) {
            stringBuffer.append("{\\sp{\\sn fLine}{\\sv 0}}");
            return;
        }
        stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(lineInfo.getLineWidth()).append("}}");
        if (lineInfo.getPattern() != null) {
            PatternInfo patternInfo = lineInfo.getPattern();
            stringBuffer.append("{\\sp{\\sn lineColor}{\\sv ").append(this.getColor(patternInfo.getForeColor())).append("}}");
            stringBuffer.append("{\\sp{\\sn lineBackColor}{\\sv ").append(this.getColor(patternInfo.getBackColor())).append("}}");
            stringBuffer.append("{\\sp{\\sn lineType}{\\sv 1}}").append("{\\sp{\\sn fLine}{\\sv 1}}");
        } else {
            byte by;
            if (lineInfo.getLineColor() != null) {
                stringBuffer.append("{\\sp{\\sn lineColor}{\\sv ").append(this.getColor(lineInfo.getLineColor())).append("}}").append("{\\sp{\\sn fLine}{\\sv 1}}");
            } else {
                stringBuffer.append("{\\sp{\\sn fLine}{\\sv 0}}");
            }
            stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(lineInfo.getLineWidth()).append("}}");
            byte by2 = lineInfo.getLineDash();
            switch (by2) {
                case 7: {
                    stringBuffer.append("{\\sp{\\sn lineEndCapStyle}{\\sv 0}}");
                }
                case 8: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 2}}");
                    break;
                }
                case 9: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 6}}");
                    break;
                }
                case 10: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 8}}");
                    break;
                }
                case 11: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 7}}");
                    break;
                }
                case 12: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 9}}");
                    break;
                }
                case 13: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 10}}");
                    break;
                }
            }
            byte by3 = lineInfo.getLineStyle();
            switch (by3) {
                case 2: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 1}}");
                    break;
                }
                case 4: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 2}}");
                    break;
                }
                case 3: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 3}}");
                    break;
                }
                case 5: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 4}}");
                    break;
                }
            }
            stringBuffer.append("{\\sp{\\sn fArrowheadsOK}{\\sv 0}}");
            byte by4 = lineInfo.getBeginArrowStyle();
            if (by4 != 14) {
                switch (by4) {
                    case 15: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 1}}");
                        break;
                    }
                    case 17: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 2}}");
                        break;
                    }
                    case 16: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 5}}");
                        break;
                    }
                    case 18: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 3}}");
                        break;
                    }
                    default: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 4}}");
                    }
                }
                stringBuffer.append("{\\sp{\\sn lineStartArrowWidth}{\\sv 1}}{\\sp{\\sn lineStartArrowLength}{\\sv 1}}");
            }
            if ((by = lineInfo.getEndArrowStyle()) != 14) {
                switch (by4) {
                    case 15: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 1}}");
                        break;
                    }
                    case 17: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 2}}");
                        break;
                    }
                    case 16: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 5}}");
                        break;
                    }
                    case 18: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 3}}");
                        break;
                    }
                    default: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 4}}");
                    }
                }
                stringBuffer.append("{\\sp{\\sn lineEndArrowWidth}{\\sv 1}}{\\sp{\\sn lineEndArrowLength}{\\sv 1}}");
            }
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        lineInfo.reset();
    }

    protected String prepareText(String string) {
        char[] cArray = string.toCharArray();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c > '\u00ff' || c < '\u0000') {
                stringBuffer.append("\\uc2\\u").append((int)c).append("\\'").append(Constant.HEX[c >> 12 & 0xF]).append(Constant.HEX[c >> 8 & 0xF]).append("\\'").append(Constant.HEX[c >> 4 & 0xF]).append(Constant.HEX[c & 0xF]);
            } else if (c >= '\u0080') {
                stringBuffer.append("\\'").append(Integer.toHexString(c));
            } else if (c == '\r' || c == '\n') {
                stringBuffer.append(c);
            } else if (c < ' ') {
                stringBuffer.append("\\'").append(Integer.toHexString(c));
            } else if (c == '\\' || c == '{' || c == '}') {
                stringBuffer.append("\\'").append(Integer.toHexString(c));
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected boolean equal(LineInfo lineInfo, LineInfo lineInfo2) {
        if (lineInfo == null && lineInfo2 == null) {
            return true;
        }
        if (lineInfo != null && lineInfo2 != null) {
            return lineInfo.equal(lineInfo2);
        }
        return false;
    }
}

