/*
 * Decompiled with CFR 0.152.
 */
package jet.report.xls;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    private static final double QOIV = (double)DateUtil.QOIV(new GregorianCalendar(1900, 0, 1)) - 2.0;

    private DateUtil() {
    }

    public static double getExcelDate(Date date) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        if (calendar.get(1) < 1900 || calendar.get(1) > 9999) {
            return -1.0;
        }
        calendar = DateUtil.get(calendar);
        double d = (double)(date.getTime() - calendar.getTime().getTime()) / 8.64E7;
        return d + (double)DateUtil.QOIV(calendar) - QOIV;
    }

    public static Date getJavaDate(double d) {
        if (DateUtil.isValidExcelDate(d)) {
            int n = (int)Math.floor(d);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(1900, 0, n - 1);
            int n2 = (int)((d - Math.floor(d)) * 8.64E7 + 0.5);
            gregorianCalendar.set(14, n2);
            return gregorianCalendar.getTime();
        }
        return null;
    }

    public static boolean isValidExcelDate(double d) {
        return d > -4.9E-324;
    }

    private static int QOIV(Calendar calendar) {
        return calendar.get(6) + DateUtil.floor(calendar.get(1));
    }

    private static int floor(int n) {
        if (n < 1601) {
            throw new IllegalArgumentException("'year' must be 1601 or greater");
        }
        int n2 = n - 1601;
        int n3 = 365 * n2 + n2 / 4 - n2 / 100 + n2 / 400;
        return n3;
    }

    private static Calendar get(Calendar calendar) {
        calendar.get(11);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.get(11);
        return calendar;
    }
}

