/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import jet.connect.DbColDesc;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUProcedure;
import jet.universe.JetUResourceEntity;
import toolkit.db.ParaInterface;
import toolkit.db.ProcParaInfo;

public class JetUProcParameter
extends JetUResourceEntity
implements ParaInterface {
    public JetNumber index = new JetNumber(this, "Index");
    public JetString parameterName = new JetString(this, "ParameterName");
    public JetEnumeration type = new JetEnumeration(this, "Type", 81);
    public JetNumber sqlType = new JetNumber(this, "SQLType");
    public JetString sqlTypeName = new JetString(this, "SQLTypeName");
    public JetNumber precision = new JetNumber(this, "Precision");
    public JetNumber length = new JetNumber(this, "Length");
    public JetNumber scale = new JetNumber(this, "Scale");
    public JetNumber radix = new JetNumber(this, "Radix");
    public JetNumber nullable = new JetNumber(this, "Nullable");
    public JetString value = new JetString(this, "Value");
    private static final HashMap COMBO_EDITOR = new HashMap(15);

    public JetUProcParameter() {
    }

    public JetUProcParameter(String string, String string2, ProcParaInfo procParaInfo) {
        super(string, string2);
        this.index.set(procParaInfo.iIndex);
        this.parameterName.set(procParaInfo.strName);
        this.type.set(new Integer(procParaInfo.iType));
        this.sqlType.set(procParaInfo.iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.sqlTypeName.set(procParaInfo.strSQLTypeName);
        this.precision.set(procParaInfo.iPrecision);
        this.length.set(procParaInfo.iLength);
        this.scale.set(procParaInfo.iScale);
        this.radix.set(procParaInfo.iRadix);
        this.nullable.set(procParaInfo.iNullable);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.value.set(procParaInfo.value);
    }

    public JetUProcedure getProcedure() {
        return (JetUProcedure)this.getParent();
    }

    public String getProcedureName() {
        JetUProcedure jetUProcedure = this.getProcedure();
        if (jetUProcedure != null) {
            return jetUProcedure.getResourceName();
        }
        return null;
    }

    public int getIndex() {
        return this.index.get();
    }

    public void setIndex(int n) {
        this.index.set(n);
    }

    public String getParameterName() {
        return this.parameterName.get();
    }

    public void set(String string) {
        this.parameterName.set(string);
    }

    public boolean isINParameter() {
        return this.type.intValue() == 1 || this.type.intValue() == 2;
    }

    public boolean isOUTParameter() {
        return this.type.intValue() == 4 || this.type.intValue() == 2;
    }

    public int getType() {
        return this.type.intValue();
    }

    public void setType(int n) {
        this.type.set(new Integer(n));
    }

    public int getSQLType() {
        return this.sqlType.get();
    }

    public void setSQLType(int n) {
        this.sqlType.set(n);
    }

    public String getSQLTypeName() {
        return this.sqlTypeName.get();
    }

    public void setSQLTypeName(String string) {
        this.sqlTypeName.set(string);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int n) {
        this.precision.set(n);
    }

    public int getLength() {
        return this.length.get();
    }

    public void setLength(int n) {
        this.length.set(n);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int n) {
        this.scale.set(n);
    }

    public int getRadix() {
        return this.radix.get();
    }

    public void setRadix(int n) {
        this.radix.set(n);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int n) {
        this.nullable.set(n);
    }

    public String getValue() {
        return this.value.get();
    }

    public void setValue(String string) {
        this.value.set(string);
    }

    public DbColDesc getColDesc() {
        return null;
    }

    public String getDefinition() {
        return null;
    }

    public String getName() {
        return this.getParameterName();
    }

    public String getInstancePrefix() {
        return "ProcdureParameter";
    }

    public boolean isSimilar(JetUResourceEntity jetUResourceEntity) {
        return super.isSimilar(jetUResourceEntity) && this.index.equal(((JetUProcParameter)jetUResourceEntity).index) && this.parameterName.equal(((JetUProcParameter)jetUResourceEntity).parameterName) && this.type.equal(((JetUProcParameter)jetUResourceEntity).type) && this.sqlType.equal(((JetUProcParameter)jetUResourceEntity).sqlType);
    }

    public String toString() {
        return null;
    }

    public HashMap getIndecialMap() {
        return COMBO_EDITOR;
    }

    static {
        COMBO_EDITOR.put("DisplayWidth", new Integer(0));
        COMBO_EDITOR.put("Name", new Integer(1));
        COMBO_EDITOR.put("ParameterName", new Integer(2));
        COMBO_EDITOR.put("Precision", new Integer(3));
        COMBO_EDITOR.put("SQLType", new Integer(4));
        COMBO_EDITOR.put("Description", new Integer(5));
        COMBO_EDITOR.put("Length", new Integer(6));
        COMBO_EDITOR.put("SQLTypeName", new Integer(7));
        COMBO_EDITOR.put("Radix", new Integer(8));
        COMBO_EDITOR.put("GUIField", new Integer(9));
        COMBO_EDITOR.put("Type", new Integer(10));
        COMBO_EDITOR.put("Value", new Integer(11));
        COMBO_EDITOR.put("Scale", new Integer(12));
        COMBO_EDITOR.put("Nullable", new Integer(13));
        COMBO_EDITOR.put("Index", new Integer(14));
    }
}

