/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.util.JRLog;
import java.awt.Frame;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbColDesc;
import jet.connect.DbQuery;
import jet.connect.DbValue;
import jet.connect.RecordFilter;
import jet.dataengine.api.expression.IExpression;
import jet.datasource.JRColDesc;
import jet.datasource.JRExternalQueryRunner;
import jet.datasource.JRResultSet;
import jet.datasource.JRResultSetException;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.exception.UserException;
import jet.formula.FormulaInfo;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.VarsTable;
import jet.log.JRLogger;
import jet.report.JetRptSubLink;
import jet.rptengine.RptFormulaContainer;
import jet.server.api.SecurityContext;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWherePortion;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.universe.engine.UFileQueryEngine;
import jet.universe.engine.UHDSEngine;
import jet.universe.engine.UProcedureEngine;
import jet.universe.engine.UPsqlQueryEngine;
import jet.universe.engine.UUDSEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.ParameterNotResolved;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.resultfile.UResultFileResultSet;
import jet.util.DbValueComparer;
import jet.util.HashVector;
import toolkit.db.DbTools;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.PsqlTable;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.gui.JdbcDatabase;

public abstract class UQueryEngine {
    protected JetUUniverse unvs;
    protected String strQueryName;
    protected String dataSourceName = "";
    protected Vector mappingFlds;
    protected Vector groupParams;
    protected Vector subLinks;
    protected Vector rptSubLinks;
    protected Vector[] aOrderBys;
    protected String strWherePortion;
    protected String strWherePortionName;
    protected String orderBy;
    protected JetUJDBCConnection jCnnt = null;
    protected Hashtable htDbFields = new Hashtable();
    protected RptFormulaContainer fmlsContainer = null;
    protected Hashtable htDbFieldsInLocalWhere = null;
    protected RptFormulaContainer fmlsInLocalWhere = null;
    protected Vector vecDbFields = null;
    protected int[] aiDbFieldsBackIndex = new int[0];
    protected Vector vecDbFieldsInLocalWhere = null;
    protected int[] aiDbFieldsInLocalWhereBackIndex = new int[0];
    protected HashVector vecFormulas = null;
    protected HashVector vecFormulasInLocalWhere = null;
    protected Hashtable paramsBuff = new Hashtable();
    protected Vector serverLinks = new Vector();
    protected Vector localLinks = new Vector();
    protected Vector paramLinks = new Vector();
    protected Vector rptServerLinks = null;
    protected Vector rptLocalLinks = null;
    protected Vector rptParamLinks = null;
    protected String strURL = null;
    protected String strUID = null;
    protected String strPSWD = null;
    protected String strJdbcDriver = null;
    protected boolean bUseDefaultConnection = true;
    protected boolean bStarted = false;
    protected DbQuery dbQuery = null;
    protected ResultSet rs = null;
    protected File flResultFile = null;
    protected boolean bUseResultFile = false;
    protected boolean bUseDSDriver = false;
    protected boolean bUseCacheQuery = false;
    protected UDSDriver dsdriver = null;
    protected boolean bUseUserDataSource = false;
    protected boolean bRunnerStart = false;
    protected JRExternalQueryRunner jreqRunner = null;
    private boolean _getResultSet = false;
    private String addOnlyUserName = "";
    private boolean checkDAG = false;
    protected transient int[] dbBufferInfo = null;
    protected Connection userDbConnection = null;
    protected ResultSet userResultSet = null;
    private boolean checkParameters = false;
    int class$;
    protected boolean bResolveRpt = false;
    protected Vector serverSecurity = new Vector();
    protected Vector localSecurity = new Vector();
    protected boolean hasReportRLS;
    protected String strLocalSecurity;
    protected Vector mpNames = new Vector();
    protected Hashtable htMPNameDescPairs;
    protected RecordFilter secFilter;
    boolean clear = false;
    Vector I = new Vector();
    protected SecurityContext secCxt = null;
    private static JRLogger close;
    protected String userTimeZone = "";
    protected String rptUserName;
    protected String pushDownWhereString;
    protected JdbcDriversConfig jdbcDriversConfig;
    private boolean columnName;
    static Class class$jet$universe$engine$UQueryEngine;
    static final boolean $assertionsDisabled;

    public void setUserTimeZone(String string) {
        this.userTimeZone = string;
        if (this.unvs != null) {
            this.unvs.setUserTimeZone(string);
        }
    }

    public UQueryEngine(JetUUniverse jetUUniverse, String string, String string2, Vector vector, Vector vector2, Vector vector3, boolean bl) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        this(jetUUniverse, string, string2, vector, vector2, vector3, null, bl);
    }

    public UQueryEngine(JetUUniverse jetUUniverse, String string, String string2, Vector vector, Vector vector2, Vector vector3, Vector vector4, boolean bl) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        String string3;
        this.unvs = jetUUniverse;
        this.mappingFlds = vector;
        this.groupParams = vector2;
        this.subLinks = vector3;
        this.bUseResultFile = bl;
        this.rptSubLinks = vector4;
        this.setQuery(string, string2);
        JetUConnection jetUConnection = jetUUniverse.getDatabase(string).getConnection();
        if (jetUConnection != null && jetUConnection instanceof JetUJDBCConnection) {
            this.jCnnt = (JetUJDBCConnection)jetUConnection;
        }
        String string4 = string3 = this.jCnnt == null ? null : this.jCnnt.getJdbcDriver();
        if (string3 != null && string3.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            this._getResultSet = true;
        }
    }

    protected void setQuery(String string) {
        this.setQuery("", string);
    }

    protected void setQuery(String string, String string2) {
        this.strQueryName = string2;
        this.dataSourceName = string;
    }

    public void setConnection(String string, String string2, String string3, String string4) {
        this.strURL = string;
        this.strUID = string2;
        this.strPSWD = string3;
        this.strJdbcDriver = string4;
        if (string4 != null && string4.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            this._getResultSet = true;
        }
        this.bUseDefaultConnection = false;
    }

    public void setNeedCloseSettingConnection(boolean bl) {
        this.columnName = bl;
    }

    public boolean needCloseSettingConnection() {
        return this.columnName;
    }

    public void setConnection(Connection connection) {
        this.userDbConnection = connection;
    }

    public void setUserResultSet(ResultSet resultSet) {
        this.userResultSet = resultSet;
    }

    public void setFetchSupportInfo(boolean bl) {
        this.checkParameters = bl;
    }

    public void setDSDriver(String string) throws LoadUserDataSourceException {
        if (string != null && !string.equals("")) {
            try {
                this.dsdriver = new UDSDriver(string);
                this.bUseCacheQuery = string.startsWith("jrquery:/jet.universe.resultfile.UResultFileResultSet");
                this.bUseDSDriver = !this.dsdriver.isDefaultDriver();
            }
            catch (UDSDriverFormatException uDSDriverFormatException) {
                throw new LoadUserDataSourceException(0, "");
            }
        } else {
            this.bUseDSDriver = false;
        }
    }

    public void setExternalQueryRunner(JRExternalQueryRunner jRExternalQueryRunner) {
        this.jreqRunner = jRExternalQueryRunner;
    }

    public void setCache(boolean bl) {
        this.clear = bl;
    }

    public boolean isCache() {
        return this.clear;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.secCxt = securityContext;
    }

    abstract void initParamNamesInQry() throws LoadUserDataSourceException;

    public void initialize() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError, LoadUserDataSourceException {
        if (this instanceof UHDSEngine) {
            this.clear = false;
        } else if (this instanceof UPsqlQueryEngine) {
            JetUQuery jetUQuery = this.unvs.GetQueryByResourceName(this.dataSourceName, this.strQueryName);
            if (jetUQuery.enableSQLStmtCreator.get()) {
                this.clear = false;
            }
        }
        if (this.clear) {
            this.initParamNamesInQry();
        }
        if (!this.bResolveRpt) {
            this.initGroupParameters();
            this.initSubLink();
        } else {
            this.initRptSubLink();
        }
        this.initMappingFields();
        this.initLocalWhere();
        this.initQuery();
        if (!this.bResolveRpt) {
            this.initParamLink();
        }
    }

    protected void initSubLink() throws CannotFindEntity, SubLinkError {
        this.serverLinks.removeAllElements();
        this.localLinks.removeAllElements();
        this.paramLinks.removeAllElements();
        if (this.subLinks != null) {
            DbValueComparer dbValueComparer;
            int n = this.subLinks.size();
            int n2 = 0;
            while (n2 < n) {
                dbValueComparer = (DbValueComparer)this.subLinks.elementAt(n2);
                String string = dbValueComparer.columnName;
                JetUResourceEntity jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity == null) {
                    throw new CannotFindEntity(string);
                }
                if (jetUResourceEntity instanceof JetUDBField) {
                    this.serverLinks.addElement(dbValueComparer);
                } else if (jetUResourceEntity instanceof JetUFormulaInterface) {
                    this.localLinks.addElement(dbValueComparer);
                } else if (jetUResourceEntity instanceof JetUParameter) {
                    if (this.clear && this.I.contains(dbValueComparer.columnName)) {
                        this.clear = false;
                    }
                    if (dbValueComparer.operator != 0) {
                        throw new SubLinkError(dbValueComparer.columnName);
                    }
                    this.paramLinks.addElement(dbValueComparer);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknow type of field");
                }
                ++n2;
            }
            if (!this.supportServerSubLink() || this.clear) {
                Vector<DbValueComparer> vector = new Vector<DbValueComparer>();
                n = this.serverLinks.size();
                int n3 = 0;
                while (n3 < n) {
                    dbValueComparer = (DbValueComparer)this.serverLinks.elementAt(n3);
                    vector.addElement(dbValueComparer);
                    ++n3;
                }
                n = vector.size();
                int n4 = 0;
                while (n4 < n) {
                    dbValueComparer = (DbValueComparer)vector.elementAt(n4);
                    this.serverLinks.removeElement(dbValueComparer);
                    this.localLinks.addElement(dbValueComparer);
                    ++n4;
                }
            }
        }
    }

    public void setRecSec(Vector vector) throws CannotFindEntity {
        int n;
        this.serverSecurity.removeAllElements();
        this.localSecurity.removeAllElements();
        if (vector != null) {
            n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                DbValueComparer dbValueComparer = (DbValueComparer)vector.elementAt(n2);
                String string = dbValueComparer.columnName;
                JetUResourceEntity jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity == null) {
                    throw new CannotFindEntity(string);
                }
                if (jetUResourceEntity instanceof JetUDBField && this.supportServerSubLink()) {
                    this.serverSecurity.addElement(dbValueComparer);
                } else {
                    this.localSecurity.addElement(dbValueComparer);
                }
                ++n2;
            }
        }
        if (this.localSecurity.size() > 0) {
            n = this.serverSecurity.size();
            int n3 = 0;
            while (n3 < n) {
                this.localSecurity.addElement(this.serverSecurity.elementAt(n3));
                ++n3;
            }
            this.serverSecurity.removeAllElements();
        }
    }

    public void setSecPolicy(IExpression iExpression) {
        if (this.hasReportRLS) {
            return;
        }
        if (this.mpNames == null) {
            this.mpNames = new Vector();
        } else {
            this.mpNames.removeAllElements();
        }
        if (this.htMPNameDescPairs == null) {
            this.htMPNameDescPairs = new Hashtable();
        }
    }

    public RecordFilter getLocalSecFilter() {
        return this.secFilter;
    }

    public void setReportRLS(boolean bl) {
        this.hasReportRLS = bl;
    }

    protected void initRptSubLink() throws CannotFindEntity, SubLinkError {
        if (this.rptSubLinks != null) {
            JetRptSubLink jetRptSubLink;
            this.rptServerLinks = new Vector(3);
            this.rptLocalLinks = new Vector(3);
            this.rptParamLinks = new Vector(3);
            int n = this.rptSubLinks.size();
            int n2 = 0;
            while (n2 < n) {
                jetRptSubLink = (JetRptSubLink)this.rptSubLinks.elementAt(n2);
                String string = jetRptSubLink.subColumn.get();
                JetUResourceEntity jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity == null) {
                    throw new CannotFindEntity(string);
                }
                if (jetUResourceEntity instanceof JetUDBField) {
                    this.rptServerLinks.addElement(jetRptSubLink);
                } else if (jetUResourceEntity instanceof JetUFormulaInterface) {
                    this.rptLocalLinks.addElement(jetRptSubLink);
                } else if (jetUResourceEntity instanceof JetUParameter) {
                    if (jetRptSubLink.operator.get() != DbValueComparer.strOper[0]) {
                        throw new SubLinkError(jetRptSubLink.mainColumn.get());
                    }
                    this.rptParamLinks.addElement(jetRptSubLink);
                }
                ++n2;
            }
            if (!this.supportServerSubLink()) {
                n = this.rptServerLinks.size();
                int n3 = 0;
                while (n3 < n) {
                    jetRptSubLink = (JetRptSubLink)this.rptServerLinks.elementAt(n3);
                    this.rptLocalLinks.addElement(jetRptSubLink);
                    this.rptServerLinks.removeElement(jetRptSubLink);
                    ++n3;
                }
            }
        }
    }

    public void setSubLinks(Vector vector) {
        block3: {
            this.subLinks = vector;
            try {
                this.initSubLink();
                if (this.haveLocalWhere()) {
                    this.initLocalWhere();
                }
            }
            catch (Exception exception) {
                if (!close.isErrorEnabled()) break block3;
                close.error("", exception);
            }
        }
    }

    protected void initParamLink() throws SubLinkError {
        if (!this.paramLinks.isEmpty()) {
            int n = this.paramLinks.size();
            DbValueComparer dbValueComparer = null;
            try {
                int n2 = 0;
                while (n2 < n) {
                    dbValueComparer = (DbValueComparer)this.paramLinks.elementAt(n2);
                    this.setParameterValue(dbValueComparer.columnName, dbValueComparer.value);
                    ++n2;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new SubLinkError(dbValueComparer.columnName);
            }
        }
    }

    protected void initGroupParameters() {
        if (this.groupParams != null && !this.groupParams.isEmpty()) {
            int n = this.groupParams.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.groupParams.elementAt(n2);
                JetUResourceEntity jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity instanceof JetUParameter) {
                    this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity, 1);
                }
                ++n2;
            }
        }
    }

    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery {
        int n = this.mappingFlds.size();
        this.fmlsContainer = this.dataSourceName == null ? new RptFormulaContainer(this.unvs, this.strQueryName) : new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        String string = this.dataSourceName;
        int n2 = 0;
        while (n2 < n) {
            JetUResourceEntity jetUResourceEntity;
            String string2 = (String)this.mappingFlds.elementAt(n2);
            JetUResourceEntity jetUResourceEntity2 = string != null ? this.unvs.getResourceByName(string, this.strQueryName, string2) : this.unvs.getResourceByName(this.strQueryName, string2);
            if (jetUResourceEntity2 == null && (jetUResourceEntity = this.unvs.getAnyResourceByName(string2)) != null && jetUResourceEntity instanceof JetUParameter) {
                jetUResourceEntity2 = jetUResourceEntity;
            }
            if (jetUResourceEntity2 == null) {
                throw new CannotFindEntity(string2);
            }
            if (jetUResourceEntity2 instanceof JetUDBField) {
                this.htDbFields.put(string2, jetUResourceEntity2);
            } else if (jetUResourceEntity2 instanceof JetUFormulaInterface) {
                this.putFormula(this.fmlsContainer, string2, (JetUFormulaInterface)((Object)jetUResourceEntity2));
            } else if (jetUResourceEntity2 instanceof JetUParameter) {
                this.putParameter(string2.toUpperCase(), (JetUParameter)jetUResourceEntity2);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unknow type of field");
            }
            ++n2;
        }
        this.putRefFldsToBuf(this.fmlsContainer, this.htDbFields);
        this.putRefParamToBuf(this.fmlsContainer);
    }

    protected void initLocalWhere() throws QueryWhereFormulaGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, FormulaRingException, ParseFormulaFailedException, CannotUseGlobalVarInFrmlWhere, CannotFindFrmlRefFld, FormulaHasGrammarError {
        if (this.haveLocalWhere()) {
            this.htDbFieldsInLocalWhere = new Hashtable();
            this.fmlsInLocalWhere = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
            this.putFormulasInLocalWhereToBuffer();
            VarsTable varsTable = new VarsTable();
            varsTable.addOnlyUserName();
            this.fmlsInLocalWhere.parseFormulas(true, varsTable);
            VarsTable varsTable2 = (VarsTable)this.fmlsInLocalWhere.getGVarTable().clone();
            varsTable2.remove("USERNAME");
            if (varsTable2.size() != 0) {
                throw new CannotUseGlobalVarInFrmlWhere();
            }
            this.putFldsInLocalLinkToBuf();
            this.putRefFldsToBuf(this.fmlsInLocalWhere, this.htDbFieldsInLocalWhere);
            this.putRefParamToBuf(this.fmlsInLocalWhere);
        }
    }

    public boolean haveLocalWhere() {
        return !this.localLinks.isEmpty() || this.secFilter != null || !this.localSecurity.isEmpty();
    }

    protected void putFormulasInLocalWhereToBuffer() throws FormulaHasGrammarError, QueryWhereFormulaGrammarError {
        block8: {
            Object object;
            Object object2;
            int n;
            block7: {
                JetUResourceEntity jetUResourceEntity;
                int n2;
                if (!this.localLinks.isEmpty()) {
                    n = this.localLinks.size();
                    n2 = 0;
                    while (n2 < n) {
                        object2 = (DbValueComparer)this.localLinks.elementAt(n2);
                        object = ((DbValueComparer)object2).columnName;
                        jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, (String)object);
                        if (jetUResourceEntity instanceof JetUFormulaInterface) {
                            this.putFormula(this.fmlsInLocalWhere, (String)object, (JetUFormulaInterface)((Object)jetUResourceEntity));
                        }
                        ++n2;
                    }
                }
                if (this.localSecurity.isEmpty()) break block7;
                n = this.localSecurity.size();
                n2 = 0;
                while (n2 < n) {
                    object2 = (DbValueComparer)this.localSecurity.elementAt(n2);
                    object = ((DbValueComparer)object2).columnName;
                    jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, (String)object);
                    if (jetUResourceEntity instanceof JetUFormulaInterface) {
                        this.putFormula(this.fmlsInLocalWhere, (String)object, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    }
                    ++n2;
                }
                break block8;
            }
            if (this.mpNames == null) break block8;
            int n3 = this.mpNames.size();
            n = 0;
            while (n < n3) {
                object2 = (String)this.mpNames.elementAt(n);
                object = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, (String)object2);
                if (object instanceof JetUFormulaInterface) {
                    this.putFormula(this.fmlsInLocalWhere, (String)object2, (JetUFormulaInterface)object);
                }
                ++n;
            }
        }
    }

    protected void putFldsInLocalLinkToBuf() {
        block8: {
            Object object;
            Object object2;
            int n;
            block7: {
                JetUResourceEntity jetUResourceEntity;
                int n2;
                if (!this.localLinks.isEmpty()) {
                    n = this.localLinks.size();
                    n2 = 0;
                    while (n2 < n) {
                        object2 = (DbValueComparer)this.localLinks.elementAt(n2);
                        object = ((DbValueComparer)object2).columnName;
                        jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, (String)object);
                        if (jetUResourceEntity instanceof JetUDBField) {
                            this.htDbFieldsInLocalWhere.put(jetUResourceEntity.getResourceNameInUpperCase(), jetUResourceEntity);
                        }
                        ++n2;
                    }
                }
                if (this.localSecurity.isEmpty()) break block7;
                n = this.localSecurity.size();
                n2 = 0;
                while (n2 < n) {
                    object2 = (DbValueComparer)this.localSecurity.elementAt(n2);
                    object = ((DbValueComparer)object2).columnName;
                    jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, (String)object);
                    if (jetUResourceEntity instanceof JetUDBField) {
                        this.htDbFieldsInLocalWhere.put(jetUResourceEntity.getResourceNameInUpperCase(), jetUResourceEntity);
                    }
                    ++n2;
                }
                break block8;
            }
            if (this.mpNames == null) break block8;
            int n3 = this.mpNames.size();
            n = 0;
            while (n < n3) {
                object2 = (String)this.mpNames.elementAt(n);
                object = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, (String)object2);
                if (object instanceof JetUDBField) {
                    this.htDbFieldsInLocalWhere.put(((JetUResourceEntity)object).getResourceNameInUpperCase(), object);
                }
                ++n;
            }
        }
    }

    protected void purifyFmlsInLocalWhereCon() {
        HashVector hashVector = this.fmlsInLocalWhere.getFormulas();
        int n = hashVector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = (String)hashVector.elementAt(n2);
            if (this.fmlsContainer.containsReal(string)) {
                this.fmlsInLocalWhere.removeFrml(string);
            }
            --n2;
        }
    }

    protected void purifyFldsInLocalWhereCon() throws CannotFindFrmlRefFld, FormulaHasGrammarError {
        Enumeration enumeration = this.htDbFieldsInLocalWhere.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)this.htDbFieldsInLocalWhere.get(string);
            if (!this.htDbFields.containsKey(string)) continue;
            this.htDbFieldsInLocalWhere.remove(string);
        }
    }

    protected abstract void initQuery() throws LoadUserDataSourceException;

    public void initParameters() throws ParameterNotResolved, CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError {
        this.putMapFldsInParamToBuff();
    }

    protected void putMapFldsInParamToBuff() throws ParameterNotResolved, CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError {
        RptFormulaContainer rptFormulaContainer = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        if (this.groupParams != null) {
            Enumeration enumeration = this.paramsBuff.elements();
            while (enumeration.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
                if (!this.groupParams.contains(paramDesc.name.toUpperCase()) || !paramDesc.isColumnCal()) continue;
                String string = paramDesc.inValue.toUpperCase();
                if (string == null) {
                    throw new ParameterNotResolved(paramDesc.name);
                }
                JetUResourceEntity jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity == null && this.groupParams != null && this.groupParams.contains(paramDesc.name.toUpperCase())) {
                    throw new CannotFindEntity(string);
                }
                if (jetUResourceEntity instanceof JetUDBField) {
                    this.htDbFields.put(string, jetUResourceEntity);
                    continue;
                }
                if (jetUResourceEntity instanceof JetUFormulaInterface) {
                    this.putFormula(this.fmlsContainer, string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    this.putFormula(rptFormulaContainer, string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    continue;
                }
                if (jetUResourceEntity instanceof JetUParameter) {
                    this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity);
                    String string2 = ((JetUParameter)jetUResourceEntity).getBinding();
                    if (string2 == null) continue;
                    jetUResourceEntity = this.unvs.getMaterialByName(this.dataSourceName, string2);
                    this.putParameter(string2.toUpperCase(), (JetUParameter)jetUResourceEntity);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknow type of field");
                }
            }
        }
        this.putRefFldsToBuf(rptFormulaContainer, this.htDbFields);
        this.putRefParamToBuf(rptFormulaContainer);
    }

    protected JdbcDatabase createJdbcDatabase(int n, int n2) {
        if (this.userDbConnection != null) {
            JdbcDatabase jdbcDatabase = new JdbcDatabase(this.userDbConnection);
            jdbcDatabase.setNeedCloseSettingConnection(this.columnName);
            return jdbcDatabase;
        }
        if (this.bUseDefaultConnection) {
            this.strURL = this.jCnnt.getURL();
            this.strUID = this.jCnnt.getUID();
            this.strPSWD = this.jCnnt.getPSWD();
            this.strJdbcDriver = this.jCnnt.getJdbcDriver();
        } else {
            if (this.strURL == null) {
                this.strURL = this.jCnnt.getURL();
            }
            if (this.strUID == null) {
                this.strUID = this.jCnnt.getUID();
            }
            if (this.strPSWD == null) {
                this.strPSWD = this.jCnnt.getPSWD();
            }
            if (this.strJdbcDriver == null) {
                this.strJdbcDriver = this.jCnnt.getJdbcDriver();
            }
        }
        JdbcDatabase jdbcDatabase = new JdbcDatabase(this.strURL, this.strUID, this.strPSWD, this.strJdbcDriver, DbTools.mergeTransactionIsolation(this.jCnnt.getTransactionIsolation(), n), DbTools.mergeReadOnly(this.jCnnt.getReadOnly(), n2));
        jdbcDatabase.setNeedCloseSettingConnection(this.columnName);
        return jdbcDatabase;
    }

    protected abstract void createDbQuery() throws FldNotFoundInQuery, SubLinkError, LoadUserDataSourceException, JRUserDataSourceException, JRResultSetException;

    protected void setUserSupportInfoRptPsql() {
    }

    protected void prepareBuffers() {
        block6: {
            JetUResourceEntity jetUResourceEntity;
            String string;
            block7: {
                DbValueComparer dbValueComparer;
                this.vecFormulas = this.fmlsContainer.getFormulas();
                if (!this.haveLocalWhere()) break block6;
                this.vecFormulasInLocalWhere = this.fmlsInLocalWhere.getFormulas();
                int n = this.localLinks.size();
                int n2 = 0;
                while (n2 < n) {
                    dbValueComparer = (DbValueComparer)this.localLinks.elementAt(n2);
                    string = dbValueComparer.columnName;
                    jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                    if (jetUResourceEntity instanceof JetUFormulaInterface) {
                        this.fmlsContainer.setFormulaWhere(string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    }
                    ++n2;
                }
                n = this.localSecurity.size();
                if (n <= 0) break block7;
                int n3 = 0;
                while (n3 < n) {
                    dbValueComparer = (DbValueComparer)this.localSecurity.elementAt(n3);
                    string = dbValueComparer.columnName;
                    jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                    if (jetUResourceEntity instanceof JetUFormulaInterface) {
                        this.fmlsContainer.setFormulaWhere(string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    }
                    ++n3;
                }
                break block6;
            }
            if (this.mpNames == null) break block6;
            int n = 0;
            while (n < this.mpNames.size()) {
                string = (String)this.mpNames.elementAt(n);
                jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity instanceof JetUFormulaInterface) {
                    this.fmlsContainer.setFormulaWhere(string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                }
                ++n;
            }
        }
    }

    protected void putParameter(String string, JetUParameter jetUParameter, int n) {
        if (!this.paramsBuff.containsKey(string)) {
            Object object;
            ParamDesc paramDesc = jetUParameter.getParamDesc();
            paramDesc.setBeColumn(n);
            this.paramsBuff.put(string, paramDesc);
            String string2 = paramDesc.getBinding();
            String string3 = paramDesc.getColumn();
            if (string2 != null && (object = (JetUParameter)this.unvs.getMaterialByName(this.dataSourceName, string2)) != null) {
                paramDesc = ((JetUParameter)object).getParamDesc();
                paramDesc.setBeColumn(5);
                this.paramsBuff.put(string2.toUpperCase(), paramDesc);
            }
            if (n == 0 && string3 != null && string3.length() > 0) {
                paramDesc.setBeColumn(4);
            }
            if (jetUParameter.isReferPara()) {
                object = new Hashtable();
                jetUParameter.getAllReferP(this.unvs, this.dataSourceName, this.strQueryName, (Hashtable)object);
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    if (this.mappingFlds.contains(string4.toUpperCase())) continue;
                    this.putParameter(string4.toUpperCase(), (JetUParameter)((Hashtable)object).get(string4));
                }
            }
        }
    }

    protected void putParameter(String string, JetUParameter jetUParameter) {
        this.putParameter(string, jetUParameter, 0);
    }

    public void setParameterValue(String string, DbValue dbValue) throws InvalidParameterException {
        ParamDesc paramDesc = (ParamDesc)this.paramsBuff.get(string);
        if (paramDesc != null) {
            paramDesc.set(dbValue);
        }
    }

    public void setParameterValue(String string, String string2) throws InvalidParameterException {
        ParamDesc paramDesc = (ParamDesc)this.paramsBuff.get(string);
        if (paramDesc != null) {
            paramDesc.setValue(string2, ParamDesc.defaultLocale);
        }
    }

    protected void putRefFldsToBuf(RptFormulaContainer rptFormulaContainer, Hashtable hashtable) throws CannotFindFrmlRefFld, FormulaHasGrammarError {
        Hashtable hashtable2 = rptFormulaContainer.getRefDbFlds();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)hashtable2.get(string);
            if (hashtable.containsKey(string)) continue;
            hashtable.put(string, jetUResourceEntity);
        }
    }

    protected void putRefParamToBuf(RptFormulaContainer rptFormulaContainer) throws CannotFindFrmlRefFld {
        Hashtable hashtable = rptFormulaContainer.getRefParameters();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JetUParameter jetUParameter = (JetUParameter)hashtable.get(string);
                this.putParameter(string.toUpperCase(), jetUParameter);
            }
        }
    }

    public boolean supportServerSubLink() {
        return !this.bUseResultFile && !this.bUseDSDriver && !this._getResultSet;
    }

    public boolean supportOrderBy() {
        return !this.bUseResultFile && !this.bUseDSDriver && !this._getResultSet;
    }

    public void setWherePortionName(String string) {
        this.strWherePortionName = string;
        this.strWherePortion = this.unvs.getWherePortion(this.dataSourceName, string);
    }

    public void setWherePortionString(String string) {
        this.strWherePortion = string;
    }

    public JetUWherePortion getUWherePortion() {
        return this.unvs.getUWherePortion(this.dataSourceName, this.strWherePortionName);
    }

    public String getWherePortionString() {
        return this.strWherePortion;
    }

    public Vector getSubLinks() {
        return this.subLinks;
    }

    public Vector[] getOrderBys() {
        return this.aOrderBys;
    }

    public JetUJDBCConnection getConnection() {
        return this.jCnnt;
    }

    public String getQueryName() {
        return this.strQueryName;
    }

    public void setOrderBy(Vector vector, Vector vector2) {
        this.aOrderBys = new Vector[]{vector, vector2};
        String string = this.prepareOrderByString(vector, vector2);
        if (this.dbQuery != null && !string.equals("")) {
            this.dbQuery.setOrderByClause(string);
        }
    }

    protected String prepareOrderByString(Vector vector, Vector vector2) {
        JetUConnection jetUConnection = this.unvs.getDatabase(this.dataSourceName).getConnection();
        if (jetUConnection != null && jetUConnection instanceof JetUJDBCConnection) {
            this.jCnnt = (JetUJDBCConnection)jetUConnection;
            StringBuffer stringBuffer = new StringBuffer("");
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                String string2 = (String)vector2.elementAt(n2);
                String string3 = this.getQaulifiedName(string);
                stringBuffer.append(string3);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                stringBuffer.append(",");
                ++n2;
            }
            String string = stringBuffer.toString();
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    protected JetUSupportInfo getSupportInfo() {
        JetUJdbcSupportInfo jetUJdbcSupportInfo = this.getUserSupportInfo();
        if (jetUJdbcSupportInfo != null) {
            return jetUJdbcSupportInfo;
        }
        return this.jCnnt.getSupportInfo();
    }

    protected String getQaulifiedName(String string) {
        int n = this.jCnnt.getQualifiedNamePattern();
        JetUSupportInfo jetUSupportInfo = this.getSupportInfo();
        String string2 = jetUSupportInfo.getExtraNameChar();
        String string3 = jetUSupportInfo.getQuoteChar();
        String string4 = jetUSupportInfo.getExtraKeywords();
        JetUResourceEntity jetUResourceEntity = this.unvs.getMaterialByName(this.dataSourceName, string);
        if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUDBField)) {
            jetUResourceEntity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string);
        }
        if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUDBField) {
            String string5;
            JetUDBField jetUDBField = (JetUDBField)((Object)jetUResourceEntity);
            String string6 = jetUDBField.getFldName();
            if (jetUResourceEntity instanceof JetUField) {
                JetUTableView jetUTableView = jetUDBField.getTable();
                String string7 = jetUTableView.getQualifier();
                String string8 = jetUTableView.getOwner();
                String string9 = jetUTableView.getTableName();
                string5 = PsqlTable.getQaulifiedName(n, string7, string8, string9, jetUTableView.getResourceName(), string2, string3, string4, null) + "." + DbQuery.quotedWhenNeed(string6, string2, string3, string4);
            } else if (jetUResourceEntity instanceof JetUFldQueryField) {
                String string10 = ((JetUFldQueryField)jetUDBField).getTableAlias();
                string5 = DbQuery.quotedWhenNeed(string10, string2, string3, string4) + "." + DbQuery.quotedWhenNeed(string6, string2, string3, string4);
            } else {
                string5 = DbQuery.quotedWhenNeed(string6, string2, string3, string4);
            }
            return string5;
        }
        if (jetUResourceEntity == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Can not find entity");
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"mapping name is not a JetUDBField");
        }
        return null;
    }

    protected void checkParameters() throws ParameterNotResolved {
        Enumeration enumeration = this.paramsBuff.elements();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
            if (paramDesc.inValue != null) continue;
            throw new ParameterNotResolved(paramDesc.name);
        }
    }

    public void start() throws ParameterNotResolved, FldNotFoundInQuery, SubLinkError, CannotFindFrmlRefFld, FormulaHasGrammarError, LoadUserDataSourceException, JRUserDataSourceException, JRResultSetException {
        if (!this.bResolveRpt) {
            this.checkParameters();
        }
        if (this.haveLocalWhere()) {
            this.purifyFmlsInLocalWhereCon();
            this.purifyFldsInLocalWhereCon();
        }
        if (this.jCnnt != null || this.bUseUserDataSource) {
            this.setUserSupportInfoRptPsql();
            this.createDbQuery();
            this.prepareBuffers();
            this.setUserDefinedSqlString();
        }
    }

    protected abstract void setUserDefinedSqlString();

    public JetUJdbcSupportInfo getUserSupportInfo() {
        JetUJdbcSupportInfo jetUJdbcSupportInfo = null;
        if (this.checkParameters && this.userDbConnection != null) {
            jetUJdbcSupportInfo = new JetUJdbcSupportInfo();
            jetUJdbcSupportInfo.fetchJDBCSupportInfo(this.userDbConnection);
        } else if (this.checkParameters && !this.bUseDefaultConnection) {
            if (this.strURL == null) {
                this.strURL = this.jCnnt.getURL();
            }
            if (this.strUID == null) {
                this.strUID = this.jCnnt.getUID();
            }
            if (this.strPSWD == null) {
                this.strPSWD = this.jCnnt.getPSWD();
            }
            if (this.strJdbcDriver == null) {
                this.strJdbcDriver = this.jCnnt.getJdbcDriver();
            }
            try {
                Connection connection = ConnectionsBroker.getConnection(this.strURL, this.strUID, this.strPSWD, this.strJdbcDriver, this.jCnnt.getTransactionIsolation(), this.jCnnt.getReadOnly());
                if (connection != null) {
                    jetUJdbcSupportInfo = new JetUJdbcSupportInfo();
                    jetUJdbcSupportInfo.fetchJDBCSupportInfo(connection);
                    ConnectionsBroker.freeConnection(connection);
                }
            }
            catch (Exception exception) {
                close.debug(exception);
            }
        }
        return jetUJdbcSupportInfo;
    }

    public void updateSubLink(Vector vector) {
        int n;
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        if (n2 == (n = this.subLinks.size())) {
            int n3 = 0;
            while (n3 < n) {
                DbValueComparer dbValueComparer = (DbValueComparer)this.subLinks.elementAt(n3);
                DbValueComparer dbValueComparer2 = (DbValueComparer)vector.elementAt(n3);
                if (dbValueComparer.columnName.equals(dbValueComparer2.columnName)) {
                    dbValueComparer.value = dbValueComparer2.value;
                }
                ++n3;
            }
        }
        try {
            this.initParamLink();
        }
        catch (SubLinkError subLinkError) {
            // empty catch block
        }
    }

    public void end() throws SQLException {
        block8: {
            if (this.rs != null && (this.dbQuery == null || this.dbQuery.getRS() != this.rs)) {
                try {
                    this.rs.close();
                    this.rs = null;
                }
                catch (Exception exception) {
                    this.rs = null;
                }
            }
            if (this.dbQuery != null && this.bStarted) {
                this.bStarted = false;
                if (this.addOnlyUserName == null || this.addOnlyUserName.trim().length() <= 0) {
                    this.addOnlyUserName = this.dbQuery.getSqlStatement(true);
                }
                try {
                    this.dbQuery.close();
                    this.dbQuery = null;
                    this.rs = null;
                }
                catch (Exception exception) {
                    this.dbQuery = null;
                    this.rs = null;
                    if (!close.isErrorEnabled()) break block8;
                    close.error("", exception);
                }
            }
        }
        if (this.jreqRunner != null && this.bRunnerStart) {
            this.jreqRunner.releaseResultSet(this.rs);
        }
    }

    public void closeResultSet() throws SQLException {
        if (this.rs != null && (this.dbQuery == null || this.dbQuery.getRS() != this.rs)) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Exception exception) {
                this.rs = null;
            }
        }
    }

    protected void putFormula(RptFormulaContainer rptFormulaContainer, String string, JetUFormulaInterface jetUFormulaInterface) throws FormulaHasGrammarError {
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        if (!formulaInfo.parseOK) {
            throw new FormulaHasGrammarError(string);
        }
        rptFormulaContainer.putFormula(string, jetUFormulaInterface);
    }

    public void setResultFile(File file) {
        this.flResultFile = file;
        this.bUseResultFile = true;
    }

    public String getSqlStatement() {
        if (this.dbQuery != null) {
            this.addOnlyUserName = this.dbQuery.getSqlStatement(true);
            return this.addOnlyUserName;
        }
        return this.addOnlyUserName;
    }

    public String getRawSqlStatement() {
        if (this.dbQuery != null) {
            return this.dbQuery.getSqlStatement(false);
        }
        return "";
    }

    public void setResultSet(ResultSet resultSet) {
        if (this.rs != null && this.rs != resultSet) {
            block4: {
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    if (!close.isErrorEnabled()) break block4;
                    close.error("", exception);
                }
            }
            if (this.dbQuery != null) {
                this.dbQuery.refresh();
            }
        }
        this.rs = resultSet;
    }

    public ResultSet getResultSet() throws SQLException, ClassNotFoundException, LoadUserDataSourceException, ParameterFormatInvalid {
        try {
            ResultSet resultSet;
            long l = 0L;
            if (this.htDbFields.isEmpty() && (this.htDbFieldsInLocalWhere == null || this.htDbFieldsInLocalWhere.isEmpty())) {
                return null;
            }
            if (this.userResultSet != null) {
                resultSet = this.userResultSet;
            } else {
                if (this.rs == null) {
                    if (this.bUseDSDriver) {
                        JRColDesc[] jRColDescArray = this.getColDescs();
                        if (jRColDescArray != null) {
                            String string = null;
                            String[] stringArray = null;
                            try {
                                string = this.dsdriver.getClassName();
                                stringArray = this.dsdriver.getParams();
                                Class<?> clazz = Class.forName(string);
                                Object obj = clazz.newInstance();
                                if (!(obj instanceof JRResultSet)) {
                                    throw new LoadUserDataSourceException(0, string);
                                }
                                this.rs = (ResultSet)obj;
                                ((JRResultSet)this.rs).initialize(jRColDescArray, stringArray);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new LoadUserDataSourceException(1, string);
                            }
                            catch (InstantiationException instantiationException) {
                                throw new LoadUserDataSourceException(2, string);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new LoadUserDataSourceException(3, string);
                            }
                        }
                    } else if (this.bUseResultFile) {
                        Vector vector = this.getColumnMap();
                        this.rs = new UResultFileResultSet(this.flResultFile, vector);
                    } else {
                        this._getResultSet();
                    }
                }
                resultSet = this.rs;
            }
            return resultSet;
        }
        catch (SQLException sQLException) {
            this.end();
            throw sQLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.end();
            throw classNotFoundException;
        }
        catch (ParameterFormatInvalid parameterFormatInvalid) {
            this.end();
            throw parameterFormatInvalid;
        }
    }

    protected void _getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid {
        if (this.dbQuery != null) {
            if (this.jreqRunner != null) {
                this.rs = this.jreqRunner.getResultSet(this.dbQuery.getSqlStatement(true));
                this.bRunnerStart = true;
            } else {
                this.bStarted = true;
                if (this.checkDAG) {
                    this.dbQuery.setSqlStatement(this.addOnlyUserName);
                }
                try {
                    this.rs = this.dbQuery.getResultSet();
                }
                catch (JRStopEngineException jRStopEngineException) {
                    // empty catch block
                }
            }
        }
    }

    public Vector getDbFlds() {
        return this.vecDbFields;
    }

    public int[] getDbFldsBackIndex() {
        return this.aiDbFieldsBackIndex;
    }

    public Vector getDbFldsInLocalWhere() {
        return this.vecDbFieldsInLocalWhere;
    }

    public int[] getDbFldsInLocalWhereBackIndex() {
        return this.aiDbFieldsInLocalWhereBackIndex;
    }

    public RptFormulaContainer getFormulaContainer() {
        return this.fmlsContainer;
    }

    public HashVector getFormulas() {
        return this.vecFormulas;
    }

    public HashVector getFormulasInLocalWhere() {
        return this.vecFormulasInLocalWhere;
    }

    public VarsTable getFormulasGVarTable() {
        return this.fmlsContainer.getGVarTable();
    }

    public Hashtable getParamsBuff() {
        return this.paramsBuff;
    }

    public ParamDesc getParameter(String string) {
        return (ParamDesc)this.paramsBuff.get(string.toUpperCase());
    }

    public String getFormulaWhere() {
        return null;
    }

    public Vector getLocalLinks() {
        return this.localLinks;
    }

    public Vector getLocalSecurity() {
        return this.localSecurity;
    }

    public boolean metaChanged(ResultSet resultSet) throws SQLException {
        return false;
    }

    public int[] updateColMap(ResultSet resultSet) throws SQLException {
        return null;
    }

    protected abstract Vector getTotalCols();

    public abstract JRColDesc[] getColDescs();

    public Vector getColumnMap() {
        int n;
        if (this instanceof UPsqlQueryEngine) {
            n = this.vecDbFields.size();
            if (this.haveLocalWhere()) {
                n += this.vecDbFieldsInLocalWhere.size();
            }
        } else {
            n = this.getTotalCols().size();
        }
        Vector<DbColDesc> vector = new Vector<DbColDesc>();
        String string = null;
        DbColDesc dbColDesc = null;
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            string = null;
            if (this.aiDbFieldsBackIndex[n3] != -1) {
                string = (String)this.vecDbFields.elementAt(this.aiDbFieldsBackIndex[n3] - 1);
                n2 = this.aiDbFieldsBackIndex[n3] - 1;
            } else if (this.haveLocalWhere()) {
                string = (String)this.vecDbFieldsInLocalWhere.elementAt(this.aiDbFieldsInLocalWhereBackIndex[n3] - 1);
                n2 = this.aiDbFieldsInLocalWhereBackIndex[n3] - 1;
            }
            if (string != null) {
                dbColDesc = this.unvs.getSQLType(this.dataSourceName, this.strQueryName, string);
                dbColDesc.setColName(string);
                if (n2 == vector.size()) {
                    vector.add(dbColDesc);
                } else if (n2 > vector.size()) {
                    int n4 = vector.size();
                    int n5 = 0;
                    while (n5 < n2 - n4) {
                        vector.add(null);
                        ++n5;
                    }
                    vector.add(dbColDesc);
                } else {
                    vector.setElementAt(dbColDesc, n2);
                }
            }
            ++n3;
        }
        return vector;
    }

    public Vector getFmlsColDescs() {
        DbColDesc dbColDesc;
        JetRptFormula jetRptFormula;
        String string;
        Enumeration enumeration;
        Vector<DbColDesc> vector = new Vector<DbColDesc>(5);
        Hashtable<String, DbColDesc> hashtable = new Hashtable<String, DbColDesc>();
        if (this.vecFormulas != null && this.vecFormulas.size() != 0) {
            enumeration = this.vecFormulas.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                jetRptFormula = (JetRptFormula)this.vecFormulas.get(string);
                dbColDesc = (DbColDesc)hashtable.get(string);
                if (dbColDesc == null) {
                    dbColDesc = jetRptFormula.getColDesc();
                    dbColDesc.setColName(string);
                    hashtable.put(string, dbColDesc);
                }
                if (jetRptFormula.isConstant()) {
                    dbColDesc.setConstant(true);
                }
                vector.addElement(dbColDesc);
            }
        }
        if (this.vecFormulasInLocalWhere != null && this.vecFormulasInLocalWhere.size() != 0) {
            enumeration = this.vecFormulasInLocalWhere.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                jetRptFormula = (JetRptFormula)this.vecFormulasInLocalWhere.get(string);
                dbColDesc = (DbColDesc)hashtable.get(string);
                if (dbColDesc == null) {
                    dbColDesc = jetRptFormula.getColDesc();
                    dbColDesc.setColName(string);
                    hashtable.put(string, dbColDesc);
                }
                if (jetRptFormula.isConstant()) {
                    dbColDesc.setConstant(true);
                }
                vector.addElement(dbColDesc);
            }
        }
        return vector;
    }

    public void clearMem() {
        this.unvs = null;
        this.mappingFlds = null;
        this.orderBy = null;
        this.subLinks = null;
        if (this.htDbFields != null) {
            this.htDbFields.clear();
        }
        this.htDbFields = null;
        this.fmlsContainer = null;
        if (this.paramsBuff != null) {
            this.paramsBuff.clear();
        }
        this.paramsBuff = null;
        if (this.vecDbFields != null) {
            this.vecDbFields.removeAllElements();
        }
        this.vecDbFields = null;
        if (this.vecFormulas != null) {
            this.vecFormulas.clear();
        }
        this.vecFormulas = null;
        if (this.dbQuery != null && this.bStarted) {
            try {
                this.end();
            }
            catch (Exception exception) {
                close.debug(exception);
            }
        }
        this.rs = null;
        this.jCnnt = null;
    }

    public static UQueryEngine createEngine(JetUUniverse jetUUniverse, String string, Vector vector, Vector vector2, Vector vector3, boolean bl) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        return UQueryEngine.createEngine(jetUUniverse, "", string, vector, vector2, vector3, bl);
    }

    public static UQueryEngine createEngine(JetUUniverse jetUUniverse, String string, String string2, Vector vector, Vector vector2, Vector vector3, boolean bl) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        return UQueryEngine.createEngine(jetUUniverse, string, string2, vector, vector2, vector3, null, bl);
    }

    public static UQueryEngine createEngine(JetUUniverse jetUUniverse, String string, Vector vector, Vector vector2, Vector vector3, Vector vector4, boolean bl) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        return UQueryEngine.createEngine(jetUUniverse, "", string, vector, vector2, vector3, vector4, bl);
    }

    public static UQueryEngine createEngine(JetUUniverse jetUUniverse, String string, String string2, Vector vector, Vector vector2, Vector vector3, Vector vector4, boolean bl) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        UQueryEngine uQueryEngine = null;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable != null) {
            if (jetUQueriable instanceof JetUQuery) {
                uQueryEngine = new UPsqlQueryEngine(jetUUniverse, string, string2, vector, vector2, vector3, vector4, bl);
            } else if (jetUQueriable instanceof JetUFileQuery) {
                uQueryEngine = new UFileQueryEngine(jetUUniverse, string, string2, vector, vector2, vector3, vector4, bl);
            } else if (jetUQueriable instanceof JetUProcedure) {
                uQueryEngine = new UProcedureEngine(jetUUniverse, string, string2, vector, vector2, vector3, bl);
            } else if (jetUQueriable instanceof JetUUserDataSource) {
                uQueryEngine = new UUDSEngine(jetUUniverse, string, string2, vector, vector2, vector3, bl);
            } else if (jetUQueriable instanceof JetUHierDataSource) {
                uQueryEngine = new UHDSEngine(jetUUniverse, string, string2, vector, vector2, vector3, bl);
            }
        } else {
            throw new CannotFindQuery(string2);
        }
        return uQueryEngine;
    }

    public void setID(int n) {
        this.class$ = n;
    }

    public String toString() {
        return super.toString() + '@' + this.class$;
    }

    public DbQuery getDBQuery() {
        return this.dbQuery;
    }

    public boolean isJinfonetOOJDBCDriver() {
        return this._getResultSet;
    }

    public HashVector checkDAG(Frame frame, Hashtable hashtable, Vector vector, Hashtable hashtable2) {
        HashVector hashVector;
        block2: {
            hashVector = null;
            try {
                hashVector = this.fmlsContainer.checkDAG(frame, hashtable, vector, hashtable2);
            }
            catch (UserException userException) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, userException);
            }
        }
        return hashVector;
    }

    public Hashtable getFormulaToSection() {
        return this.fmlsContainer.getFormulaToSection();
    }

    public void setDbBufferInfo(int[] nArray) {
        this.dbBufferInfo = nArray;
    }

    public void setResolveRpt(boolean bl) {
        this.bResolveRpt = bl;
    }

    public void setRptUserName(String string) {
        if (this instanceof UPsqlQueryEngine) {
            ((UPsqlQueryEngine)this).psqlQuery.setRptUserName(string);
        } else if (this instanceof UHDSEngine) {
            ((UHDSEngine)this).uHDS.setRptUserName(string);
        }
        this.rptUserName = string;
    }

    public String getRptUserName() {
        return this.rptUserName;
    }

    public void setAddtionWhereString(String string) {
        this.pushDownWhereString = string;
    }

    public void setSQLStatement(String string) {
        this.checkDAG = true;
        this.addOnlyUserName = string;
    }

    public void setJdbcDriversConfig(JdbcDriversConfig jdbcDriversConfig) {
        this.jdbcDriversConfig = jdbcDriversConfig;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$engine$UQueryEngine == null ? (class$jet$universe$engine$UQueryEngine = UQueryEngine.class$("jet.universe.engine.UQueryEngine")) : class$jet$universe$engine$UQueryEngine).desiredAssertionStatus();
        close = JRLogger.getLogger((class$jet$universe$engine$UQueryEngine == null ? (class$jet$universe$engine$UQueryEngine = UQueryEngine.class$("jet.universe.engine.UQueryEngine")) : class$jet$universe$engine$UQueryEngine).getName());
    }
}

