/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.psql.JetPsqlColumn;
import jet.universe.psql.JetPsqlCondition;
import jet.universe.psql.RptPsqlFormulaColumn;
import toolkit.db.PsqlQuery;
import toolkit.db.PsqlSelColumn;

public class JetPsqlSelColumn
extends JetPsqlColumn {
    public JetNumber tableIndex = new JetNumber(this, "tableIndex");
    public JetString tableName = new JetString(this, "TableName");
    public JetString qlf = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString corr = new JetString(this, "CorrelatinName");
    public JetString mappingName = new JetString(this, "mappingName");
    public JetBoolean isFormulaField = new JetBoolean(this, "isFormulaField");
    public JetBoolean isHidden = new JetBoolean(this, "isHidden");
    public JetBoolean isCompCol = new JetBoolean(this, "isCompCol");
    private static final HashMap I = new HashMap(11);

    public JetPsqlSelColumn() {
    }

    public JetPsqlSelColumn(PsqlQuery psqlQuery, PsqlSelColumn psqlSelColumn) {
        super(psqlSelColumn);
        int n;
        Vector vector;
        this.uname.set(psqlSelColumn.getSuperMappingName());
        if (psqlQuery == null) {
            this.tableName.set(psqlSelColumn.table.getMappingName());
            this.qlf.set(psqlSelColumn.qualifier);
            this.owner.set(psqlSelColumn.owner);
            return;
        }
        boolean bl = psqlSelColumn.isCompCol();
        this.isFormulaField.set(bl);
        this.isHidden.set(psqlSelColumn.isHide());
        this.isCompCol.set(psqlSelColumn.bCompCol);
        this.mappingName.set(psqlSelColumn.getMappingName());
        if (bl) {
            this.tableName.set((String)null);
            this.qlf.set((String)null);
            this.owner.set((String)null);
            this.corr.set((String)null);
        } else {
            vector = psqlQuery.getPsqlTablesVector();
            n = vector.indexOf(psqlSelColumn.table);
            if (n >= 0) {
                this.tableIndex.set(n);
            }
            this.tableName.set(psqlSelColumn.table.getMappingName());
            this.qlf.set(psqlSelColumn.table.getQualifier());
            this.owner.set(psqlSelColumn.table.getOwner());
            this.corr.set(psqlSelColumn.table.getCorrelationName());
        }
        vector = psqlSelColumn.vConditions;
        n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            if (string != null && string.length() != 0) {
                this.add(new JetPsqlCondition(string, n2), -1);
            }
            ++n2;
        }
    }

    public void setName(String string) {
        super.setName(string);
    }

    public String getName() {
        return super.getName();
    }

    private JetUFormula I() {
        JetObject jetObject = (JetObject)((Object)this.getParent());
        while (!(jetObject instanceof JetUDatabase)) {
            jetObject = (JetObject)((Object)jetObject.getParent());
        }
        if (jetObject instanceof JetUDatabase) {
            JetUDatabase jetUDatabase = (JetUDatabase)jetObject;
            String string = this.mappingName.toString().toUpperCase();
            return jetUDatabase.getFormulaByResourceName(string);
        }
        return null;
    }

    public PsqlSelColumn makePsqlSelColumn(int n) {
        Object object;
        PsqlSelColumn psqlSelColumn = null;
        if (this.isFormulaField.get()) {
            psqlSelColumn = new RptPsqlFormulaColumn();
            object = this.I();
            if (object != null) {
                ((RptPsqlFormulaColumn)psqlSelColumn).setUFormulaEntity((JetUFormula)object);
            }
        } else {
            psqlSelColumn = new PsqlSelColumn();
        }
        psqlSelColumn.setName(this.name.get());
        psqlSelColumn.setSuperMappingName(this.uname.get());
        psqlSelColumn.setMappingName(this.mappingName.get());
        psqlSelColumn.qualifier = this.qlf.get();
        psqlSelColumn.owner = this.owner.get();
        psqlSelColumn.corr = this.corr.get();
        psqlSelColumn.sTableName = this.tableName.get();
        psqlSelColumn.tableIndex = this.tableIndex.get();
        psqlSelColumn.setCompCol(this.isCompCol.get());
        if (this.isFormulaField.get()) {
            psqlSelColumn.setCompCol(true);
        }
        psqlSelColumn.setHide(this.isHidden.get());
        object = psqlSelColumn.vConditions;
        if (((Vector)object).size() < 16) {
            ((Vector)object).setSize(16);
        }
        Vector vector = this.getChildren();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            JetObject jetObject = (JetObject)vector.elementAt(n3);
            if (jetObject instanceof JetPsqlCondition) {
                String string = ((JetPsqlCondition)jetObject).cond.get();
                int n4 = ((JetPsqlCondition)jetObject).row.get();
                if (n4 < 16) {
                    ((Vector)object).setElementAt(string, n4);
                }
            }
            ++n3;
        }
        return psqlSelColumn;
    }

    public void delete() {
        Vector vector = this.getChildren();
        int n = vector.size() - 1;
        while (n >= 0) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            this.remove(jetObject);
            --n;
        }
        super.delete();
    }

    public String getInstancePrefix() {
        return "PSQLSelColumn";
    }

    public HashMap getIndecialMap() {
        return I;
    }

    static {
        I.put("Qualifier", new Integer(0));
        I.put("Name", new Integer(1));
        I.put("isCompCol", new Integer(2));
        I.put("tableIndex", new Integer(3));
        I.put("CorrelatinName", new Integer(4));
        I.put("isHidden", new Integer(5));
        I.put("isFormulaField", new Integer(6));
        I.put("mappingName", new Integer(7));
        I.put("UName", new Integer(8));
        I.put("TableName", new Integer(9));
        I.put("Owner", new Integer(10));
    }
}

