/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import com.jinfonet.dataservice.expression.unchecked.UnCheckedOperatorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedMultiExpression;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.dataengine.util.DSLog;
import jet.util.SQLTraveler;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.ReloadQueryException;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.query.parser.ASTBooleanFactor;
import toolkit.db.query.parser.ASTBooleanTerm;
import toolkit.db.query.parser.ASTExplicitBoolean;
import toolkit.db.query.parser.ASTPredicate;
import toolkit.db.query.parser.ASTQueryStatement;
import toolkit.db.query.parser.ASTSearchCondition;
import toolkit.db.query.parser.ASTWhereClause;
import toolkit.db.query.parser.Node;
import toolkit.db.query.parser.ParseException;
import toolkit.db.query.parser.QueryParser;
import toolkit.db.query.parser.SimpleNode;

public class PsqlQuery
implements Serializable {
    public static final String LOGIC_AND = "AND";
    public static final String LOGIC_OR = "OR";
    public static final String LOGIC_NOT = "NOT";
    public static boolean bStateOfJoinOnForeignKeys_Def = true;
    public static boolean bStateOfJoinOnPrimaryKey_Def = true;
    public static boolean bStateOfJoinOnLikeName_Def = true;
    public static boolean bStateOfShowTableNames_Def = false;
    public static boolean bShowMappingName_Def = false;
    public static boolean bStateOfProhibitCartesianProducts_Def = true;
    public static boolean bAutoQuote_Def = false;
    public static int maxSize = 50;
    public static int pageSize = 100;
    public static int maxCurPage = 400;
    private static DSLog add = DSLog.getDSLog((class$toolkit$db$PsqlQuery == null ? (class$toolkit$db$PsqlQuery = PsqlQuery.class$("toolkit.db.PsqlQuery")) : class$toolkit$db$PsqlQuery).getName());
    protected String mappingName = null;
    protected boolean checkId = true;
    protected transient String errors = "";
    public Vector vTables;
    public Vector vSelCols;
    public Vector vGroupbySelCols;
    public Vector vOrderbySelCols;
    public Vector vPsqlJoin;
    public Vector vSCGrps = null;
    protected IExpression searchConditionExpression;
    public String sAndExpression = null;
    public Vector vAndExpression;
    public String sHavingExpression = null;
    public Vector vHavingExpression;
    public Vector vUnion;
    protected String sExtWhere = null;
    protected String sReplWhere = null;
    protected String altWhereClause = null;
    protected String userDefinedQueryStmt = "";
    protected String username;
    protected String password;
    protected boolean share;
    public boolean bStateOfUnqualifiedName = true;
    public boolean bStateOfJoinOnForeignKeys = true;
    public boolean bStateOfJoinOnPrimaryKey = true;
    public boolean bStateOfJoinOnLikeName = true;
    public boolean bStateOfShowTableNames = false;
    public boolean bShowMappingName = false;
    public boolean bStateOfProhibitCartesianProducts = true;
    public boolean bAutoQuote = false;
    public boolean bDistinct = false;
    protected boolean bIgnorePredicateIfParamIsNull = false;
    public Object objConnectInfo = null;
    public int ver = 1;
    protected SQLMapInfo sqlMapInfo = null;
    protected boolean convertFromOldSCGroup = true;
    static Class class$toolkit$db$PsqlQuery;

    public PsqlQuery() {
        this.QOIV();
        this.bStateOfJoinOnForeignKeys = bStateOfJoinOnForeignKeys_Def;
        this.bStateOfJoinOnPrimaryKey = bStateOfJoinOnPrimaryKey_Def;
        this.bStateOfJoinOnLikeName = bStateOfJoinOnLikeName_Def;
        this.bStateOfShowTableNames = bStateOfShowTableNames_Def;
        this.bShowMappingName = bShowMappingName_Def;
        this.bStateOfProhibitCartesianProducts = bStateOfProhibitCartesianProducts_Def;
        this.bAutoQuote = bAutoQuote_Def;
    }

    private void QOIV() {
        this.vTables = new Vector();
        this.vSelCols = new Vector();
        this.vGroupbySelCols = new Vector();
        this.vOrderbySelCols = new Vector();
        this.vPsqlJoin = new Vector();
        this.vAndExpression = new Vector();
        this.vHavingExpression = new Vector();
        this.vUnion = new Vector();
    }

    public void reloadFromQueryTree(ASTQueryStatement aSTQueryStatement) throws ReloadQueryException {
    }

    protected void removeTables() {
        this.vTables.removeAllElements();
    }

    public void removeJoins() {
        this.vPsqlJoin.removeAllElements();
    }

    public void removeAndConditions() {
        this.vAndExpression.removeAllElements();
        this.sAndExpression = null;
    }

    public void setMappingName(String string) {
        this.mappingName = string;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setExtendedWhere(String string) {
        this.sExtWhere = string;
    }

    public String getExtendedWhere() {
        return this.sExtWhere;
    }

    public void setReplacedWhere(String string) {
        this.sReplWhere = string;
        if (string != null && string.trim().length() == 0) {
            this.sReplWhere = null;
        }
    }

    public String getReplacedWhere() {
        return this.sReplWhere;
    }

    public void setAltWhereClause(String string) {
        this.altWhereClause = string;
    }

    public String getAltWhereClause() {
        return this.altWhereClause;
    }

    public void setConnectInfo(Object object) {
        this.objConnectInfo = object;
    }

    public Object getConnectInfoObj() {
        return this.objConnectInfo;
    }

    public boolean isDistinct() {
        return this.bDistinct;
    }

    public void setDistinct(boolean bl) {
        this.bDistinct = bl;
    }

    public boolean isIgnorePredicateIfParamIsNull() {
        return this.bIgnorePredicateIfParamIsNull;
    }

    public void setIgnorePredicateIfParamIsNull(boolean bl) {
        this.bIgnorePredicateIfParamIsNull = bl;
    }

    protected void update(Vector vector) {
        this.updateSelColumns();
        this.updatePsqlJoins();
    }

    public void initialPsqlTables(Vector vector) {
        int n = this.vTables.size() - 1;
        while (n >= 0) {
            PsqlTable psqlTable = (PsqlTable)this.vTables.elementAt(n);
            if (psqlTable == null) {
                this.vTables.removeElementAt(n);
            } else {
                PsqlTable psqlTable2 = PsqlTable.getTableByName(vector, psqlTable.getQualifier(), psqlTable.getOwner(), psqlTable.getName(), false);
                if (psqlTable2 == null) {
                    this.vTables.removeElementAt(n);
                } else {
                    psqlTable.newVectors();
                    psqlTable.setColumns(psqlTable2.getColumns());
                }
            }
            --n;
        }
    }

    public void updateSelColumns() {
        int n = this.vSelCols.size() - 1;
        while (n >= 0) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)this.vSelCols.elementAt(n);
            if (psqlSelColumn != null && !psqlSelColumn.isCompCol()) {
                psqlSelColumn.table = PsqlTable.getTableByName(this.vTables, psqlSelColumn.getQualifier(), psqlSelColumn.getOwner(), psqlSelColumn.getTableName(), false);
                if (psqlSelColumn.table == null) {
                    this.vSelCols.removeElementAt(n);
                }
            }
            --n;
        }
    }

    public void updatePsqlJoins() {
        int n = this.vTables.size();
        Object var9_2 = null;
        int n2 = this.vPsqlJoin.size() - 1;
        while (n2 >= 0) {
            PsqlJoin psqlJoin = (PsqlJoin)this.vPsqlJoin.elementAt(n2);
            int n3 = psqlJoin.getIndexOfTableFrom();
            if (n3 >= n) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_10", (Object)String.valueOf(n2 + 1)) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(n2);
                }
                psqlJoin.setNotResolved();
            } else {
                PsqlTable psqlTable = (PsqlTable)this.vTables.elementAt(n3);
                if (psqlTable == null) {
                    this.errors = this.errors + JResource.getMessage("CAT_PSQL_11", (Object)String.valueOf(n2 + 1)) + "\n";
                    if (!this.checkId) {
                        this.vPsqlJoin.removeElementAt(n2);
                    }
                    psqlJoin.setNotResolved();
                } else {
                    psqlJoin.setTableFrom(psqlTable);
                    int n4 = n3;
                    n3 = psqlJoin.getIndexOfTableTo();
                    if (n3 >= n) {
                        this.errors = this.errors + JResource.getMessage("CAT_PSQL_12", (Object)String.valueOf(n2 + 1)) + "\n";
                        if (!this.checkId) {
                            this.vPsqlJoin.removeElementAt(n2);
                        }
                        psqlJoin.setNotResolved();
                    } else {
                        PsqlTable psqlTable2 = (PsqlTable)this.vTables.elementAt(n3);
                        if (psqlTable2 == null) {
                            this.errors = this.errors + JResource.getMessage("CAT_PSQL_13", (Object)String.valueOf(n2 + 1)) + "\n";
                            if (!this.checkId) {
                                this.vPsqlJoin.removeElementAt(n2);
                            }
                            psqlJoin.setNotResolved();
                        } else {
                            PsqlColumn psqlColumn;
                            psqlJoin.setTableTo(psqlTable2);
                            if (n3 != n4) {
                                // empty if block
                            }
                            if (psqlJoin.getColumnFrom() == null) {
                                psqlColumn = this.ver == 0 ? psqlTable.getColumnByName(psqlJoin.sColFrom) : psqlTable.getColumnByMappingName(psqlJoin.sColFrom);
                            } else {
                                PsqlColumn psqlColumn2 = psqlColumn = this.ver == 0 ? psqlTable.getColumnByName(psqlJoin.getColumnFrom().getName()) : psqlTable.getColumnByMappingName(psqlJoin.getColumnFrom().getMappingName());
                            }
                            if (psqlColumn == null) {
                                this.errors = this.errors + JResource.getMessage("CAT_PSQL_14", new Object[]{String.valueOf(n2 + 1), psqlJoin.sColFrom}) + "\n";
                                if (!this.checkId) {
                                    this.vPsqlJoin.removeElementAt(n2);
                                }
                                psqlJoin.setNotResolved();
                            } else {
                                PsqlColumn psqlColumn3;
                                psqlJoin.setColumnFrom(psqlColumn);
                                psqlJoin.idxColFrom = psqlTable.getColumns().indexOf(psqlColumn);
                                if (psqlJoin.getColumnTo() == null) {
                                    psqlColumn3 = this.ver == 0 ? psqlTable2.getColumnByName(psqlJoin.sColTo) : psqlTable2.getColumnByMappingName(psqlJoin.sColTo);
                                } else {
                                    PsqlColumn psqlColumn4 = psqlColumn3 = this.ver == 0 ? psqlTable2.getColumnByName(psqlJoin.getColumnTo().getName()) : psqlTable2.getColumnByMappingName(psqlJoin.getColumnTo().getMappingName());
                                }
                                if (psqlColumn3 == null) {
                                    this.errors = this.errors + JResource.getMessage("CAT_PSQL_15", new Object[]{String.valueOf(n2 + 1), psqlJoin.sColTo}) + "\n";
                                    if (!this.checkId) {
                                        this.vPsqlJoin.removeElementAt(n2);
                                    }
                                    psqlJoin.setNotResolved();
                                } else {
                                    if (this.ver != 0) {
                                        psqlJoin.sColFrom = psqlColumn.getName();
                                        psqlJoin.sColTo = psqlColumn3.getName();
                                    }
                                    psqlJoin.setColumnTo(psqlColumn3);
                                    psqlJoin.idxColTo = psqlTable2.getColumns().indexOf(psqlColumn3);
                                    if (psqlJoin.getJoinCondition() == null) {
                                        psqlJoin.setJoinCondition(PsqlJoin.createJoinCondition(psqlJoin));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            --n2;
        }
    }

    public Vector getPsqlTablesVector() {
        return this.vTables;
    }

    public Vector getSelColsVector() {
        return this.vSelCols;
    }

    public Vector getTablesForUnselectedCols() {
        PsqlTable psqlTable;
        Vector<PsqlTable> vector = new Vector<PsqlTable>();
        int n = this.vTables.size();
        int n2 = 0;
        while (n2 < n) {
            psqlTable = (PsqlTable)this.vTables.elementAt(n2);
            vector.addElement(psqlTable.getCopy());
            ++n2;
        }
        n = this.vSelCols.size();
        int n3 = 0;
        while (n3 < n) {
            PsqlColumn psqlColumn;
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)this.vSelCols.elementAt(n3);
            if (psqlSelColumn.table != null && (psqlTable = PsqlTable.getTableByName(vector, psqlSelColumn.table.getQualifier(), psqlSelColumn.table.getOwner(), psqlSelColumn.table.getName(), psqlSelColumn.table.getCorrelationName(), false)) != null && (psqlColumn = psqlTable.getColumnByName(psqlSelColumn.getName())) != null) {
                psqlTable.columns.removeElement(psqlColumn);
            }
            ++n3;
        }
        return vector;
    }

    public Vector getGroupbyColsVector() {
        return this.vGroupbySelCols;
    }

    public Vector getOrderbyColsVector() {
        return this.vOrderbySelCols;
    }

    public Vector getPsqlJoinsVector() {
        return this.vPsqlJoin;
    }

    public IExpression getSearchConditionGroups() {
        return this.searchConditionExpression;
    }

    public String getStringOfSearchConditionGroups() {
        return PsqlQuery.getStringOfWPGroups(this.searchConditionExpression, null, true);
    }

    public String getStringOfSearchConditionGroups(Vector vector) {
        return PsqlQuery.getStringOfWPGroups(this.searchConditionExpression, vector, true);
    }

    public static Vector convertExpression2Vector(IExpression iExpression) {
        if (iExpression != null) {
            String string = null;
            SimpleNode simpleNode = null;
            try {
                string = iExpression.getStringValue(true);
                simpleNode = QueryParser.parse("select * from t where " + string);
            }
            catch (ParseException parseException) {
            }
            catch (ConditionException conditionException) {
                // empty catch block
            }
            if (simpleNode != null) {
                int n = 0;
                while (n < simpleNode.jjtGetNumChildren()) {
                    Node node = simpleNode.jjtGetChild(n);
                    if (node instanceof ASTWhereClause) {
                        ASTWhereClause aSTWhereClause = (ASTWhereClause)node;
                        ASTSearchCondition aSTSearchCondition = (ASTSearchCondition)aSTWhereClause.jjtGetChild(0);
                        try {
                            return PsqlQuery.convertASTSearchCondition2Vector(aSTSearchCondition);
                        }
                        catch (ReloadQueryException reloadQueryException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            } else {
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                return vector;
            }
        }
        return new Vector();
    }

    private static Vector _getLogic(ASTSearchCondition aSTSearchCondition, ASTBooleanFactor aSTBooleanFactor, Vector vector) throws ReloadQueryException {
        int n = 0;
        int n2 = aSTSearchCondition.jjtGetNumChildren();
        while (n < n2) {
            ASTBooleanTerm aSTBooleanTerm = (ASTBooleanTerm)aSTSearchCondition.jjtGetChild(n);
            int n3 = 0;
            int n4 = aSTBooleanTerm.jjtGetNumChildren();
            while (n3 < n4) {
                Object object;
                ASTBooleanFactor aSTBooleanFactor2 = (ASTBooleanFactor)aSTBooleanTerm.jjtGetChild(n3);
                Node node = aSTBooleanFactor2.jjtGetChild(0);
                if (node instanceof ASTExplicitBoolean || node instanceof ASTPredicate || node instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() != null) {
                    object = new Vector<String[]>();
                    vector.add(object);
                    if (aSTBooleanFactor != null) {
                        ((Vector)object).add(PsqlQuery._makeAndLine(aSTBooleanFactor2, node, PsqlQuery._getLogic(aSTBooleanFactor2, 2)));
                    } else {
                        ((Vector)object).add(PsqlQuery._makeAndLine(aSTBooleanFactor2, node, PsqlQuery._getLogic(aSTBooleanFactor2, 1)));
                    }
                } else if (node instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() == null) {
                    object = (ASTSearchCondition)node;
                    Vector vector2 = new Vector();
                    vector.add(vector2);
                    PsqlQuery._getLogic((ASTSearchCondition)object, aSTBooleanFactor2, vector2);
                } else {
                    throw new ReloadQueryException("Unexpected node '" + node.getClass().getName() + "' in search condition!");
                }
                ++n3;
            }
            ++n;
        }
        return vector;
    }

    protected static final String[] _makeAndLine(ASTBooleanFactor aSTBooleanFactor, Node node, String string) throws ReloadQueryException {
        String[] stringArray = new String[]{"", "", "", ""};
        if (node instanceof ASTExplicitBoolean) {
            ASTExplicitBoolean aSTExplicitBoolean = (ASTExplicitBoolean)node;
            stringArray[0] = aSTBooleanFactor.getPrefix() != null ? aSTBooleanFactor.getPrefix() + " " + aSTExplicitBoolean.getValue() : aSTExplicitBoolean.getValue();
            if (aSTBooleanFactor.getPostfix() != null) {
                stringArray[0] = stringArray[0] + " " + aSTBooleanFactor.getPostfix();
            }
        } else if (node instanceof ASTPredicate) {
            ASTPredicate aSTPredicate = (ASTPredicate)node;
            stringArray[0] = aSTBooleanFactor.getPrefix() != null ? aSTBooleanFactor.getPrefix() + " " + (aSTPredicate.getLeftExpression() == null ? "" : aSTPredicate.getLeftExpression()) : (aSTPredicate.getLeftExpression() == null ? "" : aSTPredicate.getLeftExpression());
            String string2 = stringArray[1] = aSTPredicate.getOperator() == null ? "" : aSTPredicate.getOperator();
            stringArray[2] = aSTBooleanFactor.getPostfix() != null ? (aSTPredicate.getRightExpression() == null ? "" : aSTPredicate.getRightExpression()) + " " + aSTBooleanFactor.getPostfix() : (aSTPredicate.getRightExpression() == null ? "" : aSTPredicate.getRightExpression());
        } else if (node instanceof ASTSearchCondition) {
            ASTSearchCondition aSTSearchCondition = (ASTSearchCondition)node;
            if (aSTBooleanFactor.getPrefix() != null) {
                stringArray[0] = aSTBooleanFactor.getPrefix() + " " + (aSTSearchCondition.getExpression() == null ? "" : aSTSearchCondition.getExpression());
            } else {
                String string3 = stringArray[0] = aSTSearchCondition.getExpression() == null ? "" : aSTSearchCondition.getExpression();
            }
            if (aSTBooleanFactor.getPostfix() != null) {
                stringArray[0] = stringArray[0] + " " + aSTBooleanFactor.getPostfix();
            }
        } else {
            throw new ReloadQueryException("Unexpected node '" + node.getClass().getName() + "' in search condition!");
        }
        stringArray[3] = string;
        return stringArray;
    }

    protected static final String _getLogic(ASTBooleanFactor aSTBooleanFactor, int n) throws ReloadQueryException {
        Node node = aSTBooleanFactor;
        Node node2 = null;
        Node node3 = null;
        ASTBooleanFactor aSTBooleanFactor2 = null;
        int n2 = 0;
        while (!(node instanceof ASTWhereClause)) {
            node2 = node.jjtGetParent();
            n2 = node2.jjtIndexOf(node);
            if (n2 < node2.jjtGetNumChildren() - 1) {
                if (n == 1) {
                    if (node2 instanceof ASTSearchCondition) {
                        aSTBooleanFactor2 = (ASTBooleanFactor)node2.jjtGetChild(n2 + 1).jjtGetChild(0);
                        node3 = aSTBooleanFactor2.jjtGetChild(0);
                        if (node3 instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() == null) {
                            return LOGIC_OR + (aSTBooleanFactor2.getPrefix() == null ? "" : " NOT");
                        }
                        return LOGIC_OR;
                    }
                    if (node2 instanceof ASTBooleanTerm) {
                        aSTBooleanFactor2 = (ASTBooleanFactor)node2.jjtGetChild(n2 + 1);
                        node3 = aSTBooleanFactor2.jjtGetChild(0);
                        if (node3 instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() == null) {
                            return LOGIC_AND + (aSTBooleanFactor2.getPrefix() == null ? "" : " NOT");
                        }
                        return LOGIC_AND;
                    }
                    throw new ReloadQueryException("Brench in other node '" + node2.getClass().getName() + "'!");
                }
                if (n == 2) {
                    if (node2 instanceof ASTSearchCondition) {
                        return LOGIC_OR;
                    }
                    if (node2 instanceof ASTBooleanTerm) {
                        return LOGIC_AND;
                    }
                    throw new ReloadQueryException("Brench in other node '" + node2.getClass().getName() + "'!");
                }
            }
            if (!((node = node2) instanceof ASTSearchCondition)) continue;
            --n;
        }
        return LOGIC_AND;
    }

    public static Vector convertASTSearchCondition2Vector(ASTSearchCondition aSTSearchCondition) throws ReloadQueryException {
        Node node = aSTSearchCondition;
        while (node.jjtGetNumChildren() <= 1) {
            if (node.jjtGetNumChildren() == 0) {
                throw new ReloadQueryException("No child in search condition node!");
            }
            if ((node = node.jjtGetChild(0)).jjtGetNumChildren() > 1) break;
            if (node.jjtGetNumChildren() == 0) {
                throw new ReloadQueryException("No child in boolean term node!");
            }
            if (!((node = node.jjtGetChild(0).jjtGetChild(0)) instanceof ASTSearchCondition)) break;
            aSTSearchCondition = (ASTSearchCondition)node;
        }
        Vector vector = new Vector();
        PsqlQuery._getLogic(aSTSearchCondition, null, vector);
        PsqlQuery._makeAndLine(vector);
        return vector;
    }

    private static void _makeAndLine(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.get(n);
            if (e instanceof Vector) {
                Vector vector2 = (Vector)e;
                if (vector2.size() == 0) {
                    vector.remove(n);
                    --n;
                } else {
                    PsqlQuery._makeAndLine(vector2);
                }
            }
            ++n;
        }
    }

    public Vector getAndExpressionVector() {
        return this.vAndExpression;
    }

    public String getAndExpressionString() {
        return this.sAndExpression;
    }

    public Vector getHavingExpressionVector() {
        return this.vHavingExpression;
    }

    public String getHavingExpressionString() {
        return this.sHavingExpression;
    }

    public Vector getUnionVector() {
        return this.vUnion;
    }

    public boolean getStateOfUnqualifiedName() {
        return this.bStateOfUnqualifiedName;
    }

    public boolean getStateOfJoinOnForeignKeys() {
        return this.bStateOfJoinOnForeignKeys;
    }

    public boolean getStateOfJoinOnPrimaryKey() {
        return this.bStateOfJoinOnPrimaryKey;
    }

    public boolean getStateOfJoinOnLikeName() {
        return this.bStateOfJoinOnLikeName;
    }

    public boolean getStateOfShowTableNames() {
        return this.bStateOfShowTableNames;
    }

    public boolean getStateOfProhibitCartesianProducts() {
        return this.bStateOfProhibitCartesianProducts;
    }

    public boolean getStateOfAutoQuote() {
        return this.bAutoQuote;
    }

    public boolean isShowMappingName() {
        return this.bShowMappingName;
    }

    public void setShowMappingName(boolean bl) {
        this.bShowMappingName = bl;
    }

    public boolean hasCompCols() {
        return DbTools.hasCompCols(this.vSelCols);
    }

    public void setPsqlJoinsVector(Vector vector) {
        this.vPsqlJoin = vector;
    }

    public String getResolveErrors() {
        return this.errors.length() == 0 ? null : this.errors;
    }

    public void setCheckId(boolean bl) {
        this.checkId = bl;
    }

    public static String getStringOfWPGroups(Vector vector) {
        return PsqlQuery.getStringOfWPGroups(vector, null);
    }

    public static String getStringOfWPGroups(IExpression iExpression) {
        return PsqlQuery.getStringOfWPGroups(iExpression, null, true);
    }

    public static String getStringOfWPGroups(IExpression iExpression, Vector vector) {
        return PsqlQuery.getStringOfWPGroups(iExpression, vector, true);
    }

    public static String getStringOfWPGroups(IExpression iExpression, Vector vector, boolean bl) {
        if (iExpression == null) {
            return "";
        }
        if (vector == null || vector.size() == 0) {
            try {
                return iExpression.getStringValue(true);
            }
            catch (ConditionException conditionException) {
                return "";
            }
        }
        if (iExpression instanceof IUnCheckedExpression) {
            IUnCheckedExpression iUnCheckedExpression = (IUnCheckedExpression)iExpression;
            try {
                IUnCheckedExpression iUnCheckedExpression2 = PsqlQuery.removeExp4NullParameter(iUnCheckedExpression, vector);
                if (iUnCheckedExpression2 == null) {
                    return "";
                }
                return iUnCheckedExpression2.getStringValue(true);
            }
            catch (ConditionException conditionException) {
                return "";
            }
        }
        return "";
    }

    public static String getStringOfWPGroups(Vector vector, Vector vector2) {
        String string = null;
        if (vector != null) {
            Vector vector3 = null;
            String string2 = null;
            String[] stringArray = null;
            int n = vector.size();
            if (vector2 == null || vector2.size() == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < n) {
                    vector3 = (Vector)vector.elementAt(n2);
                    int n3 = vector3.size();
                    stringBuffer.append("(");
                    int n4 = 0;
                    while (n4 < n3) {
                        stringArray = (String[])vector3.elementAt(n4);
                        stringBuffer.append(stringArray[0]);
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[1]);
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[2]);
                        if (n4 == n3 - 1) {
                            string2 = stringArray[3];
                        } else {
                            stringBuffer.append(" ");
                            stringBuffer.append(stringArray[3]);
                            stringBuffer.append(" ");
                        }
                        ++n4;
                    }
                    stringBuffer.append(")");
                    if (n2 < n - 1) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string2);
                        stringBuffer.append(" ");
                    }
                    ++n2;
                }
                string = stringBuffer.toString();
            } else {
                Vector vector4 = new Vector(n);
                Vector<Vector> vector5 = new Vector<Vector>(n);
                Vector vector6 = null;
                Vector vector7 = null;
                int n5 = 0;
                while (n5 < n) {
                    vector3 = (Vector)vector.elementAt(n5);
                    int n6 = vector3.size();
                    vector6 = new Vector(n6);
                    vector7 = new Vector(n6);
                    int n7 = 0;
                    while (n7 < n6) {
                        stringArray = (String[])vector3.elementAt(n7);
                        vector7.addElement(stringArray);
                        if (n7 < n6 - 1) {
                            if (stringArray[3].equals(LOGIC_OR)) {
                                vector6.addElement(vector7);
                                vector7 = new Vector(n6 - n7);
                            }
                        } else {
                            string2 = stringArray[3];
                            vector6.addElement(vector7);
                        }
                        ++n7;
                    }
                    vector5.addElement(vector6);
                    if (n5 < n - 1) {
                        if (string2.startsWith(LOGIC_OR)) {
                            vector4.addElement(vector5);
                            vector5 = new Vector<Vector>(n - n5);
                        }
                    } else {
                        vector4.addElement(vector5);
                    }
                    ++n5;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n8 = vector4.size();
                int n9 = 0;
                while (n9 < n8) {
                    vector5 = (Vector<Vector>)vector4.elementAt(n9);
                    stringBuffer2.setLength(0);
                    boolean bl4 = false;
                    int n10 = vector5.size();
                    int n11 = 0;
                    while (n11 < n10) {
                        bl2 = bl;
                        vector6 = (Vector)vector5.elementAt(n11);
                        stringBuffer3.setLength(0);
                        stringBuffer3.append('(');
                        boolean bl5 = false;
                        int n12 = vector6.size();
                        int n13 = 0;
                        while (n13 < n12) {
                            vector7 = (Vector)vector6.elementAt(n13);
                            stringBuffer4.setLength(0);
                            boolean bl6 = false;
                            int n14 = vector7.size();
                            int n15 = 0;
                            while (n15 < n14) {
                                stringArray = (String[])vector7.elementAt(n15);
                                string2 = stringArray[3];
                                if (string2.endsWith(LOGIC_NOT)) {
                                    bl = true;
                                }
                                if (vector2 == null || !PsqlQuery.hasNullValueParamInThisPredicate(stringArray, vector2)) {
                                    if (bl6) {
                                        stringBuffer4.append(' ').append(LOGIC_AND).append(' ');
                                    }
                                    stringBuffer4.append(stringArray[0]).append(' ').append(stringArray[1]).append(' ').append(stringArray[2]);
                                    bl6 = true;
                                }
                                ++n15;
                            }
                            if (stringBuffer4.length() > 0) {
                                if (bl5) {
                                    stringBuffer3.append(' ').append(LOGIC_OR).append(' ');
                                }
                                stringBuffer3.append(stringBuffer4);
                                bl5 = true;
                            }
                            ++n13;
                        }
                        if (stringBuffer3.length() > 1) {
                            stringBuffer3.append(')');
                        } else {
                            stringBuffer3.setLength(0);
                        }
                        if (stringBuffer3.length() > 0) {
                            if (bl4) {
                                stringBuffer2.append(' ').append(LOGIC_AND).append(bl2 ? " NOT" : "").append(' ');
                            }
                            stringBuffer2.append(stringBuffer3);
                            bl4 = true;
                        }
                        ++n11;
                    }
                    if (stringBuffer2.length() > 0) {
                        if (bl3) {
                            stringBuffer.append(' ').append(LOGIC_OR).append(bl2 ? " NOT" : "").append(' ');
                        }
                        stringBuffer.append(stringBuffer2);
                        bl3 = true;
                    }
                    ++n9;
                }
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public String getUserDefinedQueryStmt() {
        return this.userDefinedQueryStmt;
    }

    public void setUserDefinedQueryStmt(String string) {
        this.userDefinedQueryStmt = string == null ? "" : string;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getShare() {
        return this.share;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean hasUnion() {
        return this.vUnion.size() != 0;
    }

    public void setSQLMapInfo(SQLMapInfo sQLMapInfo) {
        this.sqlMapInfo = sQLMapInfo;
    }

    public SQLMapInfo getSQLMapInfo() {
        return this.sqlMapInfo;
    }

    protected static boolean hasNullValueParamInThisPredicate(String[] stringArray, Vector vector) {
        int n = 0;
        while (n < stringArray.length) {
            Vector vector2 = SQLTraveler.find(stringArray[n]);
            if (vector2 != null && vector2.size() != 0) {
                int n2 = 0;
                while (n2 < vector2.size()) {
                    SQLTraveler.Position position = (SQLTraveler.Position)vector2.elementAt(n2);
                    if (vector.contains(stringArray[n].substring(position.start, position.end).toUpperCase())) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    public void setSearchConditionGroups(IExpression iExpression) {
        this.searchConditionExpression = iExpression;
    }

    public static IExpression scGroup2scExpression(Vector vector) {
        if (vector == null) {
            return null;
        }
        ExpWithLastOP expWithLastOP = PsqlQuery.add(vector);
        if (expWithLastOP == null) {
            return null;
        }
        return PsqlQuery.add(vector).getExp();
    }

    private static ExpWithLastOP add(Vector vector) {
        try {
            ArrayList<ExpWithLastOP> arrayList = new ArrayList<ExpWithLastOP>();
            ExpWithLastOP expWithLastOP = null;
            Vector<String[]> vector2 = new Vector<String[]>();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                block8: {
                    block5: {
                        block6: {
                            String[] stringArray;
                            block9: {
                                block7: {
                                    Object e;
                                    block4: {
                                        e = vector.elementAt(n);
                                        if (!(e instanceof Vector)) break block4;
                                        stringArray = (String[])e;
                                        expWithLastOP = PsqlQuery.add((Vector)stringArray);
                                        break block5;
                                    }
                                    if (!(e instanceof String[])) break block6;
                                    stringArray = (String[])e;
                                    if (vector2.size() == 0) break block7;
                                    vector2.add(stringArray);
                                    if (!PsqlQuery.bAutoQuote_Def(vector2)) break block8;
                                    Vector vector3 = PsqlQuery.append(vector2);
                                    expWithLastOP = PsqlQuery.add(vector3);
                                    vector2.clear();
                                    break block5;
                                }
                                if (PsqlQuery.bAutoQuote(stringArray) == 0) break block9;
                                vector2.add(stringArray);
                                break block8;
                            }
                            IUnCheckedExpression iUnCheckedExpression = PsqlQuery.bDistinct(stringArray);
                            String string = stringArray[3];
                            PsqlQuery psqlQuery = new PsqlQuery();
                            psqlQuery.getClass();
                            expWithLastOP = new ExpWithLastOP(psqlQuery, iUnCheckedExpression, string);
                            break block5;
                        }
                        throw new IllegalArgumentException("the Four element group is wrong");
                    }
                    if (expWithLastOP != null) {
                        arrayList.add(expWithLastOP);
                    }
                }
                ++n;
            }
            return PsqlQuery.addElement(arrayList);
        }
        catch (ConditionException conditionException) {
            return null;
        }
    }

    private static ExpWithLastOP addElement(List list) throws ConditionException {
        if (list.size() == 0) {
            return null;
        }
        ExpWithLastOP[] expWithLastOPArray = new ExpWithLastOP[list.size()];
        list.toArray(expWithLastOPArray);
        expWithLastOPArray = PsqlQuery.altWhereClause(expWithLastOPArray, "AND NOT");
        expWithLastOPArray = PsqlQuery.altWhereClause(expWithLastOPArray, LOGIC_AND);
        expWithLastOPArray = PsqlQuery.altWhereClause(expWithLastOPArray, "OR NOT");
        expWithLastOPArray = PsqlQuery.altWhereClause(expWithLastOPArray, LOGIC_OR);
        return expWithLastOPArray[0];
    }

    private static ExpWithLastOP[] altWhereClause(ExpWithLastOP[] expWithLastOPArray, String string) throws ConditionException {
        Object[] objectArray;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        ArrayList<IUnCheckedExpression> arrayList = new ArrayList<IUnCheckedExpression>();
        ArrayList<ExpWithLastOP> arrayList2 = new ArrayList<ExpWithLastOP>();
        int n = 0;
        while (n < expWithLastOPArray.length) {
            if (expWithLastOPArray[n].getLastLogicOperator().equalsIgnoreCase(string) && n != expWithLastOPArray.length - 1) {
                arrayList.add(expWithLastOPArray[n].getExp());
            } else if (arrayList.isEmpty()) {
                arrayList2.add(expWithLastOPArray[n]);
            } else {
                arrayList.add(expWithLastOPArray[n].getExp());
                objectArray = new IUnCheckedExpression[arrayList.size()];
                arrayList.toArray(objectArray);
                IUnCheckedMultiExpression iUnCheckedMultiExpression = iExpressionFactory.createUnCheckedMultiExpression(new UnCheckedOperatorImpl(string), (IUnCheckedExpression[])objectArray);
                arrayList.clear();
                PsqlQuery psqlQuery = new PsqlQuery();
                psqlQuery.getClass();
                arrayList2.add(new ExpWithLastOP(psqlQuery, iUnCheckedMultiExpression, expWithLastOPArray[n].getLastLogicOperator()));
            }
            ++n;
        }
        objectArray = new ExpWithLastOP[arrayList2.size()];
        arrayList2.toArray(objectArray);
        return objectArray;
    }

    private static Vector append(Vector vector) {
        Vector vector2 = new Vector();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            int n3;
            String string;
            String[] stringArray;
            Object e = vector.get(n);
            if (n == 0) {
                stringArray = (String[])e;
                string = stringArray[0];
                n3 = string.indexOf(40);
                stringArray[0] = string.substring(0, n3) + string.substring(n3 + 1);
            }
            if (n == n2 - 1) {
                stringArray = (String[])e;
                string = stringArray[2];
                n3 = string.lastIndexOf(41);
                stringArray[2] = string.substring(0, n3) + string.substring(n3 + 1);
            }
            vector2.add(e);
            ++n;
        }
        return vector2;
    }

    private static int bAutoQuote(String[] stringArray) {
        int n = 0;
        char[] cArray = (stringArray[0] + stringArray[2]).toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '(') {
                ++n;
            } else if (cArray[n2] == ')') {
                --n;
            }
            ++n2;
        }
        return n;
    }

    private static boolean bAutoQuote_Def(Vector vector) {
        int n = 0;
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            String[] stringArray = (String[])vector.get(n2);
            n += PsqlQuery.bAutoQuote(stringArray);
            ++n2;
        }
        return n == 0;
    }

    private static IUnCheckedExpression bDistinct(String[] stringArray) throws ConditionException {
        IUnCheckedExpression iUnCheckedExpression = null;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        if (stringArray[1].equalsIgnoreCase("is null") || stringArray[1].equalsIgnoreCase("is not null")) {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(stringArray[0]);
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(stringArray[1]);
            iUnCheckedExpression = iExpressionFactory.createUnCheckedSingleExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression);
        } else if (stringArray[1].equalsIgnoreCase("between") || stringArray[1].equalsIgnoreCase("not between")) {
            String[] stringArray2 = stringArray[2].split("and");
            if (stringArray2[0].equals(stringArray[2]) && (stringArray2 = stringArray[2].split(LOGIC_AND))[0].equals(stringArray[2])) {
                stringArray2 = stringArray[2].split("And");
            }
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(stringArray[0]);
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(stringArray[1]);
            IUnCheckedVariableExpression iUnCheckedVariableExpression2 = iExpressionFactory.createUnCheckedVariableExpression(stringArray2[0]);
            IUnCheckedVariableExpression iUnCheckedVariableExpression3 = null;
            iUnCheckedVariableExpression3 = stringArray2.length == 1 ? iExpressionFactory.createUnCheckedVariableExpression("") : iExpressionFactory.createUnCheckedVariableExpression(stringArray2[1]);
            iUnCheckedExpression = iExpressionFactory.createUnCheckedTripleExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression2, iUnCheckedVariableExpression3);
        } else {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(stringArray[0]);
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(stringArray[1]);
            IUnCheckedVariableExpression iUnCheckedVariableExpression4 = iExpressionFactory.createUnCheckedVariableExpression(stringArray[2]);
            iUnCheckedExpression = iExpressionFactory.createUnCheckedBinaryExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression4);
        }
        return iUnCheckedExpression;
    }

    public static IUnCheckedExpression removeExp4NullParameter(IUnCheckedExpression iUnCheckedExpression, Vector vector) throws ConditionException {
        if (iUnCheckedExpression == null) {
            return iUnCheckedExpression;
        }
        if (vector == null || vector.size() == 0) {
            return iUnCheckedExpression;
        }
        IUnCheckedExpression iUnCheckedExpression2 = (IUnCheckedExpression)ExpressionToolKit.cloneExpression(iUnCheckedExpression);
        if (ExpressionToolKit.isMultiExp((iUnCheckedExpression2 = (IUnCheckedExpression)ExpressionToolKit.compressExpression(iUnCheckedExpression2)).expressionType())) {
            IUnCheckedExpression[] iUnCheckedExpressionArray = ((IUnCheckedMultiExpression)iUnCheckedExpression2).getExpressions();
            int n = 0;
            while (n < iUnCheckedExpressionArray.length) {
                PsqlQuery.bShowMappingName(n, iUnCheckedExpressionArray[n], iUnCheckedExpression2, vector);
                ++n;
            }
            PsqlQuery.bIgnorePredicateIfParamIsNull(iUnCheckedExpression2);
            return iUnCheckedExpression2;
        }
        String string = iUnCheckedExpression2.getStringValue(true);
        String[] stringArray = new String[]{string};
        if (PsqlQuery.hasNullValueParamInThisPredicate(stringArray, vector)) {
            return null;
        }
        return iUnCheckedExpression2;
    }

    private static void bIgnorePredicateIfParamIsNull(IUnCheckedExpression iUnCheckedExpression) {
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            ArrayList<IUnCheckedExpression> arrayList = new ArrayList<IUnCheckedExpression>();
            int n = 0;
            while (n < iUnCheckedExpressionArray.length) {
                if (iUnCheckedExpressionArray[n] != null) {
                    if (ExpressionToolKit.isMultiExp(iUnCheckedExpressionArray[n].expressionType())) {
                        PsqlQuery.bIgnorePredicateIfParamIsNull(iUnCheckedExpressionArray[n]);
                    } else {
                        arrayList.add(iUnCheckedExpressionArray[n]);
                    }
                }
                ++n;
            }
            if (arrayList.size() >= 2) {
                iUnCheckedMultiExpression.setExpressions(arrayList.toArray(new IUnCheckedExpression[0]));
            } else {
                iUnCheckedExpression = arrayList.size() == 1 ? (IUnCheckedExpression)arrayList.get(0) : null;
            }
        }
    }

    private static void bShowMappingName(int n, IUnCheckedExpression iUnCheckedExpression, IUnCheckedExpression iUnCheckedExpression2, Vector vector) throws ConditionException {
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedExpression[] iUnCheckedExpressionArray = ((IUnCheckedMultiExpression)iUnCheckedExpression).getExpressions();
            int n2 = 0;
            while (n2 < iUnCheckedExpressionArray.length) {
                PsqlQuery.bShowMappingName(n2, iUnCheckedExpressionArray[n2], iUnCheckedExpression, vector);
                ++n2;
            }
        } else {
            String string = iUnCheckedExpression.getStringValue(true);
            String[] stringArray = new String[]{string};
            if (PsqlQuery.hasNullValueParamInThisPredicate(stringArray, vector)) {
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression2;
                IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
                iUnCheckedExpressionArray[n] = null;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ExpWithLastOP {
        private final IUnCheckedExpression QOIV;
        private final String I;
        private final PsqlQuery this$0;

        public ExpWithLastOP(PsqlQuery psqlQuery, IUnCheckedExpression iUnCheckedExpression, String string) {
            this.this$0 = psqlQuery;
            this.QOIV = iUnCheckedExpression;
            this.I = string;
        }

        public IUnCheckedExpression getExp() {
            return this.QOIV;
        }

        public String getLastLogicOperator() {
            return this.I;
        }
    }
}

