/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.gui;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jet.ReportEnv;
import jet.log.JRLogger;
import toolkit.db.version2.PoolService;

public class ConnectionsBroker {
    static PoolService QOIV;
    private static JRLogger append;
    static Class class$toolkit$db$gui$ConnectionsBroker;

    public static Connection getConnection(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        return ConnectionsBroker.getConnection(string, string2, string3, string4, 0, 1);
    }

    public static Connection getConnection(String string, String string2, String string3, String string4, int n, int n2) throws SQLException, ClassNotFoundException {
        return ConnectionsBroker.getConnection(string, string2, string3, string4, n, n2, null);
    }

    public static Connection getConnection(String string, String string2, String string3, String string4, int n, int n2, String string5) throws SQLException, ClassNotFoundException {
        Object object;
        block18: {
            block17: {
                if (append.isDebugEnabled()) {
                    object = "default";
                    if (n2 != 1) {
                        object = n2 > 1 ? "true" : "false";
                    }
                    String string6 = "unknown level - " + n;
                    switch (n) {
                        case 0: {
                            string6 = "default";
                            break;
                        }
                        case 1: {
                            string6 = "Transaction None";
                            break;
                        }
                        case 2: {
                            string6 = "Transaction Read Uncommitted";
                            break;
                        }
                        case 3: {
                            string6 = "Transaction Read Committed";
                            break;
                        }
                        case 4: {
                            string6 = "Transaction Repeatable Read";
                            break;
                        }
                        case 5: {
                            string6 = "Transaction Serializable";
                        }
                    }
                    append.debug("ConnectionsBroker.getConnection()\nurl=" + string + "\r\nuid=" + string2 + "\r\njdbcDriver=" + string4 + "\r\nTransactionIsolationLevel=" + string6 + "\r\nReadOnly=" + (String)object);
                }
                object = QOIV.getConnection(string4, string, string2, string3, string5);
                try {
                    if (object != null && n2 != 1) {
                        object.setReadOnly(n2 > 1);
                    }
                }
                catch (Throwable throwable) {
                    if (!append.isErrorEnabled()) break block17;
                    append.error("", throwable);
                }
            }
            try {
                if (object != null && n != 0 && n != object.getTransactionIsolation()) {
                    object.setTransactionIsolation(n);
                }
            }
            catch (Throwable throwable) {
                if (!append.isErrorEnabled()) break block18;
                append.error("", throwable);
            }
        }
        if (append.isDebugEnabled()) {
            append.debug("ConnectionsBroker.getConnection()\n" + object.toString());
        }
        return object;
    }

    public static PoolService getPoolService() {
        return QOIV;
    }

    public static boolean closeCachedConnection(Connection connection) throws SQLException {
        if (append.isDebugEnabled()) {
            append.debug("ConnectionsBroker.closeCachedConnection())\n" + connection.toString());
        }
        connection.close();
        return true;
    }

    public static void freeConnection(Connection connection) throws SQLException {
        if (append.isDebugEnabled()) {
            append.debug("ConnectionsBroker.freeConnection()\n" + connection.toString());
        }
        connection.close();
    }

    public static void closeAllCachedConnections() {
        QOIV.destroy();
    }

    public static void releaseAllExpiredConnections() {
        QOIV.release();
    }

    public static void destroy() {
        QOIV.destroy();
        QOIV = null;
    }

    public static boolean loadJdbcDrivers() {
        boolean bl;
        block12: {
            block11: {
                bl = true;
                String string = ReportEnv.binPath + "jdbcdrivers.properties";
                FileInputStream fileInputStream = null;
                try {
                    if (string != null) {
                        fileInputStream = new FileInputStream(string);
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        fileInputStream.close();
                        String string2 = (String)properties.get("jdbc.drivers");
                        if (string2 != null && (string2 = string2.trim()).length() > 0) {
                            String string3;
                            if (string2.startsWith(":")) {
                                string2 = string2.substring(1).trim();
                            }
                            if ((string3 = System.getProperty("jdbc.drivers")) != null && string3.trim().length() > 0) {
                                string2 = (string3 = string3.trim()).endsWith(":") ? string3 + string2 : string3 + ":" + string2;
                            }
                            Properties properties2 = System.getProperties();
                            properties2.put("jdbc.drivers", string2);
                            System.setProperties(properties2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    bl = false;
                    if (!append.isErrorEnabled()) break block11;
                    append.error("", throwable);
                }
            }
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            catch (Throwable throwable) {
                bl = false;
            }
            try {
                if (!bl) {
                    Class.forName("com.ms.jdbc.odbc.JdbcOdbcDriver");
                }
            }
            catch (Throwable throwable) {
                bl = false;
                if (!append.isErrorEnabled()) break block12;
                append.error("", throwable);
            }
        }
        return bl;
    }

    public static void getPoolDump(Writer writer) throws IOException {
        QOIV.dump(writer);
    }

    public static Connection getJNDIConnection(String string, String string2, String string3) throws NamingException, SQLException {
        DataSource dataSource;
        Connection connection = null;
        append.debug("begin to create connection from datasoure.xml\n\r\nuid=" + string2 + "\r\nJNDI_NAME=" + string);
        InitialContext initialContext = new InitialContext();
        if (initialContext != null && (dataSource = (DataSource)initialContext.lookup(string)) != null) {
            connection = string2 != null && string2.length() > 0 ? dataSource.getConnection(string2, string3) : dataSource.getConnection();
        }
        return connection;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        append = JRLogger.getLogger((class$toolkit$db$gui$ConnectionsBroker == null ? (class$toolkit$db$gui$ConnectionsBroker = ConnectionsBroker.class$("toolkit.db.gui.ConnectionsBroker")) : class$toolkit$db$gui$ConnectionsBroker).getName());
        ConnectionsBroker.loadJdbcDrivers();
        QOIV = new PoolService();
    }
}

