/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Dimension;

public class Unit {
    public static final int DPI = 5760;
    public static final float RATE = 25.4f;
    public static final int INCH = 0;
    public static final int MM = 1;
    public static final int TRANSPARENT = -16777216;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int CENTER = 0;
    public static final int TILE = 1;
    public static final int STRETCH = 2;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final String NULL = "NULL";
    public static final int GT = 0;
    public static final int GE = 1;
    public static final int LT = 2;
    public static final int LE = 3;
    public static final int EQ = 4;
    public static final int NE = 5;
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NON = 2;
    static final String[] QOIV = new String[]{">", ">=", "<", "<=", "==", "!="};
    static final String[] equals = new String[]{"and", "or", "non"};
    static final String[] mmToPixel = new String[]{"Center", "Tile", "Stretch"};
    static final String[] pixelToMM = new String[]{"Center", "Top", "Right"};
    static final String[] I = new String[]{"Cenger", "Left", "Right"};
    static final String[] Z = new String[]{"Portrait", "Landscape"};
    static final String[] C = new String[]{"Letter", "Legal", "Executive", "4A0", "2A0", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "RA0", "RA1", "RA2", "SRA0", "SRA1", "RSA2", "Envelope C3", "Envelope B4", "Envelope C4", "Envelope B5", "Envelope C5", "Envelope B6/C4", "Envelope B6", "Envelope C6", "Envelope DL", "Envelope C7/6", "Envelope C7", "Custom size"};
    static final int[][] B = new int[][]{{216000, 279400}, {216000, 355600}, {184150, 266700}, {1682000, 2378000}, {1189000, 1682000}, {841000, 1189000}, {594000, 841000}, {420000, 594000}, {297000, 420000}, {210000, 297000}, {148000, 210000}, {105000, 148000}, {74000, 105000}, {52000, 74000}, {37000, 52000}, {26000, 37000}, {1000000, 1414000}, {707000, 1000000}, {500000, 707000}, {353000, 500000}, {250000, 353000}, {176000, 250000}, {125000, 176000}, {88000, 125000}, {62000, 88000}, {44000, 62000}, {31000, 44000}, {917000, 1297000}, {648000, 917000}, {458000, 648000}, {324000, 458000}, {229000, 324000}, {162000, 229000}, {114000, 162000}, {81000, 114000}, {57000, 81000}, {860000, 1220000}, {610000, 860000}, {430000, 610000}, {900000, 1280000}, {640000, 900000}, {450000, 640000}, {324000, 458000}, {250000, 353000}, {229000, 324000}, {176000, 250000}, {162000, 229000}, {125000, 324000}, {125000, 176000}, {114000, 162000}, {110000, 220000}, {81000, 162000}, {81000, 114000}};
    static final String[] D = new String[]{"Inch", "mm"};
    static int F = 2;
    static float J = 1.0f;

    public static float inchToMM(float f) {
        return f * 25.4f;
    }

    public static int inchToPixel(float f) {
        return (int)(f * 5760.0f);
    }

    public static int inchToPixel(float f, int n) {
        return (int)(f * (float)n * J);
    }

    public static float mmToInch(float f) {
        return f / 25.4f;
    }

    public static int mmToPixel(float f) {
        return (int)(f / 25.4f * 5760.0f);
    }

    public static int mmToPixel(float f, int n) {
        return (int)(f / 25.4f * (float)n * J);
    }

    public static float pixelToInch(int n) {
        return (float)n / 5760.0f;
    }

    public static float pixelToInch(int n, int n2) {
        return (float)n / (float)n2 / J;
    }

    public static float pixelToMM(int n) {
        return (float)n / 25.4f / 5760.0f;
    }

    public static float pixelToMM(int n, int n2) {
        return (float)n / 25.4f / (float)n2 / J;
    }

    public static int internalToExternal(int n, int n2) {
        return (int)((float)n / 5760.0f * (float)n2 * J);
    }

    public static int externalToInternal(int n, int n2) {
        return (int)((float)n / (float)n2 / J * 5760.0f);
    }

    public static String getUnitName(int n) {
        if (n < 0 || n > 1) {
            n = 0;
        }
        return D[n];
    }

    public static int getUnitType(String string) {
        int n = D.length;
        while (--n >= 0) {
            if (!string.equals(D[n])) continue;
            return n;
        }
        return -1;
    }

    public static void setPrecision(int n) {
        if (n >= 0) {
            F = n;
        }
    }

    public static int getPrecision() {
        return F;
    }

    public static void setZoomFactor(float f) {
        if (f > 0.0f) {
            J = f;
        }
    }

    public static float getZoomFactor() {
        return J;
    }

    public static String getOrientation(int n) {
        return Z[n];
    }

    public static String getPaper(int n, int n2, int n3) {
        n = (int)(Unit.pixelToMM(n) * 1000.0f);
        n2 = (int)(Unit.pixelToMM(n2) * 1000.0f);
        int n4 = C.length - 1;
        block4: while (--n4 >= 0) {
            switch (n3) {
                case 0: {
                    if (n != B[n4][0] || n2 != B[n4][1]) continue block4;
                    return C[n4];
                }
                case 1: {
                    if (n2 != B[n4][0] || n != B[n4][1]) continue block4;
                    return C[n4];
                }
            }
        }
        return C[C.length - 1];
    }

    public static Dimension getPaperSize(String string, int n) {
        int n2 = C.length - 1;
        while (--n2 >= 0) {
            if (!C[n2].equals(string)) continue;
            int n3 = Unit.mmToPixel((float)B[n2][0] / 1000.0f);
            int n4 = Unit.mmToPixel((float)B[n2][1] / 1000.0f);
            switch (n) {
                case 0: {
                    return new Dimension(n3, n4);
                }
                case 1: {
                    return new Dimension(n4, n3);
                }
            }
        }
        return null;
    }

    public static String getMode(int n) {
        return mmToPixel[n];
    }

    public static String getHAlignment(int n) {
        return pixelToMM[n];
    }

    public static String getVAlignment(int n) {
        return I[n];
    }

    public static String getCondition(int n) {
        return QOIV[n];
    }

    public static String getRelative(int n) {
        return equals[n];
    }
}

