/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.DataSchemaObjectType;
import com.jinfonet.dataservice.api.schema.relational.JDataField;
import com.jinfonet.dataservice.relational.datasource.AFunction;
import com.jinfonet.dataservice.relational.datasource.JFormula;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.formula.JetRptFormula;
import jet.universe.JetUFormula;

public class Formula
extends AFunction
implements JFormula {
    private JetRptFormula FORMULAMAPPING = null;
    private String I = null;

    public String getExpressionString() {
        return this.I;
    }

    private Formula(String string) throws DSException {
        super(string, DataSchemaObjectType.FORMULAMAPPING);
    }

    public Formula(String string, JetRptFormula jetRptFormula) throws DSException {
        this(string);
        this.FORMULAMAPPING = jetRptFormula;
        DbColDesc dbColDesc = jetRptFormula.getColDesc();
        this.dataType = Types.sqlTypeToType(dbColDesc.getSqlType());
        this.I = jetRptFormula.getExpression();
        this.length = dbColDesc.getPrecision();
        this.scale = dbColDesc.getScale();
        this.precision = dbColDesc.getPrecision();
        this.nullable = dbColDesc.nullable;
    }

    public Formula(String string, JetUFormula jetUFormula) throws DSException {
        this(string);
        this.FORMULAMAPPING = jetUFormula.getRptFormula();
        this.dataType = Types.sqlTypeToType(jetUFormula.getSqlType());
        this.I = jetUFormula.getExpression();
        this.length = jetUFormula.getLength();
        this.scale = jetUFormula.getScale();
        this.precision = jetUFormula.getPrecision();
        this.nullable = jetUFormula.getColDesc().nullable;
    }

    public int getReturnDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public JetRptFormula getFormula() {
        return this.FORMULAMAPPING;
    }

    public void setFormula(JetRptFormula jetRptFormula) {
        this.FORMULAMAPPING = jetRptFormula;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getFunctionSyntaxType() {
        return 5;
    }

    public void dump() {
        super.dump();
        this.log.debug("FieldMappingType: " + this.getFieldMappingType());
        this.log.debug("FunctionSyntaxType: " + this.getFunctionSyntaxType());
        this.log.debug("ExtendFunctionName: " + this.getExtendFunctionName());
        this.log.debug("ExtendFunction: " + this.getExtendFunction());
        this.log.debug("DataType: " + Types.getDataTypeName(this.getDataType()));
        this.log.debug("Precision: " + this.getPrecision());
        this.log.debug("Scale: " + this.getScale());
        this.log.debug("Length: " + this.getLength());
        JDataField[] jDataFieldArray = this.getDependentDataFields();
        if (jDataFieldArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < jDataFieldArray.length) {
                String string = jDataFieldArray[n].getName();
                stringBuffer.append("[");
                stringBuffer.append(string);
                stringBuffer.append("],");
                ++n;
            }
            this.log.debug("DependentDataFields: " + stringBuffer);
        }
    }
}

