/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource.xml;

import com.jinfonet.dataservice.relational.datasource.xml.MutipleContentHandler;
import com.jinfonet.dataservice.relational.datasource.xml.XMLDataFetchHandler;
import com.jinfonet.dataservice.relational.datasource.xml.XPathContentHandler;
import com.jinfonet.dataservice.relational.datasource.xml.XPathErrorHandler;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jet.dataengine.api.DSException;
import jet.datasource.InputStreamFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxParseProcess {
    private XMLDataFetchHandler QOIV = null;

    public SaxParseProcess(TransformRelationModel[] transformRelationModelArray, TimeZone timeZone, Locale locale) throws DSException {
        this.QOIV = new XMLDataFetchHandler(transformRelationModelArray, timeZone, locale);
    }

    public static RelationPool[] getAllResult(String string, Vector vector) {
        XPathContentHandler xPathContentHandler = null;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setErrorHandler(new XPathErrorHandler());
            xPathContentHandler = new XPathContentHandler(vector);
            xMLReader.setContentHandler(xPathContentHandler);
            xMLReader.parse(string);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (DSException dSException) {
            dSException.printStackTrace();
        }
        return xPathContentHandler.getAllResults();
    }

    public static RelationPool[] getResults(String string, Vector vector) {
        MutipleContentHandler mutipleContentHandler = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            mutipleContentHandler = new MutipleContentHandler(vector);
            sAXParser.parse(string, (DefaultHandler)mutipleContentHandler);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (DSException dSException) {
            dSException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return mutipleContentHandler.getAllResults();
    }

    public Map getAllRelationData(String string) throws DSException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (string.startsWith("file:") || string.startsWith("ftp:") || string.startsWith("http:")) {
                sAXParser.parse(string, (DefaultHandler)this.QOIV);
            } else {
                sAXParser.parse(new File(string), (DefaultHandler)this.QOIV);
            }
        }
        catch (SAXException sAXException) {
            throw new DSException(11602, new String[]{sAXException.getMessage()}, sAXException);
        }
        catch (IOException iOException) {
            throw new DSException(11603, new String[]{iOException.getMessage()}, iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(11604, new String[]{parserConfigurationException.getMessage()}, parserConfigurationException);
        }
        return this.QOIV.getRelationDataSet();
    }

    public Map getAllRelationData(InputStreamFactory inputStreamFactory) throws DSException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputStream inputStream = inputStreamFactory.createInputStream();
            InputSource inputSource = new InputSource(inputStream);
            sAXParser.parse(inputSource, (DefaultHandler)this.QOIV);
            inputStream.close();
            inputStream = null;
            inputSource = null;
        }
        catch (SAXException sAXException) {
            throw new DSException(2147, new String[]{sAXException.getMessage()}, sAXException);
        }
        catch (IOException iOException) {
            throw new DSException(2148, new String[]{iOException.getMessage()}, iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(2149, new String[]{parserConfigurationException.getMessage()}, parserConfigurationException);
        }
        return this.QOIV.getRelationDataSet();
    }

    public void setCancel(boolean bl) {
        this.QOIV.setCancel(bl);
    }
}

