/*
 * Decompiled with CFR 0.152.
 */
package guitools.tree;

import guitools.tree.TreeNode;
import guitools.tree.TreeNodeManager;
import java.awt.Color;
import java.awt.Image;
import java.awt.SystemColor;
import java.util.Vector;

public class SimpleTreeNode
implements TreeNode {
    private Image QOIV = null;
    private String addElement = null;
    private Object append = null;
    private Vector clone = new Vector();
    private TreeNode compareTo = null;
    private boolean contains = true;
    private boolean delete = true;
    private boolean elementAt = false;
    private int equals = 0;
    private Color equalsIgnoreCase = SystemColor.windowText;
    private TreeNodeManager getData = null;
    public static final int NOSORT = 0;
    public static final int ASCSORT = 1;
    public static final int DESCSORT = 2;

    public SimpleTreeNode(Image image, String string, Object object) {
        this(image, string);
        this.append = object;
    }

    public SimpleTreeNode(Image image, String string) {
        this.QOIV = image;
        this.addElement = string;
    }

    public void insert(TreeNode treeNode, int n) {
        if (this.clone == null) {
            this.clone = new Vector(1);
        }
        if (n < 0) {
            this.clone.addElement(treeNode);
        } else {
            this.clone.insertElementAt(treeNode, n);
        }
    }

    public void insert(SimpleTreeNode simpleTreeNode, int n) {
        this.insert((TreeNode)simpleTreeNode, n);
        simpleTreeNode.setParent(this);
        if (this.getData != null) {
            this.getData.itemInserted(this, simpleTreeNode, n);
        }
    }

    public Object clone() {
        SimpleTreeNode simpleTreeNode = new SimpleTreeNode(this.getImage(), this.getText(), this.getData());
        Vector vector = this.getSubNodes();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SimpleTreeNode simpleTreeNode2 = (SimpleTreeNode)vector.elementAt(n2);
            simpleTreeNode.insert((SimpleTreeNode)simpleTreeNode2.clone(), -1);
            ++n2;
        }
        return simpleTreeNode;
    }

    public boolean delete(TreeNode treeNode) {
        if (this.clone != null && this.clone.contains(treeNode)) {
            this.clone.removeElement(treeNode);
            return true;
        }
        return false;
    }

    public void delete(SimpleTreeNode simpleTreeNode) {
        if (this.delete((TreeNode)simpleTreeNode)) {
            simpleTreeNode.setParent(null);
        }
    }

    public void setParent(TreeNode treeNode) {
        this.compareTo = treeNode;
    }

    public void setSelectable(boolean bl) {
        this.contains = bl;
    }

    public void setEditable(boolean bl) {
        this.elementAt = bl;
    }

    public void setVisible(boolean bl) {
        this.delete = bl;
    }

    public void refreshSubNodes() {
    }

    public void AddSubNodes(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.insert((SimpleTreeNode)vector.elementAt(n2), -1);
            ++n2;
        }
    }

    public Vector getSubNodes() {
        return this.clone;
    }

    public Vector getVisibleNodes() {
        int n = 0;
        if (this.clone != null) {
            n = this.clone.size();
        }
        Vector<TreeNode> vector = new Vector<TreeNode>(n);
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode = (TreeNode)this.clone.elementAt(n2);
            if (treeNode.isVisible()) {
                vector.addElement(treeNode);
            }
            ++n2;
        }
        return vector;
    }

    public int numberOfSubNodes() {
        if (this.clone != null) {
            return this.clone.size();
        }
        return 0;
    }

    public int indexOfSubNode(TreeNode treeNode) {
        return this.clone.indexOf(treeNode);
    }

    public TreeNode getSubNode(int n) {
        if (this.clone != null) {
            return (TreeNode)this.clone.elementAt(n);
        }
        return null;
    }

    public TreeNode getNodeByName(String string, boolean bl) {
        SimpleTreeNode simpleTreeNode = null;
        Vector vector = this.getSubNodes();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            simpleTreeNode = (SimpleTreeNode)vector.elementAt(n2);
            if (bl ? string.equalsIgnoreCase(simpleTreeNode.getText()) : string.equals(simpleTreeNode.getText())) {
                return simpleTreeNode;
            }
            ++n2;
        }
        return simpleTreeNode;
    }

    public Object getData() {
        return this.append;
    }

    public void setData(Object object) {
        this.append = object;
    }

    public String getText() {
        return this.addElement;
    }

    public Color getFontColor() {
        return this.equalsIgnoreCase;
    }

    public void setFontColor(Color color) {
        this.equalsIgnoreCase = color;
    }

    public Image getImage() {
        return this.QOIV;
    }

    public void setImage(Image image) {
        this.QOIV = image;
    }

    public TreeNode getParent() {
        return this.compareTo;
    }

    public boolean isSelectable() {
        return this.contains;
    }

    public boolean isVisible() {
        return this.delete;
    }

    public boolean isEditable() {
        return this.elementAt;
    }

    public boolean needSort() {
        return this.equals != 0;
    }

    public void setSort(int n) {
        this.equals = n;
        Vector vector = this.getSubNodes();
        if (vector != null) {
            SimpleTreeNode.setSort(vector, n);
        }
    }

    public static void setSort(Vector vector, int n) {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            ((SimpleTreeNode)vector.elementAt(n3)).setSort(n);
            ++n3;
        }
    }

    public int compare(TreeNode treeNode, TreeNode treeNode2) {
        if (this.equals == 0) {
            return this.indexOfSubNode(treeNode) - this.indexOfSubNode(treeNode2);
        }
        String string = treeNode.getText().toUpperCase();
        String string2 = treeNode2.getText().toUpperCase();
        int n = string.compareTo(string2);
        if (this.equals == 1) {
            return n;
        }
        return -n;
    }

    public boolean isTextValid(String string) {
        if (this.getData == null) {
            char[] cArray = string.toCharArray();
            return cArray[0] < '0' || cArray[0] > '9';
        }
        return this.getData.isTextValid(this, string);
    }

    public void setText(String string) {
        this.addElement = string;
        if (this.getData != null) {
            this.getData.textChanged(this, string);
        }
    }

    public void deleted() {
        if (this.compareTo != null && this.compareTo instanceof SimpleTreeNode) {
            ((SimpleTreeNode)this.compareTo).delete(this);
        }
        if (this.getData != null) {
            this.getData.itemDeleted(this);
        }
    }

    public void insertNodes(Vector vector, int n) {
        if (this.clone == null) {
            this.clone = new Vector(1);
        }
        int n2 = n < 0 ? this.clone.size() : n;
        int n3 = 0;
        while (n3 < vector.size()) {
            SimpleTreeNode simpleTreeNode = (SimpleTreeNode)vector.elementAt(n3);
            this.clone.insertElementAt(simpleTreeNode, n2 + n3);
            simpleTreeNode.setParent(this);
            ++n3;
        }
    }

    public boolean isTextEqual(String string, boolean bl) {
        if (bl) {
            return string.equalsIgnoreCase(this.getText());
        }
        return string.equals(this.getText());
    }

    public TreeNode getFirstNode(String string, boolean bl) {
        TreeNode treeNode = null;
        Vector vector = this.getSubNodes();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SimpleTreeNode simpleTreeNode = (SimpleTreeNode)vector.elementAt(n2);
            Vector vector2 = simpleTreeNode.getSubNodes();
            if (simpleTreeNode.isTextEqual(string, bl)) {
                treeNode = simpleTreeNode;
            }
            if (treeNode == null && vector2 != null & vector2.size() > 0) {
                treeNode = simpleTreeNode.getFirstNode(string, bl);
            }
            if (treeNode != null) break;
            ++n2;
        }
        return treeNode;
    }

    public TreeNode getFirstLeafNode(String string, boolean bl) {
        TreeNode treeNode = null;
        Vector vector = this.getSubNodes();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SimpleTreeNode simpleTreeNode = (SimpleTreeNode)vector.elementAt(n2);
            Vector vector2 = simpleTreeNode.getSubNodes();
            if (vector2 == null || vector2.size() == 0) {
                if (bl) {
                    if (string.equalsIgnoreCase(simpleTreeNode.getText())) {
                        treeNode = simpleTreeNode;
                    }
                } else if (string.equals(simpleTreeNode.getText())) {
                    treeNode = simpleTreeNode;
                }
            } else {
                treeNode = simpleTreeNode.getFirstLeafNode(string, bl);
            }
            if (treeNode != null) break;
            ++n2;
        }
        return treeNode;
    }

    public void deleteAllNodes() {
        if (this.clone != null) {
            this.clone.removeAllElements();
        }
    }

    public void setManager(TreeNodeManager treeNodeManager) {
        this.getData = treeNodeManager;
    }

    public TreeNodeManager getManager() {
        return this.getData;
    }

    public String toString() {
        if (this.getData() != null) {
            return this.getText() + "=>" + this.getData();
        }
        return this.getText();
    }
}

