/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Hashtable;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbPage;
import jet.connect.DbRecordModel;
import jet.dataengine.util.DSLog;
import jet.util.RAFile;

public class NDbBuffer
extends DbBuffer {
    private final DSLog QOIV = DSLog.getDSLog(this.getClass().getName());
    private DbBuffer append;
    private Hashtable clear;
    private int close;

    public NDbBuffer(DbBuffer dbBuffer) {
        this.append = dbBuffer;
    }

    public NDbBuffer(DbRecordModel dbRecordModel, File file, Hashtable hashtable, int n) throws IOException {
        super(dbRecordModel, hashtable);
        this.file = file;
        this.bufFile = new RAFile(file, "rw");
        this.lastPage = new DbPage(this, 0);
        this.close = n;
    }

    public NDbBuffer(DbRecordModel dbRecordModel, Hashtable hashtable) {
        super(dbRecordModel, new Hashtable());
        this.clear = hashtable;
    }

    public NDbBuffer(DbRecordModel dbRecordModel, Hashtable hashtable, int n) {
        super(false, dbRecordModel, hashtable, 0, n, 0);
        this.clear = hashtable;
    }

    public void Read() throws IOException {
        this.lastPage.readFromFile(this.bufFile);
        this.currentEnd = this.close;
        this.finish();
        this.setNeedWaitFetch(false);
    }

    public Hashtable getBlobTable() {
        return this.append.descToBlobFiles;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        DbColDesc dbColDesc = this.getColDesc(n);
        ByteArrayInputStream byteArrayInputStream = null;
        RandomAccessFile randomAccessFile = null;
        if (dbColDesc != null) {
            randomAccessFile = (RAFile)this.clear.get(dbColDesc);
        }
        if (randomAccessFile != null) {
            try {
                int n2 = randomAccessFile.readInt();
                byte[] byArray = new byte[n2];
                randomAccessFile.read(byArray);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        return byteArrayInputStream;
    }

    public void closeBlobFile() {
        Object object;
        Object object2;
        if (this.clear != null) {
            object2 = this.clear.keys();
            object = null;
            RAFile rAFile = null;
            while (object2.hasMoreElements()) {
                object = (DbColDesc)object2.nextElement();
                rAFile = (RAFile)this.clear.get(object);
                if (rAFile == null) continue;
                try {
                    rAFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.clear.clear();
        }
        try {
            this.bufFile.close();
            if (this.descToBlobFiles != null) {
                object = this.descToBlobFiles.elements();
                while (object.hasMoreElements()) {
                    object2 = (RAFile)object.nextElement();
                    ((RandomAccessFile)object2).close();
                }
            }
        }
        catch (IOException iOException) {
            this.QOIV.debug("when close file occur error:" + iOException.getMessage());
        }
    }
}

