/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.sqltoolkit;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class JavaCharStream {
    public static final boolean staticFlag = false;
    public int bufpos = -1;
    int AdjustBuffSize;
    int ExpandBuff;
    int FillBuff;
    protected int[] bufline;
    protected int[] bufcolumn;
    protected int column = 0;
    protected int line = 1;
    protected boolean prevCharIsCR = false;
    protected boolean prevCharIsLF = false;
    protected Reader inputStream;
    protected char[] nextCharBuf;
    protected char[] buffer;
    protected int maxNextCharInd = 0;
    protected int nextCharInd = -1;
    protected int inBuf = 0;
    protected int tabSize = 8;

    static final int AdjustBuffSize(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException();
    }

    protected void setTabSize(int n) {
        this.tabSize = n;
    }

    protected int getTabSize(int n) {
        return this.tabSize;
    }

    protected void ExpandBuff(boolean bl) {
        char[] cArray = new char[this.AdjustBuffSize + 2048];
        int[] nArray = new int[this.AdjustBuffSize + 2048];
        int[] nArray2 = new int[this.AdjustBuffSize + 2048];
        try {
            if (bl) {
                System.arraycopy(this.buffer, this.FillBuff, cArray, 0, this.AdjustBuffSize - this.FillBuff);
                System.arraycopy(this.buffer, 0, cArray, this.AdjustBuffSize - this.FillBuff, this.bufpos);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.FillBuff, nArray, 0, this.AdjustBuffSize - this.FillBuff);
                System.arraycopy(this.bufline, 0, nArray, this.AdjustBuffSize - this.FillBuff, this.bufpos);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.FillBuff, nArray2, 0, this.AdjustBuffSize - this.FillBuff);
                System.arraycopy(this.bufcolumn, 0, nArray2, this.AdjustBuffSize - this.FillBuff, this.bufpos);
                this.bufcolumn = nArray2;
                this.bufpos += this.AdjustBuffSize - this.FillBuff;
            } else {
                System.arraycopy(this.buffer, this.FillBuff, cArray, 0, this.AdjustBuffSize - this.FillBuff);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.FillBuff, nArray, 0, this.AdjustBuffSize - this.FillBuff);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.FillBuff, nArray2, 0, this.AdjustBuffSize - this.FillBuff);
                this.bufcolumn = nArray2;
                this.bufpos -= this.FillBuff;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        this.ExpandBuff = this.AdjustBuffSize += 2048;
        this.FillBuff = 0;
    }

    protected void FillBuff() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        try {
            int n = this.inputStream.read(this.nextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (n == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            throw iOException;
        }
    }

    protected char ReadByte() throws IOException {
        if (++this.nextCharInd >= this.maxNextCharInd) {
            this.FillBuff();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    public char BeginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.AdjustBuffSize) {
                this.bufpos = 0;
            }
            this.FillBuff = this.bufpos;
            return this.buffer[this.bufpos];
        }
        this.FillBuff = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    protected void AdjustBuffSize() {
        if (this.ExpandBuff == this.AdjustBuffSize) {
            if (this.FillBuff > 2048) {
                this.bufpos = 0;
                this.ExpandBuff = this.FillBuff;
            } else {
                this.ExpandBuff(false);
            }
        } else if (this.ExpandBuff > this.FillBuff) {
            this.ExpandBuff = this.AdjustBuffSize;
        } else if (this.FillBuff - this.ExpandBuff < 2048) {
            this.ExpandBuff(true);
        } else {
            this.ExpandBuff = this.FillBuff;
        }
    }

    protected void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += this.tabSize - this.column % this.tabSize;
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    public char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.AdjustBuffSize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        if (++this.bufpos == this.ExpandBuff) {
            this.AdjustBuffSize();
        }
        this.buffer[this.bufpos] = c = this.ReadByte();
        if (c == '\\') {
            this.UpdateLineColumn(c);
            int n = 1;
            while (true) {
                if (++this.bufpos == this.ExpandBuff) {
                    this.AdjustBuffSize();
                }
                try {
                    this.buffer[this.bufpos] = c = this.ReadByte();
                    if (c != '\\') {
                        this.UpdateLineColumn(c);
                        if (c == 'u' && (n & 1) == 1) {
                            if (--this.bufpos >= 0) break;
                            this.bufpos = this.AdjustBuffSize - 1;
                            break;
                        }
                        this.backup(n);
                        return '\\';
                    }
                }
                catch (IOException iOException) {
                    if (n > 1) {
                        this.backup(n);
                    }
                    return '\\';
                }
                this.UpdateLineColumn(c);
                ++n;
            }
            try {
                while ((c = this.ReadByte()) == 'u') {
                    ++this.column;
                }
                this.buffer[this.bufpos] = c = (char)(JavaCharStream.AdjustBuffSize(c) << 12 | JavaCharStream.AdjustBuffSize(this.ReadByte()) << 8 | JavaCharStream.AdjustBuffSize(this.ReadByte()) << 4 | JavaCharStream.AdjustBuffSize(this.ReadByte()));
                this.column += 4;
            }
            catch (IOException iOException) {
                throw new Error("Invalid escape character at line " + this.line + " column " + this.column + ".");
            }
            if (n == 1) {
                return c;
            }
            this.backup(n - 1);
            return '\\';
        }
        this.UpdateLineColumn(c);
        return c;
    }

    public int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public int getLine() {
        return this.bufline[this.bufpos];
    }

    public int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public int getBeginColumn() {
        return this.bufcolumn[this.FillBuff];
    }

    public int getBeginLine() {
        return this.bufline[this.FillBuff];
    }

    public void backup(int n) {
        this.inBuf += n;
        if ((this.bufpos -= n) < 0) {
            this.bufpos += this.AdjustBuffSize;
        }
    }

    public JavaCharStream(Reader reader, int n, int n2, int n3) {
        this.inputStream = reader;
        this.line = n;
        this.column = n2 - 1;
        this.ExpandBuff = this.AdjustBuffSize = n3;
        this.buffer = new char[n3];
        this.bufline = new int[n3];
        this.bufcolumn = new int[n3];
        this.nextCharBuf = new char[4096];
    }

    public JavaCharStream(Reader reader, int n, int n2) {
        this(reader, n, n2, 4096);
    }

    public JavaCharStream(Reader reader) {
        this(reader, 1, 1, 4096);
    }

    public void ReInit(Reader reader, int n, int n2, int n3) {
        this.inputStream = reader;
        this.line = n;
        this.column = n2 - 1;
        if (this.buffer == null || n3 != this.buffer.length) {
            this.ExpandBuff = this.AdjustBuffSize = n3;
            this.buffer = new char[n3];
            this.bufline = new int[n3];
            this.bufcolumn = new int[n3];
            this.nextCharBuf = new char[4096];
        }
        this.prevCharIsCR = false;
        this.prevCharIsLF = false;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.FillBuff = 0;
        this.bufpos = -1;
        this.nextCharInd = -1;
    }

    public void ReInit(Reader reader, int n, int n2) {
        this.ReInit(reader, n, n2, 4096);
    }

    public void ReInit(Reader reader) {
        this.ReInit(reader, 1, 1, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n, n2, n3);
    }

    public JavaCharStream(InputStream inputStream, int n, int n2, int n3) {
        this(new InputStreamReader(inputStream), n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string, int n, int n2) throws UnsupportedEncodingException {
        this(inputStream, string, n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, int n, int n2) {
        this(inputStream, n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, string, 1, 1, 4096);
    }

    public JavaCharStream(InputStream inputStream) {
        this(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string, int n, int n2, int n3) throws UnsupportedEncodingException {
        this.ReInit(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, int n, int n2, int n3) {
        this.ReInit(new InputStreamReader(inputStream), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, String string, int n, int n2) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, int n, int n2) {
        this.ReInit(inputStream, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, 1, 1, 4096);
    }

    public String GetImage() {
        if (this.bufpos >= this.FillBuff) {
            return new String(this.buffer, this.FillBuff, this.bufpos - this.FillBuff + 1);
        }
        return new String(this.buffer, this.FillBuff, this.AdjustBuffSize - this.FillBuff) + new String(this.buffer, 0, this.bufpos + 1);
    }

    public char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (this.bufpos + 1 >= n) {
            System.arraycopy(this.buffer, this.bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(this.buffer, this.AdjustBuffSize - (n - this.bufpos - 1), cArray, 0, n - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, cArray, n - this.bufpos - 1, this.bufpos + 1);
        }
        return cArray;
    }

    public void Done() {
        this.nextCharBuf = null;
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }

    public void adjustBeginLineColumn(int n, int n2) {
        int n3 = this.FillBuff;
        int n4 = this.bufpos >= this.FillBuff ? this.bufpos - this.FillBuff + this.inBuf + 1 : this.AdjustBuffSize - this.FillBuff + this.bufpos + 1 + this.inBuf;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n5 < n4 && this.bufline[n6 = n3 % this.AdjustBuffSize] == this.bufline[n7 = ++n3 % this.AdjustBuffSize]) {
            this.bufline[n6] = n;
            n8 = n9 + this.bufcolumn[n7] - this.bufcolumn[n6];
            this.bufcolumn[n6] = n2 + n9;
            n9 = n8;
            ++n5;
        }
        if (n5 < n4) {
            this.bufline[n6] = n++;
            this.bufcolumn[n6] = n2 + n9;
            while (n5++ < n4) {
                n6 = n3 % this.AdjustBuffSize;
                this.bufline[n6] = this.bufline[n6] != this.bufline[++n3 % this.AdjustBuffSize] ? n++ : n;
            }
        }
        this.line = this.bufline[n6];
        this.column = this.bufcolumn[n6];
    }
}

