/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JDemandQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.dataengine8.query.ARawDataQuery;
import jet.dataengine8.query.QueryManager;
import jet.datasource.InputStreamFactory;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQuery;
import jet.universe.JetUUniverse;
import jet.universe.JetUXMLConnection;

public class DemandQuery
extends ARawDataQuery
implements JDemandQuery {
    private static String GetQueryByResourceName = "DemandQuery";
    private DataDescription NULL_ParameterList;
    private JetUUniverse QOIV;
    private String append;
    private String check;
    private String[] checkCanBeChange = ARawDataQuery.ZERO_STRING_ARRAY;
    private InputStreamFactory checkClose;
    private boolean checkDataSourceName = false;

    public DemandQuery(QueryManager queryManager, int n) throws DSException {
        super(queryManager, n);
        this.log.externalDebug(1007, new Object[]{"On deman query", String.valueOf(n)});
    }

    public JetUUniverse getCatalog() throws DSException {
        super.checkClose();
        return this.QOIV;
    }

    public void setCatalog(JetUUniverse jetUUniverse) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.QOIV = jetUUniverse;
    }

    public String getDataSourceName() throws DSException {
        super.checkClose();
        return this.append;
    }

    public void setDataSourceName(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.append = string;
    }

    public String getQueryName() throws DSException {
        super.checkClose();
        return this.check;
    }

    public void setQueryName(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.check = string;
    }

    public String[] getJoinList() throws DSException {
        super.checkClose();
        return (String[])this.checkCanBeChange.clone();
    }

    public void setJoinList(String[] stringArray) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (stringArray != null) {
            this.checkCanBeChange = (String[])stringArray.clone();
        }
    }

    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.QOIV == null) {
            throw new DSException(1052);
        }
        if (this.append == null) {
            throw new DSException(1110);
        }
        this.checkDataSourceName(this.QOIV, this.append);
        this.checkQueryName(this.QOIV, this.append, this.check);
        this.checkMappingName(this.QOIV, this.append);
        JetUDatabase jetUDatabase = this.QOIV.getDatabase(this.append);
        this.filters = ExpressionToolKit.replaceAllName(jetUDatabase, this.filters);
        if (this.parameterValueList != null && this.parameterValueList != ParameterValueList.NULL_ParameterList) {
            this.parameterValueList.updateParameterName(this.QOIV.getDatabase(this.append));
        }
        if (StringTools.isEmptyStringWithTrim(this.check)) {
            throw new DSException(1111);
        }
        if (this.NULL_ParameterList != null && this.NULL_ParameterList.getType() != 122889 && this.NULL_ParameterList.getType() != 4106) {
            throw new DSException(1148);
        }
    }

    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("Demand Query:");
        this.log.indent(GetQueryByResourceName);
        super.dump();
        this.log.debug("universe: " + (this.QOIV == null ? "null" : this.QOIV.getName()));
        this.log.debug("dataSourceName: " + this.append);
        this.log.debug("on demand queryName: " + this.check);
        this.log.debug("join paths: size = " + this.checkCanBeChange.length);
        this.log.indent(GetQueryByResourceName);
        int n = 0;
        int n2 = this.checkCanBeChange.length;
        while (n < n2) {
            this.log.debug(this.checkCanBeChange[n]);
            ++n;
        }
        this.log.deIndent(GetQueryByResourceName);
        this.log.deIndent(GetQueryByResourceName);
        this.log.debug("End Demand Query.");
    }

    public JQuery copy(int n) throws DSException {
        super.checkClose();
        DemandQuery demandQuery = new DemandQuery(this.manager, n);
        this.copyRawDataQuery(demandQuery);
        demandQuery.QOIV = this.QOIV;
        demandQuery.append = this.append;
        demandQuery.check = this.check;
        demandQuery.mappingNames = this.mappingNames;
        demandQuery.checkCanBeChange = this.checkCanBeChange;
        return demandQuery;
    }

    public boolean supportPushdown() {
        JetUConnection jetUConnection = this.QOIV.getDatabase(this.append).getConnection();
        if (jetUConnection == null || jetUConnection instanceof JetUXMLConnection) {
            return false;
        }
        String string = ((JetUJDBCConnection)jetUConnection).getJdbcDriver();
        if (string != null && string.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            return false;
        }
        JetUQuery jetUQuery = this.QOIV.GetQueryByResourceName(this.append, this.check);
        if (jetUQuery instanceof JetUQuery) {
            JetUQuery jetUQuery2 = jetUQuery;
            if (!StringTools.isEmptyStringWithTrim(jetUQuery2.getPsqlQuery().getUserDefinedQueryStmt())) {
                return false;
            }
            if (jetUQuery2.enableSQLStmtCreator.get()) {
                return false;
            }
            return jetUQuery2.getPsqlQuery().getUnionVector().size() == 0;
        }
        return false;
    }

    protected void clearMemory() {
        super.clearMemory();
        this.QOIV = null;
        this.append = null;
        this.check = null;
        this.checkCanBeChange = null;
    }

    public InputStreamFactory getInputStremFactory() throws DSException {
        return this.checkClose;
    }

    public boolean hasInputStreamFactory() {
        return this.checkDataSourceName;
    }

    public void setInputStreamFactory(InputStreamFactory inputStreamFactory) throws DSException {
        this.checkDataSourceName = inputStreamFactory != null;
        this.checkClose = inputStreamFactory;
        this.log.debug(" *** Query : HDSQuery. hasStreamFactory:" + this.checkDataSourceName + ".");
        this.log.debug(" *** InputStreamFactory: " + this.checkClose);
    }

    public DataDescription getDataDescription() throws DSException {
        super.checkClose();
        return this.NULL_ParameterList;
    }

    public void setDataDescription(DataDescription dataDescription) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.NULL_ParameterList = dataDescription;
    }
}

