/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.linearBarcode.Barcode128;

public class BarcodeUtil {
    public static int centreX;
    public static int centreY;

    public static StringBuffer code128Tran(String string, int n) {
        Barcode128 barcode128 = new Barcode128();
        barcode128.setBarcodeData(string);
        barcode128.setStartType(n);
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2 + 1];
        byArray = barcode128.getCombinedIndex();
        StringBuffer stringBuffer = new StringBuffer();
        byte by = BarcodeUtil.check128(byArray, barcode128.getDefaultStartType());
        stringBuffer.append(BarcodeUtil.getcode((byte)(103 + barcode128.getDefaultStartType())));
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] != 0) {
                stringBuffer.append(BarcodeUtil.getcode(byArray[n3]));
            }
            ++n3;
        }
        stringBuffer.append(BarcodeUtil.getcode(by));
        stringBuffer.append("1100011101011");
        return stringBuffer;
    }

    public static StringBuffer codabarTran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = BarcodeTable.codabar.length;
        if (!(string.indexOf(0) != 65 && string.indexOf(0) != 66 && string.indexOf(0) != 67 && string.indexOf(0) != 68 || string.indexOf(string.length() - 1) != 65 && string.indexOf(string.length() - 1) != 66 && string.indexOf(string.length() - 1) != 67 && string.indexOf(string.length() - 1) != 68)) {
            stringBuffer2.append(string);
        } else {
            stringBuffer2.append('A').append(string).append('A');
        }
        int n2 = 0;
        while (n2 < stringBuffer2.length()) {
            int n3 = 0;
            while (n3 < n) {
                if (stringBuffer2.charAt(n2) == BarcodeTable.codabar[n3]) {
                    stringBuffer.append(BarcodeTable.codabarTranslate[n3]);
                }
                ++n3;
            }
            ++n2;
        }
        return stringBuffer;
    }

    public static StringBuffer[] EAN13Tran(String string) {
        int n;
        String string2 = new String();
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        int n2 = 0;
        while (n2 <= 9) {
            if (string.charAt(0) == BarcodeTable.EAN13[n2]) {
                string2 = BarcodeTable.EAN13MTable[n2];
            }
            ++n2;
        }
        stringBufferArray[0] = stringBufferArray[0].append("101");
        int n3 = 1;
        while (n3 <= 6) {
            if (string2.charAt(n3 - 1) == '0') {
                n = 0;
                while (n <= 9) {
                    if (string.charAt(n3) == BarcodeTable.EAN13[n]) {
                        stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n <= 9) {
                    if (string.charAt(n3) == BarcodeTable.EAN13[n]) {
                        stringBufferArray[0].append(BarcodeTable.EAN13Translate[1][n]);
                    }
                    ++n;
                }
            }
            ++n3;
        }
        stringBufferArray[1].append("01010");
        n = 7;
        while (n < 13) {
            int n4 = 0;
            while (n4 <= 9) {
                if (string.charAt(n) == BarcodeTable.EAN13[n4]) {
                    stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n4]);
                }
                ++n4;
            }
            ++n;
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    public static StringBuffer[] EAN8Tran(String string) {
        int n;
        String string2 = new String();
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        stringBufferArray[0] = stringBufferArray[0].append("101");
        int n2 = 0;
        while (n2 < 4) {
            n = 0;
            while (n <= 9) {
                if (string.charAt(n2) == BarcodeTable.EAN13[n]) {
                    stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
                }
                ++n;
            }
            ++n2;
        }
        stringBufferArray[1].append("01010");
        n = 4;
        while (n < 8) {
            int n3 = 0;
            while (n3 <= 9) {
                if (string.charAt(n) == BarcodeTable.EAN13[n3]) {
                    stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n3]);
                }
                ++n3;
            }
            ++n;
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    public static StringBuffer UPCETran(String string) {
        int n;
        String string2 = new String();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == '0') {
            n = 0;
            while (n <= 9) {
                if (string.charAt(7) == BarcodeTable.EAN13[n]) {
                    string2 = BarcodeTable.UPCEMTable[0][n];
                }
                ++n;
            }
        } else {
            n = 0;
            while (n <= 9) {
                if (string.charAt(7) == BarcodeTable.EAN13[n]) {
                    string2 = BarcodeTable.UPCEMTable[1][n];
                }
                ++n;
            }
        }
        stringBuffer.append("101");
        n = 1;
        while (n <= 6) {
            int n2;
            if (string2.charAt(n - 1) == '0') {
                n2 = 0;
                while (n2 <= 9) {
                    if (string.charAt(n) == BarcodeTable.EAN13[n2]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[0][n2]);
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 <= 9) {
                    if (string.charAt(n) == BarcodeTable.EAN13[n2]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[1][n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        stringBuffer.append("010101");
        return stringBuffer;
    }

    public static StringBuffer[] UPCATran(String string) {
        int n;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        stringBufferArray[0].append("101");
        int n2 = 0;
        while (n2 < 6) {
            n = 0;
            while (n <= 9) {
                if (string.charAt(n2) == BarcodeTable.EAN13[n]) {
                    stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
                }
                ++n;
            }
            ++n2;
        }
        stringBufferArray[1].append("01010");
        n = 6;
        while (n < 12) {
            int n3 = 0;
            while (n3 <= 9) {
                if (string.charAt(n) == BarcodeTable.EAN13[n3]) {
                    stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n3]);
                }
                ++n3;
            }
            ++n;
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    public static StringBuffer Code39Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n > 0 && string.charAt(0) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
            stringBuffer.append("0");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                n3 = 0;
                while (n3 < 10) {
                    if (string.charAt(n2) == BarcodeTable.code39N[n3]) {
                        stringBuffer.append(BarcodeTable.code39NTranslate[n3]);
                    }
                    ++n3;
                }
            } else if (string.charAt(n2) >= 'A' && string.charAt(n2) <= 'Z') {
                n3 = 0;
                while (n3 < 26) {
                    if (string.charAt(n2) == BarcodeTable.code39C[n3]) {
                        stringBuffer.append(BarcodeTable.code39CTranslate[n3]);
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < 8) {
                    if (string.charAt(n2) == BarcodeTable.code39S[n3]) {
                        stringBuffer.append(BarcodeTable.code39STranslate[n3]);
                    }
                    ++n3;
                }
            }
            stringBuffer.append("0");
            ++n2;
        }
        if (string.charAt(n - 1) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
        }
        return stringBuffer;
    }

    public static StringBuffer supplement2Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String();
        int n = BarcodeUtil.checkSupplement2(string);
        string2 = BarcodeTable.supplement2MTable[n];
        stringBuffer.append("1011");
        int n2 = 0;
        while (n2 <= 1) {
            int n3;
            if (string2.charAt(n2) == '0') {
                n3 = 0;
                while (n3 <= 9) {
                    if (string.charAt(n2) == BarcodeTable.EAN13[n3]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[0][n3]);
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 <= 9) {
                    if (string.charAt(n2) == BarcodeTable.EAN13[n3]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[1][n3]);
                    }
                    ++n3;
                }
            }
            if (n2 != 1) {
                stringBuffer.append("01");
            }
            ++n2;
        }
        return stringBuffer;
    }

    public static StringBuffer supplement5Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String();
        int n = BarcodeUtil.checkSupplement5(string);
        string2 = BarcodeTable.supplement5MTable[n];
        stringBuffer.append("1011");
        int n2 = 0;
        while (n2 <= 4) {
            int n3;
            if (string2.charAt(n2) == '0') {
                n3 = 0;
                while (n3 <= 9) {
                    if (string.charAt(n2) == BarcodeTable.EAN13[n3]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[0][n3]);
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 <= 9) {
                    if (string.charAt(n2) == BarcodeTable.EAN13[n3]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[1][n3]);
                    }
                    ++n3;
                }
            }
            if (n2 != 4) {
                stringBuffer.append("01");
            }
            ++n2;
        }
        return stringBuffer;
    }

    public static int checkCode(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = string.length() + 1;
        int n5 = 2;
        while (n5 <= n2) {
            int n6 = 0;
            if (n5 % 2 == 0) {
                n6 = new Integer(String.valueOf(string.charAt(n2 - n5)));
                n3 += n6;
            } else {
                n6 = new Integer(String.valueOf(string.charAt(n2 - n5)));
                n4 += n6;
            }
            ++n5;
        }
        n = n3 * 3 + n4;
        n = n % 10 != 0 ? 10 - n % 10 : 0;
        return n;
    }

    public static char checkCode2(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                n4 = 0;
                while (n4 < 10) {
                    if (string.charAt(n3) == BarcodeTable.code39N[n4]) {
                        n += n4;
                    }
                    ++n4;
                }
            } else if (string.charAt(n3) >= 'A' && string.charAt(n3) <= 'Z') {
                n4 = 0;
                while (n4 < 26) {
                    if (string.charAt(n3) == BarcodeTable.code39C[n4]) {
                        n = n + n4 + 10;
                    }
                    ++n4;
                }
            } else if (string.charAt(n3) != '*') {
                n4 = 0;
                while (n4 < 8) {
                    if (string.charAt(n3) == BarcodeTable.code39S[n4]) {
                        n = n + n4 + 10 + 26;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        char c = (n %= 43) <= 9 ? BarcodeTable.code39N[n] : (n <= 35 ? BarcodeTable.code39C[n - 10] : BarcodeTable.code39S[n - 10 - 26]);
        return c;
    }

    public static byte check128(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = 0;
        byte by = 0;
        int n4 = 1;
        while (n4 <= n2) {
            if (byArray[n4 - 1] != -1) {
                n3 += n4 * byArray[n4 - 1];
            }
            ++n4;
        }
        n3 = n + 103 + n3;
        by = (byte)(n3 % 103);
        return by;
    }

    public static int checkSupplement2(String string) {
        int n = new Integer(String.valueOf(string));
        return n %= 4;
    }

    public static int checkSupplement5(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 5) {
            int n4 = 0;
            if (n3 % 2 == 0) {
                n4 = new Integer(String.valueOf(string.charAt(n3)));
                n2 += n4 * 3;
            } else {
                n4 = new Integer(String.valueOf(string.charAt(n3)));
                n += n4 * 9;
            }
            ++n3;
        }
        int n5 = (n2 + n) % 10;
        return n5;
    }

    public static StringBuffer getcode(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = BarcodeTable.code128table1[by];
        int[] nArray = new int[11];
        int n2 = 0;
        while (n2 < 11) {
            nArray[10 - n2] = n % 2;
            n /= 2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 11) {
            stringBuffer.append(nArray[n3]);
            ++n3;
        }
        return stringBuffer;
    }

    public static String convertUPCAtoUPCE(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < 12) {
            String string2 = "000000000000" + string;
            string = string2.substring(string2.length() - 12, string2.length());
        }
        if (string.length() == 12) {
            if (string.charAt(0) != '0' && string.charAt(0) != '1') {
                stringBuffer.append("Invalid Number System (only 0 & 1 are valid)");
            } else if (string.substring(3, 6).equals("000") || string.substring(3, 6).equals("100") || string.substring(3, 6).equals("200")) {
                stringBuffer.append(string.substring(1, 3) + string.substring(8, 11) + string.substring(3, 4));
            } else if (string.substring(4, 6).equals("00")) {
                stringBuffer.append(string.substring(1, 4) + string.substring(9, 11) + "3");
            } else if (string.substring(5, 6).equals("0")) {
                stringBuffer.append(string.substring(1, 5) + string.substring(10, 11) + "4");
            } else if (string.charAt(11) >= '5') {
                stringBuffer.append(string.substring(1, 6) + string.substring(10, 11));
            } else {
                stringBuffer.append("Invalid product code (00005 to 00009 are valid)");
            }
        } else {
            stringBuffer.append("Invalid product code ");
        }
        if (stringBuffer.substring(0, 1).equals("I")) {
            return stringBuffer.toString();
        }
        return string.charAt(0) + stringBuffer.toString() + string.charAt(string.length() - 1);
    }

    public static void printBarcodeDataM(String string, Graphics2D graphics2D, int n, int n2, int n3) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = n2;
        int n5 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        int n6 = 0;
        while (n6 < string.length()) {
            int n7 = n - n3 / 2 + n3 / string.length() * n6 + n3 / (2 * string.length());
            int n8 = fontMetrics.stringWidth(string.charAt(n6) + "");
            graphics2D.drawString(string.charAt(n6) + "", n7 - n8 / 2, n4 + n5 * 3 / 4);
            ++n6;
        }
    }

    public static void printBarcodeDataB(String string, Graphics2D graphics2D, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        graphics2D.drawString(string, n - n3, n2 - n4 / 4);
    }

    public static void printBarcodeDataA(String string, Graphics2D graphics2D, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        graphics2D.drawString(string, n + n3 / 4, n2 - n4 / 4);
    }

    public static void printBarcodeDataU(String string, Graphics2D graphics2D, int n, int n2, int n3) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = n2;
        int n5 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        int n6 = 0;
        while (n6 < string.length()) {
            int n7 = n - n3 / 2 + n3 / string.length() * n6 + n3 / (2 * string.length());
            int n8 = fontMetrics.stringWidth(string.charAt(n6) + "");
            graphics2D.drawString(string.charAt(n6) + "", n7 - n8 / 2, n4 - n5 / 4);
            ++n6;
        }
    }

    public static void setCentre(int n, int n2) {
        centreX = n;
        centreY = n2;
    }

    public static int getCodabarLength(StringBuffer stringBuffer, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if ((n4 + 1) % 7 % 2 != 0 || (n4 + 1) % 7 == 0) {
                n3 = stringBuffer.charAt(n4) == '1' ? (n3 += n2) : ++n3;
                if ((n4 + 1) % 7 == 0) {
                    ++n3;
                }
            } else {
                n3 = stringBuffer.charAt(n4) == '1' ? (n3 += n2) : ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public static float getUserDimFromMils(int n, int n2) {
        float f;
        if (n2 == 0) {
            f = (float)n * 72.0f / 1000.0f;
            if ((float)n - f * 1000.0f / 72.0f > 0.0f) {
                f += 1.0f;
            }
        } else {
            f = n2 == 1 ? (float)((double)n * 1312.3 / 3333.33 * 72.0 / 1000.0) : (float)n;
        }
        return f;
    }

    public static void drawbar(Graphics2D graphics2D, float f, float f2, float f3, float f4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f + f3, f2);
        generalPath.lineTo(f + f3, f2 + f4);
        generalPath.lineTo(f, f2 + f4);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }
}

