/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.exception.EngingPreinitException;
import jet.report.JetRptDataContainer;
import jet.report.JetRptSubReport;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.JReportEngine;
import jet.rptengine.JSubReportEngine;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.JSubRSReportEngine;
import jet.rptservice.engine.JSubRptSetEngine;
import jet.rptservice.engine.infocenter.ReportCenter;
import jet.rptservice.engine.infocenter.ReportInfo;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.engine.infocenter.ReportViewInfo;
import jet.rptservice.exception.JRSubReportMissedException;
import jet.rptservice.pub.RSDInfo;
import jet.rptservice.util.Tools;
import jet.server.api.ServerInfo;
import jet.util.EngineErrorListener;
import jet.util.JFieldValueNLSManager;

public class JRSReportEngine {
    protected JetRptReport report;
    private JRptSetEngine QOIV;
    protected Hashtable htViewEngine = new Hashtable();
    protected ReportCenter rptCenter;
    protected boolean singleThread;

    public JRSReportEngine() {
    }

    public JRSReportEngine(JetRptReport jetRptReport, JRptSetEngine jRptSetEngine) {
        JRLog.trace(6, "JRSReportEngine()..., rpt = " + jetRptReport + " rptSetEngine = " + jRptSetEngine);
        this.report = jetRptReport;
        this.QOIV = jRptSetEngine;
        JRLog.trace(6, "End of JRSReportEngine()...");
    }

    public void createViewEngine(JetRptReport jetRptReport, String[] stringArray) {
        JRLog.trace(6, "createViewEngine()..., rpt = " + jetRptReport + " rptSetEngine = " + this.QOIV + " viewNames = " + stringArray);
        if (stringArray == null) {
            return;
        }
        String string = this.rptCenter.getRptName();
        ReportInfo reportInfo = this.QOIV.getRptInfo(string);
        int n = 0;
        while (n < stringArray.length) {
            JRLog.trace(6, "JRSReportEngine()..., rpt=" + jetRptReport + " rptView=" + stringArray[n]);
            JetRptReportSet jetRptReportSet = this.rptCenter.getRptSetCenter().getRptSet();
            JRLog.trace(6, "rptName: " + this.rptCenter.getRptName() + " viewName: " + stringArray[n]);
            JRLog.trace(6, "universe= " + this.QOIV.getUniverse());
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[n]);
            if (jReportEngine == null) {
                Object object;
                JRLog.trace(6, "new report engine, view name = " + stringArray[n]);
                JetRptReport jetRptReport2 = jetRptReportSet.getReportView(this.rptCenter.getRptName(), stringArray[n]);
                Object var9_9 = null;
                JetRptReport jetRptReport3 = null;
                if (!this.QOIV.hasRegisted(jetRptReport2)) {
                    this.QOIV.registReportView(jetRptReport2);
                    jetRptReport2.setRuntimeReportAlias(JRptSetEngine.getFixedAlias(jetRptReport2));
                    jetRptReport3 = jetRptReport2;
                } else {
                    int n2 = this.QOIV.genAliasNo();
                    jetRptReport3 = (JetRptReport)jetRptReport2.deepDupWithName();
                    jetRptReport3.createNamingSystem();
                    jetRptReport3.afterInit();
                    jetRptReport3.setRuntimeReportAlias(String.valueOf(n2));
                }
                String string2 = null;
                if (reportInfo != null && (object = reportInfo.getRptViewInfo(stringArray[n])) != null) {
                    string2 = ((ReportViewInfo)object).getStyleGroup();
                }
                jReportEngine = new JReportEngine(this.QOIV.getUniverse(), jetRptReport3, this.singleThread, null);
                this.htViewEngine.put(stringArray[n], jReportEngine);
                jReportEngine.setDataEngine(this.QOIV.getDataEngine());
                jReportEngine.setSecurityContext(this.QOIV.getSecurityContext());
                JRLog.trace(6, "$$$$$$$$$$$isDhtml: " + this.QOIV.isDHTML());
                jReportEngine.setDHTML(this.QOIV.isDHTML());
                jReportEngine.setSecurityData(JRptSetEngine.getSecurityData());
                object = this.QOIV.getServerInfo();
                JRLog.trace(6, "set server info to JReportEngine, info: " + object);
                jReportEngine.setServerInfo((ServerInfo)object);
                jReportEngine.setAllowFFP(this.QOIV.isAllowFFP());
                jReportEngine.setToken(this.QOIV.getCPUToken());
                jReportEngine.setEncoding(this.QOIV.getEncoding());
                jReportEngine.setLocale(this.QOIV.getLocale());
                jReportEngine.setTimeZone(this.QOIV.getTimeZone());
                jReportEngine.setClientName(this.QOIV.getClientName());
                jReportEngine.getSystemVariable().setModifiedDate(this.QOIV.getSysVariable().getModifiedDate());
                jReportEngine.setFieldNLSManager(this.getNLSManager(stringArray[n]));
                ReportViewCenter reportViewCenter = new ReportViewCenter(jReportEngine, this.rptCenter, stringArray[n], jetRptReport2);
                if (this.QOIV.getListeners() != null && !this.QOIV.getListeners().isEmpty()) {
                    int n3 = 0;
                    while (n3 < this.QOIV.getListeners().size()) {
                        reportViewCenter.getListener().addListener((EngineErrorListener)this.QOIV.getListeners().elementAt(n3));
                        ++n3;
                    }
                }
                jReportEngine.addListener(reportViewCenter.getListener());
                reportViewCenter.setEngineKeyWord(String.valueOf(0));
                this.rptCenter.setReportViewCenter(stringArray[n], reportViewCenter);
                reportViewCenter.setStyleGroup(string2);
                if (this.QOIV.isDHTML()) {
                    this.applyStyle(stringArray[n], false);
                }
                jReportEngine.setThreadPriority(this.QOIV.getPriority());
            }
            ++n;
        }
        JRLog.trace(6, "End of createViewEngine()...");
    }

    void I(String string, boolean bl) {
        JSubReportEngine[] jSubReportEngineArray;
        JetRptReport jetRptReport;
        JetRptReport jetRptReport2;
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.applyStyleNls()..., viewName: " + string + " includeSubRpts: " + bl);
        }
        if ((jReportEngine = this.getViewEngine(string)) == null) {
            return;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JetRptReport jetRptReport3 = jReportEngine.getReportViewCenter().getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "apply style: " + string2);
        }
        if ((jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(jetRptReport3, string2, this.getRptSetEngine().getFontMap(), this.getRptSetEngine().getFontMapEncoding(), this.getRptSetEngine().getFontMapLocale() == null ? this.getRptSetEngine().getLocale() : this.getRptSetEngine().getFontMapLocale(), this.getRptSetEngine().getNLSBundleInfo(), this.getRptSetEngine().getNLSMode())) != jetRptReport3) {
            jetRptReport2.setAppliedStyle(string2);
        }
        if (jetRptReport2 != (jetRptReport = jReportEngine.getReport())) {
            jetRptReport2.setRuntimeReportAlias(String.valueOf(jetRptReport.getRuntimeReportAlias()));
            jReportEngine.updateRptTemplate(jetRptReport2);
            reportViewCenter.setReportView(jetRptReport2);
        }
        if (bl && (jSubReportEngineArray = reportViewCenter.getAllSubReportEngine()) != null && jSubReportEngineArray.length > 0) {
            int n = 0;
            while (n < jSubReportEngineArray.length) {
                ReportViewCenter reportViewCenter2 = jSubReportEngineArray[n].getReportViewCenter();
                ReportCenter reportCenter = reportViewCenter2.getRptCenter();
                JSubRSReportEngine jSubRSReportEngine = (JSubRSReportEngine)reportCenter.getRptSetCenter().getRptSetEngine().getReportEngine(reportCenter.getRptName());
                jSubRSReportEngine.I(reportViewCenter2.getViewName(), false);
                ++n;
            }
        }
        JRLog.trace(6, "End of JRSReportEngine.applyStyleNls().");
    }

    protected void applyStyle(String string, boolean bl) {
        JSubReportEngine[] jSubReportEngineArray;
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.applyStyle()..., viewName: " + string + " includeSubRpts: " + bl);
        }
        if ((jReportEngine = this.getViewEngine(string)) == null) {
            return;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JetRptReport jetRptReport = jReportEngine.getReportViewCenter().getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "apply style: " + string2);
        }
        JetRptReport jetRptReport2 = ObjectLogicFactory.getViewLogic().applyDynamicStyle(jetRptReport, string2, false);
        jetRptReport2.setAppliedStyle(string2);
        if (bl && (jSubReportEngineArray = reportViewCenter.getAllSubReportEngine()) != null && jSubReportEngineArray.length > 0) {
            int n = 0;
            while (n < jSubReportEngineArray.length) {
                ReportViewCenter reportViewCenter2 = jSubReportEngineArray[n].getReportViewCenter();
                ReportCenter reportCenter = reportViewCenter2.getRptCenter();
                JSubRSReportEngine jSubRSReportEngine = (JSubRSReportEngine)reportCenter.getRptSetCenter().getRptSetEngine().getReportEngine(reportCenter.getRptName());
                jSubRSReportEngine.applyStyle(reportViewCenter2.getViewName(), false);
                ++n;
            }
        }
        JRLog.trace(6, "End of JRSReportEngine.applyStyle().");
    }

    private String QOIV() {
        String string = this.QOIV.getReportSet().getPath();
        return string == null ? "" : string;
    }

    public JFieldValueNLSManager getNLSManager(String string) {
        JRLog.trace(6, "JRSReportEngine.getNLSManager()...");
        JFieldValueNLSManager jFieldValueNLSManager = null;
        if (this.getRptSetEngine().isRsd()) {
            JRLog.trace(6, "get nls manager for rsd report set.");
            RSDInfo rSDInfo = this.getRptSetEngine().getRSDInfo();
            jFieldValueNLSManager = rSDInfo.getNLSManager(this.getReportCenter().getRptName(), string);
        } else {
            JRLog.trace(6, "get nls manager for not rsd report set.");
            String string2 = this.QOIV();
            JRLog.trace(6, "fullPath: " + string2 + " locale: " + this.getRptSetEngine().getLocale());
            jFieldValueNLSManager = JFieldValueNLSManager.getFieldValueNLSManager(string2, this.getRptSetEngine().getLocale());
        }
        return jFieldValueNLSManager;
    }

    public void createViewEngine(JetRptReport jetRptReport, int n) {
        JRLog.trace(6, "createViewEngine()..., rpt = " + jetRptReport + " rptStatus = " + n);
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = new String[]{this.report.getCurViewName()};
                break;
            }
            case 1: {
                stringArray = this.report.getOpenedViewNames();
                break;
            }
            case 2: {
                stringArray = this.report.getAllViewName();
                break;
            }
            default: {
                JRLog.error(1, "JRSReportEngine()...,invalid rpt status: " + n);
                return;
            }
        }
        this.createViewEngine(jetRptReport, stringArray);
        JRLog.trace(6, "End of createViewEngine()...");
    }

    Vector I() {
        Vector<String> vector = new Vector<String>();
        if (this.htViewEngine == null || this.report == null) {
            return vector;
        }
        String[] stringArray = this.report.getAllViewName();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = 0;
        while (n < stringArray.length) {
            if (this.htViewEngine.containsKey(stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        return vector;
    }

    public JReportEngine getViewEngine(String string) {
        if (this.htViewEngine == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            if (this.report == null) {
                return null;
            }
            string2 = this.report.getCurViewName();
        }
        return (JReportEngine)this.htViewEngine.get(string2);
    }

    public JReportEngine getViewEngine() {
        return this.getViewEngine(null);
    }

    public void setReportCenter(ReportCenter reportCenter) {
        this.rptCenter = reportCenter;
    }

    public JRptSetEngine getRptSetEngine() {
        return this.QOIV;
    }

    public JetRptReport getReport() {
        return this.report;
    }

    public ReportCenter getReportCenter() {
        return this.rptCenter;
    }

    public boolean isSingleThread() {
        return this.singleThread;
    }

    public void setSingleThread(boolean bl) {
        this.singleThread = bl;
        if (this.htViewEngine != null) {
            Enumeration enumeration = this.htViewEngine.keys();
            while (enumeration.hasMoreElements()) {
                JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(enumeration.nextElement());
                jReportEngine.setSingleThread(bl);
            }
        }
    }

    public String[] getViewNames() {
        Vector vector = new Vector();
        if (this.htViewEngine != null) {
            Iterator iterator = this.htViewEngine.keySet().iterator();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
        }
        return vector.toArray(new String[0]);
    }

    public void preinitEngine(String[] stringArray, boolean bl) throws EngingPreinitException {
        JRLog.trace(6, "JRSReportEngine.preinitEngine()..., viewNames = " + Tools.toString(stringArray) + " forceInit: " + bl);
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[n]);
            if (jReportEngine == null) {
                JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[n]);
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            if (bl || !reportViewCenter.hasPreinit()) {
                reportViewCenter.setPreinit();
                if (this.QOIV.getType() == 1) {
                    jReportEngine.setLinkInfo(this.QOIV.getLinkInfo());
                } else if (this.QOIV.getType() == 2) {
                    jReportEngine.setDetailInfo(this.QOIV.getMasterDetailInfo());
                }
                jReportEngine.updateRptTemplate(reportViewCenter.getOriReportView());
                long l = System.currentTimeMillis();
                jReportEngine.preinitEngine();
                long l2 = System.currentTimeMillis();
                JRLog.trace(6, "pre init report view:" + jReportEngine.getReportViewCenter().getViewName());
            }
            ++n;
        }
        JRLog.trace(6, "End of JRSReportEngine.preinitEngine()...");
    }

    public void preinitEngineAbsolute(String[] stringArray) throws EngingPreinitException {
        JRLog.trace(6, "JRSReportEngine.preinitEngineAbsolute()..., viewNames = " + Tools.toString(stringArray));
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[n]);
            if (jReportEngine == null) {
                JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[n]);
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            reportViewCenter.setPreinit();
            long l = System.currentTimeMillis();
            jReportEngine.preinitEngine();
            long l2 = System.currentTimeMillis();
            JRLog.trace(6, "pre init report view:" + jReportEngine.getReportViewCenter().getViewName());
            ++n;
        }
        JRLog.trace(6, "End of JRSReportEngine.preinitEngineAbsolute()...");
    }

    public void initRunEngine(String[] stringArray, boolean bl) {
        JRLog.trace(6, "JRSReportEngine.initRunEngine()..., viewNames = " + Tools.toString(stringArray));
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[n]);
            if (jReportEngine == null) {
                JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[n]);
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            if (bl || !reportViewCenter.hasInitRun()) {
                reportViewCenter.setInitRun();
                long l = System.currentTimeMillis();
                jReportEngine.initRun();
                long l2 = System.currentTimeMillis();
                JRLog.trace(6, "init run report view: " + jReportEngine.getReportViewCenter().getViewName());
                jReportEngine.getReportViewCenter().refreshDataSet();
            }
            ++n;
        }
        JRLog.trace(6, "End of JRSReportEngine.initRunEngine()...");
    }

    public void initRunEngineAbsolute(String[] stringArray) {
        JRLog.trace(6, "JRSReportEngine.initRunEngineAbsolute()..., viewNames = " + Tools.toString(stringArray));
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[n]);
            if (jReportEngine == null) {
                JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[n]);
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            reportViewCenter.setInitRun();
            long l = System.currentTimeMillis();
            jReportEngine.initRun();
            long l2 = System.currentTimeMillis();
            JRLog.trace(6, "init run report view: " + jReportEngine.getReportViewCenter().getViewName());
            ++n;
        }
        JRLog.trace(6, "End of JRSReportEngine.initRunEngineAbsolute()...");
    }

    private void add(String string, boolean bl) {
        JRLog.trace(6, "JRSReportEngine.runReportView()..., viewName: " + string);
        if (this.htViewEngine == null) {
            return;
        }
        JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
        if (jReportEngine == null) {
            return;
        }
        long l = System.currentTimeMillis();
        ReportViewCenter reportViewCenter = this.getReportCenter().getReportViewCenter(string);
        JetRptReport jetRptReport = reportViewCenter.getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        try {
            if (!this.getRptSetEngine().isRsd()) {
                JRLog.trace(6, "get nls view...");
                JetRptReport jetRptReport2 = null;
                if (bl) {
                    String string3 = jetRptReport.getAppliedStyle();
                    if (!Tools.equals(string2, string3)) {
                        jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(jetRptReport, string2, this.QOIV.getFontMap(), this.QOIV.getFontMapEncoding(), this.QOIV.getFontMapLocale() == null ? this.QOIV.getLocale() : this.QOIV.getFontMapLocale(), this.QOIV.getNLSBundleInfo(), this.QOIV.getNLSMode());
                        jetRptReport2.setAppliedStyle(string2);
                    } else {
                        jetRptReport2 = ObjectLogicFactory.getViewLogic().applyNLSNeedCheck(jetRptReport, this.QOIV.getFontMap(), this.QOIV.getFontMapEncoding(), this.QOIV.getFontMapLocale() == null ? this.QOIV.getLocale() : this.QOIV.getFontMapLocale(), this.QOIV.getNLSBundleInfo(), this.QOIV.getNLSMode());
                    }
                    if (jetRptReport2 != jetRptReport) {
                        jetRptReport2.setRuntimeReportAlias(jReportEngine.getReport().getRuntimeReportAlias());
                    }
                    JRLog.trace(6, "free previous view...");
                    JetRptReport jetRptReport3 = reportViewCenter.getReportView();
                    if (jetRptReport3 != null && jetRptReport3 != jetRptReport2 && jetRptReport3 != jetRptReport && jetRptReport3 != this.report) {
                        jetRptReport3.clearReport();
                    }
                    reportViewCenter.setReportView(jetRptReport2);
                    JRLog.trace(6, "update report template...");
                    jReportEngine.updateRptTemplate(jetRptReport2);
                    JSubReportEngine[] jSubReportEngineArray = reportViewCenter.getAllSubReportEngine();
                    if (jSubReportEngineArray != null && jSubReportEngineArray.length > 0) {
                        int n = 0;
                        while (n < jSubReportEngineArray.length) {
                            this.addElement(string, jSubReportEngineArray[n]);
                            ++n;
                        }
                    }
                }
            }
            JRLog.trace(6, "get nls manager and set to report view engine...");
            jReportEngine.setFieldNLSManager(this.getNLSManager(string));
            reportViewCenter.getListener().reset();
        }
        catch (RuntimeException runtimeException) {
            JRLog.trace(6, runtimeException);
            this.QOIV.I(this.rptCenter.getRptName(), string);
            throw runtimeException;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "start report view engine, view name: " + string + " viewEngine: " + jReportEngine);
        }
        jReportEngine.initEngineFlag();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "SCHEDULE_BEFORE_START, [ELAPSED]: " + (System.currentTimeMillis() - l) + " [ms]");
        }
        long l2 = System.currentTimeMillis();
        jReportEngine.start();
        if (JRLog.isTrace(6)) {
            long l3 = System.currentTimeMillis();
            JRLog.trace(6, "SCHEDULE_STARTRPTENGINE, [ELAPSED]: " + (l3 - l2) + " [ms]");
            JRLog.trace(6, "SCHEDULE_RUNRPTVIEW, [ELAPSED]: " + (l3 - l) + " [ms]");
            JRLog.trace(6, "End of JRSReportEngine.runReportView().");
        }
    }

    private void addElement(String string, JSubReportEngine jSubReportEngine) {
        ReportViewCenter reportViewCenter = jSubReportEngine.getReportViewCenter();
        JetRptReport jetRptReport = reportViewCenter.getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        JRLog.trace(6, "get nls view...");
        JetRptReport jetRptReport2 = null;
        String string3 = jetRptReport.getAppliedStyle();
        if (!Tools.equals(string2, string3)) {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(jetRptReport, string2, this.QOIV.getFontMap(), this.QOIV.getFontMapEncoding(), this.QOIV.getFontMapLocale() == null ? this.QOIV.getLocale() : this.QOIV.getFontMapLocale(), this.QOIV.getNLSBundleInfo(), this.QOIV.getNLSMode());
            jetRptReport2.setAppliedStyle(string2);
        } else {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().applyNLSNeedCheck(jetRptReport, this.QOIV.getFontMap(), this.QOIV.getFontMapEncoding(), this.QOIV.getFontMapLocale() == null ? this.QOIV.getLocale() : this.QOIV.getFontMapLocale(), this.QOIV.getNLSBundleInfo(), this.QOIV.getNLSMode());
        }
        if (jetRptReport2 != jetRptReport) {
            jetRptReport2.setRuntimeReportAlias(jSubReportEngine.getReport().getRuntimeReportAlias());
        }
        JRLog.trace(6, "free previous view...");
        JetRptReport jetRptReport3 = reportViewCenter.getReportView();
        if (jetRptReport3 != null && jetRptReport3 != jetRptReport2 && jetRptReport3 != jetRptReport && jetRptReport3 != jSubReportEngine.getReportCenter().getReport()) {
            jetRptReport3.clearReport();
        }
        reportViewCenter.setReportView(jetRptReport2);
        JRLog.trace(6, "get nls manager and set to report view engine...");
        jSubReportEngine.setFieldNLSManager(this.getNLSManager(string));
        reportViewCenter.getListener().reset();
        JRLog.trace(6, "update report template...");
        jSubReportEngine.updateRptTemplate(jetRptReport2);
    }

    public boolean applyStyleNls(String string) {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.applyStyleNls()..., viewName: " + string);
        }
        if (this.getRptSetEngine().isRsd()) {
            return false;
        }
        ReportViewCenter reportViewCenter = this.rptCenter.getReportViewCenter(string);
        if (reportViewCenter == null) {
            return false;
        }
        boolean bl = false;
        JetRptReport jetRptReport = reportViewCenter.getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        JetRptReport jetRptReport2 = null;
        String string3 = jetRptReport.getAppliedStyle();
        if (!Tools.equals(string2, string3)) {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(jetRptReport, string2, this.QOIV.getFontMap(), this.QOIV.getFontMapEncoding(), this.QOIV.getFontMapLocale() == null ? this.QOIV.getLocale() : this.QOIV.getFontMapLocale(), this.QOIV.getNLSBundleInfo(), this.QOIV.getNLSMode());
            jetRptReport2.setAppliedStyle(string2);
        } else {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().applyNLSNeedCheck(jetRptReport, this.QOIV.getFontMap(), this.QOIV.getFontMapEncoding(), this.QOIV.getFontMapLocale() == null ? this.QOIV.getLocale() : this.QOIV.getFontMapLocale(), this.QOIV.getNLSBundleInfo(), this.QOIV.getNLSMode());
        }
        if (jetRptReport2 != jetRptReport) {
            object = reportViewCenter.getReportViewEngine();
            jetRptReport2.setRuntimeReportAlias(((JReportEngine)object).getReport().getRuntimeReportAlias());
            bl = true;
        }
        JRLog.trace(6, "free previous view...");
        object = reportViewCenter.getReportView();
        if (object != null && object != jetRptReport2 && object != jetRptReport && object != this.rptCenter.getReport()) {
            ((JetRptReport)object).clearReport();
        }
        reportViewCenter.setReportView(jetRptReport2);
        JRLog.trace(6, "End of JRSReportEngine.applyStyleNls(), return: " + bl);
        return bl;
    }

    boolean I(String string) {
        boolean bl = JRLog.isTrace(6);
        if (bl) {
            JRLog.trace(6, "JRSReportEngine.layoutReportView()..., viewName: " + string);
        }
        if (this.htViewEngine == null) {
            JRLog.trace(6, "End of JRSReportEngine.layoutReportView(), no any report view engines, return false.");
            return false;
        }
        JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
        if (jReportEngine == null) {
            JRLog.trace(6, "End of JRSReportEngine.layoutReportView(), report view engine don't exist, return false.");
            return false;
        }
        long l = System.currentTimeMillis();
        ReportViewCenter reportViewCenter = this.getReportCenter().getReportViewCenter(string);
        reportViewCenter.getListener().reset();
        reportViewCenter.getForceExpiredTable().clearFET();
        long l2 = System.currentTimeMillis();
        JRLog.trace(6, "layout report view , view name...");
        jReportEngine.initEngineFlag();
        jReportEngine.restart();
        long l3 = System.currentTimeMillis();
        JRLog.trace(6, "SCHEDULE_STARTRPTENGINE, [ELAPSED]: " + (l3 - l2) + " [ms]");
        if (bl) {
            long l4 = System.currentTimeMillis();
            JRLog.trace(6, "SCHEDULE_RUNRPTVIEW, [ELAPSED]: " + (l4 - l) + " [ms]");
            JRLog.trace(6, "End of JRSReportEngine.runReportView(), return true.");
        }
        return true;
    }

    public void runReportView(String[] stringArray) {
        this.runReportView(stringArray, true);
    }

    public void runReportView(String[] stringArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.add(string, bl);
            ++n;
        }
    }

    public void runReportViewWithRefreshData(String[] stringArray, boolean bl) {
    }

    public Vector getViewEngines() {
        Vector vector = new Vector();
        if (this.htViewEngine == null) {
            return vector;
        }
        String[] stringArray = this.report.getAllViewName();
        int n = 0;
        while (n < stringArray.length) {
            if (this.htViewEngine.containsKey(stringArray[n])) {
                vector.addElement(this.htViewEngine.get(stringArray[n]));
            }
            ++n;
        }
        return vector;
    }

    public void clearMem(String string) {
        if (this.htViewEngine != null && this.htViewEngine.containsKey(string)) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
            jReportEngine.clearMem();
            this.htViewEngine.remove(string);
        }
    }

    public synchronized void clearMem() {
        JRLog.trace(6, "JRSReportEngine.clearMem()...");
        if (this.htViewEngine != null) {
            Enumeration enumeration = this.htViewEngine.keys();
            while (enumeration.hasMoreElements()) {
                JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(enumeration.nextElement());
                JRLog.trace(6, " clear memory of report view engine: " + jReportEngine);
                jReportEngine.clearMem();
            }
            if (this.htViewEngine != null) {
                this.htViewEngine.clear();
                this.htViewEngine = null;
            }
        }
        this.report = null;
        this.QOIV = null;
        if (this.rptCenter != null) {
            this.rptCenter.clearMem();
            this.rptCenter = null;
        }
        JRLog.trace(6, "End of JRSReportEngine.clearMem().");
    }

    public void stop(String string) {
        JRLog.trace(6, "JRSReportEngine.stop()..., viewName: " + string);
        if (this.htViewEngine != null) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
            if (jReportEngine != null) {
                jReportEngine.stop();
            } else {
                JRLog.error(3, "can't stop view engine, no such view engine, view name: " + string);
            }
        }
        JRLog.trace(6, "End of JRSReportEngine.stop().");
    }

    public void clear(String string) {
        JRLog.trace(6, "JRSReportEngine.clear()..., viewName: " + string);
        JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
        if (jReportEngine != null) {
            JRLog.trace(5, "clear view engine, view name: " + string);
            jReportEngine.clear();
        } else {
            JRLog.trace(5, "can't clear view engine, no such view engine, view name: " + string);
            JRLog.error(3, "can't clear view engine, no such view engine, view name: " + string);
        }
        JRLog.trace(6, "End of JRSReportEngine.clear().");
    }

    Thread[] Z() {
        JRLog.trace(6, "JRSReportEngine.getAllThreads()...");
        Vector<Thread> vector = new Vector<Thread>();
        if (this.htViewEngine != null && !this.htViewEngine.isEmpty()) {
            Enumeration enumeration = this.htViewEngine.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(k);
                JRLog.trace(6, "get threads from JReportEngine, viewEngine: " + jReportEngine);
                Thread[] threadArray = jReportEngine.getAllThreads();
                if (threadArray == null || threadArray.length == 0) continue;
                int n = 0;
                while (n < threadArray.length) {
                    JRLog.trace(6, "get threads from JReportEngine, thread: " + threadArray[n]);
                    vector.addElement(threadArray[n]);
                    ++n;
                }
                JRLog.trace(6, "end of get threads from JReportEngine.");
            }
        }
        JRLog.trace(6, "End of JRSReportEngine.getAllThreads().");
        return vector.toArray(new Thread[vector.size()]);
    }

    protected void closeRelatedDataInstance(String string, String[] stringArray) {
        String[] stringArray2;
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.closeRelatedDataInstance()..., viewName: " + string + " dcNames: " + Tools.toString(stringArray));
        }
        if (stringArray == null || stringArray.length == 0) {
            JRLog.trace(6, "End of JRSReportEngine.closeRelatedDataInstance(), no data container names.");
        }
        if ((jReportEngine = this.getViewEngine(string)) == null) {
            JRLog.trace(6, "End of JRSReportEngine.closeRelatedDataInstance(), no view engine.");
        }
        if ((stringArray2 = this.addListener(string, stringArray, true)) != null && stringArray2.length > 0) {
            Object object;
            int n;
            JSubReportEngine[] jSubReportEngineArray = this.afterInit(string, stringArray2, false);
            if (jSubReportEngineArray != null && jSubReportEngineArray.length > 0) {
                n = 0;
                while (n < jSubReportEngineArray.length) {
                    object = jSubReportEngineArray[n].getReportViewCenter();
                    String string2 = ((ReportViewCenter)object).getRptCenter().getRptName();
                    String string3 = jSubReportEngineArray[n].getReportViewCenter().getViewName();
                    String string4 = ((ReportViewCenter)object).getRootDataContainerName();
                    JRSReportEngine jRSReportEngine = jSubReportEngineArray[n].getRptSetEngine().getReportEngine(string2);
                    jRSReportEngine.closeRelatedDataInstance(string3, new String[]{string4});
                    ++n;
                }
            }
            n = 0;
            while (n < stringArray2.length) {
                object = (JetRptDataContainer)jReportEngine.getReport().nameToObject(stringArray2[n]);
                if (object != null) {
                    try {
                        jReportEngine.closeQuerysForSelf((JetRptDataContainer)object, false);
                        jReportEngine.closeQuerysForSelf((JetRptDataContainer)object, true);
                    }
                    catch (JRScheduleException jRScheduleException) {
                        JRLog.trace(5, jRScheduleException);
                    }
                }
                ++n;
            }
        }
        JRLog.trace(6, "End of JRSReportEngine.closeRelatedDataInstance().");
    }

    private String[] addListener(String string, String[] stringArray, boolean bl) {
        String[] stringArray2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.getDescendantDataContainerNames()..., viewName: " + string + " dcNames: " + Tools.toString(stringArray) + " includeSelf: " + bl);
        }
        if (stringArray == null || stringArray.length == 0) {
            JRLog.trace(6, "End of JRSReportEngine.getDescendantDataContainerNames(), no data container names, return null.");
            return null;
        }
        JReportEngine jReportEngine = this.getViewEngine(string);
        if (jReportEngine == null) {
            JRLog.trace(6, "End of JRSReportEngine.getDescendantDataContainerNames(), no view engine, return null.");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        int n = 0;
        while (n < stringArray.length) {
            if (bl && !arrayList.contains(stringArray[n])) {
                arrayList.add(stringArray[n]);
            }
            if ((stringArray2 = reportViewCenter.getDescendant(stringArray[n])) != null && stringArray2.length > 0) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (!arrayList.contains(stringArray2[n2])) {
                        arrayList.add(stringArray2[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        String[] stringArray3 = stringArray2 = arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRSReportEngine.getDescendantDataContainerNames(), return: " + Tools.toString(stringArray2));
        }
        return stringArray2;
    }

    private JSubReportEngine[] afterInit(String string, String[] stringArray, boolean bl) {
        JSubReportEngine[] jSubReportEngineArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.getSubViewEngines()..., viewName: " + string + " dcNames: " + Tools.toString(stringArray) + " includeDescendant: " + bl);
        }
        if (stringArray == null || stringArray.length == 0) {
            JRLog.trace(6, "End of JRSReportEngine.getSubViewEngines(), no data container names, return null.");
            return null;
        }
        JReportEngine jReportEngine = this.getViewEngine(string);
        if (jReportEngine == null) {
            JRLog.trace(6, "End of JRSReportEngine.getSubViewEngines(), no view engine, return null.");
            return null;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JReportEngine jReportEngine2 = jReportEngine;
        if (this.QOIV instanceof JSubRptSetEngine) {
            jReportEngine2 = ((JSubRptSetEngine)this.QOIV).getMainViewEngine();
        }
        String[] stringArray2 = bl ? this.addListener(string, stringArray, true) : stringArray;
        ArrayList<JSubReportEngine> arrayList = new ArrayList<JSubReportEngine>();
        int n = 0;
        while (n < stringArray2.length) {
            Vector vector;
            jSubReportEngineArray = reportViewCenter.getContainerInfo(stringArray2[n]);
            if (jSubReportEngineArray != null && (vector = jSubReportEngineArray.getSubRptInstNames()) != null && !vector.isEmpty()) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    block11: {
                        String string2 = (String)vector.elementAt(n2);
                        JetRptSubReport jetRptSubReport = (JetRptSubReport)jReportEngine.getReport().nameToObject(string2);
                        JSubReportEngine jSubReportEngine = null;
                        try {
                            jSubReportEngine = jReportEngine2.getSubReportEngine(jetRptSubReport);
                        }
                        catch (JRSubReportMissedException jRSubReportMissedException) {
                            break block11;
                        }
                        if (jSubReportEngine != null && !arrayList.contains(jSubReportEngine)) {
                            arrayList.add(jSubReportEngine);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        jSubReportEngineArray = arrayList.toArray(new JSubReportEngine[arrayList.size()]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRSReportEngine.getSubViewEngines(), return: " + Tools.toString(jSubReportEngineArray));
        }
        return jSubReportEngineArray;
    }
}

