/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbDecimal;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;

public class DbDouble
extends DbNumber {
    public double value;

    public DbDouble() {
    }

    public DbDouble(double d) {
        this.value = d;
        this.bNull = false;
    }

    public DbDouble(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public double get() {
        return this.value;
    }

    public void set(double d) {
        this.value = d;
        this.bNull = false;
    }

    public void set(ResultSet resultSet, int n) throws SQLException {
        this.value = resultSet.getDouble(n);
        this.bNull = resultSet.wasNull();
    }

    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        this.value = jRHierarchicalDataset.getDouble(n);
        this.bNull = jRHierarchicalDataset.wasNull();
    }

    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    public Object clone() {
        DbDouble dbDouble = new DbDouble(this.desc);
        dbDouble.bNull = this.bNull;
        dbDouble.value = this.value;
        return dbDouble;
    }

    public boolean equals(DbValue dbValue) {
        DbDouble dbDouble = (DbDouble)dbValue;
        if (dbDouble.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        return this.value == dbDouble.value;
    }

    public int compareTo(DbValue dbValue) {
        DbDouble dbDouble = (DbDouble)dbValue;
        if (dbDouble.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbDouble.bNull) {
                return 0;
            }
            return -1;
        }
        if (this.value == dbDouble.value) {
            return 0;
        }
        if (this.value < dbDouble.value) {
            return -1;
        }
        return 1;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void set(DbValue dbValue) {
        if (dbValue instanceof DbDecimal) {
            this.set(((DbDecimal)dbValue).doubleValue());
        } else {
            this.value = ((DbDouble)dbValue).value;
        }
        this.bNull = dbValue.bNull;
    }

    public void setValue(DbNumber dbNumber) {
        if (dbNumber instanceof DbDouble) {
            this.set(dbNumber);
        } else {
            this.bNull = dbNumber.bNull;
            if (!this.bNull) {
                this.value = dbNumber.doubleValue();
            }
        }
    }

    public void setValue(String string) {
        try {
            this.value = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.value = Double.NaN;
        }
        this.bNull = false;
    }
}

