/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbReal;
import jet.connect.DbValue;

public class DbFloatColumnBuffer
extends DbColumnBuffer {
    float[] QOIV;

    public float[] getBuffer() {
        return this.QOIV;
    }

    public DbFloatColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new float[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = ((DbReal)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbReal)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeFloat(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readFloat();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

