/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.AdMetaData;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.Record;

public class DbParallelBuffer
extends DbBuffer {
    Vector I = new Vector();
    DbBuffer[] QOIV;
    int[] Z;

    public DbParallelBuffer(DbRecordModel dbRecordModel) {
        Hashtable hashtable = dbRecordModel.getAllRM();
        int n = hashtable.size();
        this.QOIV = new DbBuffer[n];
        this.Z = new int[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DbRecordModel dbRecordModel2 = (DbRecordModel)hashtable.get(string);
            this.I.addElement(string);
            this.QOIV[n2] = new DbBuffer(dbRecordModel2);
            this.Z[n2] = n2;
            dbRecordModel2.setDbBuffer(this.QOIV[n2++]);
        }
        this.recordModel = dbRecordModel;
        this.setMetaData(new AdMetaData(dbRecordModel));
    }

    public DbParallelBuffer(DbRecordModel dbRecordModel, Vector vector) {
        Hashtable hashtable = dbRecordModel.getAllRM();
        int n = hashtable.size();
        this.QOIV = new DbBuffer[n];
        this.Z = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = (String)vector.elementAt(n3);
            DbRecordModel dbRecordModel2 = (DbRecordModel)hashtable.get(string);
            this.I.addElement(string);
            this.QOIV[n2] = new DbBuffer(dbRecordModel2);
            this.Z[n2] = n2;
            dbRecordModel2.setDbBuffer(this.QOIV[n2++]);
            ++n3;
        }
        this.recordModel = dbRecordModel;
        this.setMetaData(new AdMetaData(dbRecordModel));
    }

    public DbParallelBuffer(boolean bl, DbRecordModel dbRecordModel, int n, int n2, int n3) {
        Hashtable hashtable = dbRecordModel.getAllRM();
        int n4 = hashtable.size();
        this.QOIV = new DbBuffer[n4];
        this.Z = new int[n4];
        int n5 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DbRecordModel dbRecordModel2 = (DbRecordModel)hashtable.get(string);
            this.I.addElement(string);
            this.QOIV[n5] = new DbBuffer(bl, dbRecordModel2, n, n2, n3);
            this.Z[n5] = n5;
            dbRecordModel2.setDbBuffer(this.QOIV[n5++]);
        }
        this.recordModel = dbRecordModel;
        this.setMetaData(new AdMetaData(dbRecordModel));
    }

    public void setPageCount(int n) {
        int n2 = this.QOIV.length;
        int n3 = 0;
        while (n3 < n2) {
            this.QOIV[n3].setPageCount(n);
            ++n3;
        }
    }

    public void setRecPerPage(int n) {
        if (n > 0) {
            int n2 = this.QOIV.length;
            int n3 = 0;
            while (n3 < n2) {
                this.QOIV[n3].setRecPerPage(n);
                ++n3;
            }
        }
    }

    public synchronized void addRecord(Record record, String string) {
        int n = this.I.indexOf(string);
        if (n == -1) {
            n = this.getIndexRev(string);
        }
        if (n != -1) {
            this.QOIV[n].addRecord(record);
        }
    }

    public void clearMem() {
        int n = this.QOIV.length;
        int n2 = 0;
        while (n2 < n) {
            this.QOIV[n2].clearMem();
            ++n2;
        }
    }

    public void setNeedWaitFetch(boolean bl) {
        int n = this.QOIV.length;
        int n2 = 0;
        while (n2 < n) {
            this.QOIV[n2].setNeedWaitFetch(bl);
            ++n2;
        }
    }

    public Vector getBranchs() {
        return this.I;
    }

    public String getBranch(int n) {
        return (String)this.I.elementAt(n);
    }

    public DbBuffer[] getBuffers() {
        return this.QOIV;
    }

    public int getBufferNum() {
        return this.QOIV.length;
    }

    public int getIndex(String string) {
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.I.elementAt(n2);
            if (string.equals(string2) || string.startsWith(string2 + ".")) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public DbBuffer getDbBuffer(String string) {
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.I.elementAt(n2);
            if (string.equals(string2) || string.startsWith(string2 + ".")) {
                return this.QOIV[n2];
            }
            ++n2;
        }
        return null;
    }

    public int getIndexRev(String string) {
        int n = this.I.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.I.elementAt(n2);
            if (string2.equals(string) || string2.startsWith(string + ".")) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int[] getAllIndex() {
        return this.Z;
    }

    public int getParallelSize() {
        return this.Z.length;
    }

    public DbRecordModel getRecordModel(int n) {
        return this.QOIV[n].recordModel;
    }

    public DbRecordModel[] getRecordModels() {
        DbRecordModel[] dbRecordModelArray = new DbRecordModel[this.Z.length];
        int n = 0;
        while (n < this.Z.length) {
            dbRecordModelArray[n] = this.QOIV[n].recordModel;
            ++n;
        }
        return dbRecordModelArray;
    }

    public int getIndexByField(String string) {
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.QOIV[n2].recordModel.hasName(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public DbBuffer getBufferByField(String string) {
        int n = this.getIndexByField(string);
        if (n == -1) {
            return this.QOIV[0];
        }
        return this.QOIV[n];
    }

    public int getIndexByField(String string, String string2) {
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)this.I.elementAt(n2);
            if (this.QOIV[n2].recordModel.hasName(string) && (string2 == null || string3.equals(string2) || string3.startsWith(string2 + "."))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndexByField(DbColDesc dbColDesc) {
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            DbColDesc[] dbColDescArray = this.QOIV[n2].recordModel.getColDescs();
            if (dbColDescArray.length > (n3 = dbColDesc.getColIndex()) && dbColDescArray[n3].colName.equalsIgnoreCase(dbColDesc.colName)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndexByRM(DbRecordModel dbRecordModel) {
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.QOIV[n2].recordModel == dbRecordModel) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int[] getIndexByFields(Vector vector) {
        int n;
        Vector<Integer> vector2 = new Vector<Integer>();
        int n2 = this.I.size();
        int n3 = 0;
        while (n3 < n2) {
            boolean bl = false;
            n = vector.size();
            int n4 = 0;
            while (n4 < n) {
                if (!this.QOIV[n3].recordModel.hasName((String)vector.elementAt(n4))) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                vector2.addElement(new Integer(n3));
            }
            ++n3;
        }
        n2 = vector2.size();
        if (n2 == 0) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        int[] nArray = new int[n2];
        n = 0;
        while (n < n2) {
            nArray[n] = (Integer)vector2.elementAt(n);
            ++n;
        }
        return nArray;
    }

    public int[] getAllIndexByField(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = this.I.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.QOIV[n2].recordModel.hasName(string)) {
                vector.addElement(new Integer(n2));
            }
            ++n2;
        }
        n = vector.size();
        if (n == 0) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = (Integer)vector.elementAt(n3);
            ++n3;
        }
        return nArray;
    }

    public int getRecords() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            n += this.QOIV[n2].getRecords();
            ++n2;
        }
        return n;
    }

    public Object clone() {
        DbRecordModel dbRecordModel = (DbRecordModel)this.recordModel.clone();
        DbParallelBuffer dbParallelBuffer = new DbParallelBuffer(dbRecordModel, this.getBranchs());
        dbParallelBuffer.cacheToFile = this.cacheToFile;
        dbParallelBuffer.currentReadingRow = 0;
        dbParallelBuffer.initFile();
        this.currentReadingRow = 0;
        try {
            int n = 0;
            while (n < this.QOIV.length) {
                this.I(this.QOIV[n], dbParallelBuffer.QOIV[n]);
                ++n;
            }
            dbParallelBuffer.finished = true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return dbParallelBuffer;
    }

    void I(DbBuffer dbBuffer, DbBuffer dbBuffer2) throws SQLException {
        dbBuffer.setReadCursor(0);
        DbRecordModel dbRecordModel = dbBuffer.getRecordModel();
        Record record = null;
        int n = 0;
        while (n < dbBuffer.getRecords()) {
            record = dbRecordModel.createRecord();
            dbBuffer.nextRecord(record, true);
            dbBuffer2.addRecord(record);
            ++n;
        }
        dbBuffer2.finish();
        dbBuffer.setReadCursor(0);
    }
}

