/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbSmallInt;
import jet.connect.DbValue;

public class DbShortColumnBuffer
extends DbColumnBuffer {
    short[] QOIV;

    public short[] getBuffer() {
        return this.QOIV;
    }

    public DbShortColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new short[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = ((DbSmallInt)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbSmallInt)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeShort(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readShort();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

