/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui.param;

import java.io.UnsupportedEncodingException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jet.JDesgResource;
import jet.JResource;
import jet.exception.InvalidParameterException;

public class ParameterTools {
    public static final int DateType = 5;
    public static final int TimeType = 6;
    public static final int DateTimeType = 7;

    public static void checkIntergerParam(String string, String string2) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (string2.trim().length() <= 0) {
            string2 = "";
        }
        if (string2 != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
            number = (Number)new DecimalFormat(string2, decimalFormatSymbols).parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)string2));
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.getDefault());
            parsePosition = new ParsePosition(0);
            decimalFormat.setParseIntegerOnly(true);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                String string3 = decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getGroupingSeparator() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "";
                char[] cArray = new char[5];
                int n = 0;
                while (n < cArray.length) {
                    cArray[n] = decimalFormatSymbols.getDigit();
                    ++n;
                }
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new Object[]{string3, String.valueOf(cArray)}));
            }
        }
    }

    public static void checkNumberParam(String string, String string2) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (string2.trim().length() <= 0) {
            string2 = "";
        }
        if (string2 != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
            number = (Number)new DecimalFormat(string2, decimalFormatSymbols).parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)string2));
            }
        } else {
            parsePosition = new ParsePosition(0);
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.getDefault());
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFML", (Object)decimalFormat.toLocalizedPattern()));
            }
        }
    }

    public static void checkStringParam(String string, String string2) throws InvalidParameterException {
        try {
            if (string2.trim().length() <= 0) {
                string2 = "";
            }
            if (string2 == "") {
                new String(string.getBytes(), "8859_1");
            } else if (!string2.startsWith("UTF8")) {
                new String(string.getBytes(string2), "8859_1");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidParameterException(JDesgResource.getMessage("ILLEGAL_PARAM_ERROR3"));
        }
    }

    public static void checkCurrencyParam(String string, String string2) throws InvalidParameterException {
        Number number = null;
        if (string2.trim().length() <= 0) {
            string2 = "";
        }
        ParsePosition parsePosition = new ParsePosition(0);
        if (string2 != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
            number = (Number)new DecimalFormat(string2, decimalFormatSymbols).parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JDesgResource.getMessage("FML_USERFORMAT", (Object)string2));
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.getDefault());
            DecimalFormat decimalFormat2 = (DecimalFormat)DecimalFormat.getCurrencyInstance(Locale.getDefault());
            parsePosition = new ParsePosition(0);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                parsePosition = new ParsePosition(0);
                number = decimalFormat2.parse(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    number = null;
                }
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new Object[]{decimalFormat.toLocalizedPattern(), decimalFormat2.toLocalizedPattern()}));
            }
        }
    }

    public static void checkBooleanParam(String string, String string2) throws InvalidParameterException {
        String string3;
        String string4;
        if (string2.trim().length() <= 0) {
            string2 = "";
        }
        if (string2 != "") {
            String[] stringArray = ParameterTools.QOIV(string2);
            string4 = stringArray[0];
            string3 = stringArray[1];
        } else {
            string4 = "true";
            string3 = "false";
        }
        if (!string.equalsIgnoreCase(string4) && !string.equalsIgnoreCase(string3)) {
            if (string2 == "") {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new String[]{"true", "false"}));
            }
            throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)("TRUE = \"" + string4 + "\" , FALSE = \"" + string3 + "\"")));
        }
    }

    private static String[] QOIV(String string) {
        String string2;
        String string3;
        int n = string.indexOf("/");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "false";
        }
        return new String[]{string3, string2};
    }

    public static void checkParametersParam(String string) throws InvalidParameterException {
        if (!string.startsWith("@")) {
            throw new InvalidParameterException(JResource.getMessage("FML_VALIDFML", (Object)JDesgResource.getMessage("PARAMETERS_FORMAT")));
        }
        if (string.indexOf(",") == -1) {
            if (string.length() <= 1 || string.substring(1).indexOf("@") != -1) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFML", (Object)JDesgResource.getMessage("PARAMETERS_FORMAT")));
            }
            return;
        }
        String[] stringArray = ParameterTools.append(string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            if (!string2.startsWith("@") || string2.substring(1).indexOf("@") != -1) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFML", (Object)JDesgResource.getMessage("PARAMETERS_FORMAT")));
            }
            ++n;
        }
    }

    private static String[] append(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == ',') {
                ++n2;
            }
            ++n3;
        }
        String[] stringArray = new String[n2 + 1];
        String string2 = string;
        int n4 = 0;
        while (string2.indexOf(",") != -1) {
            stringArray[n4] = string2.substring(0, string2.indexOf(","));
            string2 = string2.substring(string2.indexOf(",") + 1, string2.length());
            ++n4;
        }
        stringArray[n4] = string2;
        return stringArray;
    }

    public static void checkDateTimeParam(String string, String string2, int n) throws InvalidParameterException {
        String string3 = string;
        Date date = null;
        if (string2.trim().length() <= 0) {
            string2 = "";
        }
        if (string2 != "") {
            ParsePosition parsePosition = new ParsePosition(0);
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.getDefault());
            SimpleDateFormat simpleDateFormat = null;
            try {
                simpleDateFormat = new SimpleDateFormat(string2, dateFormatSymbols);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidParameterException(JResource.getMessage("ERROR_FORMAT"));
            }
            date = (Date)simpleDateFormat.parseObject(string3, parsePosition);
            if (date != null && parsePosition.getIndex() != string3.length()) {
                date = null;
            }
            if (date == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)string2));
            }
        } else {
            ParameterTools.charAt(string3, n);
        }
    }

    private static void charAt(String string, int n) throws InvalidParameterException {
        Object object;
        String string2 = string;
        Date date = null;
        SimpleDateFormat[] simpleDateFormatArray = null;
        Locale locale = Locale.getDefault();
        switch (n) {
            case 5: {
                simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(0, locale)};
                break;
            }
            case 6: {
                simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(0, locale)};
                break;
            }
            case 7: {
                simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, locale)};
            }
        }
        int n2 = 0;
        while (date == null && n2 < simpleDateFormatArray.length) {
            simpleDateFormatArray[n2].setLenient(false);
            object = simpleDateFormatArray[n2].getDateFormatSymbols();
            ((DateFormatSymbols)object).setZoneStrings(new String[0][0]);
            simpleDateFormatArray[n2].setDateFormatSymbols((DateFormatSymbols)object);
            ParsePosition parsePosition = new ParsePosition(0);
            date = simpleDateFormatArray[n2].parse(string2.trim(), parsePosition);
            if (date != null && parsePosition.getIndex() != string2.length()) {
                date = null;
            }
            ++n2;
        }
        if (date == null) {
            object = JResource.getMessage("FML_VALIDFML1");
            int n3 = 0;
            while (n3 < simpleDateFormatArray.length) {
                object = (String)object + "\n    " + simpleDateFormatArray[n3].toLocalizedPattern();
                ++n3;
            }
            throw new InvalidParameterException((String)object);
        }
    }
}

