/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JCliResource;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.cs.FileNameFromTemplate;
import jet.cs.JRMail;
import jet.cs.QuickSort;
import jet.export.pdf.SignatureTools;
import jet.util.EncodingSupport;
import jet.util.HeadlessHelper;

public class APIUtil {
    private static Hashtable QOIV = new Hashtable();

    private APIUtil() {
    }

    public static int parseInt(String string) {
        return CSUtil.parseInt(string);
    }

    public static int parseInt(String string, int n) {
        return CSUtil.parseInt(string, n);
    }

    public static long parseLong(String string) {
        return CSUtil.parseLong(string);
    }

    public static long parseLong(String string, int n) {
        return CSUtil.parseLong(string, n);
    }

    public static long parseLong(String string, long l) {
        return CSUtil.parseLong(string, l);
    }

    public static boolean getBoolean(String string) {
        return CSUtil.getBoolean(string);
    }

    public static boolean getBoolean(String string, boolean bl) {
        return CSUtil.getBoolean(string, bl);
    }

    public static String getDefaultTimeZone() {
        return CSUtil.getDefaultTimeZone();
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        if (throwable != null) {
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static String toDateTimeString(Date date, TimeZone timeZone) {
        return CSUtil.toDateTimeString(date, timeZone);
    }

    public static String toWinDateString(Date date) {
        return CSUtil.getWinDate(date);
    }

    public static String toSortableWinDateString(Date date) {
        return CSUtil.getSortableWinDate(date);
    }

    public static String toWinDateStringShowing(Date date) {
        return CSUtil.getWinDateInHead(date);
    }

    public static String toWinDateSecondString(Date date) {
        return CSUtil.getWinDateWithSec(date);
    }

    public static String getTimeElapseString(long l) {
        return CSUtil.getTimeElapseString(l);
    }

    public static String getLaunchTypeString(int n) {
        return CSUtil.getLaunchTypeString(n);
    }

    public static String getDisplayNameOfTask(String string) {
        try {
            return CustomTaskManager.getDisplayName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hashtable parseParamValues(InputStream inputStream) throws IOException {
        return CSUtil.parseParamValues(inputStream);
    }

    public static String addUrlPath(String string, String string2) {
        return CSUtil.addUrlPaths(string, string2);
    }

    public static String addUrlPaths(String string, String string2) {
        return CSUtil.addURLPath(string, string2);
    }

    public static String convertToAbsPath(File file, File file2) {
        return CSUtil.convertToAbsPath(file, file2);
    }

    public static String[] getPathAndName(String string) {
        return CSUtil.getPathAndName(string);
    }

    public static String VectorToURLEncodedString(Vector vector) {
        return CSUtil.VectorToURLEncodedString(vector);
    }

    public static void transferJRMailProperties(Properties properties) {
        Vector<JRMail> vector = new Vector<JRMail>(1);
        vector.addElement(new JRMail(properties));
        JRMail.toProperties(vector, properties);
    }

    public static Properties makeMailProperty(Properties properties, boolean bl) {
        Vector<CSMail> vector = new Vector<CSMail>(1);
        vector.addElement(bl ? new CSMail(properties) : new JRMail(properties));
        return JRMail.toProperties(vector, properties);
    }

    public static String[][] getSupportedEncodings() {
        return EncodingSupport.encodings;
    }

    public static String[] getSupportedEncodingNames() {
        return EncodingSupport.getSupportedEncodingNames();
    }

    public static String[] getSupportedEncodingDescriptions() {
        return EncodingSupport.getSupportedEncodingDescriptions();
    }

    public static String getEncodingNameByDescription(String string) {
        return EncodingSupport.getEncodingNameByDescription(string);
    }

    public static String getEncodingDescriptionByName(String string) {
        return EncodingSupport.getEncodingDescriptionByName(string);
    }

    public static String getExtName(String string) {
        return CSUtil.getExtName(string);
    }

    public static String removeExtName(String string) {
        return CSUtil.removeExtName(string);
    }

    public static String getNameWithoutExt(String string) {
        return CSUtil.getNameWithoutExt(string);
    }

    public static String getNameWithoutExt(String string, boolean bl) {
        return CSUtil.getNameWithoutExt(string, bl);
    }

    public static String getNodeNameWithoutExt(String string, boolean bl) {
        return CSUtil.getNodeNameWithoutExt(string, bl);
    }

    public static String getFileNameWithoutDir(String string) {
        return CSUtil.getFileNameWithoutDir(string);
    }

    public static boolean checkFileNameWithTemplate(String string) {
        if (string != null && string.trim().length() > 0) {
            return FileNameFromTemplate.checkFileNameWithTemplate(string);
        }
        return false;
    }

    public static String writeFileToString(File file) {
        return CSUtil.writeFileToString(file);
    }

    public static Properties parseQuery(String string) {
        return CSUtil.parseQuery(string);
    }

    public static String escapeHtmlSpecialChars(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    bl = true;
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    bl = true;
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    bl = true;
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return bl ? stringBuffer.toString() : string;
    }

    public static Vector sortAsCol(Vector vector, Vector vector2, boolean bl) {
        return QuickSort.sort(vector, vector2, bl);
    }

    /*
     * Unable to fully structure code
     */
    public static String[][] sortAsCol(String[][] var0, int var1_1, int var2_2) {
        block12: {
            block11: {
                var3_3 = var0.length;
                if (var3_3 < 2) {
                    return var0;
                }
                var10_4 = var3_3 / 2;
                var11_5 = new int[var10_4][2];
                var12_6 = 0;
                var11_5[0][0] = 0;
                var11_5[0][1] = var3_3 - 1;
                if (var2_2 != 0) break block11;
                while (var12_6 >= 0) {
                    var4_7 = var6_11 = var11_5[var12_6][0];
                    var5_9 = var7_13 = var11_5[var12_6][1];
                    --var12_6;
                    if (var4_7 >= var5_9) continue;
                    var8_15 = var0[(var4_7 + var5_9) / 2][var1_1].toLowerCase();
                    ** GOTO lbl29
                    {
                        ++var6_11;
                        do {
                            if (var6_11 < var5_9 && var0[var6_11][var1_1].toLowerCase().compareTo(var8_15) < 0) continue block1;
                            while (var7_13 > var4_7 && var0[var7_13][var1_1].toLowerCase().compareTo(var8_15) > 0) {
                                --var7_13;
                            }
                            if (var6_11 > var7_13) continue;
                            var9_17 = var0[var6_11];
                            var0[var6_11] = var0[var7_13];
                            var0[var7_13] = var9_17;
                            ++var6_11;
                            --var7_13;
lbl29:
                            // 3 sources

                        } while (var6_11 <= var7_13);
                    }
                    if (var4_7 < var7_13) {
                        var11_5[++var12_6][0] = var4_7;
                        var11_5[var12_6][1] = var7_13;
                    }
                    if (var6_11 >= var5_9) continue;
                    var11_5[++var12_6][0] = var6_11;
                    var11_5[var12_6][1] = var5_9;
                }
                break block12;
            }
            if (var2_2 != 1) break block12;
            while (var12_6 >= 0) {
                var4_8 = var6_12 = var11_5[var12_6][0];
                var5_10 = var7_14 = var11_5[var12_6][1];
                --var12_6;
                if (var4_8 >= var5_10) continue;
                var8_16 = var0[(var4_8 + var5_10) / 2][var1_1].toLowerCase();
                ** GOTO lbl59
                {
                    ++var6_12;
                    do {
                        if (var6_12 < var5_10 && var0[var6_12][var1_1].toLowerCase().compareTo(var8_16) > 0) continue block5;
                        while (var7_14 > var4_8 && var0[var7_14][var1_1].toLowerCase().compareTo(var8_16) < 0) {
                            --var7_14;
                        }
                        if (var6_12 > var7_14) continue;
                        var9_18 = var0[var6_12];
                        var0[var6_12] = var0[var7_14];
                        var0[var7_14] = var9_18;
                        ++var6_12;
                        --var7_14;
lbl59:
                        // 3 sources

                    } while (var6_12 <= var7_14);
                }
                if (var4_8 < var7_14) {
                    var11_5[++var12_6][0] = var4_8;
                    var11_5[var12_6][1] = var7_14;
                }
                if (var6_12 >= var5_10) continue;
                var11_5[++var12_6][0] = var6_12;
                var11_5[var12_6][1] = var5_10;
            }
        }
        return var0;
    }

    public static String getPublishRptTaskDisplayName(Hashtable hashtable) {
        String string = (String)hashtable.get("jrs.task_class");
        if (string != null && string.equals("jet.server.schedule.jrtasks.PublishRptTask")) {
            string = "";
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_version"), false)) {
                string = JCliResource.getMessage("CS_MSG_203");
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_disk"), false)) {
                if (string != "") {
                    string = string + ", ";
                }
                string = string + JCliResource.getMessage("CS_MSG_204");
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_mail"), false)) {
                if (string != "") {
                    string = string + ", ";
                }
                string = string + JCliResource.getMessage("CS_MSG_205");
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_FTP"), false)) {
                if (string != "") {
                    string = string + ", ";
                }
                string = string + JCliResource.getMessage("CS_MSG_251");
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_printer"), false)) {
                if (string != "") {
                    string = string + ", ";
                }
                string = string + JCliResource.getMessage("CS_MSG_206");
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_fax"), false)) {
                if (string != "") {
                    string = string + ", ";
                }
                string = string + JCliResource.getMessage("CS_MSG_283");
            }
        }
        return string;
    }

    public static boolean isValidEmailAddress(String string) {
        int n = 0;
        int n2 = 0;
        n = string.indexOf("@");
        n2 = string.lastIndexOf(".");
        return n > 0 && n <= n2 && n2 != string.length() - 1 && n2 != n + 1;
    }

    public static boolean isValidNodeName(String string) {
        return CSUtil.isValidNodeName(string);
    }

    public static int[] getYearMonthDate(Date date) {
        int[] nArray = new int[]{-1, -1, -1};
        nArray[0] = date.getYear() + 1900;
        nArray[1] = date.getMonth() + 1;
        nArray[2] = date.getDate();
        return nArray;
    }

    public static void deleteDirectory(String string) throws SecurityException {
        CSUtil.deleteUploadedFiles(string);
    }

    public static Vector[] getRptRelatedFiles(String string) throws SecurityException {
        return CSUtil.getRptRelatedFiles(string);
    }

    public static boolean isReportFile(String string) {
        return CSUtil.isReportFile(string);
    }

    public static boolean isCatalogFile(String string) {
        return CSUtil.isCatalogFile(string);
    }

    public static String[] getLogicalFolderAndName(String string) {
        return CSUtil.getLogicalFolderAndName(string);
    }

    public static void putTempValueToHt(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        QOIV.put(string, string2);
    }

    public static Object getTempValueFromHt(String string) {
        return QOIV.get(string);
    }

    public static void removeTempValueInHt(String string) {
        QOIV.remove(string);
    }

    public static String checkDigitalIDFileAndPassword(InputStream inputStream, String string) {
        int n = SignatureTools.checkDigitalIDFileAndPassword(inputStream, string);
        String string2 = null;
        if (n == 102) {
            string2 = JCliResource.getMessage("CS_MSG_240");
        } else if (n == 101) {
            string2 = JCliResource.getMessage("CS_MSG_241");
        } else if (n == 100) {
            string2 = null;
        }
        return string2;
    }

    public static int getScreenResolution() {
        return HeadlessHelper.getScreenResolution();
    }
}

