/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.util;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.util.Bits;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine8.util.dataswap.IDataCache;

public class CacheObjectOutputStream {
    private byte[] QOIV;
    private int arraycopy = 4;
    private char[] getChars = new char[100];

    public CacheObjectOutputStream(int n) {
        if (n < 10) {
            n = 10;
        }
        this.QOIV = new byte[n];
    }

    public int writeToDataCache(IDataCache iDataCache) {
        Bits.putInt(this.QOIV, 0, this.arraycopy - 4);
        return iDataCache.putBytes(this.QOIV, 0, this.arraycopy);
    }

    public int size() {
        return this.arraycopy - 4;
    }

    public void refresh() {
        this.arraycopy = 4;
    }

    public void writeInt(int n) {
        this.arraycopy(4);
        this.getChars(n);
    }

    public void writeLong(long l) {
        this.arraycopy(-5);
        this.getTime(l);
    }

    public void writeDouble(double d) {
        this.arraycopy(8);
        this.QOIV(this.arraycopy + 8);
        Bits.putDouble(this.QOIV, this.arraycopy, d);
        this.arraycopy += 8;
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws DSException {
        if (bigDecimal == null) {
            this.arraycopy(0);
            return;
        }
        this.arraycopy(3);
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        this.getChars(n);
        this.getChars(bigDecimal.scale());
        this.QOIV(this.arraycopy + n);
        Bits.putBytes(this.QOIV, this.arraycopy, byArray);
        this.arraycopy += n;
    }

    public void writeString(String string) {
        if (string == null) {
            this.arraycopy(0);
            return;
        }
        this.arraycopy(12);
        int n = string.length();
        int n2 = n * 2;
        this.getChars(n2);
        this.QOIV(this.arraycopy + n2);
        if (n < this.getChars.length) {
            string.getChars(0, n, this.getChars, 0);
            this.length(this.getChars, 0, n);
        } else {
            int n3 = 0;
            int n4 = this.getChars.length;
            do {
                string.getChars(n3, n3 + n4, this.getChars, 0);
                this.length(this.getChars, 0, n4);
                if (n - (n3 += n4) >= n4) continue;
                n4 = n - n3;
            } while (n4 > 0);
        }
    }

    public void writeDate(Date date) {
        if (date == null) {
            this.arraycopy(0);
            return;
        }
        this.arraycopy(91);
        this.getTime(date.getTime());
    }

    public void writeTime(Time time2) {
        if (time2 == null) {
            this.arraycopy(0);
            return;
        }
        this.arraycopy(92);
        this.getTime(time2.getTime());
    }

    public void writeTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            this.arraycopy(0);
            return;
        }
        this.arraycopy(93);
        this.getTime(timestamp.getTime());
    }

    private void QOIV(int n) {
        int n2 = this.QOIV.length;
        if (n > n2) {
            byte[] byArray = this.QOIV;
            int n3 = n2 * 3 / 2;
            if (n > n3) {
                n3 = n;
            }
            this.QOIV = new byte[n3];
            System.arraycopy(byArray, 0, this.QOIV, 0, n2);
        }
    }

    private void arraycopy(int n) {
        this.QOIV(this.arraycopy + 1);
        this.QOIV[this.arraycopy++] = (byte)n;
    }

    private void getChars(int n) {
        this.QOIV(this.arraycopy + 4);
        Bits.putInt(this.QOIV, this.arraycopy, n);
        this.arraycopy += 4;
    }

    private void getTime(long l) {
        this.QOIV(this.arraycopy + 8);
        Bits.putLong(this.QOIV, this.arraycopy, l);
        this.arraycopy += 8;
    }

    private void length(char[] cArray, int n, int n2) {
        this.QOIV(this.arraycopy + n2);
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            Bits.putChar(this.QOIV, this.arraycopy, cArray[n3]);
            ++n3;
            this.arraycopy += 2;
        }
    }
}

