/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import jet.datastream.DSField;
import jet.datastream.DSSubReport;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.export.util.ExportCache;
import jet.report.xls.BFont;
import jet.report.xls.GlobalWorksheet;
import jet.util.FontSets;
import jet.util.Propertiable;

public class ExcelCache
extends ExportCache {
    public static final String[] BORDERLINENAME = new String[]{"TopLine", "LeftLine", "BottomLine", "RightLine"};
    public static final byte TOP = 0;
    public static final byte LEFT = 1;
    public static final byte BOTTOM = 2;
    public static final byte RIGHT = 3;
    public static final int NOJFONT = -1;
    private boolean ENGLISH;
    private boolean FALSE;
    private Hashtable QOIV = new Hashtable();
    private Hashtable TRUE = new Hashtable();
    private Hashtable append = new Hashtable();
    private Hashtable booleanValue = new Hashtable();
    private Hashtable canCacheToXls = new Hashtable();
    private Hashtable canCacheWordWrap = new Hashtable();
    private Hashtable clear = new Hashtable();
    private Hashtable contains;
    private Hashtable containsKey;
    private Hashtable convertUnitToInch;
    private boolean error = true;
    private boolean get = false;
    private Hashtable getBooleanPropertyByName = new Hashtable();
    private Hashtable getClass = new Hashtable();
    private boolean getColorIndex = true;
    private Hashtable getColorPropertyByName = new Hashtable();
    private Hashtable getExcelBorderStyle = new Hashtable();
    private Hashtable getExcelFontName = new Hashtable();
    private int getExportToXLS = -1;
    private Hashtable getFont = new Hashtable();
    private Hashtable getFontIndex = new Hashtable();
    private Hashtable getFontName = new Hashtable();

    public ExcelCache(boolean bl, File file, String string) {
        super(file, string);
        this.ENGLISH = JRLog.isError(2);
        this.FALSE = bl;
        this.TRUE();
    }

    public void setWordWrap(int n) {
        if (n == 0) {
            this.error = false;
        } else if (n == 2) {
            this.get = true;
        }
    }

    public void setPJFVersion(int n) {
        if (n != 0 && n < 262416) {
            this.getColorIndex = false;
        }
    }

    public boolean getWordWrap(DSField dSField) {
        if (this.error) {
            return this.get;
        }
        this.canCacheWordWrap(dSField);
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Boolean bl = (Boolean)this.getBooleanPropertyByName.get(dSTemplatible);
        if (bl != null) {
            return bl;
        }
        return CCUtil.getBooleanPropertyByName(dSField, "WordWrap");
    }

    public boolean getWordUdoWrap(JRVisiableResult jRVisiableResult) {
        if (this.error) {
            return this.get;
        }
        return CCUtil.getBooleanPropertyByName(jRVisiableResult, "wordWrap");
    }

    public int getExcelFontIndex(GlobalWorksheet globalWorksheet, DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Integer n = (Integer)this.getColorPropertyByName.get(dSTemplatible);
        if (n == null) {
            boolean bl;
            short s;
            boolean bl2 = true;
            if (this.getExcelBorderStyle.containsKey(dSTemplatible)) {
                bl2 = false;
            }
            String string = CCUtil.getStringPropertyByName(dSField, "FontFace");
            if (bl2) {
                bl2 = !CCUtil.isChangeByFormularProperty(dSField, "FontFace");
            }
            BFont bFont = new BFont();
            int n2 = this.getFontStyle(string);
            string = this.getExcelFontName(string);
            bFont.setFontName(string);
            if (n2 != -1) {
                if ((n2 & 1) == 1) {
                    bFont.setBoldStyle(true);
                }
                if ((n2 & 2) == 2) {
                    bFont.setItalic(true);
                }
            } else {
                n2 = 0;
                s = this.ENGLISH(dSField, "Bold");
                bl = this.ENGLISH(dSField, "Italic");
                if (bl2) {
                    boolean bl3 = bl2 = !CCUtil.isChangeByFormularProperty(dSField, "Bold");
                    if (bl2) {
                        bl2 = !CCUtil.isChangeByFormularProperty(dSField, "Italic");
                    }
                }
                bFont.setBoldStyle(s != 0);
                bFont.setItalic(bl);
            }
            s = (short)(Unit.convertUnitToInch(this.BORDERLINENAME(dSField, "FontSize")) * 1440.0);
            bl = this.ENGLISH(dSField, "StrikeOut");
            if (bl2) {
                bl2 = !CCUtil.isChangeByFormularProperty(dSField, "StrikeOut");
            }
            boolean bl4 = this.ENGLISH(dSField, "Underline");
            if (bl2) {
                bl2 = !CCUtil.isChangeByFormularProperty(dSField, "Underline");
            }
            boolean bl5 = this.ENGLISH(dSField, "Shadow");
            if (bl2) {
                bl2 = !CCUtil.isChangeByFormularProperty(dSField, "Shadow");
            }
            bFont.setFontHeight(s);
            bFont.setStrickout(bl);
            if (bl4) {
                bFont.setUnderline((byte)1);
            }
            bFont.setShadow(bl5);
            int n3 = CCUtil.getColorPropertyByName(dSField, "Foreground").getRGB();
            if (bl2) {
                bl2 = !CCUtil.isChangeByFormularProperty(dSField, "Foreground");
            }
            bFont.setColor((short)globalWorksheet.getColorIndex(n3));
            if (!bl2) {
                this.getExcelBorderStyle.put(dSTemplatible, Boolean.TRUE);
                return globalWorksheet.getFontIndex(bFont);
            }
            n = new Integer(globalWorksheet.getFontIndex(bFont));
            this.getColorPropertyByName.put(dSTemplatible, n);
        }
        return n;
    }

    private int BORDERLINENAME(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    private boolean ENGLISH(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    private boolean FALSE(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getTemplate().getPropertyByName(string);
        return this.QOIV(propertiable);
    }

    private boolean QOIV(Propertiable propertiable) {
        if (propertiable == null) {
            return false;
        }
        return propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
    }

    private void TRUE() {
        this.contains = new Hashtable();
        this.contains.put("Default", "Arial");
        this.contains.put("Dialog", "Arial");
        this.contains.put("SansSerif", "Arial");
        this.contains.put("Serif", "Times New Roman");
        this.contains.put("Monospaced", "Courier New");
        this.contains.put("Helvetica", "sansserif");
        this.contains.put("TimesRoman", "serif");
        this.contains.put("Courier", "Courier New");
        this.contains.put("DialogInput", "Courier New");
        this.contains.put("ZapfDingbats", "WingDings");
        this.containsKey = new Hashtable();
        this.convertUnitToInch = new Hashtable();
        this.convertUnitToInch.put("SUM", "Sum");
        this.convertUnitToInch.put("COUNT", "Count");
        this.convertUnitToInch.put("AVERAGE", "Average");
        this.convertUnitToInch.put("MAXIMUM", "Max");
        this.convertUnitToInch.put("MINIMUM", "Min");
        this.convertUnitToInch.put("POPULATIONSTDEV", "DEVSQ1");
        this.convertUnitToInch.put("STDDEV", "DEVSQ2");
        this.convertUnitToInch.put("POPULATIONVARIANCE", "DEVSQ3");
        this.convertUnitToInch.put("VARIANCE", "DEVSQ4");
    }

    public String getExcelFontName(String string) {
        String string2 = (String)this.contains.get(string);
        if (string2 == null || string2.length() == 0) {
            string2 = FontSets.getFont(string, 0, 16).getFontName(Locale.ENGLISH);
            this.contains.put(string, string2);
        }
        return string2;
    }

    public short[] getExcelBorderStyle(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        short[] sArray = (short[])this.clear.get(dSTemplatible);
        if (sArray == null) {
            int n = CCUtil.getIntPropertyByName(dSField, "BorderWidth") / 4;
            int[] nArray = new int[BORDERLINENAME.length];
            int n2 = 0;
            while (n2 < BORDERLINENAME.length) {
                nArray[n2] = CCUtil.getIntPropertyByName(dSField, BORDERLINENAME[n2]);
                ++n2;
            }
            sArray = new short[BORDERLINENAME.length];
            int n3 = 0;
            while (n3 < BORDERLINENAME.length) {
                sArray[n3] = this.getExcelBorderStyle(n, nArray[n3]);
                ++n3;
            }
            this.clear.put(dSTemplatible, sArray);
        }
        return sArray;
    }

    public short getExcelBorderStyle(int n, int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                if (n < 20) {
                    return 1;
                }
                if (n > 35) {
                    return 5;
                }
                return 2;
            }
            case 2: {
                if (n < 20) {
                    return 3;
                }
                return 8;
            }
            case 3: {
                if (n < 20) {
                    return 11;
                }
                return 12;
            }
            case 4: {
                if (n < 20) {
                    return 9;
                }
                return 10;
            }
        }
        return 6;
    }

    public int getFontStyle(String string) {
        Integer n = (Integer)this.containsKey.get(string);
        if (n == null) {
            FontSets.getFont(string, 0, 16);
            int n2 = FontSets.isTrueType(string) ? FontSets.getTrueTypeFontStyle(string) : -1;
            n = new Integer(n2);
            this.containsKey.put(string, n);
        }
        return n;
    }

    public void clear() {
        super.clear();
        if (this.contains != null) {
            this.contains.clear();
            this.contains = null;
        }
        if (this.containsKey != null) {
            this.containsKey = null;
            this.containsKey = null;
        }
        if (this.convertUnitToInch != null) {
            this.convertUnitToInch.clear();
            this.convertUnitToInch = null;
        }
        if (this.QOIV != null) {
            this.QOIV.clear();
            this.QOIV = null;
        }
        if (this.TRUE != null) {
            this.TRUE.clear();
            this.TRUE = null;
        }
        if (this.append != null) {
            this.append.clear();
            this.append = null;
        }
        if (this.booleanValue != null) {
            this.booleanValue.clear();
            this.booleanValue = null;
        }
        if (this.canCacheToXls != null) {
            this.canCacheToXls.clear();
            this.canCacheToXls = null;
        }
        if (this.canCacheWordWrap != null) {
            this.canCacheWordWrap.clear();
            this.canCacheWordWrap = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        if (this.getColorPropertyByName != null) {
            this.getColorPropertyByName.clear();
            this.getColorPropertyByName = null;
        }
        if (this.getExcelFontName != null) {
            this.getExcelFontName.clear();
            this.getExcelFontName = null;
        }
        if (this.getFont != null) {
            this.getFont.clear();
            this.getFont = null;
        }
        if (this.getFontIndex != null) {
            this.getFontIndex.clear();
            this.getFontIndex = null;
        }
        if (this.getFontName != null) {
            this.getFontName.clear();
            this.getFontName = null;
        }
    }

    public String getExcelFunction(String string) {
        return (String)this.convertUnitToInch.get(string.toUpperCase());
    }

    public boolean isExport(JRObjectResult jRObjectResult) {
        if (this.getColorIndex && jRObjectResult.getObjectType() == 44) {
            return false;
        }
        int n = jRObjectResult.getObjectType();
        if (n == 8192) {
            return false;
        }
        DSTemplatible dSTemplatible = jRObjectResult.getTemplate();
        Object v = this.canCacheToXls.get(dSTemplatible);
        if (v != null) {
            return (Boolean)v;
        }
        boolean bl = true;
        boolean bl2 = jRObjectResult instanceof JRVisiableResult;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.FALSE) {
            boolean bl5 = bl4 = (n & 0x10) == 16;
            if (bl4) {
                bl2 = true;
                bl3 = true;
            }
        }
        if (bl2) {
            boolean bl6;
            boolean bl7;
            if (!bl4) {
                switch (n) {
                    case 33: 
                    case 37: 
                    case 45: {
                        if (!((DSSubReport)jRObjectResult).isError()) break;
                        if (this.ENGLISH) {
                            JRLog.error(2, 2402206);
                        }
                        return false;
                    }
                }
                boolean bl8 = bl3 = ((JRVisiableResult)jRObjectResult).getWidth() > 0 && ((JRVisiableResult)jRObjectResult).getHeight() > 0;
                if (!bl3) {
                    if (n == 262178) {
                        bl3 = true;
                    }
                    if (!bl3 && this.ENGLISH) {
                        JRLog.error(2, 2402204, String.valueOf(((JRVisiableResult)jRObjectResult).getObjectType()));
                        JRLog.error(2, 2402205, ((JRVisiableResult)jRObjectResult).getWidth() + "*" + ((JRVisiableResult)jRObjectResult).getHeight());
                    }
                }
            }
            if ((v = this.append.get(dSTemplatible)) != null) {
                bl7 = (Boolean)v;
            } else {
                bl7 = this.booleanValue(jRObjectResult);
                v = this.QOIV.get(dSTemplatible);
                if (v != null) {
                    bl = (Boolean)v;
                } else {
                    boolean bl9 = bl = !this.FALSE(jRObjectResult, "Invisible");
                    if (bl) {
                        this.QOIV.put(dSTemplatible, Boolean.TRUE);
                        this.append.put(dSTemplatible, new Boolean(bl7));
                    } else {
                        this.QOIV.put(dSTemplatible, Boolean.FALSE);
                    }
                }
            }
            v = this.booleanValue.get(dSTemplatible);
            if (v != null) {
                bl6 = (Boolean)v;
            } else {
                bl6 = this.append(jRObjectResult);
                v = this.TRUE.get(dSTemplatible);
                if (v != null) {
                    boolean bl10 = (Boolean)v;
                    if (!bl10) {
                        bl = false;
                    }
                } else {
                    boolean bl11 = CCUtil.canCacheToXls(jRObjectResult);
                    if (bl11) {
                        this.TRUE.put(dSTemplatible, Boolean.TRUE);
                        this.booleanValue.put(dSTemplatible, new Boolean(bl6));
                    } else {
                        this.TRUE.put(dSTemplatible, Boolean.FALSE);
                        bl = false;
                    }
                }
            }
            boolean bl12 = bl2 = !bl7 && bl6 && bl3;
        }
        if (bl) {
            if (bl2) {
                this.canCacheToXls.put(dSTemplatible, Boolean.TRUE);
            } else {
                this.canCacheToXls.put(dSTemplatible, Boolean.FALSE);
            }
        }
        return bl2;
    }

    private boolean append(JRObjectResult jRObjectResult) {
        return CCUtil.getExportToXLS(jRObjectResult);
    }

    private boolean booleanValue(JRObjectResult jRObjectResult) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, "Invisible");
    }

    public boolean isTextField(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.canCacheWordWrap.get(dSTemplatible);
        if (v != null) {
            return (Boolean)v;
        }
        Propertiable propertiable = dSField.getPropertyByName("renderType");
        if (propertiable != null) {
            int n = (Integer)propertiable.getObject();
            if (n == 0 || n == 4) {
                this.canCacheWordWrap.put(dSTemplatible, Boolean.TRUE);
                return true;
            }
            this.canCacheWordWrap.put(dSTemplatible, Boolean.FALSE);
            return false;
        }
        this.canCacheWordWrap.put(dSTemplatible, Boolean.TRUE);
        return true;
    }

    public boolean canCacheWordWrap(DSField dSField) {
        if (this.error) {
            return true;
        }
        DSTemplatible dSTemplatible = dSField.getTemplate();
        if (this.getClass.contains(dSTemplatible)) {
            return false;
        }
        if (this.getBooleanPropertyByName.containsKey(dSTemplatible)) {
            return true;
        }
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "WordWrap");
        boolean bl2 = this.FALSE(dSField, "WordWrap");
        if (bl2) {
            this.getClass.put(dSTemplatible, Boolean.TRUE);
        } else if (bl) {
            this.getBooleanPropertyByName.put(dSTemplatible, Boolean.TRUE);
        } else {
            this.getBooleanPropertyByName.put(dSTemplatible, Boolean.FALSE);
        }
        return !bl2;
    }

    public boolean isSplit(JRObjectResult jRObjectResult) {
        int n = jRObjectResult.getObjectType();
        if (n == 8192) {
            return false;
        }
        DSTemplatible dSTemplatible = jRObjectResult.getTemplate();
        if (this.getExcelFontName.containsKey(dSTemplatible)) {
            return (Boolean)this.getExcelFontName.get(dSTemplatible);
        }
        Propertiable propertiable = jRObjectResult.getPropertyByName("OnNewSheet");
        if (propertiable == null) {
            this.getExcelFontName.put(dSTemplatible, Boolean.FALSE);
            return false;
        }
        Boolean bl = (Boolean)propertiable.getObject();
        if (!this.QOIV(propertiable)) {
            this.getExcelFontName.put(dSTemplatible, bl);
        }
        return bl;
    }

    public Object getKey(JRObjectResult jRObjectResult, int n) {
        String string;
        Object object;
        if (this.getExportToXLS != n) {
            this.getExportToXLS = n;
            this.getFont.clear();
        }
        if ((object = this.getFont.get(string = this.canCacheToXls(jRObjectResult))) != null) {
            return object;
        }
        int n2 = jRObjectResult.getObjectType();
        if (n2 == 33 || n2 == 37 || n2 == 45) {
            int n3;
            Object object2;
            int n4;
            DSSubReport dSSubReport = (DSSubReport)jRObjectResult;
            int n5 = dSSubReport.getStartXPos();
            if (n2 == 45) {
                n4 = dSSubReport.getStartYPos();
                object2 = jRObjectResult.getPropertyByName("Horizontal");
                n3 = 0;
                if (object2 != null) {
                    n3 = ((Boolean)object2.getObject()).booleanValue();
                }
                if (n3 != 0) {
                    return dSSubReport.getTemplate();
                }
            } else {
                n4 = dSSubReport.getStartLocation();
            }
            object2 = dSSubReport.getTemplate();
            if (n5 == 0 && n4 == 0) {
                n3 = 1;
                Integer n6 = (Integer)this.getFontName.get(object2);
                if (n6 != null) {
                    n3 = n6 + 1;
                }
                n6 = new Integer(n3);
                this.getFontName.put(object2, n6);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(object2).append("_pn(").append(n).append(")_idx(").append(n3).append(")");
                object = stringBuffer.toString();
                this.getFontIndex.put(object2, object);
            } else {
                object = this.getFontIndex.get(object2);
            }
        } else {
            object = n2 == 262179 ? jRObjectResult.getTemplate() : jRObjectResult.getTemplate();
        }
        this.getFont.put(string, object);
        return object;
    }

    private String canCacheToXls(JRObjectResult jRObjectResult) {
        return jRObjectResult.getClass().getName() + "@" + Integer.toHexString(jRObjectResult.hashCode());
    }

    public void resetKey() {
        this.getExportToXLS = -1;
        this.getFont.clear();
        this.getFontIndex.clear();
        this.getFontName.clear();
    }
}

